/*
 * Decompiled with CFR 0.152.
 */
package com.kakadu;

import java.util.ArrayList;
import java.util.List;

public class KakaduDecoder {
    private static List<String> libsToLoad32 = new ArrayList<String>();
    private static List<String> libsToLoad64;
    private int width = 0;
    private int height = 0;
    private int size = 0;
    private boolean isSignedData = false;
    private int precision = 0;
    private int nofComp = 0;
    private int threads = 1;
    private long nativePtr = this.nativeConstruct();

    public static List<String> getLibsToLoad32() {
        return libsToLoad32;
    }

    public static List<String> getLibsToLoad64() {
        return libsToLoad64;
    }

    public KakaduDecoder(int n) {
        this.setThreads(n);
    }

    public KakaduDecoder() {
        this(1);
    }

    public void destroy() {
        this.nativeDestruct(this.nativePtr);
        this.nativePtr = 0L;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isSignedData() {
        return this.isSignedData;
    }

    public int getNofComponents() {
        return this.nofComp;
    }

    public int getPrecisionPerComponent() {
        return this.precision;
    }

    public void setThreads(int n) {
        this.threads = n;
    }

    public Object decode(byte[] byArray, Object object) {
        this.validateSettings(new Object[]{byArray});
        this.nativeSetParameters(this.nativePtr, this.threads);
        this.nativeDecodeHeader(this.nativePtr, byArray, byArray.length);
        this.getValuesFromNative();
        if (this.nofComp == 1) {
            if (this.precision > 0 && this.precision <= 8) {
                byte[] byArray2 = null;
                byArray2 = object instanceof byte[] && ((byte[])object).length == this.size ? (byte[])object : new byte[this.size];
                this.nativeDecodeToByte(this.nativePtr, byArray, byArray.length, byArray2, byArray2.length);
                return byArray2;
            }
            if (this.precision > 8 && this.precision <= 16) {
                short[] sArray = null;
                sArray = object instanceof short[] && ((short[])object).length == this.size ? (short[])object : new short[this.size];
                this.nativeDecodeToShort(this.nativePtr, byArray, byArray.length, sArray, sArray.length);
                return sArray;
            }
            throw new IllegalStateException("Unsupported component precision: " + this.precision);
        }
        if (this.nofComp == 3) {
            if (this.precision == 8) {
                byte[] byArray3 = new byte[this.size * 3];
                this.nativeDecodeToByte(this.nativePtr, byArray, byArray.length, byArray3, byArray3.length);
                return byArray3;
            }
            throw new IllegalStateException("Unsupported component precision: " + this.precision);
        }
        throw new IllegalStateException("Unsupported number of components: " + this.nofComp);
    }

    private void getValuesFromNative() {
        this.width = this.nativeGetWidth(this.nativePtr);
        this.height = this.nativeGetHeight(this.nativePtr);
        this.nofComp = this.nativeGetNumberOfComponents(this.nativePtr);
        this.precision = this.nativeGetPrecision(this.nativePtr);
        this.isSignedData = this.nativeIsSigned(this.nativePtr);
        this.size = this.width * this.height;
        if (this.size <= 0) {
            throw new IllegalStateException("Invalid image size: width=" + this.width + ", height=" + this.height);
        }
    }

    private void validateSettings(Object ... objectArray) {
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("Native data instance is null");
        }
        if (this.threads <= 0) {
            throw new IllegalStateException("Illegal number of threads: " + this.threads);
        }
        if (objectArray == null || objectArray.length == 0 || objectArray[0] == null) {
            throw new IllegalStateException("Input must be non-null");
        }
    }

    private native long nativeConstruct();

    private native void nativeDestruct(long var1);

    private native void nativeSetParameters(long var1, int var3);

    private native int nativeGetWidth(long var1);

    private native int nativeGetHeight(long var1);

    private native int nativeGetNumberOfComponents(long var1);

    private native int nativeGetPrecision(long var1);

    private native boolean nativeIsSigned(long var1);

    private native void nativeDecodeHeader(long var1, byte[] var3, int var4);

    private native void nativeDecodeToByte(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native void nativeDecodeToShort(long var1, byte[] var3, int var4, short[] var5, int var6);

    static {
        libsToLoad32.add("libwinpthread-1");
        libsToLoad32.add("libgcc_s_dw2-1");
        libsToLoad32.add("libstdc++-6");
        libsToLoad32.add("libkdu_vs7AR");
        libsToLoad32.add("libkdu_as7AR");
        libsToLoad32.add("libkakadujni");
        libsToLoad64 = new ArrayList<String>();
        libsToLoad64.add("libwinpthread-1");
        libsToLoad64.add("libgcc_s_seh-1");
        libsToLoad64.add("libstdc++-6");
        libsToLoad64.add("libkdu_vs7AR");
        libsToLoad64.add("libkdu_as7AR");
        libsToLoad64.add("libkakadujni");
    }
}

