/*
 * Decompiled with CFR 0.152.
 */
package org.openJpeg;

import java.util.Objects;
import org.openJpeg.OpenJPEGJavaCoder;

public class OpenJPEGJavaDecoder
extends OpenJPEGJavaCoder {
    public OpenJPEGJavaDecoder() {
        this.nativePtr = this.nativeConstruct();
    }

    public OpenJPEGJavaDecoder(int n) {
        this.nativePtr = this.nativeConstruct();
        this.threads = n;
    }

    public Object decode(byte[] byArray, Object object) {
        this.validateSettings(new Object[]{byArray});
        this.nativeSetParameters(this.nativePtr, this.threads);
        if (object != null) {
            if (object instanceof byte[]) {
                return this.decodeToByte(byArray, (byte[])object);
            }
            if (object instanceof short[]) {
                return this.decodeToShort(byArray, (short[])object);
            }
            if (object instanceof int[]) {
                return this.decodeToInt(byArray, (int[])object);
            }
            throw new IllegalArgumentException("Uncompressed data array of unsupported type " + object.getClass().getSimpleName());
        }
        return this.decode(byArray);
    }

    private Object decode(byte[] byArray) {
        Object object = this.nativeDecode(this.nativePtr, byArray, byArray.length);
        this.getValuesFromNative();
        return object;
    }

    private byte[] decodeToByte(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = this.nativeDecodeToByte(this.nativePtr, byArray, byArray.length, byArray2, byArray2.length);
        this.getValuesFromNative();
        if (byArray3 == null) {
            return byArray2;
        }
        return byArray3;
    }

    private short[] decodeToShort(byte[] byArray, short[] sArray) {
        short[] sArray2 = this.nativeDecodeToShort(this.nativePtr, byArray, byArray.length, sArray, sArray.length);
        this.getValuesFromNative();
        if (sArray2 == null) {
            return sArray;
        }
        return sArray2;
    }

    private int[] decodeToInt(byte[] byArray, int[] nArray) {
        int[] nArray2 = this.nativeDecodeToInt(this.nativePtr, byArray, byArray.length, nArray, nArray.length);
        this.getValuesFromNative();
        if (nArray2 == null) {
            return nArray;
        }
        return nArray2;
    }

    private void getValuesFromNative() {
        this.width = this.nativeGetWidth(this.nativePtr);
        this.height = this.nativeGetHeight(this.nativePtr);
        this.nofComp = this.nativeGetNumberOfComponents(this.nativePtr);
        this.allocBitsPerComp = this.nativeGetAllocatedBitsPerComponent(this.nativePtr);
        this.usedBitsPerComp = this.nativeGetUsedBitsPerComponent(this.nativePtr);
        this.isSignedData = this.nativeIsSigned(this.nativePtr);
    }

    @Override
    protected void validateSettings(Object ... objectArray) {
        super.validateSettings(new Object[0]);
        if (Objects.isNull(objectArray[0])) {
            throw new IllegalArgumentException("Input must be non-null");
        }
    }

    private native void nativeSetParameters(long var1, int var3);

    private native int nativeGetWidth(long var1);

    private native int nativeGetHeight(long var1);

    private native int nativeGetNumberOfComponents(long var1);

    private native int nativeGetAllocatedBitsPerComponent(long var1);

    private native int nativeGetUsedBitsPerComponent(long var1);

    private native boolean nativeIsSigned(long var1);

    private native Object nativeDecode(long var1, byte[] var3, int var4);

    private native byte[] nativeDecodeToByte(long var1, byte[] var3, int var4, byte[] var5, int var6);

    private native short[] nativeDecodeToShort(long var1, byte[] var3, int var4, short[] var5, int var6);

    private native int[] nativeDecodeToInt(long var1, byte[] var3, int var4, int[] var5, int var6);
}

