/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.nativeWin32.lz4;

public class LZ4Decoder {
    private static final int LZ4_MAGIC = 407708164;
    private static final byte FLG_ALLOWED = 104;
    private static final byte BD_ALLOWED = 112;
    private static final int BLOCKSIZE_64KB = 65536;
    private static final int BLOCKSIZE_256KB = 262144;
    private static final int BLOCKSIZE_1MB = 0x100000;
    private static final int BLOCKSIZE_4MB = 0x400000;
    private static final byte FLG_MASK = 104;
    private static final byte FLG_BLOCK_CS_MASK = 16;
    private static final byte FLG_CONTENT_CS_MASK = 4;
    private static final byte BD_MASK = 112;
    private static final int[] BD_BLOCKSIZE = new int[]{0, 0, 0, 0, 65536, 262144, 0x100000, 0x400000};

    private LZ4Decoder() {
    }

    public static byte[] decodeToByte(byte[] byArray) {
        LZ4Decoder.checkFrameDescriptor(byArray);
        int n = LZ4Decoder.readInt(byArray, 6);
        LZ4Decoder.checkContentSize(n);
        byte[] byArray2 = new byte[n];
        int n2 = LZ4Decoder.nativeDecodeToByte(byArray, 15, byArray.length, byArray2, BD_BLOCKSIZE[byArray[5] >> 4], n, (byArray[4] & 0x10) == 16, (byArray[4] & 0x10) == 4);
        if (n2 < 0) {
            throw new IllegalStateException("Could not decode LZ4 to byte[], error code " + n2);
        }
        return byArray2;
    }

    public static short[] decodeToShort(byte[] byArray) {
        LZ4Decoder.checkFrameDescriptor(byArray);
        int n = LZ4Decoder.readInt(byArray, 6);
        LZ4Decoder.checkContentSize(n);
        short[] sArray = new short[n / 2];
        int n2 = LZ4Decoder.nativeDecodeToShort(byArray, 15, byArray.length, sArray, BD_BLOCKSIZE[byArray[5] >> 4], n, (byArray[4] & 0x10) == 16, (byArray[4] & 0x10) == 4);
        if (n2 < 0) {
            throw new IllegalStateException("Could not decode LZ4 to short[], error code " + n2);
        }
        return sArray;
    }

    public static int[] decodeToInt(byte[] byArray) {
        LZ4Decoder.checkFrameDescriptor(byArray);
        int n = LZ4Decoder.readInt(byArray, 6);
        LZ4Decoder.checkContentSize(n);
        int[] nArray = new int[n / 4];
        int n2 = LZ4Decoder.nativeDecodeToInt(byArray, 15, byArray.length, nArray, BD_BLOCKSIZE[byArray[5] >> 4], n, (byArray[4] & 0x10) == 16, (byArray[4] & 0x10) == 4);
        if (n2 < 0) {
            throw new IllegalStateException("Could not decode LZ4 to int[], error code " + n2);
        }
        return nArray;
    }

    private static int readInt(byte[] byArray, int n) {
        return byArray[n++] & 0xFF | (byArray[n++] & 0xFF) << 8 | (byArray[n++] & 0xFF) << 16 | (byArray[n] & 0xFF) << 24;
    }

    private static void checkContentSize(int n) {
        if (n < 0) {
            throw new IllegalStateException("Could not decode LZ4, negative content size (" + n + ")");
        }
    }

    private static void checkFrameDescriptor(byte[] byArray) {
        if (byArray.length < 6) {
            throw new IllegalArgumentException("Insufficient stream length");
        }
        int n = LZ4Decoder.readInt(byArray, 0);
        if (n != 407708164) {
            throw new IllegalArgumentException("Not a valid LZ4 stream: starts with " + LZ4Decoder.readInt(byArray, 0));
        }
        byte by = byArray[4];
        if ((by & 0x68) != 104) {
            throw new IllegalArgumentException("LZ4 stream unsupported, FLG=" + by);
        }
        byte by2 = byArray[5];
        if ((by2 | 0x70) != 112) {
            throw new IllegalArgumentException("LZ4 stream unsupported, BD=" + by2);
        }
    }

    private static native int nativeDecodeToByte(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, boolean var6, boolean var7);

    private static native int nativeDecodeToShort(byte[] var0, int var1, int var2, short[] var3, int var4, int var5, boolean var6, boolean var7);

    private static native int nativeDecodeToInt(byte[] var0, int var1, int var2, int[] var3, int var4, int var5, boolean var6, boolean var7);
}

