/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.pdfrenderer;

import com.sun.pdfview.OutlineNode;
import com.sun.pdfview.PDFFile;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class PDFInfo {
    public static void main(String[] args) throws IOException {
        if (args.length != 1) {
            System.err.println("usage: java PDFInfo pdfspec");
            return;
        }
        RandomAccessFile raf = new RandomAccessFile(new File(args[0]), "r");
        FileChannel fc = raf.getChannel();
        MappedByteBuffer buf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
        PDFFile pdfFile = new PDFFile(buf);
        System.out.println("Major version = " + pdfFile.getMajorVersion());
        System.out.println("Minor version = " + pdfFile.getMinorVersion());
        System.out.println("Version string = " + pdfFile.getVersionString() + "\n");
        System.out.println("Is printable = " + pdfFile.isPrintable());
        System.out.println("Is saveable = " + pdfFile.isSaveable() + "\n");
        OutlineNode oln = pdfFile.getOutline();
        if (oln != null) {
            System.out.println("Outline\n");
            Enumeration<TreeNode> e = oln.preorderEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
                System.out.println(node);
            }
        }
    }
}

