/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfrenderer.tools.charset;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFDocEncodingMapGenerator {
    public static final void main(String[] args) throws IOException {
        Map<String, Character> unicodeNames = PDFDocEncodingMapGenerator.readUnicodeNames();
        int[] unicodeCharacters = new int[256];
        HashSet<Integer> mappedCharacters = new HashSet<Integer>();
        ArrayList<Integer> problemMappings = new ArrayList<Integer>();
        BufferedReader r = new BufferedReader(new InputStreamReader(PDFDocEncodingMapGenerator.class.getResourceAsStream("PDFDocEncodingMap.txt")));
        String charLine = null;
        String decLine = null;
        String hexLine = null;
        String octalLine = null;
        String unicodeLine = null;
        String nameLine = null;
        String notesLine = null;
        int i = 0;
        while (i < 256) {
            int unicodeCh;
            if (charLine == null) {
                charLine = PDFDocEncodingMapGenerator.readEncodingLine(r);
            }
            if (decLine == null) {
                decLine = PDFDocEncodingMapGenerator.readEncodingLine(r);
            }
            hexLine = PDFDocEncodingMapGenerator.readEncodingLine(r);
            octalLine = PDFDocEncodingMapGenerator.readEncodingLine(r);
            unicodeLine = PDFDocEncodingMapGenerator.readEncodingLine(r);
            nameLine = PDFDocEncodingMapGenerator.readEncodingLine(r);
            notesLine = PDFDocEncodingMapGenerator.readEncodingLine(r);
            String ourCharLine = charLine;
            String ourDecLine = decLine;
            if (notesLine != null && PDFDocEncodingMapGenerator.parseDecLine(notesLine) == i + 1) {
                charLine = nameLine;
                decLine = notesLine;
                nameLine = null;
                notesLine = null;
            } else {
                String extraLine = PDFDocEncodingMapGenerator.readEncodingLine(r);
                if (extraLine != null && PDFDocEncodingMapGenerator.parseDecLine(extraLine) == i + 1) {
                    charLine = notesLine;
                    decLine = extraLine;
                    notesLine = null;
                } else {
                    charLine = extraLine;
                    decLine = null;
                }
            }
            System.out.println(String.valueOf(ourCharLine) + " " + ourDecLine + " " + hexLine + " " + octalLine + " " + unicodeLine + " " + nameLine + " " + notesLine);
            boolean undefinedCh = "Undefined".equals(unicodeLine);
            if (!undefinedCh) {
                unicodeCh = Integer.parseInt(unicodeLine.substring(2), 16);
                if (mappedCharacters.contains(unicodeCh)) {
                    problemMappings.add(i);
                    System.out.println(" !!! " + unicodeCh + " is already mapped to");
                }
                mappedCharacters.add(unicodeCh);
            } else {
                unicodeCh = 65533;
            }
            if (nameLine != null) {
                String unicodeName;
                Character mappedCh;
                if (!(undefinedCh || (mappedCh = unicodeNames.get(unicodeName = nameLine.startsWith("(") ? nameLine : nameLine.replaceFirst("\\s*\\(.*$", ""))) != null && mappedCh.charValue() == unicodeCh)) {
                    if (mappedCh != null) {
                        System.out.println(" !!! name maps to " + mappedCh + " (" + mappedCh.charValue() + ")");
                        problemMappings.add(i);
                    } else {
                        System.out.println(" !!! unmapped name");
                        problemMappings.add(i);
                    }
                }
            } else if (ourCharLine.charAt(0) != (char)i) {
                System.out.println("  !!! Unnamed character is not same as Latin1 encoding");
                problemMappings.add(i);
            }
            if (unicodeCh >= 65536) {
                System.out.println("  !!! supplementary code point! Cannot generate with existing system");
            }
            unicodeCharacters[i] = unicodeCh;
            ++i;
        }
        if (!problemMappings.isEmpty()) {
            System.out.println(String.valueOf(problemMappings.size()) + " problems for decimal encodings:");
            for (Integer problemMapping : problemMappings) {
                System.out.println("  " + problemMapping);
            }
            System.out.println("Did not generate table due to errors");
        } else {
            System.out.println("\tprivate final static char[] PDF_DOC_ENCODING_MAP = new char[] {");
            i = 0;
            while (i < 256) {
                System.out.print("\t    ");
                int j = i;
                while (j < i + 8) {
                    System.out.print(PDFDocEncodingMapGenerator.formatArrayEntry(unicodeCharacters[j]));
                    ++j;
                }
                System.out.println(" //" + String.format("%02X-%02X", i, i + 7));
                i += 8;
            }
            System.out.println("\t};");
        }
    }

    private static String formatArrayEntry(int charVal) {
        return String.format("0x%04X, ", charVal);
    }

    private static String readEncodingLine(BufferedReader r) throws IOException {
        String line;
        while ((line = r.readLine()) != null && line.startsWith("##")) {
        }
        return line;
    }

    private static int parseDecLine(String notesLine) {
        try {
            return Integer.parseInt(notesLine);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static CharChange c(int val, String name) {
        return new CharChange(name, (char)val);
    }

    private static Map<String, Character> readUnicodeNames() throws IOException {
        String line;
        HashMap<String, Character> names = new HashMap<String, Character>();
        BufferedReader r = new BufferedReader(new InputStreamReader(PDFDocEncodingMapGenerator.class.getResourceAsStream("UnicodeData.txt")));
        while ((line = r.readLine()) != null) {
            String[] cols = line.split(";");
            char c = (char)Integer.parseInt(cols[0], 16);
            String name = cols[1];
            if ("<control>".equals(name)) {
                name = cols.length >= 11 ? "(" + cols[10] + ")" : "(control-" + c + ")";
            }
            if (names.containsKey(name)) {
                throw new IOException("Already found name " + name);
            }
            names.put(name, Character.valueOf(c));
        }
        return names;
    }

    private static class CharChange {
        String name;
        char value;

        private CharChange(String name, char value) {
            this.name = name;
            this.value = value;
        }
    }
}

