/*
 * Decompiled with CFR 0.152.
 */
package com.charls;

import com.charls.CharLSCoder;
import java.util.Arrays;

public class CharLSEncoder
extends CharLSCoder {
    @Override
    public void setInput(Object object) {
        if (object instanceof byte[]) {
            this.objectInput = object;
            this.byteInput = (byte[])object;
        } else if (object instanceof short[]) {
            this.objectInput = object;
            this.shortInput = (short[])object;
        } else {
            throw this.getInvalidInputException(object);
        }
    }

    @Override
    public int estimateOutputSize() {
        int n = this.nativeEstimateSize(this.width, this.height, this.nofComponents, this.bitsPerComponent);
        return n + n / 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void encode() {
        if (this.bitsPerComponent > 0 && this.bitsPerComponent <= 8) {
            if (this.byteInput == null || this.byteInput.length != this.width * this.height * this.nofComponents) throw this.getNonSuitableByteInputException();
            this.encodeFromByte();
            return;
        } else {
            if (this.bitsPerComponent <= 8 || this.bitsPerComponent > 16) throw this.getNonSuitableSettingsException();
            if (this.shortInput == null || this.shortInput.length != this.width * this.height * this.nofComponents) throw this.getNonSuitableShortInputException();
            this.encodeFromShort();
        }
    }

    private void encodeFromByte() {
        int n;
        int n2 = this.nativeEstimateSize(this.width, this.height, this.nofComponents, this.bitsPerComponent);
        if (this.byteOutput == null || this.byteOutput.length < n2) {
            this.byteOutput = new byte[n2];
        }
        if ((n = this.nativeEncodeFromByte(this.byteInput, this.byteInput.length, this.byteOutput, this.byteOutput.length, this.width, this.height, this.nofComponents, this.bitsPerComponent, this.interleaveMode, this.compressionMode)) != n2) {
            this.byteOutput = Arrays.copyOf(this.byteOutput, n);
        }
        this.objectOutput = this.byteOutput;
    }

    private void encodeFromShort() {
        int n;
        int n2 = this.nativeEstimateSize(this.width, this.height, this.nofComponents, this.bitsPerComponent);
        if (this.byteOutput == null || this.byteOutput.length < n2) {
            this.byteOutput = new byte[n2];
        }
        if ((n = this.nativeEncodeFromShort(this.shortInput, this.shortInput.length, this.byteOutput, this.byteOutput.length, this.width, this.height, this.nofComponents, this.bitsPerComponent, this.interleaveMode, this.compressionMode)) != n2) {
            this.byteOutput = Arrays.copyOf(this.byteOutput, n);
        }
        this.objectOutput = this.byteOutput;
    }

    private native int nativeEstimateSize(int var1, int var2, int var3, int var4);

    private native int nativeEncodeFromByte(byte[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native int nativeEncodeFromShort(short[] var1, int var2, byte[] var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);
}

