/*
 * Decompiled with CFR 0.152.
 */
package com.charls;

import com.charls.CharLSCoder;

public class CharLSDecoder
extends CharLSCoder {
    @Override
    public void setInput(Object object) {
        if (!(object instanceof byte[])) {
            throw this.getInvalidInputException(object);
        }
        this.objectInput = object;
        this.byteInput = (byte[])object;
    }

    @Override
    public int estimateOutputSize() {
        return this.width * this.height * this.nofComponents;
    }

    public void decodeHeader() {
        if (this.byteInput == null || this.byteInput.length == 0) {
            throw this.getNonSuitableByteInputException();
        }
        int[] nArray = new int[]{this.width, this.height, this.nofComponents, this.bitsPerComponent, this.interleaveMode, this.compressionMode};
        this.nativeDecodeHeader(this.byteInput, this.byteInput.length, nArray);
        this.width = nArray[0];
        this.height = nArray[1];
        this.nofComponents = nArray[2];
        this.bitsPerComponent = nArray[3];
        this.interleaveMode = nArray[4];
        this.compressionMode = nArray[5];
    }

    public void decode() {
        if (this.byteInput == null || this.byteInput.length == 0) {
            throw this.getNonSuitableByteInputException();
        }
        if (this.bitsPerComponent > 0 && this.bitsPerComponent <= 8) {
            this.decodeToByte();
        } else if (this.bitsPerComponent > 8 && this.bitsPerComponent <= 16) {
            this.decodeToShort();
        } else {
            throw this.getNonSuitableSettingsException();
        }
    }

    private void decodeToByte() {
        int n = this.estimateOutputSize();
        if (this.byteOutput == null || this.byteOutput.length != n) {
            this.byteOutput = new byte[n];
            this.objectOutput = this.byteOutput;
        }
        this.nativeDecodeToByte(this.byteInput, this.byteInput.length, this.byteOutput, this.byteOutput.length);
    }

    private void decodeToShort() {
        int n = this.estimateOutputSize();
        if (this.shortOutput == null || this.shortOutput.length != n) {
            this.shortOutput = new short[n];
            this.objectOutput = this.shortOutput;
        }
        this.nativeDecodeToShort(this.byteInput, this.byteInput.length, this.shortOutput, this.shortOutput.length);
    }

    private native void nativeDecodeHeader(byte[] var1, int var2, int[] var3);

    private native void nativeDecodeToByte(byte[] var1, int var2, byte[] var3, int var4);

    private native void nativeDecodeToShort(byte[] var1, int var2, short[] var3, int var4);
}

