/*
 * Decompiled with CFR 0.152.
 */
package com.charls;

import java.util.ArrayList;
import java.util.List;

public abstract class CharLSCoder {
    protected Object objectInput;
    protected byte[] byteInput;
    protected short[] shortInput;
    protected Object objectOutput;
    protected byte[] byteOutput;
    protected short[] shortOutput;
    protected int width;
    protected int height;
    protected int bitsPerComponent;
    protected int nofComponents;
    protected int interleaveMode;
    protected int compressionMode;

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getBitsPerComponent() {
        return this.bitsPerComponent;
    }

    public void setBitsPerComponent(int n) {
        this.bitsPerComponent = n;
    }

    public int getNofComponents() {
        return this.nofComponents;
    }

    public void setNofComponents(int n) {
        this.nofComponents = n;
    }

    public int getInterleaveMode() {
        return this.interleaveMode;
    }

    public void setInterleaveMode(int n) {
        this.interleaveMode = n;
    }

    public int getCompressionMode() {
        return this.compressionMode;
    }

    public void setCompressionMode(int n) {
        this.compressionMode = n;
    }

    public Object getInput() {
        return this.objectInput;
    }

    public abstract void setInput(Object var1);

    public Object getOutput() {
        return this.objectOutput;
    }

    public void setOutput(Object object) {
        if (object == null) {
            this.objectOutput = null;
            this.byteOutput = null;
            this.shortOutput = null;
        } else if (object instanceof byte[]) {
            this.objectOutput = object;
            this.byteOutput = (byte[])object;
        } else if (object instanceof short[]) {
            this.objectOutput = object;
            this.shortOutput = (short[])object;
        } else {
            throw this.getInvalidOutputException(object);
        }
    }

    public abstract int estimateOutputSize();

    protected IllegalArgumentException getInvalidInputException(Object object) {
        return new IllegalArgumentException("Invalid input data: " + object);
    }

    protected IllegalArgumentException getInvalidOutputException(Object object) {
        return new IllegalArgumentException("Invalid output data: " + object);
    }

    private StringBuilder getSettingsString() {
        StringBuilder stringBuilder = new StringBuilder("Illegal coder state: \n");
        stringBuilder.append("Settings:\n");
        stringBuilder.append("\tDimensions: [w x h]=[").append(this.width).append(" x ").append(this.height).append("]\n");
        stringBuilder.append("\tComponents: ").append(this.nofComponents).append(" @ ").append(this.bitsPerComponent).append(" bpc\n");
        return stringBuilder;
    }

    protected IllegalStateException getNonSuitableSettingsException() {
        return new IllegalStateException(this.getSettingsString().toString());
    }

    protected IllegalStateException getNonSuitableByteInputException() {
        StringBuilder stringBuilder = this.getSettingsString();
        stringBuilder.append("Input:\n");
        if (this.byteInput == null) {
            stringBuilder.append("\tByteArray [invalid]");
        } else {
            stringBuilder.append("\tByteArray [length=").append(this.byteInput.length).append("]");
        }
        return new IllegalStateException(stringBuilder.toString());
    }

    protected IllegalStateException getNonSuitableShortInputException() {
        StringBuilder stringBuilder = this.getSettingsString();
        stringBuilder.append("Input:\n");
        if (this.shortInput == null) {
            stringBuilder.append("\tShortArray [invalid]");
        } else {
            stringBuilder.append("\tShortArray [length=").append(this.shortInput.length).append("]");
        }
        return new IllegalStateException(stringBuilder.toString());
    }

    protected IllegalStateException getNonSuitableByteOutputException() {
        StringBuilder stringBuilder = this.getSettingsString();
        stringBuilder.append("Output:\n");
        if (this.byteOutput == null) {
            stringBuilder.append("\tByteArray [invalid]");
        } else {
            stringBuilder.append("\tByteArray [length=").append(this.byteOutput.length).append("]");
        }
        return new IllegalStateException(stringBuilder.toString());
    }

    protected IllegalStateException getNonSuitableShortOutputException() {
        StringBuilder stringBuilder = this.getSettingsString();
        stringBuilder.append("Output:\n");
        if (this.shortOutput == null) {
            stringBuilder.append("\tShortArray [invalid]");
        } else {
            stringBuilder.append("\tShortArray [length=").append(this.shortOutput.length).append("]");
        }
        return new IllegalStateException(stringBuilder.toString());
    }

    public static List<String> getLibraries32Bit() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add("libwinpthread-1");
        arrayList.add("libgcc_s_dw2-1");
        arrayList.add("libstdc++-6");
        arrayList.add("libcharlsjni");
        return arrayList;
    }

    public static List<String> getLibraries64Bit() {
        ArrayList<String> arrayList = new ArrayList<String>(4);
        arrayList.add("libwinpthread-1");
        arrayList.add("libgcc_s_seh-1");
        arrayList.add("libstdc++-6");
        arrayList.add("libcharlsjni");
        return arrayList;
    }
}

