/*
 * Decompiled with CFR 0.152.
 */
package de.pixopia.cezanne.util;

import de.pixopia.util.integrated.CodeGroup;
import de.pixopia.util.integrated.PrivateAPI;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

@PrivateAPI
@CodeGroup(value={"cezanne-util"})
public class WrapLayout
extends FlowLayout {
    private static final long serialVersionUID = 1L;

    @PrivateAPI
    public WrapLayout() {
    }

    @PrivateAPI
    public WrapLayout(int align) {
        super(align);
    }

    @PrivateAPI
    public WrapLayout(int align, int hgap, int vgap) {
        super(align, hgap, vgap);
    }

    @Override
    public Dimension preferredLayoutSize(Container target) {
        return this.a(target, true);
    }

    @Override
    public Dimension minimumLayoutSize(Container target) {
        Dimension dimension = this.a(target, false);
        dimension.width -= this.getHgap() + 1;
        return dimension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension a(Container container, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n2 = container.getSize().width;
            Container container2 = container;
            while (container2.getSize().width == 0 && container2.getParent() != null) {
                container2 = container2.getParent();
            }
            n2 = container2.getSize().width;
            if (n2 == 0) {
                n2 = Integer.MAX_VALUE;
            }
            int n3 = this.getHgap();
            int n4 = this.getVgap();
            Insets insets = container.getInsets();
            int n5 = insets.left + insets.right + n3 * 2;
            int n6 = n2 - n5;
            Dimension dimension = new Dimension(0, 0);
            int n7 = 0;
            int n8 = 0;
            int n9 = container.getComponentCount();
            for (int i2 = 0; i2 < n9; ++i2) {
                Dimension dimension2;
                Component component = container.getComponent(i2);
                if (!component.isVisible()) continue;
                Dimension dimension3 = dimension2 = bl ? component.getPreferredSize() : component.getMinimumSize();
                if (n7 + dimension2.width > n6) {
                    this.a(dimension, n7, n8);
                    n7 = 0;
                    n8 = 0;
                }
                if (n7 != 0) {
                    n7 += n3;
                }
                n7 += dimension2.width;
                n8 = Math.max(n8, dimension2.height);
            }
            this.a(dimension, n7, n8);
            dimension.width += n5;
            dimension.height += insets.top + insets.bottom + n4 * 2;
            Container container3 = SwingUtilities.getAncestorOfClass(JScrollPane.class, container);
            if (container3 != null && container.isValid()) {
                dimension.width -= n3 + 1;
            }
            return dimension;
        }
    }

    protected void a(Dimension dimension, int n2, int n3) {
        dimension.width = Math.max(dimension.width, n2);
        if (dimension.height > 0) {
            dimension.height += this.getVgap();
        }
        dimension.height += n3;
    }
}

