/*
 * Decompiled with CFR 0.152.
 */
package de.pixopia.cezanne.image.filter;

import de.pixopia.cezanne.CezanneContext;
import de.pixopia.cezanne.H;
import de.pixopia.cezanne.cache.CezanneCacheKey;
import de.pixopia.cezanne.color.CezanneColor;
import de.pixopia.cezanne.color.CezanneColorUtil;
import de.pixopia.cezanne.image.CezanneProducedImage;
import de.pixopia.cezanne.image.filter.CIFAbstract;
import de.pixopia.cezanne.image.filter.CIFMultithreaded;
import de.pixopia.cezanne.util.U;
import de.pixopia.util.integrated.CodeGroup;
import de.pixopia.util.integrated.PrivateAPI;
import de.pixopia.util.integrated.ReflectionTarget;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

@ReflectionTarget
@CodeGroup(value={"cezanne-core"})
public class CIFBlackAndWhiteColorization
extends CIFMultithreaded<RunParameters> {
    public static final U<CezanneColor> p;
    public static final U<CezanneColor> q;
    public static final U<CezanneColor> r;
    protected CezanneColor s;
    protected CezanneColor t;
    private static final String[] u;

    @Override
    public void setParameters(H parameters) {
        super.setParameters(parameters);
        this.s = parameters.a(p);
        this.t = parameters.a(q);
    }

    @Override
    public List<U<?>> getParameterInfos() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(p);
        arrayList.add(q);
        return arrayList;
    }

    protected RunParameters c(CezanneContext<?> cezanneContext) {
        boolean bl;
        Color color = this.s == null ? null : this.s.getColor(cezanneContext);
        Color color2 = this.t == null ? null : this.t.getColor(cezanneContext);
        boolean bl2 = bl = color != null && color2 != null;
        if (!bl) {
            return null;
        }
        return new RunParameters(color, color2);
    }

    @Override
    protected void populateCacheKey(CezanneProducedImage producedImage, CezanneCacheKey cacheKey) {
        super.populateCacheKey(producedImage, cacheKey);
        RunParameters runParameters = (RunParameters)producedImage.a();
        cacheKey.a(runParameters.blackTargetColor);
        cacheKey.a(runParameters.whiteTargetColor);
    }

    @Override
    @PrivateAPI
    protected int filter(int intARGB, RunParameters runParameters, int pixelIndex) {
        float[] fArray = CezanneColorUtil.intToARGB(intARGB, runParameters.temp1);
        float f2 = Math.max(Math.max(fArray[1], fArray[2]), fArray[3]);
        float[] fArray2 = CezanneColorUtil.intToARGB(runParameters.blackTargetColor.getRGB(), runParameters.temp2);
        float[] fArray3 = CezanneColorUtil.intToARGB(runParameters.whiteTargetColor.getRGB(), runParameters.temp3);
        CezanneColorUtil.blendSourceOver(fArray2, fArray3[0] * f2, fArray3[1], fArray3[2], fArray3[3]);
        fArray2[0] = fArray2[0] * fArray[0];
        int n2 = CezanneColorUtil.argbToInt(fArray2);
        return n2;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[3];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "UP\u0014\f~C]\u0007\bpc\u007f\u001a\u0003ze";
        int n3 = -1;
        block10: while (true) {
            char[] cArray;
            block15: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block14: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block14;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block15;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 23;
                                break;
                            }
                            case 1: {
                                n9 = 60;
                                break;
                            }
                            case 2: {
                                n9 = 117;
                                break;
                            }
                            case 3: {
                                n9 = 111;
                                break;
                            }
                            default: {
                                n9 = 21;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "RD\u001c\u001ca~R\u0012,z{S\u0007&xg]\u0016\u001b";
                    n3 = 0;
                    continue block10;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "@T\u001c\u001bpC]\u0007\bpc\u007f\u001a\u0003ze";
                    n3 = 1;
                    continue block10;
                }
                case 1: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        u = stringArray3;
        p = new U<Object>(u[0], CezanneColor.class, null, true);
        q = new U<Object>(u[2], CezanneColor.class, null, true);
        r = new U<Object>(u[1], CezanneColor.class, null, true);
    }

    @PrivateAPI
    protected static class RunParameters
    extends CIFAbstract.FilterRunParameters {
        @PrivateAPI
        public Color blackTargetColor;
        @PrivateAPI
        public Color whiteTargetColor;
        @PrivateAPI
        public float[] temp1;
        @PrivateAPI
        public float[] temp2;
        @PrivateAPI
        public float[] temp3;

        @PrivateAPI
        public RunParameters(Color blackTargetColor, Color whiteTargetColor) {
            this.blackTargetColor = blackTargetColor;
            this.whiteTargetColor = whiteTargetColor;
            this.temp1 = CezanneColorUtil.intToARGB(0, null);
            this.temp2 = CezanneColorUtil.intToARGB(0, null);
            this.temp3 = CezanneColorUtil.intToARGB(0, null);
        }

        public RunParameters a() {
            RunParameters runParameters = (RunParameters)super.replicateForThread();
            runParameters.temp1 = (float[])runParameters.temp1.clone();
            runParameters.temp2 = (float[])runParameters.temp2.clone();
            runParameters.temp3 = (float[])runParameters.temp3.clone();
            return runParameters;
        }
    }
}

