/*
 * Decompiled with CFR 0.152.
 */
package de.pixopia.cezanne.color;

import de.pixopia.cezanne.util.CezanneReferenceInfo;
import de.pixopia.cezanne.util.CezanneReferenceTarget;
import de.pixopia.cezanne.util.CezanneReflection;
import de.pixopia.cezanne.util.CezanneStrings;
import de.pixopia.util.integrated.CodeGroup;
import de.pixopia.util.integrated.PrivateAPI;
import java.awt.Color;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

@PrivateAPI
@CodeGroup(value={"cezanne-core"})
public class CezanneColorUtil {
    @PrivateAPI
    public static final float PRECISION = 0.0019493178f;
    private static final String[] a;

    @PrivateAPI
    public static Color deriveColor(Color baseColor, float opacityFactor, float hueOffset, float saturationFactor, float brightnessFactor) {
        block12: {
            if (baseColor == null) {
                return null;
            }
            if (opacityFactor != 1.0f || hueOffset != 0.0f) break block12;
            if (saturationFactor != 1.0f) break block12;
            if (brightnessFactor != 1.0f) break block12;
            return baseColor;
        }
        float[] fArray = CezanneColorUtil.colorToAHSB(baseColor, null);
        fArray[0] = CezanneColorUtil.a(fArray[0], opacityFactor);
        fArray[1] = fArray[1] + hueOffset;
        fArray[2] = CezanneColorUtil.a(fArray[2], saturationFactor);
        fArray[3] = CezanneColorUtil.a(fArray[3], brightnessFactor);
        int n2 = CezanneColorUtil.ahsbToInt(fArray);
        Color color = new Color(n2, true);
        if (baseColor instanceof UIResource) {
            color = new ColorUIResource(color);
        }
        return color;
    }

    @PrivateAPI
    public static float[] calculateDerivation(Color baseColor, Color derivedColor) {
        float f2;
        float f3;
        float[] fArray;
        float[] fArray2;
        float[] fArray3;
        block20: {
            block22: {
                block21: {
                    fArray3 = new float[]{1.0f, 0.0f, 1.0f, 1.0f};
                    fArray2 = CezanneColorUtil.intToAHSB(derivedColor.getRGB(), null);
                    fArray = CezanneColorUtil.intToAHSB(baseColor.getRGB(), null);
                    f3 = 0.002f;
                    float f4 = CezanneColorUtil.a(fArray2[0], fArray[0], f3);
                    if (f4 != 1.0f) {
                        fArray3[0] = f4;
                    }
                    f2 = 0.0f;
                    if (!(fArray[2] >= f3) || !(fArray2[2] >= f3)) break block20;
                    f2 = fArray2[1] - fArray[1];
                    if (!(Math.abs(f2) >= f3)) break block20;
                    if (!(f2 <= -0.5f)) break block21;
                    f2 += 1.0f;
                    break block22;
                }
                if (f2 > 0.5f) {
                    f2 -= 1.0f;
                }
            }
            fArray3[1] = f2;
        }
        float f5 = CezanneColorUtil.a(fArray2[2], fArray[2], f3);
        if (f5 != 1.0f) {
            fArray3[2] = f5;
        }
        float f6 = CezanneColorUtil.a(fArray2[3], fArray[3], f3);
        if (f6 != 1.0f) {
            fArray3[3] = f6;
        }
        float f7 = 0.003921569f;
        if (Math.abs(f2) < 4.0f * f7) {
            float f8 = 0.2f * f7;
            float f9 = fArray3[2] - 8.0f * f7;
            float f10 = fArray3[2] + 8.0f * f7;
            float f11 = fArray3[3] - 8.0f * f7;
            float f12 = fArray3[3] + 8.0f * f7;
            int n2 = derivedColor.getRGB();
            float f13 = 0.0f;
            float f14 = 0.0f;
            float f15 = 0.0f;
            for (float f16 = f9; f16 < f10; f16 += f8) {
                for (float f17 = f11; f17 < f12; f17 += f8) {
                    Color color = CezanneColorUtil.deriveColor(baseColor, fArray3[0], 0.0f, f16, f17);
                    if (color.getRGB() != n2) continue;
                    f13 += f16;
                    f14 += f17;
                    f15 += 1.0f;
                }
            }
            if (f15 > 0.0f) {
                fArray3[1] = 0.0f;
                fArray3[2] = f13 / f15;
                fArray3[3] = f14 / f15;
            }
        }
        return fArray3;
    }

    protected static float a(float f2, float f3, float f4) {
        if (f3 < f4) {
            return 1.0f;
        }
        float f5 = f2 / f3;
        if (Math.abs(f5 - 1.0f) < f4) {
            f5 = 1.0f;
        }
        return f5;
    }

    protected static float a(float f2, float f3) {
        return Math.max(0.0f, Math.min(1.0f, f2 * f3));
    }

    @CezanneReferenceInfo(a=46, c=CezanneReferenceTarget.JVM, d=true)
    public static Color a(String string) {
        if (string == null) {
            throw new IllegalArgumentException(a[0]);
        }
        try {
            if (string.startsWith("#")) {
                Color color;
                ColorUIResource colorUIResource;
                int n2 = Long.decode(string).intValue();
                ColorUIResource colorUIResource2 = colorUIResource;
                ColorUIResource colorUIResource3 = colorUIResource;
                Color color2 = color;
                Color color3 = color;
                int n3 = n2;
                boolean bl = string.length() > 7;
                color2(n3, bl);
                colorUIResource2(color3);
                return colorUIResource3;
            }
            return new ColorUIResource((Color)CezanneReflection.a(CezanneReflection.a(Color.class, CezanneStrings.toUpperCaseInvariantLocale(string)), null));
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(a[2] + string + a[1], exception);
        }
    }

    public static String a(Color color) {
        int n2 = color.getRGB();
        int n3 = (n2 >> 24 & 0xFF) == 255 ? 6 : 8;
        int n4 = n3;
        String string = a[3] + Long.toHexString(n2);
        string = string.substring(string.length() - n4);
        return "#" + string;
    }

    @PrivateAPI
    public static void clip(float[] values) {
        for (int i2 = values.length - 1; i2 >= 0; --i2) {
            values[i2] = CezanneColorUtil.clip(values[i2]);
        }
    }

    @PrivateAPI
    public static float clip(float value) {
        return Math.max(0.0f, Math.min(1.0f, value));
    }

    @PrivateAPI
    public static float[] copy(float[] source, float[] destination) {
        if (source == destination) {
            return destination;
        }
        if (destination == null) {
            destination = new float[source.length];
        }
        for (int i2 = source.length - 1; i2 >= 0; --i2) {
            destination[i2] = source[i2];
        }
        return destination;
    }

    @PrivateAPI
    public static void multiply(float[] axxx, float factor, boolean affectAlpha) {
        int n2 = affectAlpha ? 0 : 1;
        int n3 = n2;
        while (n3 < axxx.length) {
            int n4 = n3++;
            axxx[n4] = axxx[n4] * factor;
        }
    }

    @PrivateAPI
    public static void add(float[] axxx, float summand, boolean affectAlpha) {
        int n2 = affectAlpha ? 0 : 1;
        int n3 = n2;
        while (n3 < axxx.length) {
            int n4 = n3++;
            axxx[n4] = axxx[n4] + summand;
        }
    }

    @PrivateAPI
    public static void multiplyAndAdd(float[] axxx, float factor, float summand, boolean affectAlpha) {
        int n2;
        int n3 = n2 = affectAlpha ? 0 : 1;
        while (n2 < axxx.length) {
            float f2 = axxx[n2];
            axxx[n2] = f2 * factor + summand;
            ++n2;
        }
    }

    @PrivateAPI
    public static float min(float[] axxx, boolean affectAlpha) {
        float f2 = axxx[2];
        float f3 = axxx[3];
        if (f2 < f3) {
            f3 = f2;
        }
        if ((f2 = axxx[1]) < f3) {
            f3 = f2;
        }
        if (affectAlpha && (f2 = axxx[0]) < f3) {
            f3 = f2;
        }
        return f3;
    }

    @PrivateAPI
    public static float max(float[] axxx, boolean affectAlpha) {
        float f2 = axxx[2];
        float f3 = axxx[3];
        if (f2 > f3) {
            f3 = f2;
        }
        if ((f2 = axxx[1]) > f3) {
            f3 = f2;
        }
        if (affectAlpha && (f2 = axxx[0]) > f3) {
            f3 = f2;
        }
        return f3;
    }

    @PrivateAPI
    public static float[] set(float f0, float f1, float f2, float f3, float[] result) {
        if (result == null) {
            result = new float[]{f0, f1, f2, f3};
        }
        return result;
    }

    @PrivateAPI
    public static int floatToInt(float value) {
        int n2 = (int)(value * 255.0f + 0.5f);
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > 255) {
            n2 = 255;
        }
        return n2;
    }

    @PrivateAPI
    public static float intToFloat(int i2) {
        return (float)(i2 & 0xFF) / 255.0f;
    }

    @PrivateAPI
    public static float[] colorToARGB(Color color, float[] result) {
        int n2 = color == null ? 0 : color.getRGB();
        return CezanneColorUtil.intToARGB(n2, result);
    }

    @PrivateAPI
    public static float[] intToARGB(int argb, float[] result) {
        if (result == null) {
            result = new float[]{CezanneColorUtil.intToFloat(argb >>> 24 & 0xFF), CezanneColorUtil.intToFloat(argb >>> 16 & 0xFF), CezanneColorUtil.intToFloat(argb >>> 8 & 0xFF), CezanneColorUtil.intToFloat(argb & 0xFF)};
        }
        return result;
    }

    @PrivateAPI
    public static int argbToInt(float[] argb) {
        return CezanneColorUtil.argbToInt(argb[0], argb[1], argb[2], argb[3]);
    }

    @PrivateAPI
    public static int argbToInt(float alpha, float red, float green, float blue) {
        return CezanneColorUtil.floatToInt(alpha) << 24 | CezanneColorUtil.floatToInt(red) << 16 | CezanneColorUtil.floatToInt(green) << 8 | CezanneColorUtil.floatToInt(blue);
    }

    @PrivateAPI
    public static float[] colorToAHSB(Color color, float[] result) {
        int n2 = color == null ? 0 : color.getRGB();
        return CezanneColorUtil.intToAHSB(n2, result);
    }

    @PrivateAPI
    public static float[] argbToAHSB(float[] argb, float[] result) {
        float f2;
        float f3;
        float f4;
        float f5 = argb[1];
        float f6 = argb[2];
        float f7 = argb[3];
        float f8 = f4 = f5 > f6 ? f5 : f6;
        if (f7 > f4) {
            f4 = f7;
        }
        float f9 = f3 = f5 < f6 ? f5 : f6;
        if (f7 < f3) {
            f3 = f7;
        }
        float f10 = f4;
        float f11 = f4 != 0.0f ? (f4 - f3) / f4 : 0.0f;
        if (f11 == 0.0f) {
            f2 = 0.0f;
        } else {
            float f12 = (f4 - f5) / (f4 - f3);
            float f13 = (f4 - f6) / (f4 - f3);
            float f14 = (f4 - f7) / (f4 - f3);
            f2 = f5 == f4 ? f14 - f13 : (f6 == f4 ? 2.0f + f12 - f14 : 4.0f + f13 - f12);
            if ((f2 /= 6.0f) < 0.0f) {
                f2 += 1.0f;
            }
        }
        if (result == null) {
            result = new float[]{argb[0], f2, f11, f10};
        }
        return result;
    }

    @PrivateAPI
    public static float[] intToAHSB(int argb, float[] result) {
        if (result == null) {
            result = new float[4];
        }
        Color.RGBtoHSB(argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF, result);
        result[3] = result[2];
        result[2] = result[1];
        result[1] = result[0];
        result[0] = CezanneColorUtil.intToFloat(argb >>> 24 & 0xFF);
        return result;
    }

    @PrivateAPI
    public static int ahsbToInt(float[] ahsb) {
        return CezanneColorUtil.ahsbToInt(ahsb[0], ahsb[1], ahsb[2], ahsb[3]);
    }

    @PrivateAPI
    public static float[] ahsbToARGB(float[] ahsb, float[] result) {
        float f2 = ahsb[1];
        float f3 = ahsb[2];
        float f4 = ahsb[3];
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        if (f3 == 0.0f) {
            f6 = f7 = f4;
            f5 = f7;
        } else {
            float f8 = (f2 - (float)Math.floor(f2)) * 6.0f;
            float f9 = f8 - (float)Math.floor(f8);
            float f10 = f4 * (1.0f - f3);
            float f11 = f4 * (1.0f - f3 * f9);
            float f12 = f4 * (1.0f - f3 * (1.0f - f9));
            switch ((int)f8) {
                case 0: {
                    f5 = f4;
                    f6 = f12;
                    f7 = f10;
                    break;
                }
                case 1: {
                    f5 = f11;
                    f6 = f4;
                    f7 = f10;
                    break;
                }
                case 2: {
                    f5 = f10;
                    f6 = f4;
                    f7 = f12;
                    break;
                }
                case 3: {
                    f5 = f10;
                    f6 = f11;
                    f7 = f4;
                    break;
                }
                case 4: {
                    f5 = f12;
                    f6 = f10;
                    f7 = f4;
                    break;
                }
                case 5: {
                    f5 = f4;
                    f6 = f10;
                    f7 = f11;
                }
            }
        }
        if (result == null) {
            result = new float[]{ahsb[0], f5, f6, f7};
        }
        return result;
    }

    @PrivateAPI
    public static int ahsbToInt(float alpha, float hue, float saturation, float brightness) {
        return Color.HSBtoRGB(hue, saturation, brightness) & 0xFFFFFF | CezanneColorUtil.floatToInt(alpha) << 24;
    }

    @PrivateAPI
    public static void debugCheckFloat(float f2, String context) {
        block8: {
            block7: {
                if (Float.isInfinite(f2) || Float.isNaN(f2)) break block7;
                if (f2 < 0.0f) break block7;
                if (!(f2 > 1.0f)) break block8;
            }
            String string = a[4];
            if (context != null) {
                string = string + "(" + context + a[5];
            }
            string = string + f2;
            System.err.println(string);
        }
    }

    @PrivateAPI
    public static void blendSourceOver(float[] destinationARGB, float[] sourceARGB) {
        CezanneColorUtil.blendSourceOver(destinationARGB, sourceARGB, 1.0f);
    }

    @PrivateAPI
    public static void blendSourceOver(float[] destinationARGB, float[] sourceARGB, float additionalSourceAlpha) {
        float f2;
        block6: {
            float f3;
            block5: {
                f3 = sourceARGB[0] * additionalSourceAlpha;
                f2 = f3 + destinationARGB[0] * (1.0f - f3);
                if (f2 != 0.0f) break block5;
                destinationARGB[3] = 0.0f;
                destinationARGB[2] = 0.0f;
                destinationARGB[1] = 0.0f;
                break block6;
            }
            for (int i2 = 1; i2 <= 3; ++i2) {
                destinationARGB[i2] = (f3 * sourceARGB[i2] + destinationARGB[0] * destinationARGB[i2] * (1.0f - f3)) / f2;
            }
        }
        destinationARGB[0] = f2;
    }

    @PrivateAPI
    public static void blendSourceOver(float[] destinationARGB, float sourceA, float sourceR, float sourceG, float sourceB) {
        float f2;
        block3: {
            float f3;
            block2: {
                f3 = destinationARGB[0];
                f2 = sourceA + f3 * (1.0f - sourceA);
                if (f2 != 0.0f) break block2;
                destinationARGB[3] = 0.0f;
                destinationARGB[2] = 0.0f;
                destinationARGB[1] = 0.0f;
                break block3;
            }
            destinationARGB[1] = (sourceA * sourceR + f3 * destinationARGB[1] * (1.0f - sourceA)) / f2;
            destinationARGB[2] = (sourceA * sourceG + f3 * destinationARGB[2] * (1.0f - sourceA)) / f2;
            destinationARGB[3] = (sourceA * sourceB + f3 * destinationARGB[3] * (1.0f - sourceA)) / f2;
        }
        destinationARGB[0] = f2;
    }

    public static int b(int n2, int n3) {
        int n4 = n2 >>> 24 & 0xFF;
        int n5 = n2 >>> 16 & 0xFF;
        int n6 = n2 >>> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        int n8 = n3 >>> 24 & 0xFF;
        int n9 = n3 >>> 16 & 0xFF;
        int n10 = n3 >>> 8 & 0xFF;
        int n11 = n3 & 0xFF;
        n4 = (n8 * 255 + n4 * (255 - n8)) / 255;
        n5 = (n9 * n8 + n5 * (255 - n8)) / 255;
        n6 = (n10 * n8 + n6 * (255 - n8)) / 255;
        n7 = (n11 * n8 + n7 * (255 - n8)) / 255;
        return (n4 & 0xFF) << 24 | (n5 & 0xFF) << 16 | (n6 & 0xFF) << 8 | n7 & 0xFF;
    }

    @PrivateAPI
    public static int reverseBlendSourceOver(int compositionARGB, int backgroundARGB) {
        float[] fArray = new float[4];
        CezanneColorUtil.reverseBlendSourceOver(CezanneColorUtil.intToARGB(compositionARGB, null), CezanneColorUtil.intToARGB(backgroundARGB, null), fArray);
        return CezanneColorUtil.argbToInt(fArray);
    }

    @PrivateAPI
    public static void reverseBlendSourceOver(float[] compositionARGB, float[] backgroundARGB, float[] overlayARGB) {
        block8: {
            int n2;
            float f2;
            block7: {
                f2 = 0.0f;
                for (n2 = 1; n2 <= 3; ++n2) {
                    float f3 = compositionARGB[n2] - backgroundARGB[n2];
                    if (f3 > 0.0019493178f) {
                        f2 = Math.max(f2, f3 / (1.0f - backgroundARGB[n2]));
                        continue;
                    }
                    if (!(f3 < -0.0019493178f)) continue;
                    f2 = Math.max(f2, -f3 / backgroundARGB[n2]);
                }
                if (!(f2 < 0.0019493178f)) break block7;
                overlayARGB[3] = 0.0f;
                overlayARGB[2] = 0.0f;
                overlayARGB[1] = 0.0f;
                overlayARGB[0] = 0.0f;
                break block8;
            }
            overlayARGB[0] = f2;
            for (n2 = 1; n2 <= 3; ++n2) {
                overlayARGB[n2] = (compositionARGB[n2] + (overlayARGB[0] - 1.0f) * backgroundARGB[n2]) / overlayARGB[0];
            }
            CezanneColorUtil.clip(overlayARGB);
        }
    }

    public static Color a(Color color, Color color2) {
        boolean bl;
        Color color3;
        block5: {
            block4: {
                color3 = color;
                if (color2 != null && !(color2 instanceof UIResource)) break block4;
                bl = true;
                break block5;
            }
            bl = false;
        }
        return CezanneColorUtil.a(color3, bl);
    }

    public static Color a(Color color, boolean bl) {
        block4: {
            block3: {
                if (!bl) break block3;
                if (color instanceof UIResource) break block4;
                color = new ColorUIResource(color);
                break block4;
            }
            if (color instanceof ColorUIResource) {
                color = new Color(color.getRGB(), true);
            }
        }
        return color;
    }

    public static float a(float[] fArray) {
        float f2;
        if (fArray == null) {
            return 0.0f;
        }
        float f3 = f2 = fArray[1];
        float f4 = fArray[2];
        if (f4 < f2) {
            f2 = f4;
        }
        if (f4 > f3) {
            f3 = f4;
        }
        if ((f4 = fArray[3]) < f2) {
            f2 = f4;
        }
        if (f4 > f3) {
            f3 = f4;
        }
        return (f3 - f2) / f3;
    }

    public static float b(float[] fArray) {
        if (fArray == null) {
            return 0.0f;
        }
        float f2 = fArray[1];
        float f3 = fArray[2];
        if (f3 > f2) {
            f2 = f3;
        }
        if ((f3 = fArray[3]) > f2) {
            f2 = f3;
        }
        return f2;
    }

    public static boolean b(Color color, Color color2) {
        block8: {
            boolean bl;
            block10: {
                block9: {
                    if (color != null && color2 != null) break block8;
                    if (color != null) break block9;
                    if (color2 != null) break block9;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
            return bl;
        }
        return CezanneColorUtil.c(color.getRGB(), color2.getRGB());
    }

    public static boolean c(int n2, int n3) {
        block6: {
            boolean bl;
            block8: {
                block7: {
                    if ((n2 & 0xFF000000) != 0) break block6;
                    if ((n3 & 0xFF000000) != 0) break block7;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
            return bl;
        }
        boolean bl = n2 == n3;
        return bl;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        String string;
        String[] stringArray = new String[6];
        String[] stringArray2 = stringArray;
        String[] stringArray3 = stringArray;
        int n2 = 0;
        String string2 = "d-A\u0012_\u00074L\u0011XBb@\b^SbC\u0012Y\u0007 H]CR.AS";
        int n3 = -1;
        block13: while (true) {
            char[] cArray;
            block18: {
                int n4;
                int n5;
                char[] cArray2;
                int n6;
                block17: {
                    char[] cArray3 = string2.toCharArray();
                    n6 = 0;
                    int n7 = cArray3.length;
                    cArray2 = cArray3;
                    n5 = n7;
                    if (n7 <= 1) break block17;
                    cArray = cArray2;
                    n4 = n5;
                    if (n5 <= n6) break block18;
                }
                do {
                    char[] cArray4 = cArray2;
                    char[] cArray5 = cArray2;
                    int n8 = n6;
                    while (true) {
                        int n9;
                        char c2 = cArray4[n8];
                        switch (n6 % 5) {
                            case 0: {
                                n9 = 39;
                                break;
                            }
                            case 1: {
                                n9 = 66;
                                break;
                            }
                            case 2: {
                                n9 = 45;
                                break;
                            }
                            case 3: {
                                n9 = 125;
                                break;
                            }
                            default: {
                                n9 = 45;
                            }
                        }
                        cArray4[n8] = (char)(c2 ^ n9);
                        ++n6;
                        cArray2 = cArray5;
                        n5 = n5;
                        if (n5 != 0) break;
                        cArray5 = cArray2;
                        n4 = n5;
                        n8 = n5;
                        cArray4 = cArray2;
                    }
                    cArray = cArray2;
                    n4 = n5;
                } while (n5 > n6);
            }
            string = new String(cArray);
            switch (n3) {
                default: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 1;
                    string2 = "\u0000l";
                    n3 = 0;
                    continue block13;
                }
                case 0: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 2;
                    string2 = "n,[\u001cAN&\r>BK-_][F.X\u0018\r\u0000";
                    n3 = 1;
                    continue block13;
                }
                case 1: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 3;
                    string2 = "\u0017r\u001dM\u001d\u0017r\u001d";
                    n3 = 2;
                    continue block13;
                }
                case 2: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 4;
                    string2 = "n.A\u0018JF.\r\u001bAH#Y]";
                    n3 = 3;
                    continue block13;
                }
                case 3: {
                    stringArray2[n2] = string.intern();
                    stringArray2 = stringArray3;
                    stringArray3 = stringArray3;
                    n2 = 5;
                    string2 = "\u000eb";
                    n3 = 4;
                    continue block13;
                }
                case 4: 
            }
            break;
        }
        stringArray2[n2] = string.intern();
        a = stringArray3;
    }
}

