/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorUInt32;

public class VectorUIntList
extends AbstractList<VectorUInt32>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorUIntList(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorUIntList vectorUIntList) {
        return vectorUIntList == null ? 0L : vectorUIntList.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorUIntList(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorUIntList(VectorUInt32[] vectorUInt32Array) {
        this();
        this.reserve(vectorUInt32Array.length);
        for (VectorUInt32 vectorUInt32 : vectorUInt32Array) {
            this.add(vectorUInt32);
        }
    }

    public VectorUIntList(Iterable<VectorUInt32> iterable) {
        this();
        for (VectorUInt32 vectorUInt32 : iterable) {
            this.add(vectorUInt32);
        }
    }

    @Override
    public VectorUInt32 get(int n) {
        return this.doGet(n);
    }

    @Override
    public VectorUInt32 set(int n, VectorUInt32 vectorUInt32) {
        return this.doSet(n, vectorUInt32);
    }

    @Override
    public boolean add(VectorUInt32 vectorUInt32) {
        ++this.modCount;
        this.doAdd(vectorUInt32);
        return true;
    }

    @Override
    public void add(int n, VectorUInt32 vectorUInt32) {
        ++this.modCount;
        this.doAdd(n, vectorUInt32);
    }

    @Override
    public VectorUInt32 remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorUIntList() {
        this(SimpleITKJNI.new_VectorUIntList__SWIG_0(), true);
    }

    public VectorUIntList(VectorUIntList vectorUIntList) {
        this(SimpleITKJNI.new_VectorUIntList__SWIG_1(VectorUIntList.getCPtr(vectorUIntList), vectorUIntList), true);
    }

    public long capacity() {
        return SimpleITKJNI.VectorUIntList_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        SimpleITKJNI.VectorUIntList_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorUIntList_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorUIntList_clear(this.swigCPtr, this);
    }

    public VectorUIntList(int n, VectorUInt32 vectorUInt32) {
        this(SimpleITKJNI.new_VectorUIntList__SWIG_2(n, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    private int doSize() {
        return SimpleITKJNI.VectorUIntList_doSize(this.swigCPtr, this);
    }

    private void doAdd(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.VectorUIntList_doAdd__SWIG_0(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    private void doAdd(int n, VectorUInt32 vectorUInt32) {
        SimpleITKJNI.VectorUIntList_doAdd__SWIG_1(this.swigCPtr, this, n, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    private VectorUInt32 doRemove(int n) {
        return new VectorUInt32(SimpleITKJNI.VectorUIntList_doRemove(this.swigCPtr, this, n), true);
    }

    private VectorUInt32 doGet(int n) {
        return new VectorUInt32(SimpleITKJNI.VectorUIntList_doGet(this.swigCPtr, this, n), false);
    }

    private VectorUInt32 doSet(int n, VectorUInt32 vectorUInt32) {
        return new VectorUInt32(SimpleITKJNI.VectorUIntList_doSet(this.swigCPtr, this, n, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32), true);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorUIntList_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

