/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.math.BigInteger;
import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorUInt64
extends AbstractList<BigInteger>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorUInt64(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorUInt64 vectorUInt64) {
        return vectorUInt64 == null ? 0L : vectorUInt64.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorUInt64(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorUInt64(BigInteger[] bigIntegerArray) {
        this();
        this.reserve(bigIntegerArray.length);
        for (BigInteger bigInteger : bigIntegerArray) {
            this.add(bigInteger);
        }
    }

    public VectorUInt64(Iterable<BigInteger> iterable) {
        this();
        for (BigInteger bigInteger : iterable) {
            this.add(bigInteger);
        }
    }

    @Override
    public BigInteger get(int n) {
        return this.doGet(n);
    }

    @Override
    public BigInteger set(int n, BigInteger bigInteger) {
        return this.doSet(n, bigInteger);
    }

    @Override
    public boolean add(BigInteger bigInteger) {
        ++this.modCount;
        this.doAdd(bigInteger);
        return true;
    }

    @Override
    public void add(int n, BigInteger bigInteger) {
        ++this.modCount;
        this.doAdd(n, bigInteger);
    }

    @Override
    public BigInteger remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorUInt64() {
        this(SimpleITKJNI.new_VectorUInt64__SWIG_0(), true);
    }

    public VectorUInt64(VectorUInt64 vectorUInt64) {
        this(SimpleITKJNI.new_VectorUInt64__SWIG_1(VectorUInt64.getCPtr(vectorUInt64), vectorUInt64), true);
    }

    public long capacity() {
        return SimpleITKJNI.VectorUInt64_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        SimpleITKJNI.VectorUInt64_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorUInt64_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorUInt64_clear(this.swigCPtr, this);
    }

    public VectorUInt64(int n, BigInteger bigInteger) {
        this(SimpleITKJNI.new_VectorUInt64__SWIG_2(n, bigInteger), true);
    }

    private int doSize() {
        return SimpleITKJNI.VectorUInt64_doSize(this.swigCPtr, this);
    }

    private void doAdd(BigInteger bigInteger) {
        SimpleITKJNI.VectorUInt64_doAdd__SWIG_0(this.swigCPtr, this, bigInteger);
    }

    private void doAdd(int n, BigInteger bigInteger) {
        SimpleITKJNI.VectorUInt64_doAdd__SWIG_1(this.swigCPtr, this, n, bigInteger);
    }

    private BigInteger doRemove(int n) {
        return SimpleITKJNI.VectorUInt64_doRemove(this.swigCPtr, this, n);
    }

    private BigInteger doGet(int n) {
        return SimpleITKJNI.VectorUInt64_doGet(this.swigCPtr, this, n);
    }

    private BigInteger doSet(int n, BigInteger bigInteger) {
        return SimpleITKJNI.VectorUInt64_doSet(this.swigCPtr, this, n, bigInteger);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorUInt64_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

