/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.Image;
import org.itk.simple.SimpleITKJNI;

public class VectorOfImage
extends AbstractList<Image>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorOfImage(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorOfImage vectorOfImage) {
        return vectorOfImage == null ? 0L : vectorOfImage.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorOfImage(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorOfImage(Image[] imageArray) {
        this();
        this.reserve(imageArray.length);
        for (Image image : imageArray) {
            this.add(image);
        }
    }

    public VectorOfImage(Iterable<Image> iterable) {
        this();
        for (Image image : iterable) {
            this.add(image);
        }
    }

    @Override
    public Image get(int n) {
        return this.doGet(n);
    }

    @Override
    public Image set(int n, Image image) {
        return this.doSet(n, image);
    }

    @Override
    public boolean add(Image image) {
        ++this.modCount;
        this.doAdd(image);
        return true;
    }

    @Override
    public void add(int n, Image image) {
        ++this.modCount;
        this.doAdd(n, image);
    }

    @Override
    public Image remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public VectorOfImage() {
        this(SimpleITKJNI.new_VectorOfImage__SWIG_0(), true);
    }

    public VectorOfImage(VectorOfImage vectorOfImage) {
        this(SimpleITKJNI.new_VectorOfImage__SWIG_1(VectorOfImage.getCPtr(vectorOfImage), vectorOfImage), true);
    }

    public long capacity() {
        return SimpleITKJNI.VectorOfImage_capacity(this.swigCPtr, this);
    }

    public void reserve(long l) {
        SimpleITKJNI.VectorOfImage_reserve(this.swigCPtr, this, l);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorOfImage_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorOfImage_clear(this.swigCPtr, this);
    }

    public VectorOfImage(int n, Image image) {
        this(SimpleITKJNI.new_VectorOfImage__SWIG_2(n, Image.getCPtr(image), image), true);
    }

    private int doSize() {
        return SimpleITKJNI.VectorOfImage_doSize(this.swigCPtr, this);
    }

    private void doAdd(Image image) {
        SimpleITKJNI.VectorOfImage_doAdd__SWIG_0(this.swigCPtr, this, Image.getCPtr(image), image);
    }

    private void doAdd(int n, Image image) {
        SimpleITKJNI.VectorOfImage_doAdd__SWIG_1(this.swigCPtr, this, n, Image.getCPtr(image), image);
    }

    private Image doRemove(int n) {
        return new Image(SimpleITKJNI.VectorOfImage_doRemove(this.swigCPtr, this, n), true);
    }

    private Image doGet(int n) {
        return new Image(SimpleITKJNI.VectorOfImage_doGet(this.swigCPtr, this, n), false);
    }

    private Image doSet(int n, Image image) {
        return new Image(SimpleITKJNI.VectorOfImage_doSet(this.swigCPtr, this, n, Image.getCPtr(image), image), true);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorOfImage_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

