/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import org.itk.simple.Image;
import org.itk.simple.ImageFilter;
import org.itk.simple.PixelIDValueEnum;
import org.itk.simple.SimpleITKJNI;
import org.itk.simple.VectorDouble;
import org.itk.simple.VectorUInt32;

public class GridImageSource
extends ImageFilter {
    private transient long swigCPtr;

    protected GridImageSource(long l, boolean bl) {
        super(SimpleITKJNI.GridImageSource_SWIGUpcast(l), bl);
        this.swigCPtr = l;
    }

    protected static long getCPtr(GridImageSource gridImageSource) {
        return gridImageSource == null ? 0L : gridImageSource.swigCPtr;
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_GridImageSource(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public GridImageSource() {
        this(SimpleITKJNI.new_GridImageSource(), true);
    }

    public void setOutputPixelType(PixelIDValueEnum pixelIDValueEnum) {
        SimpleITKJNI.GridImageSource_setOutputPixelType(this.swigCPtr, this, pixelIDValueEnum.swigValue());
    }

    public PixelIDValueEnum getOutputPixelType() {
        return PixelIDValueEnum.swigToEnum(SimpleITKJNI.GridImageSource_getOutputPixelType(this.swigCPtr, this));
    }

    public void setSize(VectorUInt32 vectorUInt32) {
        SimpleITKJNI.GridImageSource_setSize(this.swigCPtr, this, VectorUInt32.getCPtr(vectorUInt32), vectorUInt32);
    }

    public VectorUInt32 getSize() {
        return new VectorUInt32(SimpleITKJNI.GridImageSource_getSize(this.swigCPtr, this), true);
    }

    public void setSigma(VectorDouble vectorDouble) {
        SimpleITKJNI.GridImageSource_setSigma__SWIG_0(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public void setSigma(double d) {
        SimpleITKJNI.GridImageSource_setSigma__SWIG_1(this.swigCPtr, this, d);
    }

    public VectorDouble getSigma() {
        return new VectorDouble(SimpleITKJNI.GridImageSource_getSigma(this.swigCPtr, this), true);
    }

    public void setGridSpacing(VectorDouble vectorDouble) {
        SimpleITKJNI.GridImageSource_setGridSpacing(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getGridSpacing() {
        return new VectorDouble(SimpleITKJNI.GridImageSource_getGridSpacing(this.swigCPtr, this), true);
    }

    public void setGridOffset(VectorDouble vectorDouble) {
        SimpleITKJNI.GridImageSource_setGridOffset(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getGridOffset() {
        return new VectorDouble(SimpleITKJNI.GridImageSource_getGridOffset(this.swigCPtr, this), true);
    }

    public void setScale(double d) {
        SimpleITKJNI.GridImageSource_setScale(this.swigCPtr, this, d);
    }

    public double getScale() {
        return SimpleITKJNI.GridImageSource_getScale(this.swigCPtr, this);
    }

    public void setOrigin(VectorDouble vectorDouble) {
        SimpleITKJNI.GridImageSource_setOrigin(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getOrigin() {
        return new VectorDouble(SimpleITKJNI.GridImageSource_getOrigin(this.swigCPtr, this), true);
    }

    public void setSpacing(VectorDouble vectorDouble) {
        SimpleITKJNI.GridImageSource_setSpacing(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getSpacing() {
        return new VectorDouble(SimpleITKJNI.GridImageSource_getSpacing(this.swigCPtr, this), true);
    }

    public void setDirection(VectorDouble vectorDouble) {
        SimpleITKJNI.GridImageSource_setDirection(this.swigCPtr, this, VectorDouble.getCPtr(vectorDouble), vectorDouble);
    }

    public VectorDouble getDirection() {
        return new VectorDouble(SimpleITKJNI.GridImageSource_getDirection(this.swigCPtr, this), true);
    }

    @Override
    public String getName() {
        return SimpleITKJNI.GridImageSource_getName(this.swigCPtr, this);
    }

    @Override
    public String toString() {
        return SimpleITKJNI.GridImageSource_toString(this.swigCPtr, this);
    }

    public Image execute() {
        return new Image(SimpleITKJNI.GridImageSource_execute(this.swigCPtr, this), true);
    }
}

