/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.io.im;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.im.spi.InputMethod;
import java.awt.im.spi.InputMethodContext;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedString;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import net.hussnain.beans.keyboard.VirtualKeyboard;
import net.hussnain.io.im.RabtControlObject;

public class RabtInputMethod
implements InputMethod {
    private static Logger logger = Logger.getLogger("RabtInputMethod");
    private static boolean lookUpTablesLoaded;
    private static RabtControlObjectImpl rabtIMControl;
    private static Locale[] SUPPORTED_LOCALES;
    private static Hashtable localesIndex;
    private static Hashtable localesProps;
    private static Hashtable specificLocalesProps;
    private static Hashtable normalLocalesProps;
    private static Hashtable kbNormalLocalesProps;
    private static Hashtable altLocalesProps;
    private static Hashtable altgLocalesProps;
    private static Hashtable shiftedLocalesProps;
    private static Window statusWindow;
    private static final String statusWindowTitle = "Rabt VirtualKeyboard";
    private static boolean vkbVisible;
    private static VirtualKeyboard keyboard;
    private static RabtInputMethod statusWindowOwner;
    private static boolean attachedStatusWindow;
    private Rectangle clientWindowLocation;
    private static Point globalStatusWindowLocation;
    private static HashSet rabtInputMethodInstances;
    static Method methodCreateInputMethodJFrame;
    InputMethodContext inputMethodContext;
    private boolean active;
    private boolean disposed;
    private Locale locale;
    private boolean converted;
    private StringBuffer rawText;
    private String convertedText;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$awt$im$spi$InputMethodContext;

    public RabtInputMethod(Hashtable p_locales, Hashtable p_localeProperties) throws IOException {
        if (!lookUpTablesLoaded) {
            localesIndex = p_locales;
            localesProps = p_localeProperties;
            SUPPORTED_LOCALES = p_locales.values().toArray(new Locale[0]);
            normalLocalesProps = new Hashtable();
            kbNormalLocalesProps = new Hashtable();
            altLocalesProps = new Hashtable();
            altgLocalesProps = new Hashtable();
            shiftedLocalesProps = new Hashtable();
            specificLocalesProps = new Hashtable();
            this.initializeTables();
            rabtIMControl = new RabtControlObjectImpl();
        }
        this.rawText = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputMethodContext(InputMethodContext context) {
        this.inputMethodContext = context;
        if (statusWindow == null) {
            Window sw;
            if (methodCreateInputMethodJFrame != null) {
                try {
                    Object[] params = new Object[]{statusWindowTitle, Boolean.FALSE};
                    sw = (Window)methodCreateInputMethodJFrame.invoke((Object)context, params);
                }
                catch (Exception e) {
                    sw = context.createInputMethodWindow(statusWindowTitle, false);
                }
            } else {
                sw = context.createInputMethodWindow(statusWindowTitle, false);
            }
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setForeground(Color.black);
            label.setBackground(Color.white);
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                if (statusWindow == null) {
                    statusWindow = sw;
                    statusWindow.addComponentListener(new ComponentAdapter(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void componentMoved(ComponentEvent e) {
                            Window window = statusWindow;
                            synchronized (window) {
                                Component comp;
                                if (!attachedStatusWindow && (comp = e.getComponent()).isVisible()) {
                                    globalStatusWindowLocation = comp.getLocation();
                                }
                            }
                        }
                    });
                    label.addMouseListener(new MouseAdapter(){

                        public void mouseClicked(MouseEvent e) {
                            int count = e.getClickCount();
                            if (count >= 2) {
                                RabtInputMethod.this.toggleStatusWindowStyle();
                            }
                        }
                    });
                    keyboard = new VirtualKeyboard(this);
                    if (statusWindow instanceof JFrame) {
                        ((JFrame)statusWindow).getContentPane().setLayout(new BorderLayout());
                        ((JFrame)statusWindow).getContentPane().add((Component)keyboard, "North");
                        ((JFrame)statusWindow).getContentPane().add((Component)label, "Center");
                    } else {
                        statusWindow.setLayout(new BorderLayout());
                        statusWindow.add((Component)keyboard, "North");
                        statusWindow.add((Component)label, "Center");
                    }
                    statusWindowOwner = this;
                    this.updateStatusWindow(this.locale);
                    label.setSize(200, 50);
                    statusWindow.pack();
                }
            }
        }
        this.inputMethodContext.enableClientWindowNotification(this, attachedStatusWindow);
        Window window = statusWindow;
        synchronized (window) {
            rabtInputMethodInstances.add(this);
        }
    }

    public boolean setLocale(Locale locale) {
        for (int i = 0; i < SUPPORTED_LOCALES.length; ++i) {
            if (!locale.equals(SUPPORTED_LOCALES[i])) continue;
            this.locale = locale;
            if (statusWindow != null) {
                this.updateStatusWindow(locale);
            }
            return true;
        }
        return false;
    }

    public Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateStatusWindow(Locale locale) {
        Window window = statusWindow;
        synchronized (window) {
            JLabel label = statusWindow instanceof JFrame ? (JLabel)((JFrame)statusWindow).getContentPane().getComponent(1) : (JLabel)statusWindow.getComponent(1);
            String localeName = locale == null ? "null" : locale.getDisplayName();
            String text = "Current Locale : " + localeName;
            if (!label.getText().equals(text)) {
                label.setText(text);
                Hashtable normLocProp = (Hashtable)kbNormalLocalesProps.get(locale.getLanguage());
                Hashtable shiftedLocProp = (Hashtable)shiftedLocalesProps.get(locale.getLanguage());
                Hashtable altLocProp = (Hashtable)altLocalesProps.get(locale.getLanguage());
                Hashtable altgLocrop = (Hashtable)altgLocalesProps.get(locale.getLanguage());
                keyboard.setKeymaps(normLocProp, shiftedLocProp, altLocProp, altgLocrop);
                statusWindow.pack();
            }
            if (attachedStatusWindow) {
                if (this.clientWindowLocation != null) {
                    statusWindow.setLocation(this.clientWindowLocation.x, this.clientWindowLocation.y + this.clientWindowLocation.height);
                }
            } else {
                this.setPCStyleStatusWindow();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPCStyleStatusWindow() {
        Window window = statusWindow;
        synchronized (window) {
            if (globalStatusWindowLocation == null) {
                Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                globalStatusWindowLocation = new Point(d.width - statusWindow.getWidth(), d.height - statusWindow.getHeight() - 50);
            }
            statusWindow.setLocation(RabtInputMethod.globalStatusWindowLocation.x, RabtInputMethod.globalStatusWindowLocation.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStatusWindowForeground(Color fg) {
        Window window = statusWindow;
        synchronized (window) {
            if (statusWindowOwner != this) {
                return;
            }
            JLabel label = statusWindow instanceof JFrame ? (JLabel)((JFrame)statusWindow).getContentPane().getComponent(1) : (JLabel)statusWindow.getComponent(1);
            label.setForeground(fg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void toggleStatusWindowStyle() {
        Window window = statusWindow;
        synchronized (window) {
            if (attachedStatusWindow) {
                attachedStatusWindow = false;
                this.setPCStyleStatusWindow();
            } else {
                attachedStatusWindow = true;
            }
            Iterator itr = rabtInputMethodInstances.iterator();
            while (itr.hasNext()) {
                RabtInputMethod im = (RabtInputMethod)itr.next();
                im.inputMethodContext.enableClientWindowNotification(im, attachedStatusWindow);
            }
        }
    }

    public void setCharacterSubsets(Character.Subset[] subsets) {
    }

    public void reconvert() {
        throw new UnsupportedOperationException();
    }

    public void dispatchEvent(AWTEvent event) {
        InputEvent e;
        boolean consumed = false;
        if (!this.active && event instanceof KeyEvent) {
            logger.warning("RabtInputMethod.dispatch called with KeyEvent while not active");
        }
        if (this.disposed) {
            logger.warning("RabtInputMethod.dispatch called after being disposed");
        }
        if (!(event instanceof InputEvent)) {
            logger.warning("RabtInputMethod.dispatch called with event that's not an InputEvent");
        }
        if (event.getID() == 500 && event.getSource() instanceof AbstractButton) {
            e = (MouseEvent)event;
            AbstractButton button = (AbstractButton)e.getSource();
            String sendString = button.getText();
            if (sendString.equals("Space")) {
                sendString = " ";
            } else if (sendString.equals("Ent")) {
                sendString = System.getProperty("line.separator");
                logger.info(">> new line char ist " + sendString);
            } else if (sendString.equals("BackSp")) {
                sendString = new String(new char[]{'\b'});
            }
            AttributedString as = new AttributedString(sendString);
            this.inputMethodContext.dispatchInputMethodEvent(1100, as.getIterator(), sendString.length(), null, null);
            e.consume();
        }
        if (event.getID() == 400 && this.handleCharacter((KeyEvent)(e = (KeyEvent)event))) {
            e.consume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        if (this.active) {
            logger.warning("RabtInputMethod.activate called while active");
        }
        this.active = true;
        Window window = statusWindow;
        synchronized (window) {
            statusWindowOwner = this;
            this.updateStatusWindow(this.locale);
            if (!statusWindow.isVisible() && vkbVisible) {
                statusWindow.setVisible(true);
            }
            this.setStatusWindowForeground(Color.black);
        }
    }

    public void deactivate(boolean isTemporary) {
        if (!this.active) {
            logger.warning("RabtInputMethod.deactivate called while not active");
        }
        this.setStatusWindowForeground(Color.lightGray);
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideWindows() {
        if (this.active) {
            logger.warning("RabtInputMethod.hideWindows called while active");
        }
        Window window = statusWindow;
        synchronized (window) {
            if (statusWindowOwner == this) {
                statusWindow.setVisible(false);
            }
        }
    }

    public void removeNotify() {
    }

    public void endComposition() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyClientWindowChange(Rectangle location) {
        this.clientWindowLocation = location;
        Window window = statusWindow;
        synchronized (window) {
            if (!attachedStatusWindow || statusWindowOwner != this) {
                return;
            }
            if (location != null) {
                statusWindow.setLocation(location.x, location.y + location.height);
                if (!statusWindow.isVisible()) {
                    if (this.active) {
                        this.setStatusWindowForeground(Color.black);
                    } else {
                        this.setStatusWindowForeground(Color.lightGray);
                    }
                    if (vkbVisible) {
                        statusWindow.setVisible(true);
                    }
                }
            } else if (!vkbVisible) {
                statusWindow.setVisible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        if (this.active) {
            logger.warning("RabtInputMethod.dispose called while active");
        }
        if (this.disposed) {
            logger.warning("RabtInputMethod.disposed called repeatedly");
        }
        Window window = statusWindow;
        synchronized (window) {
            rabtInputMethodInstances.remove(this);
        }
        this.disposed = true;
    }

    public Object getControlObject() {
        return rabtIMControl;
    }

    public void setCompositionEnabled(boolean enable) {
        throw new UnsupportedOperationException();
    }

    public boolean isCompositionEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTables() throws IOException {
        Class<?> clazz = this.getClass();
        synchronized (clazz) {
            if (!lookUpTablesLoaded) {
                String localeKey = null;
                String newKeyBuffer = null;
                Properties locProps = null;
                for (int currLocIndex = 0; currLocIndex < SUPPORTED_LOCALES.length; ++currLocIndex) {
                    localeKey = SUPPORTED_LOCALES[currLocIndex].getLanguage();
                    locProps = (Properties)localesProps.get(localeKey);
                    Enumeration<Object> e = locProps.keys();
                    Hashtable<String, Object> altgLocalesPropsCur = new Hashtable<String, Object>();
                    Hashtable<String, Object> altLocalesPropsCur = new Hashtable<String, Object>();
                    Hashtable<String, Object> shiftedLocalesPropsCur = new Hashtable<String, Object>();
                    Hashtable<String, Object> normalLocalesPropsCur = new Hashtable<String, Object>();
                    Hashtable<String, Object> kbNormalLocalesPropsCur = new Hashtable<String, Object>();
                    Hashtable<String, Object> specificLocalesPropsCur = new Hashtable<String, Object>();
                    while (e.hasMoreElements()) {
                        String newKey = (String)e.nextElement();
                        if (newKey.startsWith("kb-altg-")) {
                            newKeyBuffer = newKey.replaceFirst("kb-altg-", "");
                            altgLocalesPropsCur.put(newKeyBuffer, locProps.get(newKey));
                            continue;
                        }
                        if (newKey.startsWith("kb-alt-")) {
                            newKeyBuffer = newKey.replaceFirst("kb-alt-", "");
                            altLocalesPropsCur.put(newKeyBuffer, locProps.get(newKey));
                            continue;
                        }
                        if (newKey.startsWith("kb-shift-")) {
                            newKeyBuffer = newKey.replaceFirst("kb-shift-", "");
                            shiftedLocalesPropsCur.put(newKeyBuffer, locProps.get(newKey));
                        }
                        if (newKey.startsWith("kb-norm-")) {
                            newKeyBuffer = newKey.replaceFirst("kb-norm-", "");
                            kbNormalLocalesPropsCur.put(newKeyBuffer, locProps.get(newKey));
                            continue;
                        }
                        if (newKey.startsWith("Locale")) {
                            specificLocalesPropsCur.put(newKey, locProps.get(newKey));
                            continue;
                        }
                        normalLocalesPropsCur.put(newKey, locProps.get(newKey));
                    }
                    altLocalesProps.put(localeKey, altLocalesPropsCur);
                    altgLocalesProps.put(localeKey, altgLocalesPropsCur);
                    normalLocalesProps.put(localeKey, normalLocalesPropsCur);
                    kbNormalLocalesProps.put(localeKey, kbNormalLocalesPropsCur);
                    shiftedLocalesProps.put(localeKey, shiftedLocalesPropsCur);
                    specificLocalesProps.put(localeKey, specificLocalesPropsCur);
                }
                lookUpTablesLoaded = true;
            }
        }
    }

    private boolean handleCharacter(KeyEvent e) {
        boolean consumed = false;
        char sendChar = e.getKeyChar();
        this.convertedText = null;
        String rawChar = new String(new char[]{sendChar});
        Hashtable locProp = null;
        locProp = (Hashtable)normalLocalesProps.get(this.locale.getLanguage());
        if (locProp != null) {
            this.convertedText = (String)locProp.get(rawChar);
            if (this.convertedText != null) {
                AttributedString as = new AttributedString(this.convertedText);
                this.inputMethodContext.dispatchInputMethodEvent(1100, as.getIterator(), this.convertedText.length(), null, null);
                consumed = true;
            } else {
                AttributedString as = new AttributedString(rawChar);
                this.inputMethodContext.dispatchInputMethodEvent(1100, as.getIterator(), 1, null, null);
            }
        }
        return consumed;
    }

    public synchronized boolean toggleVirtualKeyboard() {
        boolean bl = vkbVisible = !vkbVisible;
        if (!statusWindow.isVisible() && vkbVisible) {
            statusWindow.setVisible(true);
        } else if (statusWindow.isVisible() && !vkbVisible) {
            statusWindow.setVisible(false);
        }
        return vkbVisible;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        attachedStatusWindow = false;
        rabtInputMethodInstances = new HashSet(20);
        methodCreateInputMethodJFrame = null;
        lookUpTablesLoaded = false;
        vkbVisible = false;
        methodCreateInputMethodJFrame = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class[] params = new Class[]{class$java$lang$String == null ? (class$java$lang$String = RabtInputMethod.class$("java.lang.String")) : class$java$lang$String, Boolean.TYPE};
                    return (class$java$awt$im$spi$InputMethodContext == null ? (class$java$awt$im$spi$InputMethodContext = RabtInputMethod.class$("java.awt.im.spi.InputMethodContext")) : class$java$awt$im$spi$InputMethodContext).getMethod("createInputMethodJFrame", params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
    }

    public class RabtControlObjectImpl
    implements RabtControlObject {
        RabtControlObjectImpl() {
        }

        public Hashtable getLocalesTable() {
            return specificLocalesProps;
        }

        public Hashtable getSupportedLocales() {
            return localesIndex;
        }

        public boolean toggleVKeyboard() {
            return RabtInputMethod.this.toggleVirtualKeyboard();
        }
    }
}

