/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.beans.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.hussnain.io.file.RabtFileChooserFilter;
import net.hussnain.utils.FileUtilities;
import net.hussnain.utils.file.Load;
import net.hussnain.utils.ui.View;

public class RabtTextPane
extends JPanel
implements UndoableEditListener {
    public static final String contentTypeText = "text/plain";
    public static final String contentTypeHTML = "text/html";
    public static final String contentTypeRTF = "text/rtf";
    public static final int fileFormatText = 10;
    public static final int fileFormatHTML = 20;
    public static final int fileFormatRTF = 30;
    private static Logger logger = Logger.getLogger("RabtTextPane");
    private static Hashtable actions;
    private static boolean actionsCreated;
    private static StyleContext styleContext;
    private Action currAction;
    private UndoManager undoMng;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private JScrollPane scrollPane;
    private JTextPane textPane;

    public RabtTextPane(JComponent p_owner, String p_contentType) {
        this.initComponents();
        if (p_contentType.equals(contentTypeHTML)) {
            this.textPane.setDocument(new HTMLDocument());
            this.textPane.setEditorKit(new HTMLEditorKit());
        } else if (p_contentType.equals(contentTypeRTF)) {
            this.textPane.setDocument(new DefaultStyledDocument(styleContext));
            this.textPane.setEditorKit(new RTFEditorKit());
        } else if (p_contentType.equals(contentTypeText)) {
            this.textPane.setDocument(new DefaultStyledDocument(styleContext));
            this.textPane.setEditorKit(new StyledEditorKit());
        }
        this.textPane.getDocument().addUndoableEditListener(this);
        this.textPane.setMargin(new Insets(3, 3, 3, 3));
        this.textPane.setCaretPosition(0);
        this.textPane.setDragEnabled(true);
        RabtTextPane.createActionTable(this.textPane);
        this.undoMng = new UndoManager();
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.textPane = new JTextPane();
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.textPane);
        this.add((Component)this.scrollPane, "Center");
    }

    public File openFile(File p_workingDirectory) {
        File file = Load.openFileDialog(this, p_workingDirectory, 0);
        this.openFileFromStream(file);
        return file;
    }

    public void openFileFromStream(File p_file) {
        if (p_file != null && p_file.isFile()) {
            try {
                URL url = p_file.toURL();
                if (url.getPath().endsWith("rtf")) {
                    RTFEditorKit kit = new RTFEditorKit();
                    this.textPane.setEditorKit(kit);
                    DefaultStyledDocument doc = new DefaultStyledDocument();
                    kit.read(url.openStream(), (Document)doc, 0);
                    this.textPane.setDocument(doc);
                } else if (url.getPath().endsWith("txt")) {
                    StyledEditorKit kit = new StyledEditorKit();
                    this.textPane.setEditorKit(kit);
                    DefaultStyledDocument doc = new DefaultStyledDocument();
                    kit.read(url.openStream(), (Document)doc, 0);
                    this.textPane.setDocument(doc);
                } else if (url.getPath().endsWith("htm") || url.getPath().endsWith("html")) {
                    HTMLEditorKit kit = new HTMLEditorKit();
                    this.textPane.setEditorKit(kit);
                    HTMLDocument doc = new HTMLDocument();
                    kit.read(url.openStream(), (Document)doc, 0);
                    this.textPane.setDocument(doc);
                } else {
                    this.textPane.setPage(url);
                }
                this.textPane.getDocument().addUndoableEditListener(this);
            }
            catch (IOException exp) {
                logger.warning("couldnt open file at " + p_file.toString());
            }
            catch (BadLocationException exp) {
                logger.warning("couldnt open file at " + p_file.toString());
            }
        }
    }

    public File saveFile(File p_file) {
        File file = p_file;
        if (file != null) {
            try {
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
                if (!this.textPane.getContentType().equals(contentTypeRTF)) {
                    this.textPane.getEditorKit().write(bw, this.textPane.getDocument(), 0, this.textPane.getDocument().getLength());
                    bw.flush();
                    bw.close();
                } else {
                    this.textPane.getEditorKit().write(fos, this.textPane.getDocument(), 0, this.textPane.getDocument().getLength());
                    ((OutputStream)fos).flush();
                    ((OutputStream)fos).close();
                }
                logger.info("file saved to " + file.toString());
            }
            catch (BadLocationException exp) {
                logger.warning("couldnt write file at " + file.toString());
            }
            catch (IOException exp) {
                logger.warning("couldnt write file at " + file.toString());
            }
        }
        return file;
    }

    public File saveFileAs(File p_workingDirectory, String p_addTitle) {
        File file;
        String userExtention;
        String cType;
        RabtFileChooserFilter filter;
        JFileChooser fd;
        String fileExtention;
        block11: {
            int value;
            fileExtention = null;
            fd = new JFileChooser();
            fd.setCurrentDirectory(p_workingDirectory);
            if (p_addTitle != null) {
                fd.setDialogTitle(p_addTitle);
            }
            filter = new RabtFileChooserFilter("Accepted Documents");
            cType = this.textPane.getEditorKit().getContentType();
            if (cType.equals(contentTypeHTML)) {
                filter.addFileExtention("htm", "html file");
                filter.addFileExtention("html", "html file");
                fileExtention = "html";
            } else if (cType.equals(contentTypeRTF)) {
                filter.addFileExtention("rtf", "richt text file");
                fileExtention = "rtf";
            } else {
                filter.addFileExtention("txt", "plain text file");
                fileExtention = "txt";
            }
            fd.addChoosableFileFilter(filter);
            View.setLocationToMid(fd);
            userExtention = null;
            do {
                int action = fd.showSaveDialog(null);
                file = fd.getSelectedFile();
                if (file == null) {
                    if (action == 0) {
                        JOptionPane.showMessageDialog(null, "There is a problem with the target file, please try again later.", "Saving File", 2);
                    }
                    break block11;
                }
                userExtention = FileUtilities.getExtension(file);
                if (userExtention == null) {
                    file = new File(new File(file.getParent()), file.getName() + "." + fileExtention);
                } else if (!userExtention.equals(fileExtention)) {
                    file = new File(new File(file.getParent()), file.getName() + "." + fileExtention);
                }
                if (action != 0) break block11;
                if (file.exists()) continue;
                this.saveFile(file);
                logger.info("file saved to " + file.getAbsolutePath());
                break block11;
            } while ((value = JOptionPane.showConfirmDialog(this, "Another file with the same name already exists.\nDo you want to overwrite this existing one?", "Saveing the File", 0)) != 0);
            this.saveFile(file);
            logger.info("file saved to " + file.getAbsolutePath());
        }
        userExtention = null;
        fileExtention = null;
        filter = null;
        fd = null;
        cType = null;
        return file;
    }

    public File exportFile(File p_file, int p_format) {
        logger.info("starting export now ..");
        File file = p_file;
        Document doc = this.textPane.getDocument();
        int docSize = doc.getLength();
        if (file != null) {
            try {
                BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(fos));
                if (p_format == 20) {
                    if (!this.textPane.getContentType().equals(contentTypeHTML)) {
                        HTMLEditorKit htmlKit = new HTMLEditorKit();
                        htmlKit.write(bw, doc, 0, docSize);
                        bw.flush();
                        bw.close();
                        htmlKit = null;
                        logger.info("file as HTML exported to " + file.toString());
                    } else {
                        this.saveFile(file);
                    }
                } else if (p_format == 30) {
                    if (!this.textPane.getContentType().equals(contentTypeRTF)) {
                        RTFEditorKit rtfKit = new RTFEditorKit();
                        rtfKit.write(fos, doc, 0, docSize);
                        ((OutputStream)fos).flush();
                        ((OutputStream)fos).close();
                        rtfKit = null;
                        logger.info("file as RTF exported to " + file.toString());
                    } else {
                        this.saveFile(file);
                    }
                } else if (!this.textPane.getContentType().equals(contentTypeText)) {
                    DefaultEditorKit textKit = new DefaultEditorKit();
                    textKit.write(bw, doc, 0, docSize);
                    bw.flush();
                    bw.close();
                    textKit = null;
                    logger.info("file as TEXT exported to " + file.toString());
                } else {
                    this.saveFile(file);
                }
                fos = null;
                bw = null;
            }
            catch (BadLocationException exp) {
                logger.warning("couldnt write file at " + file.toString());
            }
            catch (IOException exp) {
                logger.warning("couldnt write file at " + file.toString());
            }
        }
        return file;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void setBold(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("font-bold");
        this.currAction.actionPerformed(p_evt);
    }

    public void setItalic(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("font-italic");
        this.currAction.actionPerformed(p_evt);
    }

    public void setUnderline(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("font-underline");
        this.currAction.actionPerformed(p_evt);
    }

    public static void changeFont(JEditorPane p_editor, String p_fontName) {
        logger.info("changing the font to " + p_fontName);
        DefaultStyledDocument doc = (DefaultStyledDocument)p_editor.getDocument();
        if (p_editor != null) {
            int start = p_editor.getSelectionStart();
            int end = p_editor.getSelectionEnd();
            StyledEditorKit kit = (StyledEditorKit)p_editor.getEditorKit();
            SimpleAttributeSet sty = new SimpleAttributeSet();
            StyleConstants.setFontFamily(sty, p_fontName);
            if (start != end) {
                doc.setCharacterAttributes(start, end - start, sty, false);
            }
            StyleConstants.setFontFamily(kit.getInputAttributes(), p_fontName);
        }
    }

    public static void changeFontSize(int p_fontSize, ActionEvent p_evt) {
        String actionName = "font-size-" + p_fontSize;
        Action action = RabtTextPane.getActionByName(actionName);
        if (action != null) {
            logger.info("performing action " + actionName);
            action.actionPerformed(p_evt);
        } else {
            logger.info("creating  action " + actionName);
            action = new StyledEditorKit.FontSizeAction(actionName, p_fontSize);
            action.actionPerformed(p_evt);
            RabtTextPane.putActionByName(actionName, action);
        }
    }

    public static void changeFontSize(JEditorPane p_editor, int p_fontSize) {
        logger.info("changing the font size to " + p_fontSize);
        if (p_editor != null) {
            DefaultStyledDocument doc = (DefaultStyledDocument)p_editor.getDocument();
            int start = p_editor.getSelectionStart();
            int end = p_editor.getSelectionEnd();
            StyledEditorKit kit = (StyledEditorKit)p_editor.getEditorKit();
            if (start != end) {
                SimpleAttributeSet sty = new SimpleAttributeSet();
                StyleConstants.setFontSize(sty, p_fontSize);
                doc.setCharacterAttributes(start, end - start, sty, false);
            }
            StyleConstants.setFontSize(kit.getInputAttributes(), p_fontSize);
        }
    }

    public void setAlignmentRight(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("right-justify");
        this.currAction.actionPerformed(p_evt);
    }

    public void setAlignmentCenter(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("center-justify");
        this.currAction.actionPerformed(p_evt);
    }

    public void setAlignmentLeft(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("left-justify");
        this.currAction.actionPerformed(p_evt);
    }

    public static void insertImage(JEditorPane p_editor, String p_imagePath) {
        logger.info("inserting image " + p_imagePath);
        DefaultStyledDocument doc = (DefaultStyledDocument)p_editor.getDocument();
        if (p_editor != null) {
            int start = p_editor.getSelectionStart();
            SimpleAttributeSet sty = new SimpleAttributeSet();
            StyleConstants.setIcon(sty, new ImageIcon(p_imagePath));
            try {
                doc.insertString(start, " ", sty);
            }
            catch (BadLocationException exp) {
                logger.warning("image location is not correct as " + p_imagePath);
            }
        }
    }

    public void cutSelection(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("cut-to-clipboard");
        this.currAction.actionPerformed(p_evt);
    }

    public void copySelection(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("copy-to-clipboard");
        this.currAction.actionPerformed(p_evt);
    }

    public void pasteSelection(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("paste-from-clipboard");
        this.currAction.actionPerformed(p_evt);
    }

    public void selectAll(ActionEvent p_evt) {
        this.currAction = RabtTextPane.getActionByName("select-all");
        this.currAction.actionPerformed(p_evt);
    }

    public void undo(ActionEvent p_evt) {
        this.undoAction.actionPerformed(p_evt);
    }

    public void redo(ActionEvent p_evt) {
        this.redoAction.actionPerformed(p_evt);
    }

    private static synchronized void createActionTable(JTextPane p_textPane) {
        if (!actionsCreated) {
            actions = new Hashtable();
            Action[] actionsArray = p_textPane.getActions();
            for (int i = 0; i < actionsArray.length; ++i) {
                Action a = actionsArray[i];
                actions.put(a.getValue("Name"), a);
            }
        }
    }

    public static Action getActionByName(String p_name) {
        return (Action)actions.get(p_name);
    }

    public static synchronized void putActionByName(String p_name, Action a) {
        actions.put(p_name, a);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.undoMng.addEdit(e.getEdit());
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    static {
        actionsCreated = false;
        styleContext = new StyleContext();
    }

    public class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                RabtTextPane.this.undoMng.redo();
            }
            catch (CannotRedoException ex) {
                System.out.println("Unable to redo: " + ex);
                ex.printStackTrace();
            }
            this.updateRedoState();
            RabtTextPane.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            if (RabtTextPane.this.undoMng.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", RabtTextPane.this.undoMng.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Redo");
            }
        }
    }

    public class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                RabtTextPane.this.undoMng.undo();
            }
            catch (CannotUndoException ex) {
                System.out.println("Unable to undo: " + ex);
                ex.printStackTrace();
            }
            this.updateUndoState();
            RabtTextPane.this.redoAction.updateRedoState();
        }

        protected void updateUndoState() {
            if (RabtTextPane.this.undoMng.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", RabtTextPane.this.undoMng.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", "Undo");
            }
        }
    }
}

