/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.beans.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

public class DocumentTreeView
extends JPanel {
    public static final int ElementTree = 0;
    public static final int BidiTree = 1;
    JScrollPane scrollPane;
    JTextComponent textComp;
    JTree mainTree;
    Element rootElement;
    int mode;

    public DocumentTreeView(JTextComponent textPane, int treeType) {
        this.textComp = textPane;
        this.mode = treeType;
        this.setLayout(new BorderLayout());
        this.updateTree();
    }

    private final void updateTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.rootElement = this.mode == 0 ? this.textComp.getDocument().getDefaultRootElement() : this.textComp.getDocument().getRootElements()[1];
        this.addChildElements(this.rootElement, root);
        this.mainTree = new JTree(root);
        DefaultTreeSelectionModel tsm = new DefaultTreeSelectionModel();
        tsm.setSelectionMode(1);
        this.mainTree.setSelectionModel(tsm);
        this.mainTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent event) {
                TreePath tp = event.getNewLeadSelectionPath();
                if (tp != null) {
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
                    TreeCellUserObject uObj = (TreeCellUserObject)selectedNode.getUserObject();
                    Element selElm = uObj.getReference();
                    DocumentTreeView.this.textComp.select(selElm.getStartOffset(), selElm.getEndOffset());
                }
            }
        });
        if (this.scrollPane != null) {
            this.remove(this.scrollPane);
        }
        this.scrollPane = new JScrollPane();
        this.scrollPane.getViewport().add(this.mainTree);
        this.add((Component)this.scrollPane, "Center");
    }

    private final void addChildElements(Element currentElement, DefaultMutableTreeNode currentNode) {
        if (currentElement == null || currentNode == null) {
            return;
        }
        int startOffset = currentElement.getStartOffset();
        int endOffset = currentElement.getEndOffset();
        TreeCellUserObject uObj = new TreeCellUserObject(currentElement.getName() + " ( " + startOffset + " , " + endOffset + " )", currentElement);
        currentNode.setUserObject(uObj);
        if (currentElement.isLeaf()) {
            try {
                String content = currentElement.getDocument().getText(startOffset, endOffset - startOffset);
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode();
                uObj = new TreeCellUserObject(content, currentElement);
                childNode.setUserObject(uObj);
                currentNode.add(childNode);
            }
            catch (Exception e) {}
        } else {
            int childElements = currentElement.getElementCount();
            for (int i = 0; i < childElements; ++i) {
                DefaultMutableTreeNode childNode = new DefaultMutableTreeNode();
                currentNode.add(childNode);
                this.addChildElements(currentElement.getElement(i), childNode);
            }
        }
    }

    public final JFrame getFrame() {
        final JFrame frame = this.mode == 0 ? new JFrame("Document Structure (Elements)") : new JFrame("Document Structure (Bidi)");
        frame.setSize(500, 400);
        frame.getContentPane().add(this);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                frame.hide();
                DocumentTreeView.this.mainTree = null;
                frame.dispose();
            }
        });
        MenuBar bar = new MenuBar();
        Menu m = new Menu();
        m = new Menu("Commands");
        MenuItem mit = new MenuItem("Refresh");
        mit.setActionCommand("Refresh");
        mit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DocumentTreeView.this.performeMenuAction(evt);
            }
        });
        m.add(mit);
        bar.add(m);
        frame.setMenuBar(bar);
        return frame;
    }

    void performeMenuAction(ActionEvent evt) {
        String command = evt.getActionCommand();
        if (command.equals("Refresh")) {
            this.updateTree();
            this.validateTree();
        }
    }

    public class TreeCellUserObject {
        String name;
        Element ref;

        TreeCellUserObject(String p_name, Element p_ref) {
            this.name = p_name;
            this.ref = p_ref;
        }

        public Element getReference() {
            return this.ref;
        }

        public String toString() {
            return this.name;
        }
    }
}

