/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.beans.dialog.file;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.SoftBevelBorder;
import net.hussnain.utils.BooleanReference;
import utils.SwingWorker;

public class ImagePreview
extends JPanel
implements PropertyChangeListener {
    private static BooleanReference enabledPreview;
    private static JFileChooser myFC;
    private static Logger logger;
    private JLabel imageLabel;
    private JProgressBar loadingProgress;
    private JPanel mainPanel;
    private JCheckBox previewImg;
    private JLabel infoLabel;
    private JPanel statusPanel;

    public ImagePreview(JFileChooser p_fileChooser, BooleanReference p_enable) {
        this.initComponents();
        this.setPreviewState(p_enable);
        myFC = p_fileChooser;
        myFC.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.previewImg = new JCheckBox();
        this.imageLabel = new JLabel();
        this.infoLabel = new JLabel();
        this.statusPanel = new JPanel();
        this.loadingProgress = new JProgressBar();
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
        this.setMinimumSize(new Dimension(200, 200));
        this.setPreferredSize(new Dimension(200, 200));
        this.mainPanel.setLayout(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(130, 156));
        this.previewImg.setText("Preview Images:");
        this.previewImg.setHorizontalAlignment(0);
        this.previewImg.setHorizontalTextPosition(2);
        this.previewImg.setMargin(new Insets(3, 3, 3, 3));
        this.previewImg.setMaximumSize(new Dimension(1000, 500));
        this.previewImg.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ImagePreview.this.previewImg(evt);
            }
        });
        this.mainPanel.add((Component)this.previewImg, "North");
        this.imageLabel.setHorizontalAlignment(0);
        this.imageLabel.setBorder(new BevelBorder(0));
        this.imageLabel.setMaximumSize(new Dimension(1000, 1000));
        this.imageLabel.setMinimumSize(new Dimension(127, 80));
        this.imageLabel.setPreferredSize(new Dimension(127, 80));
        this.mainPanel.add((Component)this.imageLabel, "Center");
        this.infoLabel.setHorizontalAlignment(2);
        this.infoLabel.setText("<html><p><b>Size:</b></p><p><b>Width:</b></p><p><b>Height:</b></p></html>");
        this.infoLabel.setBorder(new EmptyBorder(new Insets(3, 3, 3, 3)));
        this.infoLabel.setMaximumSize(new Dimension(1000, 500));
        this.infoLabel.setMinimumSize(new Dimension(127, 51));
        this.infoLabel.setPreferredSize(new Dimension(127, 51));
        this.mainPanel.add((Component)this.infoLabel, "South");
        this.add((Component)this.mainPanel, "Center");
        this.statusPanel.setBorder(new SoftBevelBorder(0));
        this.statusPanel.setMinimumSize(new Dimension(26, 30));
        this.statusPanel.setPreferredSize(new Dimension(130, 30));
        this.loadingProgress.setMinimumSize(new Dimension(50, 15));
        this.loadingProgress.setPreferredSize(new Dimension(148, 15));
        this.loadingProgress.setString("");
        this.loadingProgress.setStringPainted(true);
        this.statusPanel.add(this.loadingProgress);
        this.add((Component)this.statusPanel, "South");
    }

    private void previewImg(ActionEvent evt) {
        JCheckBox checkbox = (JCheckBox)evt.getSource();
        enabledPreview.setBoolValue(new Boolean(checkbox.isSelected()));
        if (!checkbox.isSelected()) {
            this.imageLabel.setIcon(null);
        }
    }

    public void propertyChange(PropertyChangeEvent e) {
        Object args = null;
        String prop = e.getPropertyName();
        if (prop.equals("SelectedFileChangedProperty")) {
            File file = (File)e.getNewValue();
            if (this.isShowing() && enabledPreview.getBoolValue().booleanValue()) {
                logger.info("starting thread for status bar");
                this.loadingProgress.setIndeterminate(true);
                this.prepareThumbnail(file);
            }
        }
    }

    public final void updatePreviewPanel(ImageIcon p_imgIcon, File p_file) {
        this.imageLabel.setIcon(p_imgIcon);
        Hashtable<String, Integer> args = new Hashtable<String, Integer>();
        if (p_imgIcon != null) {
            args = new Hashtable();
            args.put("height", new Integer(p_imgIcon.getIconHeight()));
            args.put("width", new Integer(p_imgIcon.getIconWidth()));
            this.setInfoLabel(p_file, args);
        }
        this.loadingProgress.setIndeterminate(false);
    }

    private final void setInfoLabel(File p_file, Hashtable p_htable) {
        if (p_file.isFile()) {
            Integer width = (Integer)p_htable.get("width");
            Integer height = (Integer)p_htable.get("height");
            DecimalFormat df = new DecimalFormat("#0.0");
            double fileSize = p_file.length();
            String fileSizeStr = " Bytes";
            if (fileSize >= 1024.0) {
                fileSize /= 1024.0;
                fileSizeStr = " KB";
            } else if (fileSize >= 1048576.0) {
                fileSize /= 1048576.0;
                fileSizeStr = " MB";
            }
            this.infoLabel.setText("<html><p><b>Size: </b>" + df.format(fileSize) + fileSizeStr + "</p><p><b>Width: </b>" + width + "</p><p><b>Height: </b>" + height + "</p></html>");
        } else {
            this.infoLabel.setText("<html><p><b>Size:</b></p><p><b>Width:</b></p><p><b>Height:</b></p></html>");
        }
    }

    private final void setPreviewState(BooleanReference p_state) {
        enabledPreview = p_state;
        if (enabledPreview.getBoolValue().booleanValue() != this.previewImg.isSelected()) {
            this.previewImg.setSelected(p_state.getBoolValue());
        }
    }

    private void prepareThumbnail(final File p_imageFile) {
        SwingWorker worker = new SwingWorker(){
            ImageIcon thumbnail;

            public Object construct() {
                ImageIcon tmpIcon = new ImageIcon(p_imageFile.getAbsolutePath());
                this.thumbnail = tmpIcon.getIconWidth() > 150 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(150, -1, 1)) : tmpIcon;
                return this.thumbnail;
            }

            public void finished() {
                ImagePreview.this.updatePreviewPanel(this.thumbnail, p_imageFile);
            }
        };
        worker.start();
    }

    static {
        logger = Logger.getLogger("ImagePreview");
    }
}

