/*
 * Decompiled with CFR 0.152.
 */
package net.hussnain.beans.dialog;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public class SplashWindow
extends JWindow
implements Runnable {
    private static int timeout;

    public SplashWindow(URL imagePath, int timeout) {
        SplashWindow.timeout = timeout;
        JLabel imageLabel = new JLabel();
        imageLabel.setIcon(new ImageIcon(imagePath));
        imageLabel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.getContentPane().add(imageLabel);
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension frameSize = this.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        this.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public void run() {
        this.setVisible(true);
        this.enableEvents(16L);
        this.enableEvents(4L);
        if (timeout != 0) {
            try {
                Thread.sleep(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    public void processMouseEvent(MouseEvent evt) {
        if (evt.getID() == 501) {
            this.setVisible(false);
            super.processMouseEvent(evt);
            this.dispose();
        }
    }

    public static final void showSplash(SplashWindow p_owner) {
        Thread splashThread = new Thread(p_owner);
        splashThread.start();
    }
}

