/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.util.resource.locale;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.util.resource.locale.ab;
import com.visustt.tools.util.resource.locale.ac;
import java.awt.ComponentOrientation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.event.EventListenerList;

public class LocaleSelector {
    private static Logger logger = LoggerFactory.getInstance("jx.util.locale.selector");
    private static LocaleSelector globalLocaleSelctor = null;
    private Collection<Locale> supportedLocales = new HashSet<Locale>();
    private Locale defaultLocale = null;
    private Locale preferedLocale = null;
    private Locale selectedLocale = null;
    private Locale userDefinedLocale = null;
    private EventListenerList listenerList = null;
    private boolean immutable = false;

    private LocaleSelector() {
    }

    public static synchronized LocaleSelector getLocaleSelector() {
        try {
            if (globalLocaleSelctor == null) {
                globalLocaleSelctor = new LocaleSelector();
                globalLocaleSelctor.addSupportedLocale(Locale.ENGLISH);
                globalLocaleSelctor.setDefaultLocale(Locale.ENGLISH);
                globalLocaleSelctor.setPreferedLocale(Locale.getDefault());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        return globalLocaleSelctor;
    }

    @Deprecated
    public static void clear() {
        try {
            if (globalLocaleSelctor != null) {
                globalLocaleSelctor = null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
    }

    public void addSupportedLocale(Locale locale) {
        block13: {
            block14: {
                try {
                    if (this.immutable) {
                        return;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
                try {
                    if (locale == null) {
                        throw new IllegalArgumentException("can not add null locale");
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
                try {
                    if (this.supportedLocales.isEmpty()) {
                        this.defaultLocale = locale;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
                try {
                    try {
                        if (!this.supportedLocales.add(locale)) break block13;
                        if (!logger.debugIsEnabled()) break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw LocaleSelector.a(illegalArgumentException);
                    }
                    logger.debug("Adding supported locale: " + locale);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
            }
            this.fireLocaleSelectorListenerSupportedLocaleAdded(new ac(this, locale));
            this.updateSelectedLocale();
        }
    }

    public void removeSupportedLocale(Locale locale) {
        block18: {
            block22: {
                block23: {
                    block20: {
                        block21: {
                            block19: {
                                try {
                                    if (this.immutable) {
                                        return;
                                    }
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw LocaleSelector.a(illegalArgumentException);
                                }
                                try {
                                    if (locale == null) {
                                        throw new IllegalArgumentException("can not add null locale");
                                    }
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw LocaleSelector.a(illegalArgumentException);
                                }
                                try {
                                    try {
                                        if (!this.supportedLocales.remove(locale)) break block18;
                                        if (!logger.debugIsEnabled()) break block19;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw LocaleSelector.a(illegalArgumentException);
                                    }
                                    logger.debug("Removed supported locale: " + locale);
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw LocaleSelector.a(illegalArgumentException);
                                }
                            }
                            try {
                                try {
                                    if (!locale.equals(this.defaultLocale)) break block20;
                                    if (!this.supportedLocales.isEmpty()) break block21;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw LocaleSelector.a(illegalArgumentException);
                                }
                                this.defaultLocale = null;
                                break block20;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw LocaleSelector.a(illegalArgumentException);
                            }
                        }
                        this.defaultLocale = (Locale)this.getSupportedLocales().next();
                    }
                    try {
                        try {
                            if (!locale.equals(this.selectedLocale)) break block22;
                            if (!this.supportedLocales.isEmpty()) break block23;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw LocaleSelector.a(illegalArgumentException);
                        }
                        this.selectedLocale = null;
                        break block22;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw LocaleSelector.a(illegalArgumentException);
                    }
                }
                this.updateSelectedLocale();
            }
            this.fireLocaleSelectorListenerSupportedLocaleRemoved(new ac(this, locale));
        }
    }

    public Iterator getSupportedLocales() {
        return this.supportedLocales.iterator();
    }

    public boolean containsSupportedLocale(Locale locale) {
        Iterator<Locale> iterator = this.supportedLocales.iterator();
        while (iterator.hasNext()) {
            if (!((Object)iterator.next()).equals(locale)) continue;
            return true;
        }
        return false;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public void setDefaultLocale(Locale locale) throws IllegalArgumentException {
        try {
            if (!this.supportedLocales.contains(locale)) {
                throw new IllegalArgumentException("Locale " + locale + " not in supported set.");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        try {
            if (this.areEqual(this.defaultLocale, locale)) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        try {
            if (logger.debugIsEnabled()) {
                logger.debug("Setting default locale to " + locale);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        this.defaultLocale = locale;
        this.updateSelectedLocale();
    }

    public Locale getPreferedLocale() {
        return this.preferedLocale;
    }

    public void setPreferedLocale(Locale locale) {
        try {
            if (this.areEqual(locale, this.preferedLocale)) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        try {
            if (logger.debugIsEnabled()) {
                logger.debug("Setting prefered locale to " + locale);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        this.preferedLocale = locale;
        this.updateSelectedLocale();
    }

    public Locale getSelectedLocale() {
        return this.selectedLocale;
    }

    private void setSelectedLocale(Locale locale) throws IllegalArgumentException {
        block10: {
            try {
                try {
                    if (locale == null || this.supportedLocales.contains(locale)) break block10;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Locale " + locale + " not in supported set.");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw LocaleSelector.a(illegalArgumentException);
            }
        }
        try {
            if (this.areEqual(locale, this.selectedLocale)) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        try {
            if (logger.debugIsEnabled()) {
                logger.debug("Setting selected locale to " + locale);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        this.selectedLocale = locale;
        Locale.setDefault(locale);
        this.fireLocaleSelectorListenerSelectedLocaleChanged(new ac(this, locale));
    }

    private void updateSelectedLocale() {
        block14: {
            block13: {
                block12: {
                    try {
                        block11: {
                            try {
                                try {
                                    if (this.preferedLocale == null) break block11;
                                    if (!this.preferedLocale.equals(this.selectedLocale)) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw LocaleSelector.a(illegalArgumentException);
                                }
                                if (!this.supportedLocales.contains(this.preferedLocale)) break block12;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw LocaleSelector.a(illegalArgumentException);
                            }
                        }
                        return;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw LocaleSelector.a(illegalArgumentException);
                    }
                }
                try {
                    if (!this.supportedLocales.contains(this.preferedLocale)) break block13;
                    this.setSelectedLocale(this.preferedLocale);
                    break block14;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
            }
            Iterator iterator = this.getSupportedLocales();
            while (iterator.hasNext()) {
                Locale locale = (Locale)iterator.next();
                try {
                    if (!locale.getLanguage().equals(this.preferedLocale.getLanguage())) continue;
                    this.setSelectedLocale(locale);
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
            }
            this.setSelectedLocale(this.getDefaultLocale());
        }
    }

    public synchronized void addLocaleSelectorListener(ab ab5) {
        try {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        this.listenerList.add(ab.class, ab5);
    }

    public synchronized void removeLocaleSelectorListener(ab ab5) {
        try {
            if (this.listenerList == null) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        this.listenerList.remove(ab.class, ab5);
    }

    private void fireLocaleSelectorListenerSupportedLocaleAdded(ac ac2) {
        try {
            if (this.listenerList == null) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (true) {
            block8: {
                try {
                    try {
                        if (n < 0) break;
                        if (objectArray[n] != ab.class) break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw LocaleSelector.a(illegalArgumentException);
                    }
                    ((ab)objectArray[n + 1]).aa(ac2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
            }
            n -= 2;
        }
    }

    private void fireLocaleSelectorListenerSupportedLocaleRemoved(ac ac2) {
        try {
            if (this.listenerList == null) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (true) {
            block8: {
                try {
                    try {
                        if (n < 0) break;
                        if (objectArray[n] != ab.class) break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw LocaleSelector.a(illegalArgumentException);
                    }
                    ((ab)objectArray[n + 1]).ab(ac2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
            }
            n -= 2;
        }
    }

    private void fireLocaleSelectorListenerSelectedLocaleChanged(ac ac2) {
        try {
            if (this.listenerList == null) {
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw LocaleSelector.a(illegalArgumentException);
        }
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (true) {
            block8: {
                try {
                    try {
                        if (n < 0) break;
                        if (objectArray[n] != ab.class) break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw LocaleSelector.a(illegalArgumentException);
                    }
                    ((ab)objectArray[n + 1]).ac(ac2);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
            }
            n -= 2;
        }
    }

    private boolean areEqual(Object object, Object object2) {
        boolean bl;
        block8: {
            block7: {
                try {
                    block6: {
                        try {
                            try {
                                if (object == object2) break block6;
                                if (object == null) break block7;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw LocaleSelector.a(illegalArgumentException);
                            }
                            if (!object.equals(object2)) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw LocaleSelector.a(illegalArgumentException);
                        }
                    }
                    bl = true;
                    break block8;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw LocaleSelector.a(illegalArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public void setImmutable(boolean bl) {
        this.immutable = bl;
    }

    public static boolean isLeftToRight() {
        Locale locale = LocaleSelector.getLocaleSelector().getSelectedLocale();
        return ComponentOrientation.getOrientation(locale).isLeftToRight();
    }

    public Locale getUserDefinedLocale() {
        return this.userDefinedLocale;
    }

    public void setUserDefinedLocale(Locale locale) {
        this.userDefinedLocale = locale;
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

