/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.text;

import com.visustt.tools.lang.StringTool;
import java.util.Random;

public class SimpleTextScrambler {
    private static final Random rand = new Random(System.currentTimeMillis());
    private static byte[] defaultKey = new byte[]{-120, 79, 115, -73, 109, -113, -11, -1, 84, 43, 122, -127, 90, 78, -120, -91, 38, 22, 108, -38, 62, 80, -74, 1, -107, -122, -25, 11, 103, 60, 104, -32, 73, 117, -66, -126, 123, 124, -4, 114, -128, -32, 120, 82, -16, -65, -63, -53, -116, 71, -48, -80, -109, 122, 124, 99, 83, 48, 51, 119, 2, 98, -25, 117, 73, -107, -99, -38, 78, 10, -122, -96, 65, 43, 15, 4, 77, 61, -90, -23, -29, 56, 71, -4, 21, -120, -19, 23, 35, 18, 68, -22, 86, 116, -94, -40, 12, -111, 56, 30, 20, 76, -124, 58, 59, -110, 10, -118, 38, -98, 66, 50, 98, 119, -45, 67, -71, -67, 2, 24, -57, -90, 100, 3, -52, 66, -37, -64, -1, -113, 73, -16, 52, -31, -28, 40, -70, -20, -109, 31, -73, 68, 99, 93, 16, 1, -23, -19, 12, -114, -121, 81, 55, -64, -19, -75, -120, 41, -30, 103, -59, -82, 68, -121, 38, 87, 77, -6, 56, 102, 23, -92, 4, -86, 97, -43, 112, 20, -109, 3, -28, -118, -1, -70, 47, -5, 105, -48, -84, -77, -55, -106, 64, -70, 30, 96, -2, 24, 121, 89, 19, -67, 102, -69, -106, -86, 25, 10, 81, 105, -113, 100, 125, -122, -12, 29, -49, 62, 68, -117, -73, 118, 51, 29, -26, -18, 81, -78, 17, -74, 105, 39, -11, -32, 42, 50, -102, 118, 9, 109, -38, -82, 101, -75, 36, 92, -21, -75, 125, -89, 59, -67, -56, -1, -53, -40};

    public static String scramble(String string) {
        return SimpleTextScrambler.scramble(string, null);
    }

    public static String scramble(String string, byte[] byArray) {
        if (!StringTool.isDefined(string)) {
            return null;
        }
        byte[] byArray2 = null;
        byArray2 = byArray != null && byArray.length > 0 ? byArray : defaultKey;
        byte[] byArray3 = new byte[1];
        rand.nextBytes(byArray3);
        int n = byArray3[0] + 128;
        String string2 = StringTool.toRightAlignedString(Integer.toString(n, 16), 2, '0');
        byte[] byArray4 = string.getBytes();
        for (int i = 0; i < byArray4.length; ++i) {
            byArray4[i] = (byte)(byArray4[i] ^ byArray2[(i + n) % byArray2.length]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2.substring(0, 1));
        for (int i = 0; i < byArray4.length; ++i) {
            stringBuffer.append(StringTool.toRightAlignedString(Integer.toString(byArray4[i] + 128, 16), 2, '0'));
        }
        stringBuffer.append(string2.substring(1));
        return stringBuffer.toString();
    }

    public static String descramble(String string) {
        return SimpleTextScrambler.descramble(string, null);
    }

    public static String descramble(String string, byte[] byArray) {
        int n;
        if (!StringTool.isDefined(string)) {
            return null;
        }
        byte[] byArray2 = null;
        byArray2 = byArray == null ? defaultKey : byArray;
        String string2 = string.trim();
        int n2 = Integer.parseInt(string2.substring(0, 1) + string2.substring(string2.length() - 1), 16);
        string2 = string2.substring(1, string2.length() - 1);
        byte[] byArray3 = new byte[string2.length() / 2];
        for (n = 0; n < byArray3.length; ++n) {
            byArray3[n] = (byte)(Integer.parseInt(string2.substring(0, 2), 16) - 128);
            string2 = string2.substring(2);
        }
        for (n = 0; n < byArray3.length; ++n) {
            byArray3[n] = (byte)(byArray3[n] ^ byArray2[(n + n2) % byArray2.length]);
        }
        return new String(byArray3);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1 || stringArray.length > 2) {
            System.out.println("SimpleTextScrambler [-s|-scramble|-d|-descramble] <Text>");
        } else if (stringArray.length == 1 ^ (stringArray[0].equalsIgnoreCase("-s") || stringArray[0].equalsIgnoreCase("-scramble"))) {
            System.out.println(SimpleTextScrambler.scramble(stringArray[stringArray.length - 1]));
        } else if (stringArray.length == 2 && (stringArray[0].equalsIgnoreCase("-d") || stringArray[0].equalsIgnoreCase("-descramble"))) {
            System.out.println(SimpleTextScrambler.descramble(stringArray[1]));
        }
    }
}

