/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.system;

import com.visustt.nativeWin32.aa;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.io.aa.ab;
import com.visustt.tools.io.aq;
import com.visustt.tools.io.ar;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.system.OSVersion;
import com.visustt.tools.system.SystemProperties;
import com.visustt.tools.system.ac;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class LibLoader
implements aa {
    private static String[] sys_paths;
    private static String[] usr_paths;
    private static final Vector<String> MacOS_ErrorLog_Exclusions;
    private static final Vector<String> Linux_ErrorLog_Exclusions;
    private static final Vector<String> Windows_ErrorLog_Exclusions;
    private static final Vector<String> OtherOS_ErrorLog_Exclusions;
    private static final Vector<String> Custom_ErrorLog_Exclusions;
    public static final String LOGGER_NAME = "jx.tools.io.libloader";
    private static Logger logger;
    private static Logger serverLog;
    private static final LibLoader theInstance;
    private static final Set<String> currentLibraryNames;
    private static final Set<String> currentLibFiles;
    private static final Hashtable<String, String> currentLibVersions;
    private static final String nativeLibExtension;

    public static Iterator getLoadedLibraries() {
        return new HashSet<String>(currentLibFiles).iterator();
    }

    private static File extractLibraryFromURL(URL uRL, String string, boolean bl) {
        File file = null;
        try {
            file = LibLoader.extractLibraryFromURLBody(uRL, string, bl);
        }
        catch (Throwable throwable) {
            try {
                if (!LibLoader.excludeFromErrorLog(string)) {
                    logger.error((Object)("Error while extracting library from jar resoources. " + throwable), throwable);
                }
            }
            catch (Throwable throwable2) {
                throw LibLoader.a(throwable2);
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static File extractLibraryFromURLBody(URL uRL, String string, boolean bl) throws IOException, FileNotFoundException {
        Object object;
        Object object2;
        Object object3;
        String string2;
        File file;
        File file2;
        block28: {
            block27: {
                String string3;
                File file3;
                File file4;
                File file5;
                try {
                    File file6;
                    file5 = file6;
                    file4 = file6;
                    file3 = ab.aa();
                    string3 = ac.aa() ? "64" : "32";
                }
                catch (IOException iOException) {
                    throw LibLoader.a(iOException);
                }
                file5(file3, string3);
                file2 = file4;
                if (file2.exists()) break block27;
                try {
                    block30: {
                        if (file2.mkdirs()) break block27;
                        break block30;
                        catch (IOException iOException) {
                            throw LibLoader.a(iOException);
                        }
                    }
                    throw new IOException("Failed to create directory " + file2 + " - please check access rights.");
                }
                catch (IOException iOException) {
                    throw LibLoader.a(iOException);
                }
            }
            file = null;
            string2 = "";
            if (bl) break block28;
            string2 = nativeLibExtension;
        }
        try (InputStream inputStream = uRL.openStream();){
            try {
                file = File.createTempFile(string, string2, file2);
            }
            catch (IOException iOException) {
                IOException iOException2 = new IOException("Failed to create tempfile in '" + file2 + "' for lib " + string + nativeLibExtension);
                iOException2.initCause(iOException);
                throw iOException2;
            }
            file.deleteOnExit();
            object3 = new FileOutputStream(file);
            try {
                object2 = new byte[32768];
                int n = inputStream.read((byte[])object2);
                while (n != -1) {
                    ((OutputStream)object3).write((byte[])object2, 0, n);
                    n = inputStream.read((byte[])object2);
                }
            }
            finally {
                ((OutputStream)object3).close();
            }
        }
        object3 = new File(file2, string + string2);
        try {
            ar.aa(file, (File)object3, true);
            logger.debug("copied '" + file + "' to '" + (File)object3 + "'");
        }
        catch (IOException iOException) {
            logger.debug("failed to copy '" + file.getPath() + "' to '" + (File)object3 + "'");
        }
        if (aq.aa((File)object3, file) == 0) {
            object = object3;
            file.delete();
        } else {
            object2 = string + "_" + file.length();
            File file7 = new File(file2, (String)object2 + nativeLibExtension);
            if (!file7.exists()) {
                try {
                    ar.aa(file, file7, true);
                    logger.debug("copied " + file.getPath() + " to " + file7);
                }
                catch (Exception exception) {
                    logger.warn((Object)exception, exception);
                }
            }
            if (aq.aa(file7, file) == 0) {
                object = file7;
                file.delete();
            } else {
                object = file;
            }
            try {
                if (!LibLoader.excludeFromErrorLog(string)) {
                    logger.warn("Temporary library '" + (File)object3 + "' already exists as another version, but is locked (in use) by another application. Using library '" + (File)object + "' instead!");
                }
            }
            catch (IOException iOException) {
                throw LibLoader.a(iOException);
            }
        }
        return object;
    }

    public static String getLibraryVersion(String string) {
        return String.valueOf(currentLibVersions.get(string));
    }

    /*
     * Loose catch block
     */
    public static synchronized boolean loadLibrary(String string) {
        boolean bl;
        block22: {
            try {
                if (logger.infoIsEnabled()) {
                    logger.info("Requested to load library \"" + string + "\"");
                }
            }
            catch (Throwable throwable) {
                throw LibLoader.a(throwable);
            }
            bl = false;
            bl = LibLoader.loadLibraryBody(string);
            if (!bl) break block22;
            try {
                block24: {
                    if (currentLibraryNames.contains(string)) break block22;
                    break block24;
                    catch (Throwable throwable) {
                        throw LibLoader.a(throwable);
                    }
                }
                currentLibraryNames.add(string);
                break block22;
            }
            catch (Throwable throwable) {
                throw LibLoader.a(throwable);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (!LibLoader.excludeFromErrorLog(string)) {
                            logger.error((Object)("FAILED to load native library '" + string + "' (does the lib depend on other - possibly missing - resources?):" + throwable), throwable);
                        }
                    }
                    catch (Throwable throwable2) {
                        throw LibLoader.a(throwable2);
                    }
                }
                catch (Throwable throwable3) {
                    block23: {
                        try {
                            try {
                                if (!bl || currentLibraryNames.contains(string)) break block23;
                            }
                            catch (Throwable throwable4) {
                                throw LibLoader.a(throwable4);
                            }
                            currentLibraryNames.add(string);
                        }
                        catch (Throwable throwable5) {
                            throw LibLoader.a(throwable5);
                        }
                    }
                    throw throwable3;
                }
                try {
                    try {
                        if (!bl || currentLibraryNames.contains(string)) break block22;
                    }
                    catch (Throwable throwable6) {
                        throw LibLoader.a(throwable6);
                    }
                    currentLibraryNames.add(string);
                }
                catch (Throwable throwable7) {
                    throw LibLoader.a(throwable7);
                }
            }
        }
        return bl;
    }

    private static boolean loadLibraryBody(String string) {
        try {
            if (currentLibraryNames.contains(string)) {
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            throw LibLoader.a(runtimeException);
        }
        LibLoader.checkClibJiioSSE2Restriction(string);
        boolean bl = false;
        File file = new File(string);
        if (file.isAbsolute()) {
            String string2 = file.getName();
            if (string2.endsWith(nativeLibExtension)) {
                string2 = string2.substring(0, string2.length() - nativeLibExtension.length());
            }
            bl = LibLoader.loadLibraryFromAbsoluteFile(file, string2);
        } else {
            bl = LibLoader.loadLibraryFromClassPath(string);
            if (!bl) {
                bl = LibLoader.loadLibraryFromLibraryPath(string);
            }
        }
        return bl;
    }

    private static void checkClibJiioSSE2Restriction(String string) {
        block4: {
            try {
                try {
                    if (!string.equalsIgnoreCase("clib_jiio_sse2") || !Boolean.getBoolean("jx.clib_jiio_sse2.disabled")) break block4;
                }
                catch (RuntimeException runtimeException) {
                    throw LibLoader.a(runtimeException);
                }
                throw new RuntimeException("SSE2 support is deactivated by property jx.clib_jiio_sse2.disabled. Please ensure that the clibwrapper_jiio.jar is uptodate.");
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static synchronized boolean loadLibraries(List<String> list, File file) {
        boolean bl;
        block22: {
            try {
                if (logger.infoIsEnabled()) {
                    logger.info("Requested to load libraries \"" + StringTool.createString(list, "\", \"") + "\" from folder \"" + file + "\"");
                }
            }
            catch (Throwable throwable) {
                throw LibLoader.a(throwable);
            }
            bl = false;
            bl = LibLoader.loadLibrariesBody(list, file);
            if (!bl) break block22;
            try {
                block24: {
                    if (currentLibraryNames.containsAll(list)) break block22;
                    break block24;
                    catch (Throwable throwable) {
                        throw LibLoader.a(throwable);
                    }
                }
                currentLibraryNames.addAll(list);
                break block22;
            }
            catch (Throwable throwable) {
                throw LibLoader.a(throwable);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (!LibLoader.excludeFromErrorLog(list.get(0))) {
                            logger.error((Object)("Failed to load native library '" + list.get(0) + "' :" + throwable), throwable);
                        }
                    }
                    catch (Throwable throwable2) {
                        throw LibLoader.a(throwable2);
                    }
                }
                catch (Throwable throwable3) {
                    block23: {
                        try {
                            try {
                                if (!bl || currentLibraryNames.containsAll(list)) break block23;
                            }
                            catch (Throwable throwable4) {
                                throw LibLoader.a(throwable4);
                            }
                            currentLibraryNames.addAll(list);
                        }
                        catch (Throwable throwable5) {
                            throw LibLoader.a(throwable5);
                        }
                    }
                    throw throwable3;
                }
                if (!bl) break block22;
                try {
                    block25: {
                        if (currentLibraryNames.containsAll(list)) break block22;
                        break block25;
                        catch (Throwable throwable6) {
                            throw LibLoader.a(throwable6);
                        }
                    }
                    currentLibraryNames.addAll(list);
                }
                catch (Throwable throwable7) {
                    throw LibLoader.a(throwable7);
                }
            }
        }
        return bl;
    }

    private static boolean loadLibrariesBody(List list, File file) throws IOException {
        File file2;
        boolean bl;
        Object object4;
        Object object2;
        Hashtable<Object, Object> hashtable;
        block30: {
            block32: {
                block33: {
                    String string;
                    File file3;
                    File file4;
                    File file5;
                    block31: {
                        try {
                            if (currentLibraryNames.containsAll(list)) {
                                return true;
                            }
                        }
                        catch (IOException iOException) {
                            throw LibLoader.a(iOException);
                        }
                        hashtable = new Hashtable<Object, Object>();
                        Object object3 = list.iterator();
                        while (object3.hasNext()) {
                            object2 = String.valueOf(object3.next());
                            object4 = new File((String)object2);
                            try {
                                if (((File)object4).isAbsolute()) {
                                    hashtable.put(object2, object4);
                                    continue;
                                }
                            }
                            catch (IOException iOException) {
                                throw LibLoader.a(iOException);
                            }
                            object4 = LibLoader.getLibraryFromClassPath((String)object2);
                            if (object4 == null) {
                                object4 = LibLoader.findLibraryPath((String)object2);
                            }
                            try {
                                if (object4 == null) continue;
                                hashtable.put(object2, object4);
                            }
                            catch (IOException iOException) {
                                throw LibLoader.a(iOException);
                            }
                        }
                        if (hashtable.size() < list.size()) {
                            object3 = new StringBuffer();
                            ((StringBuffer)object3).append("Native libraries not available: " + hashtable.size() + " of " + list.size());
                            ((StringBuffer)object3).append(" required libraries found.");
                            ((StringBuffer)object3).append("\n\trequested: " + StringTool.createString(list, ", "));
                            object2 = hashtable.keySet();
                            try {
                                if (object2.size() != 0) {
                                    ((StringBuffer)object3).append("\n\tfound    : " + StringTool.createString((Set)object2, ", "));
                                }
                            }
                            catch (IOException iOException) {
                                throw LibLoader.a(iOException);
                            }
                            logger.error(((StringBuffer)object3).toString());
                            return false;
                        }
                        bl = false;
                        try {
                            if (file == null) break block30;
                            if (!file.getName().toUpperCase().equals("EXACT")) break block31;
                        }
                        catch (IOException iOException) {
                            throw LibLoader.a(iOException);
                        }
                        file = file.getParentFile();
                        break block33;
                    }
                    try {
                        File file6;
                        file5 = file6;
                        file4 = file6;
                        file3 = file;
                        string = ac.aa() ? "64" : "32";
                    }
                    catch (IOException iOException) {
                        throw LibLoader.a(iOException);
                    }
                    file5(file3, "dependendlib" + string);
                    file = file4;
                }
                try {
                    try {
                        if (file.exists() || file.mkdirs()) break block32;
                    }
                    catch (IOException iOException) {
                        throw LibLoader.a(iOException);
                    }
                    throw new IOException("Temporary folder for libraries does not exist and can't be created.");
                }
                catch (IOException iOException) {
                    throw LibLoader.a(iOException);
                }
            }
            for (Object object4 : list) {
                file2 = (File)hashtable.get(object4);
                File file7 = new File(file, System.mapLibraryName((String)object4));
                logger.debug("copying " + file2.getName() + " to " + file7.getAbsolutePath());
                ar.aa(file2, file7);
                hashtable.put(object4, file7);
            }
        }
        object2 = list.iterator();
        bl = true;
        while (object2.hasNext()) {
            object4 = (String)object2.next();
            try {
                if (LibLoader.isWrappedLibrary((String)object4)) {
                    continue;
                }
            }
            catch (IOException iOException) {
                throw LibLoader.a(iOException);
            }
            file2 = (File)hashtable.get(object4);
            boolean bl2 = LibLoader.loadLibraryFromAbsoluteFile(file2, (String)object4);
            try {
                if (!bl2) {
                    logger.warn("  failed to load '" + (String)object4 + "' from '" + file2 + "'");
                }
            }
            catch (IOException iOException) {
                throw LibLoader.a(iOException);
            }
            bl &= bl2;
        }
        logger.info("loaded " + list.size() + " libraries.");
        return bl;
    }

    private static boolean isWrappedLibrary(String string) {
        boolean bl;
        block5: {
            block4: {
                String string2 = string.toLowerCase();
                try {
                    try {
                        if (!string2.endsWith("_") && !string2.endsWith("_" + nativeLibExtension)) break block4;
                    }
                    catch (RuntimeException runtimeException) {
                        throw LibLoader.a(runtimeException);
                    }
                    bl = true;
                    break block5;
                }
                catch (RuntimeException runtimeException) {
                    throw LibLoader.a(runtimeException);
                }
            }
            bl = false;
        }
        return bl;
    }

    private static boolean loadLibraryFromLibraryPath(String string) {
        boolean bl = false;
        System.loadLibrary(string);
        bl = true;
        File file = LibLoader.findLibraryPath(string);
        Object object = string + nativeLibExtension;
        if (file != null) {
            currentLibFiles.add(file.getPath());
            object = file.getPath();
        } else {
            currentLibFiles.add(string + nativeLibExtension);
        }
        String string2 = "";
        if (OSVersion.isWindows()) {
            string2 = SystemProperties.winOS_getDLLVersion((String)object);
            currentLibVersions.put(string, string2);
        }
        String string3 = "native library " + (String)object + " ver. " + string2 + " loaded.";
        logger.info(string3);
        serverLog.info(string3);
        return bl;
    }

    private static boolean loadLibraryFromAbsoluteFile(File file, String string) {
        Object object;
        Object object2;
        block14: {
            block15: {
                try {
                    if (currentLibraryNames.contains(string)) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    throw LibLoader.a(exception);
                }
                try {
                    if (!file.exists()) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    throw LibLoader.a(exception);
                }
                if (string.equals("dsj")) {
                    try {
                        LibLoader.loadLibraryFromAbsoluteFileDSJ(file);
                    }
                    catch (Exception exception) {
                        logger.error((Object)exception, exception);
                        return false;
                    }
                } else {
                    System.load(file.getAbsolutePath());
                }
                object2 = "";
                try {
                    try {
                        if (!OSVersion.isWindows()) break block14;
                        if (!string.equals("VisusClient")) break block15;
                    }
                    catch (Exception exception) {
                        throw LibLoader.a(exception);
                    }
                    currentLibraryNames.add(string);
                }
                catch (Exception exception) {
                    throw LibLoader.a(exception);
                }
            }
            object = SystemProperties.winOS_getDLLVersion(file.getAbsolutePath());
            currentLibVersions.put(string, (String)object);
            object2 = " ver. " + (String)object;
        }
        object = "    library " + file.getAbsolutePath() + (String)object2 + " loaded.";
        logger.info(object);
        serverLog.info(object);
        currentLibFiles.add(file.getAbsolutePath());
        return true;
    }

    private static void loadLibraryFromAbsoluteFileDSJ(File file) throws ClassNotFoundException, SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("de.humatic.dsj.DSEnvironment");
        Method method = clazz.getMethod("setDLLPath", String.class);
        method.invoke(null, file.getParent());
        Method method2 = clazz.getMethod("getDllVersion", null);
        method2.invoke(null, (Object[])null);
    }

    /*
     * Unable to fully structure code
     */
    private static File getLibraryFromClassPath(String var0) {
        var1_1 = null;
        try {
            block10: {
                block9: {
                    var2_2 = var0;
                    if (var0.toLowerCase().contains(".manifest")) ** GOTO lbl11
                    try {
                        block11: {
                            if (!var0.toLowerCase().contains(".ax")) break block9;
                            break block11;
                            catch (IOException v0) {
                                throw LibLoader.a(v0);
                            }
                        }
                        v1 = true;
                        break block10;
                    }
                    catch (IOException v2) {
                        throw LibLoader.a(v2);
                    }
                }
                v1 = var3_4 = false;
            }
            if (!var3_4) {
                var2_2 = System.mapLibraryName(var0);
            }
            if (OSVersion.isApple()) {
                var4_5 = "mac-universal/native/" + var2_2;
                var1_1 = LibLoader.getLibraryFromClassPath2(var0, var4_5, false);
            }
            if (var1_1 == null) {
                var2_2 = LibLoader.mapClassPathLibraryName(var2_2);
                var1_1 = LibLoader.getLibraryFromClassPath2(var0, var2_2, var3_4);
            }
        }
        catch (IOException var2_3) {
            LibLoader.logger.debug((Object)("Failed to locate resource '" + var0 + "':" + var2_3), var2_3);
        }
        return var1_1;
    }

    private static File getLibraryFromClassPath2(String string, String string2, boolean bl) throws IOException {
        File file = null;
        Enumeration<URL> enumeration = theInstance.getClass().getClassLoader().getResources(string2);
        while (true) {
            try {
                try {
                    if (file != null || enumeration == null) break;
                }
                catch (IOException iOException) {
                    throw LibLoader.a(iOException);
                }
                if (!enumeration.hasMoreElements()) break;
            }
            catch (IOException iOException) {
                throw LibLoader.a(iOException);
            }
            URL uRL = enumeration.nextElement();
            logger.debug("library '" + string + "' located at '" + uRL + "'.");
            if (uRL.toString().toLowerCase().indexOf("jar!") <= 0) continue;
            file = LibLoader.extractLibraryFromURL(uRL, string, bl);
            try {
                if (file == null) continue;
                logger.info("library " + file.getPath() + " extracted from '" + uRL + "'.");
            }
            catch (IOException iOException) {
                throw LibLoader.a(iOException);
            }
        }
        return file;
    }

    private static boolean loadLibraryFromClassPath(String string) {
        boolean bl = false;
        File file = LibLoader.getLibraryFromClassPath(string);
        if (file != null) {
            bl = LibLoader.loadLibraryFromAbsoluteFile(file, string);
        }
        return bl;
    }

    private static String mapClassPathLibraryName(String string) {
        block21: {
            block20: {
                block19: {
                    block18: {
                        try {
                            try {
                                if (!OSVersion.isApple() || !OSVersion.isArchX86()) break block18;
                            }
                            catch (RuntimeException runtimeException) {
                                throw LibLoader.a(runtimeException);
                            }
                            return "mac-i386/native/" + string;
                        }
                        catch (RuntimeException runtimeException) {
                            throw LibLoader.a(runtimeException);
                        }
                    }
                    try {
                        try {
                            if (!OSVersion.isWindows() || !ac.aa()) break block19;
                        }
                        catch (RuntimeException runtimeException) {
                            throw LibLoader.a(runtimeException);
                        }
                        return "windows-x86-64/native/" + string;
                    }
                    catch (RuntimeException runtimeException) {
                        throw LibLoader.a(runtimeException);
                    }
                }
                try {
                    try {
                        try {
                            if (!OSVersion.isSolaris() || OSVersion.isArchX86()) break block20;
                        }
                        catch (RuntimeException runtimeException) {
                            throw LibLoader.a(runtimeException);
                        }
                        if (ac.aa()) break block20;
                    }
                    catch (RuntimeException runtimeException) {
                        throw LibLoader.a(runtimeException);
                    }
                    return "solaris-sparc-32/native/" + string;
                }
                catch (RuntimeException runtimeException) {
                    throw LibLoader.a(runtimeException);
                }
            }
            try {
                try {
                    if (!OSVersion.isLinux() || !ac.aa()) break block21;
                }
                catch (RuntimeException runtimeException) {
                    throw LibLoader.a(runtimeException);
                }
                return "linux-64/native/" + string;
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
        }
        return string;
    }

    private static File findLibraryPath(String string) {
        File file;
        int n;
        for (n = 0; n < sys_paths.length; ++n) {
            file = new File(sys_paths[n], System.mapLibraryName(string));
            try {
                if (!file.exists()) continue;
                return file;
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
        }
        for (n = 0; n < usr_paths.length; ++n) {
            file = new File(usr_paths[n], System.mapLibraryName(string));
            try {
                if (!file.exists()) continue;
                return file;
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
        }
        return null;
    }

    private static String[] initializePath(String string) {
        String string2 = System.getProperty(string, "");
        String string3 = File.pathSeparator;
        int n = string2.length();
        int n2 = string2.indexOf(string3);
        int n3 = 0;
        while (n2 >= 0) {
            ++n3;
            n2 = string2.indexOf(string3, n2 + 1);
        }
        String[] stringArray = new String[n3 + 1];
        n2 = 0;
        n3 = 0;
        int n4 = string2.indexOf(string3);
        while (true) {
            block10: {
                block9: {
                    try {
                        try {
                            if (n4 < 0) break;
                            if (n4 - n2 <= 0) break block9;
                        }
                        catch (RuntimeException runtimeException) {
                            throw LibLoader.a(runtimeException);
                        }
                        stringArray[n3++] = string2.substring(n2, n4);
                        break block10;
                    }
                    catch (RuntimeException runtimeException) {
                        throw LibLoader.a(runtimeException);
                    }
                }
                try {
                    if (n4 - n2 == 0) {
                        stringArray[n3++] = ".";
                    }
                }
                catch (RuntimeException runtimeException) {
                    throw LibLoader.a(runtimeException);
                }
            }
            n2 = n4 + 1;
            n4 = string2.indexOf(string3, n2);
        }
        stringArray[n3] = string2.substring(n2, n);
        return stringArray;
    }

    public static void addToErrorLogExclusions(String string) {
        if (string != null) {
            String string2 = string.trim().toLowerCase();
            try {
                if (!Custom_ErrorLog_Exclusions.contains(string2)) {
                    Custom_ErrorLog_Exclusions.add(string2);
                }
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
        }
    }

    private static boolean excludeFromErrorLog(String string) {
        try {
            if (string == null) {
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            throw LibLoader.a(runtimeException);
        }
        Vector<String> vector = null;
        String string2 = string.trim().toLowerCase();
        vector = OSVersion.isLinux() ? Linux_ErrorLog_Exclusions : (OSVersion.isApple() ? MacOS_ErrorLog_Exclusions : (OSVersion.isWindows() ? Windows_ErrorLog_Exclusions : OtherOS_ErrorLog_Exclusions));
        vector.addAll(Custom_ErrorLog_Exclusions);
        int n = vector.size();
        int n2 = 0;
        while (true) {
            block8: {
                try {
                    try {
                        if (n2 >= n) break;
                        if (string2.indexOf(String.valueOf(vector.get(n2))) < 0) break block8;
                    }
                    catch (RuntimeException runtimeException) {
                        throw LibLoader.a(runtimeException);
                    }
                    return true;
                }
                catch (RuntimeException runtimeException) {
                    throw LibLoader.a(runtimeException);
                }
            }
            ++n2;
        }
        return false;
    }

    public static boolean copyLibrariesWithoutLoading(List<String> list) {
        boolean bl;
        block14: {
            bl = true;
            try {
                if (logger.infoIsEnabled()) {
                    logger.info("Requested to load libraries \"" + StringTool.createString(list, "\", \""));
                }
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
            try {
                if (currentLibraryNames.containsAll(list)) {
                    return true;
                }
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
            int n = 0;
            while (true) {
                block13: {
                    try {
                        if (n >= list.size()) break;
                        if (LibLoader.getLibraryFromClassPath(list.get(n)) != null) break block13;
                    }
                    catch (RuntimeException runtimeException) {
                        throw LibLoader.a(runtimeException);
                    }
                    logger.error("Failed to copy native runtime library '" + list.get(n));
                    bl = false;
                }
                ++n;
            }
            try {
                try {
                    if (!bl || currentLibraryNames.containsAll(list)) break block14;
                }
                catch (RuntimeException runtimeException) {
                    throw LibLoader.a(runtimeException);
                }
                currentLibraryNames.addAll(list);
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
        }
        return bl;
    }

    static {
        block4: {
            try {
                try {
                    sys_paths = null;
                    usr_paths = null;
                    MacOS_ErrorLog_Exclusions = new Vector();
                    Linux_ErrorLog_Exclusions = new Vector();
                    Windows_ErrorLog_Exclusions = new Vector();
                    OtherOS_ErrorLog_Exclusions = new Vector();
                    Custom_ErrorLog_Exclusions = new Vector();
                    MacOS_ErrorLog_Exclusions.add("VisusClient".trim().toLowerCase());
                    MacOS_ErrorLog_Exclusions.add("VisusServer".trim().toLowerCase());
                    MacOS_ErrorLog_Exclusions.add("clib_jiio");
                    MacOS_ErrorLog_Exclusions.add("clib_jiio_util");
                    MacOS_ErrorLog_Exclusions.add("DevIL".trim().toLowerCase());
                    MacOS_ErrorLog_Exclusions.add("StarBurn".trim().toLowerCase());
                    Linux_ErrorLog_Exclusions.add("VisusClient".trim().toLowerCase());
                    Linux_ErrorLog_Exclusions.add("VisusServer".trim().toLowerCase());
                    Linux_ErrorLog_Exclusions.add("clib_jiio_util");
                    Linux_ErrorLog_Exclusions.add("DevIL".trim().toLowerCase());
                    Linux_ErrorLog_Exclusions.add("StarBurn".trim().toLowerCase());
                    Windows_ErrorLog_Exclusions.add("clib_jiio_util");
                    if (Boolean.getBoolean("jx.jvm64.noclibwarning") || !ac.aa()) break block4;
                }
                catch (RuntimeException runtimeException) {
                    throw LibLoader.a(runtimeException);
                }
                Windows_ErrorLog_Exclusions.add("clib_jiio");
            }
            catch (RuntimeException runtimeException) {
                throw LibLoader.a(runtimeException);
            }
        }
        Windows_ErrorLog_Exclusions.add("DevIL".trim().toLowerCase());
        OtherOS_ErrorLog_Exclusions.add("VisusClient".trim().toLowerCase());
        OtherOS_ErrorLog_Exclusions.add("VisusServer".trim().toLowerCase());
        OtherOS_ErrorLog_Exclusions.add("clib_jiio_util");
        OtherOS_ErrorLog_Exclusions.add("DevIL".trim().toLowerCase());
        OtherOS_ErrorLog_Exclusions.add("StarBurn".trim().toLowerCase());
        sys_paths = LibLoader.initializePath("sun.boot.library.path");
        usr_paths = LibLoader.initializePath("java.library.path");
        logger = LoggerFactory.getInstance(LOGGER_NAME);
        serverLog = LoggerFactory.getInstance("Init");
        theInstance = new LibLoader();
        currentLibraryNames = Collections.synchronizedSet(new HashSet());
        currentLibFiles = Collections.synchronizedSet(new HashSet());
        currentLibVersions = new Hashtable();
        nativeLibExtension = System.mapLibraryName("a").substring(1).toLowerCase();
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

