/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.io;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.io.CustomFileAccess;
import com.visustt.tools.io.ai;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.lang.al;
import com.visustt.tools.net.ac;
import com.visustt.tools.system.OSVersion;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;

public class FileAccess {
    private static Logger logger = LoggerFactory.getInstance("jx.util.fileaccess");
    private static boolean useChannel = System.getProperty("jx.util.fileaccess.useChannel", "false").equals("true");
    private static int MAX_FILE_BUFFER_SIZE;

    public static synchronized InputStream getStream(File file) throws IOException {
        InputStream inputStream;
        block6: {
            block8: {
                ClassLoader classLoader = FileAccess.class.getClassLoader();
                inputStream = classLoader.getResourceAsStream(file.getName());
                try {
                    block7: {
                        try {
                            try {
                                if (inputStream != null) break block6;
                                if (!file.isFile()) break block7;
                            }
                            catch (IOException iOException) {
                                throw FileAccess.a(iOException);
                            }
                            if (file.canRead()) break block8;
                        }
                        catch (IOException iOException) {
                            throw FileAccess.a(iOException);
                        }
                    }
                    throw new FileNotFoundException(file.getName());
                }
                catch (IOException iOException) {
                    throw FileAccess.a(iOException);
                }
            }
            inputStream = new FileInputStream(file.getAbsoluteFile());
        }
        return inputStream;
    }

    public static synchronized InputStream getStream(String string) throws IOException {
        ClassLoader classLoader = FileAccess.class.getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            block5: {
                File file = new File(string);
                try {
                    try {
                        if (file.isFile() && file.canRead()) break block5;
                    }
                    catch (IOException iOException) {
                        throw FileAccess.a(iOException);
                    }
                    throw new FileNotFoundException(string);
                }
                catch (IOException iOException) {
                    throw FileAccess.a(iOException);
                }
            }
            inputStream = new FileInputStream(string);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final byte[] getByteArray(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.available();
        try {
            n = n2 > 0 ? n2 : 16384;
        }
        catch (IOException iOException) {
            throw FileAccess.a(iOException);
        }
        int n3 = n;
        byte[] byArray = new byte[16384];
        boolean bl = false;
        try (ai ai2 = new ai(n3);){
            int n4 = 0;
            try {
                while (true) {
                    int n5;
                    try {
                        int n6 = n5 = bl ? inputStream.read(ai2.aa()) : inputStream.read(byArray);
                    }
                    catch (IOException iOException) {
                        throw FileAccess.a(iOException);
                    }
                    if (n5 == -1) {
                        return ai2.toByteArray();
                    }
                    n4 += n5;
                    try {
                        if (bl) {
                            ai2.aa(n5);
                            continue;
                        }
                    }
                    catch (IOException iOException) {
                        throw FileAccess.a(iOException);
                    }
                    ai2.write(byArray, 0, n5);
                }
            }
            catch (IOException iOException) {
                System.err.println("Aborted after reading " + n4 + " bytes");
                throw iOException;
            }
        }
    }

    public static final void readArray(InputStream inputStream, byte[] byArray, int n) throws IOException {
        int n2 = 0;
        int n3 = byArray.length;
        while (true) {
            int n4;
            int n5;
            byte[] byArray2;
            InputStream inputStream2;
            block9: {
                block8: {
                    try {
                        try {
                            if (n2 >= n3) break;
                            inputStream2 = inputStream;
                            byArray2 = byArray;
                            n5 = n2;
                            if (n3 - n2 >= n) break block8;
                        }
                        catch (IOException iOException) {
                            throw FileAccess.a(iOException);
                        }
                        n4 = n3 - n2;
                        break block9;
                    }
                    catch (IOException iOException) {
                        throw FileAccess.a(iOException);
                    }
                }
                n4 = n;
            }
            int n6 = inputStream2.read(byArray2, n5, n4);
            try {
                if (n6 < 0) {
                    throw new EOFException();
                }
            }
            catch (IOException iOException) {
                throw FileAccess.a(iOException);
            }
            n2 += n6;
        }
    }

    public static final int readInt(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        int n2 = inputStream.read();
        int n3 = inputStream.read();
        int n4 = inputStream.read();
        try {
            if ((n | n2 | n3 | n4) < 0) {
                throw new EOFException();
            }
        }
        catch (IOException iOException) {
            throw FileAccess.a(iOException);
        }
        return (n << 24) + (n2 << 16) + (n3 << 8) + (n4 << 0);
    }

    public static synchronized ImageIcon getIcon(String string) {
        try {
            return FileAccess.getIcon(CustomFileAccess.getCustomResource(string));
        }
        catch (IOException iOException) {
            logger.error((Object)("failed to retrieve icon resource '" + string + "':" + iOException), iOException);
            return null;
        }
    }

    public static synchronized ImageIcon getIcon(URL uRL) {
        try {
            if (uRL == null) {
                return null;
            }
        }
        catch (Exception exception) {
            throw FileAccess.a(exception);
        }
        byte[] byArray = null;
        try (InputStream inputStream = uRL.openStream();){
            byArray = FileAccess.getByteArray(inputStream);
        }
        catch (Exception exception) {
            logger.error((Object)("failed to retrieve resource \"" + uRL + "\": " + exception), exception);
            FileAccess.dumpThreads();
        }
        try {
            if (byArray != null) {
                return new ImageIcon(byArray, "resource " + uRL.toExternalForm());
            }
        }
        catch (Exception exception) {
            throw FileAccess.a(exception);
        }
        logger.error("failed to retrieve icon '" + uRL + "'");
        return null;
    }

    private static void dumpThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        threadGroup.list();
    }

    public static boolean existsInternalResourceFile(String string) {
        boolean bl;
        try {
            bl = ResourceBundle.class.getResource(string) != null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
        return bl;
    }

    @Deprecated
    public static byte[] getByteArray(String string) throws IOException {
        InputStream inputStream = null;
        try {
            inputStream = FileAccess.getStream(string);
        }
        catch (IOException iOException) {
            inputStream = FileAccess.getHTTPStream(string);
        }
        try {
            byte[] byArray = FileAccess.getByteArray(inputStream);
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    @Deprecated
    public static byte[] getFileLocal(String string) throws IOException {
        return FileAccess.getResourceBytes(string);
    }

    public static byte[] getResourceBytes(String string) throws IOException {
        try (InputStream inputStream = FileAccess.getStream(string);){
            byte[] byArray = FileAccess.getByteArray(inputStream);
            return byArray;
        }
    }

    public static final byte[] getFileLocal(File file) throws IOException {
        return FileAccess.getFileLocal(file, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static final byte[] getFileLocal(File file, int n) throws IOException {
        FileInputStream fileInputStream = null;
        byte[] byArray = null;
        try {
            long l;
            block31: {
                block37: {
                    l = 0L;
                    try {
                        if (logger.debugIsEnabled()) {
                            logger.debug("START loading '" + file + "' (useChannel=" + useChannel + ")");
                        }
                    }
                    catch (VirtualMachineError virtualMachineError) {
                        throw FileAccess.a(virtualMachineError);
                    }
                    if (logger.infoIsEnabled()) {
                        l = System.currentTimeMillis();
                    }
                    if (!useChannel) break block37;
                    fileInputStream = new FileInputStream(file);
                    FileChannel fileChannel = fileInputStream.getChannel();
                    byArray = new byte[Math.min((int)file.length(), n)];
                    ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                    fileChannel.read(byteBuffer);
                    break block31;
                }
                int n2 = Math.min((int)file.length(), n);
                fileInputStream = new FileInputStream(file);
                try {
                    if (logger.debugIsEnabled()) {
                        logger.debug("    get lenght -> " + (System.currentTimeMillis() - l) + " ms");
                    }
                }
                catch (VirtualMachineError virtualMachineError) {
                    throw FileAccess.a(virtualMachineError);
                }
                byArray = new byte[n2];
                try {
                    if (logger.debugIsEnabled()) {
                        logger.debug("    init array -> " + (System.currentTimeMillis() - l) + " ms");
                    }
                }
                catch (VirtualMachineError virtualMachineError) {
                    throw FileAccess.a(virtualMachineError);
                }
                int n3 = 0;
                try {
                    while (true) {
                        int n4;
                        int n5;
                        byte[] byArray2;
                        FileInputStream fileInputStream2;
                        block33: {
                            block32: {
                                if (n3 >= n2) break block31;
                                try {
                                    block38: {
                                        fileInputStream2 = fileInputStream;
                                        byArray2 = byArray;
                                        n5 = n3;
                                        if (n2 - n3 >= MAX_FILE_BUFFER_SIZE) break block32;
                                        break block38;
                                        catch (VirtualMachineError virtualMachineError) {
                                            throw FileAccess.a(virtualMachineError);
                                        }
                                    }
                                    n4 = n2 - n3;
                                    break block33;
                                }
                                catch (VirtualMachineError virtualMachineError) {
                                    throw FileAccess.a(virtualMachineError);
                                }
                            }
                            n4 = MAX_FILE_BUFFER_SIZE;
                        }
                        int n6 = fileInputStream2.read(byArray2, n5, n4);
                        try {
                            if (n6 < 0) {
                                throw new EOFException();
                            }
                        }
                        catch (VirtualMachineError virtualMachineError) {
                            throw FileAccess.a(virtualMachineError);
                        }
                        n3 += n6;
                    }
                }
                catch (VirtualMachineError virtualMachineError) {
                    block34: {
                        block35: {
                            if (virtualMachineError.toString().toLowerCase().indexOf("memory") == -1) break block34;
                            try {
                                block39: {
                                    if (!logger.debugIsEnabled()) break block35;
                                    break block39;
                                    catch (VirtualMachineError virtualMachineError2) {
                                        throw FileAccess.a(virtualMachineError2);
                                    }
                                }
                                logger.debug("Getting file " + file.getAbsolutePath() + " with a buffer size of " + MAX_FILE_BUFFER_SIZE + " has thrown a " + virtualMachineError.getClass() + "!!! Reducing  buffer size to " + MAX_FILE_BUFFER_SIZE / 2 + " to prevent further trouble...");
                            }
                            catch (VirtualMachineError virtualMachineError3) {
                                throw FileAccess.a(virtualMachineError3);
                            }
                        }
                        MAX_FILE_BUFFER_SIZE /= 2;
                    }
                    throw virtualMachineError;
                }
            }
            try {
                if (logger.infoIsEnabled()) {
                    logger.info("    FINISHED loading '" + file + " (" + byArray.length + ")' (" + (System.currentTimeMillis() - l) + " ms)");
                }
            }
            catch (VirtualMachineError virtualMachineError) {
                throw FileAccess.a(virtualMachineError);
            }
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
                fileInputStream = null;
            }
        }
        return byArray;
    }

    private static InputStream getHTTPStream(String string) throws IOException {
        return ac.aa(new URL(string));
    }

    public static byte[] getFileRemote(String string) throws IOException {
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(FileAccess.getHTTPStream(string));){
            byte[] byArray = FileAccess.getByteArray(bufferedInputStream);
            return byArray;
        }
    }

    public static final boolean isHTTPURL(String string) {
        block7: {
            try {
                try {
                    if (string != null && string.length() >= 7) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
        }
        try {
            if (string.trim().toLowerCase().matches("http[s]?+://.*")) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
        return false;
    }

    public static boolean isFileURL(URL uRL) {
        try {
            if (uRL == null) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
        String string = uRL.getProtocol();
        return string.equalsIgnoreCase("file");
    }

    public static final boolean fileExists(String string) {
        block7: {
            block8: {
                try {
                    if (!StringTool.isDefined(string)) {
                        return false;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                String string2 = null;
                string2 = OSVersion.isWindows() ? FileAccess.makeWindowsPath(string, false) : FileAccess.makeUnixPath(string, false);
                File file = new File(string2);
                try {
                    try {
                        if (file.isFile()) break block7;
                        if (!logger.debugIsEnabled()) break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw FileAccess.a(illegalArgumentException);
                    }
                    logger.debug("File does not exist: " + file.getAbsolutePath());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
            }
            return false;
        }
        return true;
    }

    public static final boolean folderExists(String string) {
        block7: {
            block8: {
                try {
                    if (!StringTool.isDefined(string)) {
                        return false;
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                String string2 = null;
                string2 = OSVersion.isWindows() ? FileAccess.makeWindowsPath(string, false) : FileAccess.makeUnixPath(string, false);
                File file = new File(string2);
                try {
                    try {
                        if (file.isDirectory()) break block7;
                        if (!logger.debugIsEnabled()) break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw FileAccess.a(illegalArgumentException);
                    }
                    logger.debug("Folder does not exist: " + file.getAbsolutePath());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
            }
            return false;
        }
        return true;
    }

    public static final String makeWindowsPath(String string) {
        return FileAccess.makeWindowsPath(string, true);
    }

    private static final String makeWindowsPath(String string, boolean bl) {
        Object object;
        block14: {
            try {
                try {
                    if (string != null && string.length() != 0) break block14;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
        }
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (true) {
            block15: {
                try {
                    try {
                        if (n >= string.length()) break;
                        if (!bl) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw FileAccess.a(illegalArgumentException);
                    }
                    if (string.charAt(n) != ' ') break block15;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                bl2 = true;
            }
            try {
                if (string.charAt(n) != '\"') {
                    stringBuffer.append(string.charAt(n));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
            ++n;
        }
        Object object2 = stringBuffer.toString();
        object2 = ((String)object2).startsWith("\\\\") ? "\\" + StringTool.replaceString((String)object2, "\\\\", "\\") : StringTool.replaceString((String)object2, "\\\\", "\\");
        try {
            object = bl2 ? "\"" + (String)object2 + "\"" : object2;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
        return object;
    }

    public static final String makeUnixPath(String string) {
        return FileAccess.makeUnixPath(string, true);
    }

    public static final String makeUnixPath(String string, boolean bl) {
        block14: {
            try {
                try {
                    if (string != null && string.length() != 0) break block14;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (true) {
            block15: {
                try {
                    try {
                        try {
                            if (n >= string.length()) break;
                            if (string.charAt(n) != ' ') break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw FileAccess.a(illegalArgumentException);
                        }
                        if (!bl) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw FileAccess.a(illegalArgumentException);
                    }
                    stringBuffer.append("\\");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
            }
            try {
                if (string.charAt(n) != '\"') {
                    stringBuffer.append(string.charAt(n));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
            ++n;
        }
        Object object = stringBuffer.toString();
        object = ((String)object).startsWith("//") ? "/" + StringTool.replaceString((String)object, "//", "/") : StringTool.replaceString((String)object, "//", "/");
        return object;
    }

    public static final String niceNativePath(String string) {
        block7: {
            try {
                if (string == null) {
                    throw new IllegalArgumentException("niceNativePath: path-argument is null");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
            string = File.separatorChar == '/' ? string.replace('\\', File.separatorChar) : string.replace('/', File.separatorChar);
            try {
                try {
                    if (!string.endsWith(File.separator) && string.length() != 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                return string;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
        }
        return string + File.separatorChar;
    }

    public static boolean folderWriteAccess(String object) {
        try {
            if (!FileAccess.folderExists((String)object)) {
                return false;
            }
        }
        catch (Exception exception) {
            throw FileAccess.a(exception);
        }
        if (!((String)object).endsWith(File.separator)) {
            object = (String)object + File.separator;
        }
        int n = 0;
        try {
            while (FileAccess.fileExists((String)object + String.valueOf(n) + "~.txt")) {
                ++n;
            }
        }
        catch (Exception exception) {
            throw FileAccess.a(exception);
        }
        File file = new File((String)object + String.valueOf(n) + "~.txt");
        boolean bl = false;
        try {
            file.createNewFile();
            file.delete();
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Deprecated
    public static String getExtension(String string) {
        try {
            if (!StringTool.isDefined(string)) {
                return null;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
        int n = string.lastIndexOf(46);
        return string.substring(n + 1);
    }

    public static final String getFileExtension(String string) {
        String string2;
        al.ac(string);
        int n = string.lastIndexOf(46);
        try {
            string2 = n == -1 ? "" : string.substring(n + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
        return string2;
    }

    public static final String getFileExtension(File file) {
        return FileAccess.getFileExtension(file.getName());
    }

    public static String checkFolder(String object, Logger logger) throws IOException {
        block15: {
            try {
                if (logger.debugIsEnabled()) {
                    logger.debug("Checking path '" + (String)object + "'");
                }
            }
            catch (IOException iOException) {
                throw FileAccess.a(iOException);
            }
            object = ((String)object).replaceAll(File.separator + File.separator, File.separator);
            Object object2 = System.getProperty("user.dir");
            if (!((String)object2).endsWith(File.separator)) {
                object2 = (String)object2 + File.separator;
            }
            if (!new File((String)object).isAbsolute()) {
                object = (String)object2 + (String)object;
                try {
                    if (logger.debugIsEnabled()) {
                        logger.debug("Config Path is relative! Adapted it to '" + (String)object + "'");
                    }
                }
                catch (IOException iOException) {
                    throw FileAccess.a(iOException);
                }
            }
            File file = new File((String)object);
            try {
                if (file.isFile()) {
                    throw new IOException("Configuration path '" + (String)object + "' is a file and not a folder!");
                }
            }
            catch (IOException iOException) {
                throw FileAccess.a(iOException);
            }
            try {
                try {
                    if (file.exists() || file.mkdirs()) break block15;
                }
                catch (IOException iOException) {
                    throw FileAccess.a(iOException);
                }
                throw new IOException("Configuration path '" + (String)object + "' check failed!");
            }
            catch (IOException iOException) {
                throw FileAccess.a(iOException);
            }
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeOutputStreamQuietly(OutputStream outputStream) {
        try {
            if (outputStream == null) return;
            try {
                outputStream.close();
                return;
            }
            catch (IOException iOException) {
                logger.warn((Object)"Could not close Output stream. Ignore ??", iOException);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void closeInputStreamQuietly(InputStream inputStream) {
        try {
            if (inputStream == null) return;
            try {
                inputStream.close();
                return;
            }
            catch (IOException iOException) {
                logger.warn((Object)"Could not close Output stream. Ignore ??", iOException);
                return;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
    }

    public static String adjustFileName(String string) {
        Object object = System.getProperty("user.dir").replaceAll("\\\\", "/");
        if (!((String)object).endsWith("/")) {
            object = (String)object + "/";
        }
        if (!new File(string).isAbsolute()) {
            string = ((String)object + "/" + string).replaceAll("//", "/");
            try {
                if (logger.debugIsEnabled()) {
                    logger.debug("Adapted config file to '" + string + "'");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String readTextFile(File file, String string) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            String string2 = FileAccess.readTextFile(fileInputStream, string);
            return string2;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {
                logger.error((Object)("Failed to close file imput stream! " + file.getAbsolutePath()), iOException);
            }
        }
    }

    public static final String readTextFile(InputStream inputStream, String string) throws IOException {
        StringWriter stringWriter;
        block5: {
            stringWriter = new StringWriter();
            BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, string));
            String string2 = bufferedReader.readLine();
            try {
                if (string2 == null) break block5;
                bufferedWriter.append(string2);
            }
            catch (IOException iOException) {
                throw FileAccess.a(iOException);
            }
            while (true) {
                string2 = bufferedReader.readLine();
                try {
                    if (string2 == null) break;
                    bufferedWriter.newLine();
                    bufferedWriter.append(string2);
                }
                catch (IOException iOException) {
                    throw FileAccess.a(iOException);
                }
            }
        }
        return stringWriter.toString();
    }

    public static File findFile(File file, String string) {
        block12: {
            try {
                try {
                    if (file != null && StringTool.isDefined(string)) break block12;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw FileAccess.a(illegalArgumentException);
            }
        }
        File file2 = new File(file, string);
        try {
            if (file2.canRead()) {
                return file2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw FileAccess.a(illegalArgumentException);
        }
        file2 = null;
        File[] fileArray = file.listFiles();
        int n = fileArray.length - 1;
        while (true) {
            block13: {
                try {
                    try {
                        if (n < 0 || file2 != null) break;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw FileAccess.a(illegalArgumentException);
                    }
                    if (!fileArray[n].isDirectory()) break block13;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw FileAccess.a(illegalArgumentException);
                }
                file2 = FileAccess.findFile(fileArray[n], string);
            }
            --n;
        }
        return file2;
    }

    static {
        String string = System.getProperty("jx.util.fileaccess.maxFileBufferSize", "8388608");
        int n = 0x800000;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.warn((Object)("Illegal value for system property \"jx.util.fileaccess.maxFileBufferSize\":" + string), exception);
        }
        MAX_FILE_BUFFER_SIZE = n;
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

