/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.io;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.io.FileAccess;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.net.ad;
import com.visustt.tools.util.ac.ac;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.ResourceBundle;

public class CustomFileAccess {
    private static final Logger logger = LoggerFactory.getInstance("jx.util.resource");
    protected static final String FDA_LOGO_HTML_STRING = "<td align=\"right\" valign=\"middle\" width=\"110\"><img src=\"fda_logo.png\" width=\"88\" height=\"37\" alt=\"FDA\"></td>";
    protected static final String CUSTOM_PROPERTIES = "custom/com/visustt/resources/custom/customize";
    protected static final String REPLACE_PRODUCT_NAME_KEY = "replace.product.name";
    protected static final String REMOVE_FDA_LOGO_KEY = "remove.fda.logo";
    protected static final String CUSTOMER_NAME_KEY = "customer.name";
    protected static final String PRODUCT_NAME_KEY = ".PRODUCT.NAME";
    private static CustomFileAccess instance = new CustomFileAccess();
    private static boolean useCustomJar;
    private ResourceBundle customResources;

    /*
     * Loose catch block
     */
    protected CustomFileAccess() {
        try {
            block10: {
                CustomFileAccess.setUseCustomJar(false);
                URL uRL = this.getCustomPropertiesURL();
                try {
                    if (uRL != null) {
                        CustomFileAccess.setUseCustomJar(true);
                    }
                }
                catch (Throwable throwable) {
                    throw CustomFileAccess.a(throwable);
                }
                if (!CustomFileAccess.isUseCustomJar()) break block10;
                try {
                    block11: {
                        if (System.getProperty("jx.useCustom", null) == null) break block10;
                        break block11;
                        catch (Throwable throwable) {
                            throw CustomFileAccess.a(throwable);
                        }
                    }
                    CustomFileAccess.setUseCustomJar(Boolean.getBoolean("jx.useCustom"));
                }
                catch (Throwable throwable) {
                    throw CustomFileAccess.a(throwable);
                }
            }
            if (CustomFileAccess.isUseCustomJar()) {
                ResourceBundle.Control control = ResourceBundle.Control.getNoFallbackControl(ResourceBundle.Control.FORMAT_PROPERTIES);
                this.setCustomResources(this.getCustomResourceBundle(control));
                this.applySystemProperties();
                logger.info("Initialized custom.jar file");
            }
        }
        catch (Throwable throwable) {
            CustomFileAccess.setUseCustomJar(false);
            logger.warn((Object)"Failed to initialize custom.jar file!", throwable);
        }
    }

    public static URL getCustomResource(String string) throws IOException {
        File file;
        ClassLoader classLoader = CustomFileAccess.class.getClassLoader();
        URL uRL = null;
        String string2 = null;
        if (CustomFileAccess.isUseCustomJar()) {
            string2 = CustomFileAccess.getCustomString(string);
            uRL = instance.getResourceFromClassLoader(classLoader, string2);
            uRL = instance.getFixedURLForJava15And16(uRL);
        }
        if (uRL == null) {
            uRL = instance.getResourceFromClassLoader(classLoader, string);
            uRL = instance.getFixedURLForJava15And16(uRL);
        }
        if (uRL == null && (file = new File(string)).exists()) {
            uRL = file.toURL();
        }
        try {
            if (uRL == null) {
                throw new FileNotFoundException("resource " + string2 + " or " + string);
            }
        }
        catch (IOException iOException) {
            throw CustomFileAccess.a(iOException);
        }
        return uRL;
    }

    public static InputStream getCustomStream(String string) throws IOException {
        ClassLoader classLoader = instance.getClass().getClassLoader();
        InputStream inputStream = null;
        if (CustomFileAccess.isUseCustomJar()) {
            inputStream = instance.getResourceAsStreamFromClassLoader(string, classLoader);
        }
        if (inputStream == null) {
            inputStream = instance.getStreamFromFileAccess(string);
        }
        return inputStream;
    }

    public static String getCustomString(String string) {
        if (!CustomFileAccess.isUseCustomJar()) {
            return string;
        }
        boolean bl = string.startsWith("/");
        if (bl) {
            return "/custom" + string;
        }
        return "custom/" + string;
    }

    public static boolean isUseCustomJar() {
        return useCustomJar;
    }

    public static ResourceBundle getResourceBundle() {
        if (CustomFileAccess.isUseCustomJar()) {
            return instance.getCustomResources();
        }
        return null;
    }

    public static String getCustomerProductNameKey() {
        ResourceBundle resourceBundle = instance.getCustomResources();
        if (CustomFileAccess.isReplaceProductName() && resourceBundle.containsKey(CUSTOMER_NAME_KEY)) {
            return resourceBundle.getString(CUSTOMER_NAME_KEY) + PRODUCT_NAME_KEY;
        }
        return null;
    }

    public static String removeFDALogo(String string) {
        if (CustomFileAccess.isRemoveFDALogo()) {
            string = string.replace(FDA_LOGO_HTML_STRING, "");
        }
        return string;
    }

    public static boolean isReplaceProductName() {
        return instance.getCustomResources() != null && instance.getCustomResources().containsKey(REPLACE_PRODUCT_NAME_KEY) && instance.getCustomResources().getString(REPLACE_PRODUCT_NAME_KEY).equals("true");
    }

    public static boolean isRemoveFDALogo() {
        return instance.getCustomResources() != null && instance.getCustomResources().containsKey(REMOVE_FDA_LOGO_KEY) && instance.getCustomResources().getString(REMOVE_FDA_LOGO_KEY).equals("true");
    }

    public static void setInstance(CustomFileAccess customFileAccess) {
        instance = customFileAccess;
    }

    protected ResourceBundle getCustomResources() {
        return this.customResources;
    }

    protected ResourceBundle getCustomResourceBundle(ResourceBundle.Control control) {
        return ResourceBundle.getBundle(CUSTOM_PROPERTIES, control);
    }

    protected URL getCustomPropertiesURL() {
        return CustomFileAccess.class.getResource("/custom/com/visustt/resources/custom/customize.properties");
    }

    protected void applySystemProperties() {
        Enumeration<String> enumeration = this.getCustomResources().getKeys();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = enumeration.nextElement();
            if (this.isPropertyAvailableInGlobalProperties(string2) || !StringTool.isDefined(string = this.getCustomResources().getString(string2))) continue;
            System.setProperty(string2, string);
        }
    }

    protected boolean isPropertyAvailableInGlobalProperties(String string) {
        return ac.aa().ab(string);
    }

    protected void setCustomResources(ResourceBundle resourceBundle) {
        this.customResources = resourceBundle;
    }

    protected URL getFixedURLForJava15And16(URL uRL) {
        return ad.aa(uRL);
    }

    protected URL getResourceFromClassLoader(ClassLoader classLoader, String string) {
        return classLoader.getResource(string);
    }

    protected InputStream getResourceAsStreamFromClassLoader(String string, ClassLoader classLoader) {
        return classLoader.getResourceAsStream(CustomFileAccess.getCustomString(string));
    }

    protected InputStream getStreamFromFileAccess(String string) throws IOException {
        return FileAccess.getStream(string);
    }

    protected static void setUseCustomJar(boolean bl) {
        useCustomJar = bl;
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

