/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.awt.screen;

import com.visustt.tools.awt.screen.aa.ac;
import com.visustt.tools.awt.screen.ad;
import com.visustt.tools.awt.screen.ak;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Monitor
implements ak,
Comparable {
    private static final boolean FORCE_2MP = StringTool.isTrue(System.getProperty("force2MPDisplay", "false"));
    private static final boolean FORCE_3MP = StringTool.isTrue(System.getProperty("force3MPDisplay", "false"));
    private static final boolean FORCE_5MP = StringTool.isTrue(System.getProperty("force5MPDisplay", "false"));
    private static final ad comp = new ad();
    public static final int TYPE_PSEUDO_GRAY = 67007026;
    public static final float IN2MM = 25.4f;
    public static final double NO_INTERSECTION = -1.0;
    private static final Logger LOGGER = LoggerFactory.getInstance("jx.monitor");
    private Rectangle scaledScreenRect;
    private Rectangle unscaledScreenRect;
    private Rectangle[] spannedScreenRects;
    private int colorDepth;
    private boolean isStaticGrayscale;
    private boolean isPseudoGrayscale;
    private String graphicsBoard;
    protected Point matrixPosition;
    private int numberOfPixel;
    private GraphicsDevice gd;
    private boolean spanned;
    private ArrayList edids;
    private double dpi = 0.0;
    private static final double ICON_SIZE = 0.6;
    private double diagonalSizeInInch = 0.0;
    private float scalingFactor = -1.0f;
    private float oldScalingFactor = -1.0f;

    public Monitor(Rectangle rectangle, int n, int n2, GraphicsDevice graphicsDevice, boolean bl) {
        this(rectangle, null, n, n2, graphicsDevice, bl, "", Collections.EMPTY_LIST, false);
    }

    public Monitor(Rectangle rectangle, int n, int n2, GraphicsDevice graphicsDevice, boolean bl, String string) {
        this(rectangle, null, n, n2, graphicsDevice, bl, string, Collections.EMPTY_LIST, false);
    }

    public Monitor(Rectangle rectangle, int n, int n2, GraphicsDevice graphicsDevice, boolean bl, String string, Collection collection) {
        this(rectangle, null, n, n2, graphicsDevice, bl, string, collection, false);
    }

    public Monitor(Rectangle rectangle, Rectangle[] rectangleArray, int n, int n2, GraphicsDevice graphicsDevice, boolean bl, String string, Collection collection, boolean bl2) {
        this.gd = graphicsDevice;
        this.scaledScreenRect = rectangle;
        this.colorDepth = n;
        this.graphicsBoard = string;
        this.isPseudoGrayscale = n2 == 67007026;
        this.isStaticGrayscale = n2 == 6;
        this.matrixPosition = new Point(1, 1);
        this.spanned = bl;
        this.edids = new ArrayList(collection.size());
        this.edids.addAll(collection);
        this.spannedScreenRects = rectangleArray;
        this.numberOfPixel = rectangle.width * rectangle.height;
        if (rectangleArray != null && rectangleArray.length > 0) {
            this.numberOfPixel = bl2 && rectangleArray.length == 2 && this.numberOfPixel >= 0x600000 ? 0x500000 : (bl2 && rectangleArray.length == 2 && this.numberOfPixel >= 0x3CC000 ? 0x300000 : rectangleArray[0].width * rectangleArray[0].height);
        }
    }

    public final List getEDIDs() {
        return this.edids;
    }

    private float calculateLocalScalingFactor() {
        float f;
        double d = (double)25.4f / this.getMonitorDPI();
        double d2 = 24.0 * (d / 10.0);
        if (LOGGER.debugIsEnabled() && d2 <= 0.0) {
            LOGGER.debug("Pixel size for monitor " + this.toString() + " is " + d2 + ". Setting scaling factor to 1!");
        }
        LOGGER.debug("pixelSizeMM:" + d);
        LOGGER.debug("edgeLength:" + d2);
        LOGGER.debug("monitorDPI" + this.getMonitorDPI());
        float f2 = f = d2 <= 0.0 ? 1.0f : (float)(0.6 / d2);
        if (d < 0.05) {
            f = 1.0f;
        }
        if (Boolean.getBoolean("jx.vb.useScalingTestingMode") && (f = (float)this.getX() / 1000.0f) > 2.0f) {
            f = 2.0f;
        }
        f = this.adjustScalingFactor(f);
        LOGGER.debug("Local scaling factor for monitor " + this.toString() + ": " + f);
        return f;
    }

    private float adjustScalingFactor(float f) {
        if ((double)f <= 1.13) {
            f = 1.0f;
        } else if ((double)f > 1.13 && (double)f <= 1.37) {
            f = 1.25f;
        } else if ((double)f > 1.37 && (double)f <= 1.63) {
            f = 1.5f;
        } else if ((double)f > 1.63 && (double)f <= 1.88) {
            f = 1.75f;
        } else if ((double)f > 1.88 && (double)f <= 2.13) {
            f = 2.0f;
        } else if ((double)f > 2.13 && (double)f <= 2.37) {
            f = 2.25f;
        } else if ((double)f > 2.37 && (double)f <= 2.63) {
            f = 2.5f;
        } else if ((double)f > 2.63 && (double)f <= 2.88) {
            f = 2.75f;
        } else if ((double)f > 2.88 && (double)f <= 3.13) {
            f = 3.0f;
        } else if ((double)f > 3.13 && (double)f <= 3.37) {
            f = 3.25f;
        } else if ((double)f > 3.13 && (double)f <= 3.63) {
            f = 3.5f;
        } else if ((double)f > 3.63 && (double)f <= 3.88) {
            f = 3.75f;
        } else if ((double)f > 3.88) {
            f = 4.0f;
        }
        return f;
    }

    public final double getMonitorDPI() {
        if (this.dpi == 0.0) {
            double d = this.getHeight() * this.getHeight();
            double d2 = this.getWidth() * this.getWidth();
            double d3 = Math.sqrt(d + d2);
            LOGGER.debug("monitorHeightSquared: " + d);
            LOGGER.debug("monitorWidthSquared: " + d2);
            LOGGER.debug("diagonalMonitorSizeInPixel: " + d3);
            double d4 = this.getDiagonalMonitorSizeInch();
            this.dpi = d3 / d4;
        }
        return this.dpi;
    }

    public final double getDiagonalMonitorSizeInch() {
        if (this.diagonalSizeInInch == 0.0) {
            double d = this.getHorizontalImageSizeMM() * this.getHorizontalImageSizeMM();
            double d2 = this.getVerticalImageSizeMM() * this.getVerticalImageSizeMM();
            double d3 = Math.sqrt(d2 + d);
            this.diagonalSizeInInch = Math.ceil(d3 / (double)25.4f);
            LOGGER.debug("Calculated imageHeightSquared: " + d2);
            LOGGER.debug("Calculated imageWidthSquared: " + d);
            LOGGER.debug("Calculated diagonalImageSizeInMM: " + d3);
        }
        LOGGER.debug("Calculated diagonalSizeInInch: " + this.diagonalSizeInInch);
        return this.diagonalSizeInInch;
    }

    public GraphicsDevice getGraphicsDevice() {
        return this.gd;
    }

    public String getGraphicsBoard() {
        return this.graphicsBoard;
    }

    public String getVESAID() {
        if (!this.edids.isEmpty()) {
            return ((ac)this.edids.get(0)).aE();
        }
        return null;
    }

    public String getPNPID() {
        if (!this.edids.isEmpty()) {
            return ((ac)this.edids.get(0)).aF();
        }
        return null;
    }

    public double getGamma() {
        if (!this.edids.isEmpty()) {
            return ((ac)this.edids.get(0)).an();
        }
        return -1.0;
    }

    public int getHorizontalImageSizeMM() {
        if (!this.edids.isEmpty()) {
            if (this.isLandscapeFormat()) {
                LOGGER.debug("HorizontalImageSize (Horizontal Monitor): " + ((ac)this.edids.get(0)).aC());
                return ((ac)this.edids.get(0)).aC();
            }
            LOGGER.debug("HorizontalImageSize (Vertical Monitor): " + ((ac)this.edids.get(0)).aD());
            return ((ac)this.edids.get(0)).aD();
        }
        return 0;
    }

    public int getVerticalImageSizeMM() {
        if (!this.edids.isEmpty()) {
            if (this.isLandscapeFormat()) {
                LOGGER.debug("VerticalImageSize (Horizontal Monitor): " + ((ac)this.edids.get(0)).aD());
                return ((ac)this.edids.get(0)).aD();
            }
            LOGGER.debug("VerticalImageSize (Vertical Monitor): " + ((ac)this.edids.get(0)).aC());
            return ((ac)this.edids.get(0)).aC();
        }
        return 0;
    }

    public double getHorizontalPixelSizeMM() {
        return (double)this.getHorizontalImageSizeMM() / (double)this.getWidth();
    }

    public double getVerticalPixelSizeMM() {
        return (double)this.getVerticalImageSizeMM() / (double)this.getHeight();
    }

    public String getSerialNumber() {
        if (!this.edids.isEmpty()) {
            return ((ac)this.edids.get(0)).aw();
        }
        return null;
    }

    public String getName() {
        if (!this.edids.isEmpty()) {
            return ((ac)this.edids.get(0)).av();
        }
        return null;
    }

    public String getBoundsAsHexValue() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(Integer.toHexString(this.getX()).toUpperCase());
        stringBuffer.append(":");
        stringBuffer.append(Integer.toHexString(this.getY()).toUpperCase());
        stringBuffer.append(":");
        stringBuffer.append(Integer.toHexString(this.getWidth()).toUpperCase());
        stringBuffer.append(":");
        stringBuffer.append(Integer.toHexString(this.getHeight()).toUpperCase());
        return stringBuffer.toString();
    }

    public String getBoundsAsString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(Integer.toString(this.getX()));
        stringBuffer.append(":");
        stringBuffer.append(Integer.toString(this.getY()));
        stringBuffer.append(":");
        stringBuffer.append(Integer.toString(this.getWidth()));
        stringBuffer.append(":");
        stringBuffer.append(Integer.toString(this.getHeight()));
        return stringBuffer.toString();
    }

    public boolean isColor() {
        return !this.isStaticGrayscale() && !this.isPseudoGrayscale();
    }

    public boolean isSpannedScreen() {
        return this.spanned;
    }

    public boolean isStaticGrayscale() {
        return this.isStaticGrayscale;
    }

    public boolean isPseudoGrayscale() {
        return this.isPseudoGrayscale;
    }

    public int getColorDepth() {
        return this.colorDepth;
    }

    public Rectangle getScreenRect() {
        return new Rectangle(this.scaledScreenRect);
    }

    public Point getMatrixPosition() {
        return this.matrixPosition;
    }

    public int getWidth() {
        return this.scaledScreenRect.width;
    }

    public int getHeight() {
        return this.scaledScreenRect.height;
    }

    public int getDividedWidth() {
        if (this.spannedScreenRects != null) {
            return this.spannedScreenRects[0].width;
        }
        return this.scaledScreenRect.width;
    }

    public int getDividedHeight() {
        if (this.spannedScreenRects != null) {
            return this.spannedScreenRects[0].height;
        }
        return this.scaledScreenRect.height;
    }

    public int getX() {
        return this.scaledScreenRect.x;
    }

    public int getY() {
        return this.scaledScreenRect.y;
    }

    public int getMonitorHash() {
        return (this.getMonitorID() + "__" + this.getX() + "__" + this.getY()).hashCode();
    }

    public boolean hasSameScreenRectAs(Monitor monitor) {
        if (monitor != null) {
            return this.scaledScreenRect.equals(monitor.getScreenRect());
        }
        return false;
    }

    public boolean contains(Point point) {
        return this.scaledScreenRect.contains(point);
    }

    public boolean contains(int n, int n2) {
        return this.scaledScreenRect.contains(n, n2);
    }

    public boolean isLandscapeFormat() {
        return this.scaledScreenRect.width > this.scaledScreenRect.height;
    }

    public boolean isPortraitFormat() {
        return this.scaledScreenRect.width < this.scaledScreenRect.height;
    }

    public boolean isAbove(Monitor monitor) {
        return this.scaledScreenRect.y + this.scaledScreenRect.height == monitor.getY() && this.contains(monitor.getX(), this.scaledScreenRect.y);
    }

    public boolean isBelow(Monitor monitor) {
        return this.scaledScreenRect.y - this.scaledScreenRect.height == monitor.getY() && this.contains(monitor.getX(), this.scaledScreenRect.y);
    }

    public boolean isRightOf(Monitor monitor) {
        return this.scaledScreenRect.x - this.scaledScreenRect.width == monitor.getX() && this.contains(this.scaledScreenRect.x, monitor.getY());
    }

    public boolean isLeftOf(Monitor monitor) {
        return this.scaledScreenRect.x + this.scaledScreenRect.width == monitor.getX() && this.contains(this.scaledScreenRect.x, monitor.getY());
    }

    public boolean coversGivenPercentOrMore(Rectangle rectangle, double d) {
        return this.getPercentageOfIntersectionWithRectangle(rectangle) >= d;
    }

    public double getPercentageOfIntersectionWithRectangle(Rectangle rectangle) {
        if (rectangle == null) {
            return -1.0;
        }
        if (rectangle.width == 0 || rectangle.height == 0) {
            return -1.0;
        }
        Rectangle rectangle2 = this.getUnscaledScreenRect();
        Rectangle rectangle3 = rectangle2.intersection(rectangle);
        if (rectangle3.width < 0 || rectangle3.height < 0) {
            rectangle3.width = 0;
            rectangle3.height = 0;
        }
        double d = rectangle3.width * rectangle3.height;
        double d2 = rectangle.width * rectangle.height;
        return d / d2 * 100.0;
    }

    public boolean isSameSizeAs(Monitor monitor) {
        return this.scaledScreenRect.width == monitor.getWidth() && this.scaledScreenRect.height == monitor.getHeight();
    }

    public boolean hasEDID() {
        return !this.edids.isEmpty();
    }

    public boolean is1dot3MegaPixelOrHigher() {
        return this.numberOfPixel >= 0x140000 || FORCE_2MP || FORCE_3MP || FORCE_5MP;
    }

    public boolean is2MegaPixelOrHigher() {
        return this.numberOfPixel >= 1920000 || FORCE_2MP || FORCE_3MP || FORCE_5MP;
    }

    public boolean is3MegaPixelOrHigher() {
        return this.numberOfPixel >= 0x300000 || FORCE_3MP || FORCE_5MP;
    }

    public boolean is4MegaPixelOrHigher() {
        return this.numberOfPixel >= 0x3CC000 || FORCE_5MP;
    }

    public boolean is5MegaPixelOrHigher() {
        return this.numberOfPixel >= 0x500000 || FORCE_5MP;
    }

    public boolean is8MegaPixelOrHigher() {
        return this.numberOfPixel >= 0x7D0000;
    }

    public boolean is2MegaPixel() {
        return this.numberOfPixel >= 1920000 && this.numberOfPixel < 0x300000;
    }

    public boolean is3MegaPixel() {
        return this.numberOfPixel >= 0x300000 && this.numberOfPixel < 0x3CC000;
    }

    public boolean is4MegaPixel() {
        return this.numberOfPixel >= 0x3CC000 && this.numberOfPixel < 0x500000;
    }

    public boolean is5MegaPixel() {
        return this.numberOfPixel >= 0x500000 && this.numberOfPixel < 0x7D0000;
    }

    public boolean is8MegaPixel() {
        return this.numberOfPixel >= 0x7D0000 && this.numberOfPixel < Integer.MAX_VALUE;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(2048);
        stringBuffer.append("Monitor [").append(this.matrixPosition.x).append(",");
        stringBuffer.append(this.matrixPosition.y).append("], position ");
        stringBuffer.append(this.scaledScreenRect.x).append(", ").append(this.scaledScreenRect.y).append(" ");
        stringBuffer.append("resolution ").append(this.scaledScreenRect.width).append("x");
        stringBuffer.append(this.scaledScreenRect.height).append(" (=").append(this.numberOfPixel);
        stringBuffer.append(" pixels), ").append(this.colorDepth).append(" bpp, ");
        stringBuffer.append("static grayscale palette=").append(this.isStaticGrayscale);
        stringBuffer.append(", pseudo grayscale palette=").append(this.isPseudoGrayscale);
        stringBuffer.append(", graphicsBoard=").append(this.graphicsBoard).append(", ");
        stringBuffer.append("containsEDID=").append(!this.edids.isEmpty()).append("]");
        return stringBuffer.toString();
    }

    public String getMonitorID() {
        String string = this.getSerialNumbersOnly();
        if (string == null) {
            string = this.getBoundsAsString();
        }
        return string;
    }

    public String getSerialNumbersOnly() {
        if (this.hasEDID()) {
            List list = this.getEDIDs();
            Collections.sort(list, comp);
            if (!list.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (ac ac2 : list) {
                    String string = ac2.aw();
                    if (string == null || string.length() <= 1) continue;
                    Monitor.addValue(stringBuffer, string);
                }
                if (stringBuffer.length() > 0) {
                    return stringBuffer.toString();
                }
            }
        }
        return null;
    }

    private static final StringBuffer addValue(StringBuffer stringBuffer, String string) {
        if (stringBuffer.length() > 0) {
            stringBuffer.append("/");
        }
        if (string != null) {
            stringBuffer.append(string);
        }
        return stringBuffer;
    }

    public int compareTo(Object object) {
        Monitor monitor = (Monitor)object;
        if (this.getScreenRect().x < monitor.getScreenRect().x) {
            return -1;
        }
        if (this.getScreenRect().x > monitor.getScreenRect().x) {
            return 1;
        }
        return 0;
    }

    public Rectangle getUnscaledScreenRect() {
        if (this.unscaledScreenRect != null) {
            return this.unscaledScreenRect;
        }
        return this.scaledScreenRect;
    }

    public void setUnscaledScreenRect(Rectangle rectangle) {
        this.unscaledScreenRect = rectangle;
    }

    public float getScalingFactor() {
        if (this.scalingFactor <= 0.0f) {
            this.scalingFactor = this.calculateLocalScalingFactor();
        }
        return this.scalingFactor;
    }

    public void setScalingFactor(float f) {
        this.scalingFactor = f;
    }

    public boolean revertScalingFactor() {
        if (this.oldScalingFactor != this.scalingFactor) {
            this.setScalingFactor(this.oldScalingFactor);
            return true;
        }
        return false;
    }

    public float getOldScalingFactor() {
        return this.oldScalingFactor;
    }

    public void backupScalingFactor() {
        this.oldScalingFactor = this.scalingFactor;
    }

    public Insets getInsets() {
        if (!GraphicsEnvironment.isHeadless() && this.getGraphicsDevice() != null && !Boolean.getBoolean("java.awt.headless")) {
            GraphicsConfiguration graphicsConfiguration = this.getGraphicsDevice().getDefaultConfiguration();
            if (Toolkit.getDefaultToolkit() != null) {
                return Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            }
        }
        return new Insets(0, 0, 0, 0);
    }
}

