/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.tools.awt.event;

import com.visustt.tools.awt.event.ab;
import com.visustt.tools.awt.event.ad;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import java.awt.AWTEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.TreeSet;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class KeyboardHandler
implements ad {
    private static Logger logger = LoggerFactory.getInstance("jx.gui.keyboardhandler");
    public static final int NO_KEY = -9999;
    private static int currentKey = -9999;
    private static int currentModifier = 0;
    private static TreeSet multipleCurrentKeys = new TreeSet();
    private static EventListenerList listenerList = null;
    private static KeyboardHandler theInstance = new KeyboardHandler();

    private void dispatchEventKeyEvent(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        int n = keyEvent.getID();
        if (n == 401) {
            currentKey = keyStroke.getKeyCode();
            currentModifier = keyStroke.getModifiers();
            KeyboardHandler.addKey(keyStroke.getKeyCode());
            KeyboardHandler.fireKeyPressed(keyEvent);
        } else if (n == 402) {
            currentKey = -9999;
            currentModifier = 0;
            KeyboardHandler.removeKey(keyStroke.getKeyCode());
            KeyboardHandler.fireKeyReleased(keyEvent);
        } else if (n == 400) {
            KeyboardHandler.fireKeyTyped(keyEvent);
        }
    }

    public static int getCurrentKeyDown() {
        return currentKey;
    }

    public static int getCurrentKeyModifierDown() {
        return currentModifier;
    }

    private static void addKey(int n) {
        String string = "" + (char)n;
        multipleCurrentKeys.add(string);
    }

    private static void removeKey(int n) {
        String string = "" + (char)n;
        multipleCurrentKeys.remove(string);
    }

    public static String getMultipleCurrentKeys() {
        StringBuffer stringBuffer = new StringBuffer(10);
        for (String string : multipleCurrentKeys) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static int getFirstKeyDown() {
        String string = KeyboardHandler.getMultipleCurrentKeys();
        return string.length() == 0 ? -1 : (int)string.charAt(0);
    }

    public static void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.paramString().toUpperCase().startsWith("KEY_PRESSED")) {
            currentKey = keyEvent.getKeyCode();
            currentModifier = keyEvent.getModifiers();
            KeyboardHandler.addKey(keyEvent.getKeyCode());
            KeyboardHandler.fireKeyPressed(keyEvent);
        }
        if (keyEvent.paramString().toUpperCase().startsWith("KEY_TYPED")) {
            KeyboardHandler.fireKeyTyped(keyEvent);
        }
        if (keyEvent.paramString().toUpperCase().startsWith("KEY_RELEASED")) {
            KeyboardHandler.removeKey(keyEvent.getKeyCode());
            if (keyEvent.getKeyCode() == currentKey || keyEvent.getModifiers() == currentModifier) {
                currentKey = -9999;
                currentModifier = 0;
            }
            KeyboardHandler.fireKeyReleased(keyEvent);
        }
    }

    public static synchronized void addKeyListener(KeyListener keyListener) {
        if (listenerList == null) {
            listenerList = new EventListenerList();
        }
        listenerList.add(KeyListener.class, keyListener);
    }

    public static synchronized void removeKeyListener(KeyListener keyListener) {
        if (listenerList != null) {
            listenerList.remove(KeyListener.class, keyListener);
        }
    }

    private static void fireKeyPressed(KeyEvent keyEvent) {
        if (listenerList == null) {
            return;
        }
        Object[] objectArray = listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != KeyListener.class) continue;
            ((KeyListener)objectArray[i + 1]).keyPressed(keyEvent);
        }
    }

    private static void fireKeyReleased(KeyEvent keyEvent) {
        if (listenerList == null) {
            return;
        }
        Object[] objectArray = listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != KeyListener.class) continue;
            ((KeyListener)objectArray[i + 1]).keyReleased(keyEvent);
        }
    }

    private static void fireKeyTyped(KeyEvent keyEvent) {
        if (listenerList == null) {
            return;
        }
        Object[] objectArray = listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != KeyListener.class) continue;
            ((KeyListener)objectArray[i + 1]).keyTyped(keyEvent);
        }
    }

    @Override
    public void processEvent(AWTEvent aWTEvent) {
        try {
            if (aWTEvent instanceof KeyEvent) {
                this.dispatchEventKeyEvent((KeyEvent)aWTEvent);
            }
        }
        catch (Throwable throwable) {
            try {
                if (throwable instanceof ThreadDeath) {
                    throw (ThreadDeath)throwable;
                }
            }
            catch (Throwable throwable2) {
                throw KeyboardHandler.a(throwable2);
            }
            logger.error((Object)("failed to process KeyEvent '" + aWTEvent + "':" + throwable), throwable);
        }
    }

    static {
        ab.aa(theInstance);
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

