/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.log.appender;

import java.awt.Toolkit;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="BeepAppender", category="Core", elementType="appender")
public class BeepAppender
extends AbstractAppender {
    private long lastBeepTimestamp;
    private final int minimumGapBetweenBeeps;
    private final Level minimumBeepLevel;

    protected BeepAppender(String string, String string2, String string3) {
        super(string, null, null, true, null);
        this.minimumGapBetweenBeeps = this.parseMinimumGap(string2);
        this.minimumBeepLevel = this.parseLevel(string3);
        this.lastBeepTimestamp = 0L;
    }

    Level parseLevel(String string) {
        String string2;
        try {
            string2 = string != null ? string.toUpperCase() : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw BeepAppender.a(numberFormatException);
        }
        String string3 = string2;
        try {
            if ("DEBUG".equals(string3)) {
                return Level.DEBUG;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw BeepAppender.a(numberFormatException);
        }
        try {
            if ("INFO".equals(string3)) {
                return Level.INFO;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw BeepAppender.a(numberFormatException);
        }
        try {
            if ("WARN".equals(string3)) {
                return Level.WARN;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw BeepAppender.a(numberFormatException);
        }
        try {
            if ("ERROR".equals(string3)) {
                return Level.ERROR;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw BeepAppender.a(numberFormatException);
        }
        try {
            if ("FATAL".equals(string3)) {
                return Level.FATAL;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw BeepAppender.a(numberFormatException);
        }
        return Level.WARN;
    }

    private int parseMinimumGap(String string) {
        block4: {
            try {
                if (string == null || string.length() <= 0) break block4;
            }
            catch (NumberFormatException numberFormatException) {
                throw BeepAppender.a(numberFormatException);
            }
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                LogManager.getLogger((String)"BeepAppender").error("Failed to init log appender!", (Throwable)numberFormatException);
            }
        }
        return 10000;
    }

    public void append(LogEvent logEvent) {
        block7: {
            Level level = logEvent.getLevel();
            try {
                try {
                    if (this.minimumBeepLevel.equals((Object)level) || !this.minimumBeepLevel.isMoreSpecificThan(level)) break block7;
                }
                catch (NumberFormatException numberFormatException) {
                    throw BeepAppender.a(numberFormatException);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                throw BeepAppender.a(numberFormatException);
            }
        }
        long l = System.currentTimeMillis();
        try {
            if (l - this.lastBeepTimestamp > (long)this.minimumGapBetweenBeeps) {
                this.lastBeepTimestamp = l;
                this.beep();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw BeepAppender.a(numberFormatException);
        }
    }

    protected void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public int getMinimumGapBetweenBeeps() {
        return this.minimumGapBetweenBeeps;
    }

    public Level getMinimumBeepLevel() {
        return this.minimumBeepLevel;
    }

    @PluginFactory
    public static BeepAppender createAppender(@PluginAttribute(value="name") String string, @PluginAttribute(value="minimumGapBetweenBeeps") String string2, @PluginAttribute(value="minimumBeepLevel") String string3) {
        return new BeepAppender(string, string2, string3);
    }

    private static NumberFormatException a(NumberFormatException numberFormatException) {
        return numberFormatException;
    }
}

