/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.viewer.components.viewer3d.utility;

import com.visustt.jiveX.tools.swing.ac.aa;
import com.visustt.jiveX.viewer.components.util.ac;
import java.awt.Point;
import javax.vecmath.Point2d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector2d;

public class Volume3dRotationUtils {
    public static final float ROTATION_SCALE = 2.0f;

    private Volume3dRotationUtils() {
    }

    public static void setZRotationCursor(Point2d point2d, ac ac2) {
        if (point2d.y < 0.0) {
            if (Math.abs(point2d.y) > Math.abs(point2d.x)) {
                ac2.aa(aa.ag());
            }
        } else if (point2d.y > Math.abs(point2d.x)) {
            ac2.aa(aa.ah());
        }
        if (point2d.x > 0.0) {
            if (point2d.x > Math.abs(point2d.y)) {
                ac2.aa(aa.aj());
            }
        } else if (Math.abs(point2d.x) > Math.abs(point2d.y)) {
            ac2.aa(aa.ai());
        }
    }

    public static double getZRotationRadius(double d, double d2, Point2d point2d) {
        double d3 = d - point2d.x;
        double d4 = d2 - point2d.y;
        double d5 = Math.min(d3, d4);
        return Double.compare(d5, 0.0) != 0 ? 0.6666666666666666 * d5 : 1.0;
    }

    public static boolean isMouseMovedForZRotation(Point point, Point point2, Point2d point2d) {
        Vector2d vector2d = new Vector2d((Tuple2d)point2d);
        Vector2d vector2d2 = new Vector2d((double)(point.x - point2.x), (double)(point.y - point2.y));
        double d = Math.toDegrees(vector2d.angle(vector2d2));
        if (d > 90.0) {
            d = 180.0 - d;
        }
        return d > 40.0;
    }

    public static boolean isMousePlacedForZRotation(double d, double d2, Point2d point2d, Point point) {
        double d3 = Volume3dRotationUtils.getZRotationRadius(d, d2, point2d);
        Point2d point2d2 = new Point2d(Math.abs((double)point.x - point2d.x), Math.abs((double)point.y - point2d.y));
        return point2d2.x > d3 || point2d2.y > d3;
    }

    public static double calculateRotationAngle(Point2d point2d, Point2d point2d2) {
        double d = point2d2.x * point2d.y - point2d2.y * point2d.x;
        double d2 = point2d2.x * point2d2.x + point2d2.y * point2d2.y;
        double d3 = point2d.x * point2d.x + point2d.y * point2d.y;
        double d4 = 0.0;
        double d5 = Math.sqrt(d2) * Math.sqrt(d3);
        if (Double.compare(d5, 0.0) != 0) {
            d4 = d / d5;
        }
        return Math.toDegrees(d4);
    }
}

