/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.viewer.components.viewer3d.utility;

import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class MPRBoundingBox {
    boolean boundsIsEmpty = false;
    boolean boundsIsInfinite = false;
    Point3d lower;
    Point3d upper;
    private Point3d tmpP3d = null;

    public MPRBoundingBox(Point3d point3d, Point3d point3d2) {
        this.lower = new Point3d(point3d);
        this.upper = new Point3d(point3d2);
        this.updateBoundsStates();
    }

    public MPRBoundingBox() {
        this.lower = new Point3d(-1.0, -1.0, -1.0);
        this.upper = new Point3d(1.0, 1.0, 1.0);
        this.updateBoundsStates();
    }

    public void getLower(Point3d point3d) {
        point3d.x = this.lower.x;
        point3d.y = this.lower.y;
        point3d.z = this.lower.z;
    }

    public void setLower(double d, double d2, double d3) {
        this.lower.x = d;
        this.lower.y = d2;
        this.lower.z = d3;
        this.updateBoundsStates();
    }

    public void setLower(Point3d point3d) {
        this.lower.x = point3d.x;
        this.lower.y = point3d.y;
        this.lower.z = point3d.z;
        this.updateBoundsStates();
    }

    public void getUpper(Point3d point3d) {
        point3d.x = this.upper.x;
        point3d.y = this.upper.y;
        point3d.z = this.upper.z;
    }

    public void setUpper(double d, double d2, double d3) {
        this.upper.x = d;
        this.upper.y = d2;
        this.upper.z = d3;
        this.updateBoundsStates();
    }

    public void setUpper(Point3d point3d) {
        this.upper.x = point3d.x;
        this.upper.y = point3d.y;
        this.upper.z = point3d.z;
        this.updateBoundsStates();
    }

    public Object clone() {
        return new MPRBoundingBox(this.lower, this.upper);
    }

    /*
     * Loose catch block
     */
    public boolean equals(Object object) {
        try {
            boolean bl;
            block8: {
                block7: {
                    MPRBoundingBox mPRBoundingBox = (MPRBoundingBox)object;
                    if (!this.lower.equals((Tuple3d)mPRBoundingBox.lower)) break block7;
                    try {
                        block9: {
                            if (!this.upper.equals((Tuple3d)mPRBoundingBox.upper)) break block7;
                            break block9;
                            catch (NullPointerException nullPointerException) {
                                throw MPRBoundingBox.a(nullPointerException);
                            }
                        }
                        bl = true;
                        break block8;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw MPRBoundingBox.a(nullPointerException);
                    }
                }
                bl = false;
            }
            return bl;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.hashCode();
    }

    public void transform(Matrix3d matrix3d) {
        try {
            if (this.boundsIsInfinite) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        try {
            if (this.tmpP3d == null) {
                this.tmpP3d = new Point3d();
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        double d = this.upper.x;
        double d2 = this.upper.y;
        double d3 = this.upper.z;
        double d4 = this.lower.x;
        double d5 = this.lower.y;
        double d6 = this.lower.z;
        this.tmpP3d.set(d, d2, d3);
        matrix3d.transform((Tuple3d)this.tmpP3d);
        this.upper.x = this.tmpP3d.x;
        this.upper.y = this.tmpP3d.y;
        this.upper.z = this.tmpP3d.z;
        this.tmpP3d.set(d4, d5, d6);
        matrix3d.transform((Tuple3d)this.tmpP3d);
        this.lower.x = this.tmpP3d.x;
        this.lower.y = this.tmpP3d.y;
        this.lower.z = this.tmpP3d.z;
    }

    public Point3d intersect(Point3d point3d, Vector3d vector3d) {
        Point3d point3d2 = new Point3d(Double.NaN, Double.NaN, Double.NaN);
        double d = 0.0;
        try {
            if (this.boundsIsEmpty) {
                return point3d2;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        try {
            if (this.boundsIsInfinite) {
                return point3d2;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        if (vector3d.x > 0.0) {
            d = Math.max(d, (this.lower.x - point3d.x) / vector3d.x);
        }
        if (vector3d.x < 0.0) {
            d = Math.max(d, (this.upper.x - point3d.x) / vector3d.x);
        }
        if (vector3d.y > 0.0) {
            d = Math.max(d, (this.lower.y - point3d.y) / vector3d.y);
        }
        if (vector3d.y < 0.0) {
            d = Math.max(d, (this.upper.y - point3d.y) / vector3d.y);
        }
        if (vector3d.z > 0.0) {
            d = Math.max(d, (this.lower.z - point3d.z) / vector3d.z);
        }
        if (vector3d.z < 0.0) {
            d = Math.max(d, (this.upper.z - point3d.z) / vector3d.z);
        }
        try {
            point3d2.x = point3d.x + d * vector3d.x;
            point3d2.y = point3d.y + d * vector3d.y;
            point3d2.z = point3d.z + d * vector3d.z;
            if (point3d2.x < this.lower.x) {
                return new Point3d(Double.NaN, Double.NaN, Double.NaN);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        try {
            if (point3d2.x > this.upper.x) {
                return new Point3d(Double.NaN, Double.NaN, Double.NaN);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        try {
            if (point3d2.y < this.lower.y) {
                return new Point3d(Double.NaN, Double.NaN, Double.NaN);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        try {
            if (point3d2.y > this.upper.y) {
                return new Point3d(Double.NaN, Double.NaN, Double.NaN);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        try {
            if (point3d2.z < this.lower.z) {
                return new Point3d(Double.NaN, Double.NaN, Double.NaN);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        try {
            if (point3d2.z > this.upper.z) {
                return new Point3d(Double.NaN, Double.NaN, Double.NaN);
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        return point3d2;
    }

    public boolean isEmpty() {
        return this.boundsIsEmpty;
    }

    public String toString() {
        return new String("Bounding box: Lower=" + this.lower.x + " " + this.lower.y + " " + this.lower.z + " Upper=" + this.upper.x + " " + this.upper.y + " " + this.upper.z);
    }

    private void updateBoundsStates() {
        block24: {
            block23: {
                block21: {
                    try {
                        try {
                            try {
                                try {
                                    try {
                                        try {
                                            if (this.lower.x != Double.NEGATIVE_INFINITY || this.lower.y != Double.NEGATIVE_INFINITY) break block21;
                                        }
                                        catch (NullPointerException nullPointerException) {
                                            throw MPRBoundingBox.a(nullPointerException);
                                        }
                                        if (this.lower.z != Double.NEGATIVE_INFINITY) break block21;
                                    }
                                    catch (NullPointerException nullPointerException) {
                                        throw MPRBoundingBox.a(nullPointerException);
                                    }
                                    if (this.upper.x != Double.POSITIVE_INFINITY) break block21;
                                }
                                catch (NullPointerException nullPointerException) {
                                    throw MPRBoundingBox.a(nullPointerException);
                                }
                                if (this.upper.y != Double.POSITIVE_INFINITY) break block21;
                            }
                            catch (NullPointerException nullPointerException) {
                                throw MPRBoundingBox.a(nullPointerException);
                            }
                            if (this.upper.z != Double.POSITIVE_INFINITY) break block21;
                        }
                        catch (NullPointerException nullPointerException) {
                            throw MPRBoundingBox.a(nullPointerException);
                        }
                        this.boundsIsEmpty = false;
                        this.boundsIsInfinite = true;
                        return;
                    }
                    catch (NullPointerException nullPointerException) {
                        throw MPRBoundingBox.a(nullPointerException);
                    }
                }
                try {
                    if (this.checkBoundsIsNaN()) {
                        this.boundsIsEmpty = true;
                        this.boundsIsInfinite = false;
                        return;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    throw MPRBoundingBox.a(nullPointerException);
                }
                try {
                    block22: {
                        try {
                            try {
                                this.boundsIsInfinite = false;
                                if (this.lower.x > this.upper.x || this.lower.y > this.upper.y) break block22;
                            }
                            catch (NullPointerException nullPointerException) {
                                throw MPRBoundingBox.a(nullPointerException);
                            }
                            if (!(this.lower.z > this.upper.z)) break block23;
                        }
                        catch (NullPointerException nullPointerException) {
                            throw MPRBoundingBox.a(nullPointerException);
                        }
                    }
                    this.boundsIsEmpty = true;
                    break block24;
                }
                catch (NullPointerException nullPointerException) {
                    throw MPRBoundingBox.a(nullPointerException);
                }
            }
            this.boundsIsEmpty = false;
        }
    }

    private boolean checkBoundsIsNaN() {
        try {
            if (Double.isNaN(this.lower.x + this.lower.y + this.lower.z + this.upper.x + this.upper.y + this.upper.z)) {
                return true;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        return false;
    }

    public void translate(Vector3d vector3d) {
        try {
            if (this.boundsIsEmpty) {
                this.setLower(1.0, 1.0, 1.0);
                this.setUpper(-1.0, -1.0, -1.0);
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        try {
            if (this.boundsIsInfinite) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            throw MPRBoundingBox.a(nullPointerException);
        }
        this.lower.x += vector3d.x;
        this.lower.y += vector3d.y;
        this.lower.z += vector3d.z;
        this.upper.x += vector3d.x;
        this.upper.y += vector3d.y;
        this.upper.z += vector3d.z;
    }

    private static NullPointerException a(NullPointerException nullPointerException) {
        return nullPointerException;
    }
}

