/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.viewer.components.viewer3d.utility;

import com.visustt.dicomTk.DicomObject;
import com.visustt.dicomTk.ImageModule;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.imageplane.ImagePlane;
import com.visustt.dicomTk.imageplane.aa;
import com.visustt.dicomTk.imageplane.ac;
import com.visustt.dicomTk.imaging.ac.an;
import com.visustt.dicomTk.model.ab.ae;
import com.visustt.dicomTk.model.ao;
import com.visustt.dicomTk.model.aq;
import com.visustt.jiveX.viewer.components.util.ag;
import com.visustt.jiveX.viewer.components.viewer3d.am;
import com.visustt.jiveX.viewer.components.viewer3d.ap;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.util.resource.ad;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class ImageCollectionValidity
implements ae {
    private static final String NEWLINE = "<br>";
    private static final String EXCLAMATIONMARK_NEWLINE = "! <br>";
    private static final String CANT_CREATE_IMAGE_PLANES = "Can't create ImagePlanes ";
    private static final Logger validityLogger = LoggerFactory.getInstance("jx.vb.viewer3d.setup.validitycheck");
    private static ad lang;

    private ImageCollectionValidity() {
    }

    public static HashSet<Integer> getValidSeriesSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(0x1000001);
        hashSet.add(0x1000010);
        hashSet.add(0x1000000);
        return hashSet;
    }

    public static HashSet<Integer> isValidSeries(ao ao2) {
        block19: {
            com.visustt.dicomTk.model.ap ap2;
            com.visustt.dicomTk.model.ag ag2;
            block18: {
                try {
                    if (!ao2.al()) {
                        return new HashSet<Integer>();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ImageCollectionValidity.a(illegalArgumentException);
                }
                ag2 = ao2.ae();
                ap2 = ag2.aC;
                try {
                    try {
                        if (ap2.aL() || ap2.ae().aaI) break block18;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ImageCollectionValidity.a(illegalArgumentException);
                    }
                    return new HashSet<Integer>();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ImageCollectionValidity.a(illegalArgumentException);
                }
            }
            try {
                if (!ap2.an().isEmpty()) {
                    return ap2.an();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ImageCollectionValidity.a(illegalArgumentException);
            }
            try {
                if (!ag2.af() && !ag2.aH) break block19;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ImageCollectionValidity.a(illegalArgumentException);
            }
            HashSet<Integer> hashSet = ImageCollectionValidity.getValidSeriesSet();
            aq aq2 = ap2.am();
            aq2.aa(hashSet);
            aq2.aa(ImageCollectionValidity.createHtmlReport(hashSet));
            return hashSet;
        }
        ao ao3 = ag.aa(ao2);
        try {
            if (!ao3.al()) {
                return new HashSet<Integer>();
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        com.visustt.dicomTk.model.ag ag3 = ao3.ae();
        Vector<DicomObject> vector = ImageCollectionValidity.getDcmObjectsFromImageCollection(ao3);
        aq aq3 = ImageCollectionValidity.isValidSeries(vector);
        try {
            if (ImageCollectionValidity.isMultiframeSeries(ao2)) {
                aq3.aa().add(16);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        vector.clear();
        ag3.aC.aa(aq3);
        aq3.aa(ImageCollectionValidity.createHtmlReport(aq3.aa()));
        return aq3.aa();
    }

    /*
     * Unable to fully structure code
     */
    public static aq isValidSeries(List<DicomObject> var0) {
        block36: {
            block41: {
                block42: {
                    block40: {
                        block39: {
                            block38: {
                                block37: {
                                    block35: {
                                        var1_1 = new aq();
                                        var2_2 = var1_1.aa();
                                        try {
                                            if (var0.size() < 5) {
                                                var2_2.add(0);
                                                var2_2.add(4);
                                                return var1_1;
                                            }
                                        }
                                        catch (InvalidDataException v0) {
                                            throw ImageCollectionValidity.a(v0);
                                        }
                                        var3_3 = var0.get(0);
                                        if (var3_3.getImageModule().getModality() == null) ** GOTO lbl21
                                        try {
                                            block44: {
                                                if (ImageCollectionValidity.isValidModality(var3_3)) break block35;
                                                break block44;
                                                catch (InvalidDataException v1) {
                                                    throw ImageCollectionValidity.a(v1);
                                                }
                                            }
                                            var2_2.add(0);
                                            var2_2.add(9);
                                        }
                                        catch (InvalidDataException v2) {
                                            throw ImageCollectionValidity.a(v2);
                                        }
                                    }
                                    try {
                                        var3_3.getImagePlaneModule().al();
                                    }
                                    catch (InvalidDataException var4_4) {
                                        var2_2.add(0);
                                        var2_2.add(1);
                                    }
                                    try {
                                        var3_3.getImagePlaneModule().ao();
                                        var3_3.getImagePlaneModule().ap();
                                    }
                                    catch (InvalidDataException var4_5) {
                                        var2_2.add(0);
                                        var2_2.add(2);
                                    }
                                    try {
                                        if (!StringTool.isDefined(var3_3.getImagePlaneModule().az())) {
                                            var2_2.add(0);
                                            var2_2.add(3);
                                        }
                                    }
                                    catch (InvalidDataException v3) {
                                        throw ImageCollectionValidity.a(v3);
                                    }
                                    if (var2_2.contains(0)) break block36;
                                    try {
                                        block45: {
                                            if (!ImageCollectionValidity.isSamePosition(var0)) break block37;
                                            break block45;
                                            catch (InvalidDataException v4) {
                                                throw ImageCollectionValidity.a(v4);
                                            }
                                        }
                                        var2_2.add(0);
                                        var2_2.add(5);
                                    }
                                    catch (InvalidDataException v5) {
                                        throw ImageCollectionValidity.a(v5);
                                    }
                                }
                                try {
                                    if (!ImageCollectionValidity.isSeriesParallel(var0)) break block38;
                                    var2_2.add(8);
                                    break block39;
                                }
                                catch (InvalidDataException v6) {
                                    throw ImageCollectionValidity.a(v6);
                                }
                            }
                            var2_2.add(0);
                        }
                        try {
                            if (!ImageCollectionValidity.isSeriesEquidistant(var0, var1_1, 0.05)) break block40;
                            var2_2.add(7);
                            var2_2.add(0x1000012);
                            break block41;
                        }
                        catch (InvalidDataException v7) {
                            throw ImageCollectionValidity.a(v7);
                        }
                    }
                    try {
                        if (!ImageCollectionValidity.isSeriesEquidistant(var0, var1_1, ae.ar)) break block42;
                        var2_2.add(7);
                        break block41;
                    }
                    catch (InvalidDataException v8) {
                        throw ImageCollectionValidity.a(v8);
                    }
                }
                var2_2.add(0);
            }
            try {
                try {
                    if (ImageCollectionValidity.isSeriesSheared(var0)) {
                        var2_2.add(6);
                    }
                }
                catch (IllegalArgumentException v9) {
                    throw ImageCollectionValidity.a(v9);
                }
            }
            catch (InvalidDataException var4_7) {
                ImageCollectionValidity.validityLogger.debug((Object)("Can't create ImagePlanes " + var4_7), var4_7);
                var2_2.add(0);
            }
            try {
                if (!var2_2.contains(0)) {
                    var2_2.add(0x1000001);
                    var2_2.add(0x1000010);
                    var2_2.add(0x1000000);
                }
            }
            catch (InvalidDataException v10) {
                throw ImageCollectionValidity.a(v10);
            }
        }
        try {
            if (ImageCollectionValidity.validityLogger.debugIsEnabled()) {
                ImageCollectionValidity.validityLogger.debug(ImageCollectionValidity.createReportMsg(var2_2, var3_3));
            }
        }
        catch (InvalidDataException v11) {
            throw ImageCollectionValidity.a(v11);
        }
        return var1_1;
    }

    private static boolean isValidModality(DicomObject dicomObject) {
        boolean bl;
        block10: {
            block9: {
                try {
                    block8: {
                        try {
                            try {
                                try {
                                    if (dicomObject.getSeriesModule().checkForModality("CT") || dicomObject.getSeriesModule().checkForModality("MR")) break block8;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw ImageCollectionValidity.a(illegalArgumentException);
                                }
                                if (dicomObject.getSeriesModule().checkForModality("PT")) break block8;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw ImageCollectionValidity.a(illegalArgumentException);
                            }
                            if (!dicomObject.getSeriesModule().checkForModality("SC")) break block9;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ImageCollectionValidity.a(illegalArgumentException);
                        }
                    }
                    bl = true;
                    break block10;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ImageCollectionValidity.a(illegalArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    private static boolean isSamePosition(List<DicomObject> list) {
        try {
            if (list.size() < 2) {
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageCollectionValidity.a(invalidDataException);
        }
        try {
            ImagePlane imagePlane = ImageCollectionValidity.createImagePlane(list.get(0));
            for (int i = 1; i < list.size(); ++i) {
                ImagePlane imagePlane2 = ImageCollectionValidity.createImagePlane(list.get(i));
                if (!(Math.abs(imagePlane.getDistance(imagePlane2)) > 1.0E-4)) continue;
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            validityLogger.debug((Object)(CANT_CREATE_IMAGE_PLANES + invalidDataException), invalidDataException);
            return true;
        }
        return true;
    }

    private static boolean isSeriesParallel(List<DicomObject> list) {
        try {
            if (list.size() < 2) {
                return false;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ImageCollectionValidity.a(invalidDataException);
        }
        int n = 0;
        while (n + 1 < list.size()) {
            ImagePlane imagePlane;
            ImagePlane imagePlane2;
            try {
                imagePlane2 = ImageCollectionValidity.createImagePlane(list.get(n));
                imagePlane = ImageCollectionValidity.createImagePlane(list.get(n + 1));
            }
            catch (InvalidDataException invalidDataException) {
                validityLogger.debug((Object)(CANT_CREATE_IMAGE_PLANES + invalidDataException), invalidDataException);
                return false;
            }
            boolean bl = ImageCollectionValidity.isSeriesParallel(imagePlane2, imagePlane);
            try {
                if (!bl) {
                    return false;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw ImageCollectionValidity.a(invalidDataException);
            }
            ++n;
        }
        return true;
    }

    static boolean isSeriesParallel(ImagePlane imagePlane, ImagePlane imagePlane2) {
        boolean bl;
        try {
            if (imagePlane == null) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        try {
            bl = !(Math.abs(imagePlane.getNormalVectorAngle(imagePlane2)) > 0.01);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        return bl;
    }

    static boolean isMultiframeSeries(ao ao2) {
        block4: {
            try {
                try {
                    if (ao2 != null && ao2.al()) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ImageCollectionValidity.a(illegalArgumentException);
                }
                return false;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ImageCollectionValidity.a(illegalArgumentException);
            }
        }
        return ao2.ae().aae;
    }

    private static boolean isSeriesEquidistant(List<DicomObject> list, aq aq2, double d) {
        boolean bl;
        double d2 = ImageCollectionValidity.getDistantDeviationFactor(list, aq2);
        try {
            bl = d2 < d;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static double getDistantDeviationFactor(List<DicomObject> list, aq aq2) {
        ImagePlane[] imagePlaneArray = new ImagePlane[list.size()];
        int n = 0;
        while (true) {
            try {
                if (n >= list.size()) break;
                try {
                    imagePlaneArray[n] = ImageCollectionValidity.createImagePlane(list.get(n));
                }
                catch (InvalidDataException invalidDataException) {
                    validityLogger.debug((Object)(CANT_CREATE_IMAGE_PLANES + invalidDataException), invalidDataException);
                    return Double.MAX_VALUE;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ImageCollectionValidity.a(illegalArgumentException);
            }
            ++n;
        }
        return ImageCollectionValidity.getDistantDeviationFactor(imagePlaneArray, aq2);
    }

    static double getDistantDeviationFactor(ImagePlane[] imagePlaneArray, aq aq2) {
        int n = imagePlaneArray.length - 1;
        double[] dArray = new double[n];
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2;
            ImagePlane imagePlane = imagePlaneArray[i];
            ImagePlane imagePlane2 = imagePlaneArray[i + 1];
            dArray[i] = d2 = imagePlane.getDistance(imagePlane2);
            d += d2;
        }
        double d3 = d / (double)n;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = 0.0;
            int n2 = 1;
            for (int j = i; j < n; ++j) {
                d5 += dArray[j];
                int n3 = n2++;
                double d6 = d5 - d3 * (double)n3;
                if (!(Math.abs(d6) > d4)) continue;
                d4 = Math.abs(d6);
            }
        }
        aq2.ab(d4);
        aq2.aa(d3);
        return d4;
    }

    private static boolean isSeriesSheared(List<DicomObject> list) throws InvalidDataException {
        ImagePlane[] imagePlaneArray = new ImagePlane[]{ImageCollectionValidity.createImagePlane(list.get(0)), ImageCollectionValidity.createImagePlane(list.get(1))};
        return ImageCollectionValidity.isSeriesSheared(imagePlaneArray);
    }

    private static boolean isSeriesSheared(ImagePlane[] imagePlaneArray) {
        boolean bl;
        block5: {
            block4: {
                double[] dArray = ImageCollectionValidity.calculateShearedFactor(imagePlaneArray);
                try {
                    try {
                        if (!(Math.abs(dArray[0]) > 0.01) && !(Math.abs(dArray[1]) > 0.01)) break block4;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ImageCollectionValidity.a(illegalArgumentException);
                    }
                    bl = true;
                    break block5;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ImageCollectionValidity.a(illegalArgumentException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public static double[] calculateShearedFactor(ImagePlane[] imagePlaneArray) {
        try {
            if (imagePlaneArray.length != 2) {
                throw new IllegalArgumentException("calculateShearedFactor() is called, but must contain TWO imagePlanes as argument");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        ImagePlane imagePlane = imagePlaneArray[0];
        double[] dArray = imagePlane.getAnchor();
        double[] dArray2 = imagePlaneArray[1].getAnchor();
        am am2 = new am(imagePlane.getNormalVector());
        am2.ah();
        am am3 = new am(dArray);
        am3.ac(new am(dArray2));
        am am4 = new am(imagePlane.getColOrient());
        am am5 = new am(imagePlane.getRowOrient());
        float f = am2.ad(am3);
        am2.ac(f);
        am am6 = am3.ac(am2);
        float f2 = am6.ad(am5);
        float f3 = am6.ad(am4);
        return new double[]{f2, f3};
    }

    public static int[] calculateShearRange(ao ao2, ap ap2, int[] nArray) {
        int[] nArray2;
        block2: {
            nArray2 = nArray;
            com.visustt.dicomTk.model.ag ag2 = ao2.aa(0);
            com.visustt.dicomTk.model.ag ag3 = ao2.aa(1);
            ImagePlane[] imagePlaneArray = new ImagePlane[]{ag2.ax(), ag3.ax()};
            double[] dArray = ImageCollectionValidity.calculateShearedFactor(imagePlaneArray);
            float f = (float)dArray[0];
            float f2 = (float)dArray[1];
            try {
                if (!((double)Math.abs(f) > 1.0E-5) && !((double)Math.abs(f2) > 1.0E-5)) break block2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw ImageCollectionValidity.a(illegalArgumentException);
            }
            ap2.aa(new double[]{f, f2});
            int n = Math.round(f * (float)nArray[2]);
            int n2 = Math.round(f2 * (float)nArray[2]);
            n = Math.abs(n);
            n2 = Math.abs(n2);
            ap2.aa(new int[]{n, n2});
            nArray2[0] = nArray2[0] + n;
            nArray2[1] = nArray2[1] + n2;
        }
        return nArray2;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ao getShearCorrectedImageCollection(ao ao2) {
        ao ao3 = new ao();
        com.visustt.dicomTk.model.ag ag2 = ao2.ae();
        ImagePlane imagePlane = ag2.ax();
        Vector3d vector3d = new Vector3d(imagePlane.getAnchor());
        Vector3d vector3d2 = new Vector3d(imagePlane.getRowOrient());
        Vector3d vector3d3 = new Vector3d(imagePlane.getColOrient());
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 1; i < ao2.aa(); ++i) {
            Vector3d vector3d4;
            block17: {
                com.visustt.dicomTk.model.ag ag3 = ao2.aa(i);
                ImagePlane imagePlane2 = ag3.ax();
                vector3d4 = new Vector3d(imagePlane2.getAnchor());
                Vector3d vector3d5 = new Vector3d(imagePlane.getRowOrient());
                Vector3d vector3d6 = new Vector3d(imagePlane.getColOrient());
                if (!vector3d2.equals((Tuple3d)vector3d5)) throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: image orientation of all images must be the same!");
                try {
                    if (vector3d3.equals((Tuple3d)vector3d6)) break block17;
                    throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: image orientation of all images must be the same!");
                    catch (InvalidDataException invalidDataException) {
                        throw ImageCollectionValidity.a(invalidDataException);
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageCollectionValidity.a(invalidDataException);
                }
            }
            vector3d4.sub((Tuple3d)vector3d);
            double d3 = vector3d4.dot(vector3d2);
            double d4 = vector3d4.dot(vector3d3);
            if (Math.abs(d3) > Math.abs(d)) {
                d = d3;
            }
            if (!(Math.abs(d4) > Math.abs(d2))) continue;
            d2 = d4;
        }
        if (d < 0.0) {
            Vector3d vector3d7 = new Vector3d(vector3d2);
            vector3d7.scale(d);
            vector3d.add((Tuple3d)vector3d7);
        }
        if (d2 < 0.0) {
            Vector3d vector3d8 = new Vector3d(vector3d3);
            vector3d8.scale(d2);
            vector3d.add((Tuple3d)vector3d8);
        }
        double[] dArray = new double[3];
        vector3d.get(dArray);
        int n = (int)(Math.abs(d) / imagePlane.getPixelSpacingX()) + 1;
        int n2 = (int)(Math.abs(d2) / imagePlane.getPixelSpacingY()) + 1;
        int n3 = ag2.au().af().ae();
        int n4 = ag2.au().af().ad();
        int n5 = n3 + n;
        int n6 = n4 + n2;
        for (int i = 0; i < ao2.aa(); ++i) {
            Vector3d vector3d9;
            ImagePlane imagePlane3;
            com.visustt.dicomTk.model.ag ag4;
            block18: {
                ag4 = ao2.aa(i);
                imagePlane3 = ag4.ax();
                vector3d9 = new Vector3d(imagePlane3.getAnchor());
                int n7 = ag4.au().af().ae();
                int n8 = ag4.au().af().ad();
                if (n7 != n3) throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: images must all have same image dimensions!");
                try {
                    if (n8 == n4) break block18;
                    throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: images must all have same image dimensions!");
                    catch (InvalidDataException invalidDataException) {
                        throw ImageCollectionValidity.a(invalidDataException);
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ImageCollectionValidity.a(invalidDataException);
                }
            }
            com.visustt.dicomTk.model.ag ag5 = (com.visustt.dicomTk.model.ag)ag4.clone();
            ag5.ac(new com.visustt.dicomTk.model.aa.ac(ag4.au()));
            an an2 = new an(ag5.au().af());
            ag5.au().aa(an2);
            ag5.aa((com.visustt.dicomTk.model.aa.ac)null);
            double[] dArray2 = imagePlane3.getProjectionInWorldCoordinates(dArray);
            try {
                ag5.an.getImagePlaneModule().aa(dArray2);
                ag5.ax().setImagePosition(dArray2);
            }
            catch (InvalidDataException invalidDataException) {
                throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: invalid corrected image position!" + invalidDataException.getMessage());
            }
            Vector3d vector3d10 = new Vector3d(dArray2);
            vector3d10.sub((Tuple3d)vector3d9);
            try {
                ag5.an.getImageModule().setImageWidth(n5);
                ag5.an.getImageModule().setImageHeight(n6);
                ag5.ax().setImageWidth(n5);
                ag5.ax().setImageHeight(n6);
                an2.ab(n5);
                an2.aa(n6);
                com.visustt.dicomTk.imaging.ad.ad ad2 = ag5.au().ae();
                ad2.ab(n5);
                ad2.ac(n6);
                ad2.ad(new Point2D.Double(0.0, 0.0), new Point2D.Double(n5, n6));
                ad2.ad(false);
            }
            catch (InvalidDataException invalidDataException) {
                throw new IllegalArgumentException("MPRUtilities.correctGantryTilt: invalid corrected image size!" + invalidDataException.getMessage());
            }
            ao3.ab(ag5);
        }
        return ao3;
    }

    public static Vector3d calculateVolumeOrientationDepth(ao ao2) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        int n = ao2.aa() - 1;
        for (int i = 0; i < n; ++i) {
            Vector3d vector3d3 = new Vector3d(ao2.aa(i).ax().getCorrectedAnchor());
            vector3d.set(ao2.aa(i + 1).ax().getCorrectedAnchor());
            vector3d.sub((Tuple3d)vector3d3);
            vector3d2.add((Tuple3d)vector3d);
        }
        vector3d2.x /= (double)n;
        vector3d2.y /= (double)n;
        vector3d2.z /= (double)n;
        return vector3d2;
    }

    public static am[] calculateVolumeOrientations(ao ao2) {
        Vector3d[] vector3dArray = ac.aa(ao2);
        Vector3d vector3d = ImageCollectionValidity.calculateVolumeOrientationDepth(ao2);
        return new am[]{new am(vector3dArray[0]), new am(vector3dArray[1]), new am(vector3d)};
    }

    public static int[] calculateVolumeSize(ao ao2) {
        com.visustt.dicomTk.model.ag ag2 = ao2.ae();
        an an2 = ag2.au().af();
        return new int[]{an2.ae(), an2.ad(), ao2.aa()};
    }

    private static Vector<DicomObject> getDcmObjectsFromImageCollection(ao ao2) {
        Vector<DicomObject> vector = new Vector<DicomObject>();
        try {
            for (int i = 0; i < ao2.aa(); ++i) {
                vector.add(ao2.aa((int)i).an);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        return vector;
    }

    public static String createHtmlReport(HashSet<Integer> hashSet) {
        Object object = new String();
        try {
            if (hashSet.isEmpty()) {
                return object;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        try {
            if (lang == null) {
                lang = new ad("com.visustt.jiveX.viewer.components.viewer3d.utility.resources.ImageCollectionValidityResources");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw ImageCollectionValidity.a(illegalArgumentException);
        }
        object = "<hr>";
        if (hashSet.contains(9)) {
            object = (String)object + " - DICOM TAG (0008,0060) (MODALITY) " + lang.getResourceString("MSG_WRONG_MODALITY") + EXCLAMATIONMARK_NEWLINE;
        }
        if (hashSet.contains(1)) {
            object = (String)object + " - DICOM TAG (0020,0032) (IMAGE POSITION PATIENT) " + lang.getResourceString("MSG_TAG_NOT_PRESENT") + EXCLAMATIONMARK_NEWLINE;
        }
        if (hashSet.contains(2)) {
            object = (String)object + " - DICOM TAG (0020,0037) (IMAGE ORIENTATION PATIENT) " + lang.getResourceString("MSG_TAG_NOT_PRESENT") + EXCLAMATIONMARK_NEWLINE;
        }
        if (hashSet.contains(3)) {
            object = (String)object + " - DICOM TAG (0020,0052) (FRAME OF REFERENCE UID) " + lang.getResourceString("MSG_TAG_NOT_PRESENT") + EXCLAMATIONMARK_NEWLINE;
        }
        if (hashSet.contains(16)) {
            object = (String)object + " - " + lang.getResourceString("MSG_MULTIFRAME") + NEWLINE;
        }
        if (hashSet.contains(4)) {
            object = (String)object + " - " + lang.getResourceString("MSG_NOT_ENOUGH_IMAGES") + NEWLINE;
        } else {
            block17: {
                try {
                    if (hashSet.contains(7) && hashSet.contains(0x1000012)) break block17;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw ImageCollectionValidity.a(illegalArgumentException);
                }
                object = (String)object + " - " + lang.getResourceString("MSG_NOT_EQUDISTANT") + NEWLINE;
            }
            if (!hashSet.contains(8)) {
                object = (String)object + " - " + lang.getResourceString("MSG_NOT_PARALLEL") + NEWLINE;
            }
            if (hashSet.contains(5)) {
                object = (String)object + " - " + lang.getResourceString("MSG_SAME_POSITION") + NEWLINE;
            }
        }
        return object;
    }

    public static String createReportMsg(HashSet<Integer> hashSet, DicomObject dicomObject) {
        String string;
        block8: {
            block6: {
                block7: {
                    string = "\nSERIES: " + dicomObject.getSeriesModule().getSeriesDescription() + "\n";
                    string = string + "SERIESNUMBER: " + dicomObject.getSeriesModule().getSeriesInstanceUID() + "\n";
                    string = string + "SERIESDATE: " + dicomObject.getSeriesModule().getSeriesDate() + "\n";
                    string = hashSet.contains(9) ? string + "DICOM TAG (0008,0060)(MODALITY) IS WRONG: NEEDS TO BE CT, MR OR PET\n" : string + "DICOM TAG (0008,0060)(MODALITY): VALID\n";
                    string = hashSet.contains(1) ? string + "DICOM TAG (0020,0032)(IMAGE POSITION PATIENT) NOT PRESENT!\n" : string + "DICOM TAG (0020,0032)(IMAGE POSITION PATIENT): VALID\n";
                    string = hashSet.contains(2) ? string + "DICOM TAG (0020,0037)(IMAGE ORIENTATION PATIENT) NOT PRESENT!\n" : string + "DICOM TAG (0020,0037)(IMAGE ORIENTATION PATIENT): VALID\n";
                    string = hashSet.contains(3) ? string + "DICOM TAG (0020,0052)(FRAME OF REFERENCE UID) NOT PRESENT!\n" : string + "DICOM TAG (0020,0052)(FRAME OF REFERENCE UID): VALID\n";
                    if (hashSet.contains(4)) {
                        string = string + "NOT ENOUGH IMAGES: AT LEAST 5\n";
                    } else {
                        string = hashSet.contains(7) ? string + "EQUIDISTANT: YES\n" : string + "EQUIDISTANT: NO\n";
                        string = hashSet.contains(8) ? string + "PARALLEL: YES\n" : string + "PARALLEL: NO\n";
                        string = hashSet.contains(6) ? string + "SHEARED: YES\n" : string + "SHEARED: NO\n";
                    }
                    string = hashSet.contains(16) ? string + "MULTIFRAME: YES\n" : string + "MULTIFRAME: NO\n";
                    string = string + "\n";
                    string = string + "-----------------------------------\n";
                    string = string + "SUMMARY: \n";
                    try {
                        if (hashSet.contains(0)) break block6;
                        if (!hashSet.contains(0x1000010)) break block7;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ImageCollectionValidity.a(illegalArgumentException);
                    }
                    string = string + "VALID FOR: IMAGE REGISTRATION \n";
                }
                if (hashSet.contains(0x1000001)) {
                    string = string + "VALID FOR: VOLUME RENDERING \n";
                }
                if (hashSet.contains(0x1000000)) {
                    string = string + "VALID FOR: MPR \n";
                }
                break block8;
            }
            string = string + "NOT A VALID SERIES\n";
        }
        return string;
    }

    private static ImagePlane createImagePlane(DicomObject dicomObject) throws InvalidDataException {
        ImageModule imageModule = dicomObject.getImageModule();
        aa aa10 = dicomObject.getImagePlaneModule();
        return new ImagePlane((double)imageModule.getColumnsAsInt() * aa10.ac(), (double)imageModule.getRowsAsInt() * aa10.ad(), aa10.al(), aa10.ao(), aa10.ap(), aa10.ac(), aa10.ad(), aa10.az());
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

