/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.viewer.components.hanging;

import com.visustt.dicomTk.DicomTagNames;
import com.visustt.dicomTk.criteria.CriteriaConfigurationException;
import com.visustt.jiveX.general.criteria.CriterionResolverAdapter;
import com.visustt.jiveX.general.criteria.CriterionResolverTypeComparator;
import com.visustt.jiveX.general.criteria.SeriesCriteria;
import com.visustt.jiveX.general.criteria.StudyCriteria;
import com.visustt.jiveX.general.data.priorstudies.PriorStudiesDefinition;
import com.visustt.jiveX.general.data.priorstudies.StudyAttributes;
import com.visustt.jiveX.general.data.priorstudies.StudyDefinition;
import com.visustt.jiveX.viewer.components.hanging.aae;
import com.visustt.jiveX.viewer.components.hanging.aai;
import com.visustt.jiveX.viewer.components.hanging.aal;
import com.visustt.jiveX.viewer.components.hanging.af.ab.ab;
import com.visustt.jiveX.viewer.components.hanging.ag.ad;
import com.visustt.jiveX.viewer.model.layouts.an;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.util.set.MatrixDim;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class HangingProtocol
implements Comparable<HangingProtocol> {
    private Boolean convertModalityToStudy = null;
    private Boolean showECG = null;
    private Boolean showFixedAnnotationPatientInfo = null;
    private Boolean showFixedAnnotationRuler = null;
    private Boolean showFixedAnnotationOrientation = null;
    private Boolean showFixedAnnotationUserDefined = null;
    private Boolean showFixedAnnotationWindowLevelZoom = null;
    private Boolean showFixedAnnotationImageNumber = null;
    private Boolean showFixedAnnotationTomosynthesisSlab = null;
    private Boolean showCADMarkers = null;
    private String cadMarkerResolution = null;
    private Integer applyFunctionsTo = null;
    private Integer defaultAnnotColor = null;
    private String interpolation = null;
    private String filter = null;
    private Double sharpenRadius = null;
    private Double sharpenAmount = null;
    private Float claheClipLimit = null;
    private String nextHangingProtocolAlias = null;
    private Boolean skipHPIfNoPrior = null;
    private Integer skipHPPriorCount = null;
    private Boolean skipHPIfNoTomo = null;
    private Boolean startSectorSampling = null;
    private String sectorSamplingDirection = null;
    private String sectorSamplingMode = null;
    private Double sectorSamplingZoom;
    private Boolean dontShowScoutSeries = null;
    private Boolean removeEarlierViews = null;
    private Boolean useHangingProtocolAutomatically = null;
    private Boolean splitMultiframes = null;
    private Boolean multiframeAutoplay = null;
    private Boolean multiframeCycling = null;
    private Boolean sameSpeed = null;
    private Double cineFrameRate = null;
    private Boolean cineAutoPlay = null;
    private Integer cineImageSelection = null;
    private List<aal> viewingSections = null;
    private an viewingSectionMatrix = null;
    private Boolean fullscreenIs1x1SeriesMatrix = null;
    private Boolean functionsInFullscreen = null;
    private Boolean zoomToOriginalSizeInFullscreen = Boolean.FALSE;
    private MatrixDim fullscreenMatrix = null;
    private Boolean fsMatrixPerMonitor = null;
    private Boolean mirrorLeftMammos = null;
    private Boolean flipMainStudyLeft = null;
    private Boolean flipMainStudyRight = null;
    private Boolean flipPriorStudyLeft = null;
    private Boolean flipPriorStudyRight = null;
    private Boolean flipTomoStudyLeft = null;
    private Boolean flipTomoStudyRight = null;
    private Integer tomoSlab = null;
    private Boolean mammoAutoShutter = null;
    private Boolean mammoProjectionLines = null;
    private Boolean mammoMamilaDistance = null;
    private Boolean mammoMamilaPositions = null;
    private Boolean mammoAlign = null;
    private Boolean mammoShutterShowOutline = null;
    private Boolean mergeMammoRecallStudies = null;
    private Boolean balanceMammoMatrix = null;
    private Integer numberOfPlaceholders = null;
    private Boolean mammoMlEqualsMlo = Boolean.FALSE;
    private List<aae> seriesConfigs = null;
    private Map<String, aae> seriesConfigMap = null;
    private Boolean suppressFullscreenComparemode = null;
    private Boolean showCutlines = null;
    private Boolean rulerAdjustment = null;
    private String functionpanel = null;
    private String functionPanelFixed = null;
    private String activeTab = null;
    private Boolean applyExistingImageRegistration = null;
    private Boolean createNewImageRegistration = null;
    private Boolean showFocusFrame = null;
    private aai thumbnailTreeConfig = new aai();
    private Boolean useAutomaticSorting = null;
    private Boolean useAutoImageOrientation = null;
    private Boolean showNavigationBars = null;
    private Boolean startCineInFullscreen = null;
    private Boolean separateMultiframeSeries = null;
    private Boolean filterHPsInContextmenu = null;
    private Boolean showAsToolbarButton = null;
    private Boolean useInSecondSymbolBar = null;
    private String toolbarButtonImageServerPath = null;
    private String toolbarButtonShortcut = null;
    private Integer toolbarButtonOrder = null;
    private Boolean autoImageAlignment = null;
    private Boolean synchrScrollWithFittingPlanes = null;
    private Boolean syncPanZoomWithFittingPlanes = null;
    private Boolean syncScrollWithFittingImgPosition = null;
    private Boolean syncLinkedWindowing = null;
    private Boolean playMpgAviInFullscreen = null;
    private String mammoImageSorting;
    private String mammoAcquisitionSorting;
    private String waveformSignalType;
    private String waveformLeadLayout;
    private Boolean waveformCompactView = null;
    private Boolean waveformCabreraView = null;
    private String waveformXScaling;
    private String waveformGain;
    private String waveformYSpacing;
    private String waveformAnchorLead;
    private String waveformOverlay;
    private Boolean waveform40HzFilter = null;
    private Boolean waveformHeader = null;
    private Boolean waveformCalibrationPeak = null;
    private Boolean waveformBaseline = null;
    private Boolean waveformGridMM = null;
    private Boolean waveformGrid5MM = null;
    private Boolean waveformGridCM = null;
    private List<ab> mergedSeries = null;
    private ad waveformLeadConfig;
    private Integer waveformLeadColor = null;
    private Integer waveformGridMMColor = null;
    private Integer waveformGrid5MMColor = null;
    private Integer waveformGridCMColor = null;
    private Integer waveformGridBackgroundColor = null;
    private Boolean mammoIgnoreForProcessing = Boolean.FALSE;
    private StudyDefinition studyDefinition = null;

    public HangingProtocol(String string, String string2, String string3) {
        StudyAttributes studyAttributes = new StudyAttributes(string2, string3);
        this.studyDefinition = new StudyDefinition(string, studyAttributes);
    }

    public HangingProtocol(HangingProtocol hangingProtocol) {
        ArrayList<StudyCriteria> arrayList;
        this.studyDefinition = new StudyDefinition(hangingProtocol.getStudyDefinition());
        this.studyDefinition.setAlias(hangingProtocol.getAlias());
        this.studyDefinition.setPriority(hangingProtocol.getPriorityIndex());
        this.convertModalityToStudy = hangingProtocol.getConvertModalityToStudy();
        this.showECG = hangingProtocol.getShowECG();
        this.showCADMarkers = hangingProtocol.getShowCADMarkers();
        this.cadMarkerResolution = hangingProtocol.getCadMarkerResolution();
        this.showFixedAnnotationPatientInfo = hangingProtocol.getShowFixedAnnotationPatientInfo();
        this.showFixedAnnotationRuler = hangingProtocol.getShowFixedAnnotationRuler();
        this.showFixedAnnotationOrientation = hangingProtocol.getShowFixedAnnotationOrientation();
        this.showFixedAnnotationUserDefined = hangingProtocol.getShowFixedAnnotationUserDefined();
        this.showFixedAnnotationWindowLevelZoom = hangingProtocol.getShowFixedAnnotationWindowLevelZoom();
        this.showFixedAnnotationImageNumber = hangingProtocol.getShowFixedAnnotationImageNumber();
        this.showFixedAnnotationTomosynthesisSlab = hangingProtocol.getShowFixedAnnotationTomosynthesisSlab();
        this.separateMultiframeSeries = hangingProtocol.getSeparateMultiframeSeries();
        this.showAsToolbarButton = hangingProtocol.getShowAsToolbarButton();
        this.useInSecondSymbolBar = hangingProtocol.getUseInSecondSymbolBar();
        this.toolbarButtonImageServerPath = hangingProtocol.getToolbarButtonImageServerPath();
        this.toolbarButtonShortcut = hangingProtocol.getToolbarButtonShortcut();
        this.toolbarButtonOrder = hangingProtocol.getToolbarButtonOrder();
        this.applyFunctionsTo = hangingProtocol.getApplyFunctionsTo();
        this.defaultAnnotColor = hangingProtocol.getDefaultAnnotColor();
        this.applyExistingImageRegistration = hangingProtocol.getApplyExistingImageRegistration();
        this.createNewImageRegistration = hangingProtocol.getCreateNewImageRegistration();
        this.cineImageSelection = hangingProtocol.getCineImageSelection();
        this.interpolation = hangingProtocol.getInterpolation();
        this.sharpenRadius = hangingProtocol.getSharpenRadius();
        this.sharpenAmount = hangingProtocol.getSharpenAmount();
        this.filter = hangingProtocol.getFilter();
        this.claheClipLimit = hangingProtocol.getCLAHEClipLimit();
        this.nextHangingProtocolAlias = hangingProtocol.getNextHangingProtocolAlias();
        this.skipHPIfNoPrior = hangingProtocol.getSkipHPIfNoPrior();
        this.skipHPPriorCount = hangingProtocol.getSkipHPPriorCount();
        this.skipHPIfNoTomo = hangingProtocol.getSkipHPIfNoTomo();
        this.startSectorSampling = hangingProtocol.getStartSectorSampling();
        this.sectorSamplingDirection = hangingProtocol.getSectorSamplingDirection();
        this.sectorSamplingMode = hangingProtocol.getSectorSamplingMode();
        this.sectorSamplingZoom = hangingProtocol.getSectorSamplingZoom();
        this.removeEarlierViews = hangingProtocol.getRemoveEarlierViews();
        this.dontShowScoutSeries = hangingProtocol.getDontShowScoutSeries();
        this.splitMultiframes = hangingProtocol.getSplitMultiframes();
        this.showNavigationBars = hangingProtocol.getShowNavigationBars();
        this.showFocusFrame = hangingProtocol.getShowFocusFrame();
        this.flipMainStudyLeft = hangingProtocol.getFlipMainStudyLeft();
        this.flipMainStudyRight = hangingProtocol.getFlipMainStudyRight();
        this.flipPriorStudyLeft = hangingProtocol.getFlipPriorStudyLeft();
        this.flipPriorStudyRight = hangingProtocol.getFlipPriorStudyRight();
        this.flipTomoStudyLeft = hangingProtocol.getFlipTomoStudyLeft();
        this.flipTomoStudyRight = hangingProtocol.getFlipTomoStudyRight();
        this.tomoSlab = hangingProtocol.getTomoSlab();
        this.useHangingProtocolAutomatically = hangingProtocol.getUseHangingProtocolAutomatically();
        List<StudyCriteria> list = hangingProtocol.getStudySelectionCriteria();
        if (list != null && !list.isEmpty()) {
            arrayList = new ArrayList<StudyCriteria>();
            for (StudyCriteria object : list) {
                StudyCriteria studyCriteria = object.copy();
                arrayList.add(studyCriteria);
            }
            this.studyDefinition.setStudySelectionCriteria(arrayList);
        }
        if (hangingProtocol.getFullscreenImageMatrix() != null) {
            this.fullscreenMatrix = new MatrixDim(hangingProtocol.getFullscreenImageMatrix());
        }
        this.fsMatrixPerMonitor = hangingProtocol.getFsMatrixPerMonitor();
        this.startCineInFullscreen = hangingProtocol.getStartCineInFullScreen();
        this.filterHPsInContextmenu = hangingProtocol.getFilterHPsInContextmenu();
        this.synchrScrollWithFittingPlanes = hangingProtocol.getSynchrScrollWithFittingPlanes();
        this.syncPanZoomWithFittingPlanes = hangingProtocol.getSyncPanZoomWithFittingPlanes();
        this.syncScrollWithFittingImgPosition = hangingProtocol.getSyncScrollWithFittingImgPosition();
        this.syncLinkedWindowing = hangingProtocol.getSyncLinkedWindowing();
        if (hangingProtocol.getViewingSections() != null) {
            arrayList = new ArrayList();
            for (aal aal2 : hangingProtocol.getViewingSections()) {
                arrayList.add((StudyCriteria)((Object)new aal(aal2)));
            }
            this.setViewingSections(arrayList);
            this.setMatrixOfViewingSections(hangingProtocol.getMatrixOfViewingSections());
        }
        if (hangingProtocol.getSeriesConfigs() != null) {
            arrayList = new ArrayList();
            for (aae aae2 : hangingProtocol.getSeriesConfigs()) {
                arrayList.add((StudyCriteria)((Object)new aae(aae2)));
            }
            this.setSeriesConfigs(arrayList);
        }
        if (hangingProtocol.getMergedSeries() != null) {
            arrayList = new ArrayList();
            for (ab ab5 : hangingProtocol.getMergedSeries()) {
                arrayList.add((StudyCriteria)((Object)ab5.ad()));
            }
            this.setMergedSeries(arrayList);
        }
        this.multiframeAutoplay = hangingProtocol.getMultiframeAutoplay();
        this.multiframeCycling = hangingProtocol.getMultiframeCycling();
        this.sameSpeed = hangingProtocol.getSameSpeed();
        this.cineAutoPlay = hangingProtocol.getCineAutoPlay();
        this.cineFrameRate = hangingProtocol.getCineFrameRate();
        if (hangingProtocol.getPriorStudiesDefinition() != null) {
            this.setPriorStudiesDefinition(hangingProtocol.getPriorStudiesDefinition().clone());
        }
        this.suppressFullscreenComparemode = hangingProtocol.getSuppressFullscreenComparemode();
        this.rulerAdjustment = hangingProtocol.getRulerAdjustment();
        this.showCutlines = hangingProtocol.getShowCutlines();
        this.fullscreenIs1x1SeriesMatrix = hangingProtocol.getFullscreenIs1x1SeriesMatrix();
        this.functionsInFullscreen = hangingProtocol.getFunctionsInFullscreen();
        this.zoomToOriginalSizeInFullscreen = hangingProtocol.getZoomToOriginalSizeInFullscreen();
        this.useAutomaticSorting = hangingProtocol.getUseAutomaticSorting();
        this.useAutoImageOrientation = hangingProtocol.getAutoImageOrientation();
        this.functionpanel = hangingProtocol.getFunctionPanelState();
        this.functionPanelFixed = hangingProtocol.getFunctionPanelFixed();
        this.activeTab = hangingProtocol.getActiveTab();
        this.thumbnailTreeConfig = hangingProtocol.getThumbnailTreeConfig();
        this.mirrorLeftMammos = hangingProtocol.getMirrorLeftMammos();
        this.mammoAutoShutter = hangingProtocol.getMammoAutoShutter();
        this.mammoProjectionLines = hangingProtocol.getMammoProjectionLines();
        this.mammoMamilaDistance = hangingProtocol.getMammoMamilaDistance();
        this.mammoMamilaPositions = hangingProtocol.getMammoMamilaPositions();
        this.mammoAlign = hangingProtocol.getMammoAlign();
        this.mammoShutterShowOutline = hangingProtocol.getMammoShutterShowOutline();
        this.balanceMammoMatrix = hangingProtocol.getBalanceMammoMatrix();
        this.numberOfPlaceholders = hangingProtocol.getNumberOfPlaceholders();
        this.mammoMlEqualsMlo = hangingProtocol.getMammoMLEqualsMLO();
        this.mergeMammoRecallStudies = hangingProtocol.getMergeMammoRecallStudies();
        this.mammoIgnoreForProcessing = hangingProtocol.getMammoIgnoreForProcessing();
        this.autoImageAlignment = hangingProtocol.getAutoImageAlignment();
        this.playMpgAviInFullscreen = hangingProtocol.getPlayMpgAviInFullscreen();
        this.mammoImageSorting = hangingProtocol.getMammoImageSorting();
        this.mammoAcquisitionSorting = hangingProtocol.getMammoAcquisitionSorting();
        this.waveformSignalType = hangingProtocol.getWaveformSignalType();
        this.waveformLeadLayout = hangingProtocol.getWaveformLeadLayout();
        this.waveformCompactView = hangingProtocol.getWaveformCompactView();
        this.waveformCabreraView = hangingProtocol.getWaveformCabreraView();
        this.waveformXScaling = hangingProtocol.getWaveformXScaling();
        this.waveformGain = hangingProtocol.getWaveformGain();
        this.waveformYSpacing = hangingProtocol.getWaveformYSpacing();
        this.waveformAnchorLead = hangingProtocol.getWaveformAnchorLead();
        this.waveformOverlay = hangingProtocol.getWaveformOverlay();
        this.waveform40HzFilter = hangingProtocol.getWaveform40HzFilter();
        this.waveformHeader = hangingProtocol.getWaveformHeader();
        this.waveformCalibrationPeak = hangingProtocol.getWaveformCalibrationPeak();
        this.waveformBaseline = hangingProtocol.getWaveformBaseline();
        this.waveformGridMM = hangingProtocol.getWaveformGridMM();
        this.waveformGrid5MM = hangingProtocol.getWaveformGrid5MM();
        this.waveformGridCM = hangingProtocol.getWaveformGridCM();
        this.waveformLeadConfig = hangingProtocol.getWaveformLeadConfig();
        this.waveformLeadColor = hangingProtocol.getWaveformLeadColor();
        this.waveformGridMMColor = hangingProtocol.getWaveformGridMMColor();
        this.waveformGrid5MMColor = hangingProtocol.getWaveformGrid5MMColor();
        this.waveformGridCMColor = hangingProtocol.getWaveformGridCMColor();
        this.waveformGridBackgroundColor = hangingProtocol.getWaveformGridBackgroundColor();
        this.thumbnailTreeConfig = new aai(hangingProtocol.getThumbnailTreeConfig());
        this.setLoadCriteriaRelatedStudies(hangingProtocol.isLoadCriteriaRelatedStudies());
    }

    public Boolean getCreateNewImageRegistration() {
        return this.createNewImageRegistration;
    }

    public String getAlias() {
        return this.studyDefinition.getAlias();
    }

    public void setAlias(String string) {
        this.studyDefinition.setAlias(string);
    }

    public Boolean getConvertModalityToStudy() {
        return this.convertModalityToStudy;
    }

    public void setConvertModalityToStudy(Boolean bl) {
        this.convertModalityToStudy = bl;
    }

    public Boolean getDontShowScoutSeries() {
        return this.dontShowScoutSeries;
    }

    public void setDontShowScoutSeries(Boolean bl) {
        this.dontShowScoutSeries = bl;
    }

    public Integer getApplyFunctionsTo() {
        return this.applyFunctionsTo;
    }

    public void setApplyFunctionsTo(Integer n) {
        this.applyFunctionsTo = n;
    }

    public Integer getDefaultAnnotColor() {
        return this.defaultAnnotColor;
    }

    public void setDefaultAnnotColor(Integer n) {
        this.defaultAnnotColor = n;
    }

    public Boolean getApplyExistingImageRegistration() {
        return this.applyExistingImageRegistration;
    }

    public void setApplyExistingImageRegistration(Boolean bl) {
        this.applyExistingImageRegistration = bl;
    }

    public void setCreateNewImageRegistration(Boolean bl) {
        this.createNewImageRegistration = bl;
    }

    public String getInterpolation() {
        return this.interpolation;
    }

    public void setInterpolation(String string) {
        this.interpolation = string;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String string) {
        this.filter = string;
    }

    public Double getSharpenRadius() {
        return this.sharpenRadius;
    }

    public void setSharpenRadius(Double d) {
        this.sharpenRadius = d;
    }

    public Double getSharpenAmount() {
        return this.sharpenAmount;
    }

    public void setSharpenAmount(Double d) {
        this.sharpenAmount = d;
    }

    public Float getCLAHEClipLimit() {
        return this.claheClipLimit;
    }

    public void setCLAHEClipLimit(Float f) {
        this.claheClipLimit = f;
    }

    public String getNextHangingProtocolAlias() {
        return this.nextHangingProtocolAlias;
    }

    public void setNextHangingProtocolAlias(String string) {
        this.nextHangingProtocolAlias = string;
    }

    public Boolean getSkipHPIfNoPrior() {
        return this.skipHPIfNoPrior;
    }

    public void setSkipHPIfNoPrior(Boolean bl) {
        this.skipHPIfNoPrior = bl;
    }

    public Integer getSkipHPPriorCount() {
        return this.skipHPPriorCount;
    }

    public void setSkipHPPriorCount(Integer n) {
        this.skipHPPriorCount = n;
    }

    public Boolean getSkipHPIfNoTomo() {
        return this.skipHPIfNoTomo;
    }

    public void setSkipHPIfNoTomo(Boolean bl) {
        this.skipHPIfNoTomo = bl;
    }

    public Boolean getUseHangingProtocolAutomatically() {
        return this.useHangingProtocolAutomatically;
    }

    public void setUseHangingProtocolAutomatically(Boolean bl) {
        this.useHangingProtocolAutomatically = bl;
    }

    public Boolean getFilterHPsInContextmenu() {
        return this.filterHPsInContextmenu;
    }

    public void setFilterHPsInContextmenu(Boolean bl) {
        this.filterHPsInContextmenu = bl;
    }

    public Boolean getShowCutlines() {
        return this.showCutlines;
    }

    public void setShowCutlines(Boolean bl) {
        this.showCutlines = bl;
    }

    public Boolean getRulerAdjustment() {
        return this.rulerAdjustment;
    }

    public void setRulerAdjustment(Boolean bl) {
        this.rulerAdjustment = bl;
    }

    public String getFunctionPanelState() {
        return this.functionpanel;
    }

    public void setFunctionPanelState(String string) {
        this.functionpanel = string;
    }

    public String getFunctionPanelFixed() {
        return this.functionPanelFixed;
    }

    public void setFunctionPanelFixed(String string) {
        this.functionPanelFixed = string;
    }

    public String getActiveTab() {
        return this.activeTab;
    }

    public void setActiveTab(String string) {
        this.activeTab = string;
        if (string != null && this.getFunctionPanelFixed() == null && !string.equals("INVALID")) {
            this.setFunctionPanelFixed("enabled");
        }
    }

    public Boolean getThumbnailTreeState() {
        return this.getThumbnailTreeConfig().aa();
    }

    public void setThumbnailTreeState(Boolean bl) {
        this.getThumbnailTreeConfig().aa(bl);
    }

    public aai getThumbnailTreeConfig() {
        return this.thumbnailTreeConfig;
    }

    public void setThumbnailTreeConfig(aai aai2) {
        this.thumbnailTreeConfig = aai2;
    }

    public Boolean getUseAutomaticSorting() {
        return this.useAutomaticSorting;
    }

    public void setUseAutomaticSorting(Boolean bl) {
        this.useAutomaticSorting = bl;
    }

    public Boolean getAutoImageOrientation() {
        return this.useAutoImageOrientation;
    }

    public void setAutoImageOrientation(Boolean bl) {
        this.useAutoImageOrientation = bl;
    }

    public Boolean getSynchrScrollWithFittingPlanes() {
        return this.synchrScrollWithFittingPlanes;
    }

    public void setSynchrScrollWithFittingPlanes(Boolean bl) {
        this.synchrScrollWithFittingPlanes = bl;
    }

    public Boolean getSyncPanZoomWithFittingPlanes() {
        return this.syncPanZoomWithFittingPlanes;
    }

    public void setSyncPanZoomWithFittingPlanes(Boolean bl) {
        this.syncPanZoomWithFittingPlanes = bl;
    }

    public Boolean getSyncScrollWithFittingImgPosition() {
        return this.syncScrollWithFittingImgPosition;
    }

    public void setSyncScrollWithFittingImgPosition(Boolean bl) {
        this.syncScrollWithFittingImgPosition = bl;
    }

    public Boolean getSyncLinkedWindowing() {
        return this.syncLinkedWindowing;
    }

    public void setSyncLinkedWindowing(Boolean bl) {
        this.syncLinkedWindowing = bl;
    }

    public Boolean getFullscreenIs1x1SeriesMatrix() {
        return this.fullscreenIs1x1SeriesMatrix;
    }

    public void setFullscreenIs1x1SeriesMatrix(Boolean bl) {
        this.fullscreenIs1x1SeriesMatrix = bl;
    }

    public Boolean getPlayMpgAviInFullscreen() {
        return this.playMpgAviInFullscreen;
    }

    public void setPlayMpgAviInFullscreen(Boolean bl) {
        this.playMpgAviInFullscreen = bl;
    }

    public Boolean getFunctionsInFullscreen() {
        return this.functionsInFullscreen;
    }

    public void setFunctionsInFullscreen(Boolean bl) {
        this.functionsInFullscreen = bl;
    }

    public Boolean getZoomToOriginalSizeInFullscreen() {
        return this.zoomToOriginalSizeInFullscreen;
    }

    public void setZoomToOriginalSizeInFullscreen(Boolean bl) {
        this.zoomToOriginalSizeInFullscreen = bl;
    }

    public MatrixDim getFullscreenImageMatrix() {
        return this.fullscreenMatrix;
    }

    public void setFullscreenImageMatrix(MatrixDim matrixDim) {
        this.fullscreenMatrix = matrixDim;
    }

    public Boolean getFsMatrixPerMonitor() {
        return this.fsMatrixPerMonitor;
    }

    public void setFsMatrixPerMonitor(Boolean bl) {
        this.fsMatrixPerMonitor = bl;
    }

    public Boolean getSuppressFullscreenComparemode() {
        return this.suppressFullscreenComparemode;
    }

    public void setSuppressFullscreenComparemode(Boolean bl) {
        this.suppressFullscreenComparemode = bl;
    }

    public Boolean getStartCineInFullScreen() {
        return this.startCineInFullscreen;
    }

    public void setStartCineInFullScreen(Boolean bl) {
        this.startCineInFullscreen = bl;
    }

    public Boolean getSeparateMultiframeSeries() {
        return this.separateMultiframeSeries;
    }

    public void setSeparateMultiframeSeries(Boolean bl) {
        this.separateMultiframeSeries = bl;
    }

    public Boolean getMultiframeAutoplay() {
        return this.multiframeAutoplay;
    }

    public void setMultiframeAutoplay(Boolean bl) {
        this.multiframeAutoplay = bl;
    }

    public Boolean getMultiframeCycling() {
        return this.multiframeCycling;
    }

    public void setMultiframeCycling(Boolean bl) {
        this.multiframeCycling = bl;
    }

    public Boolean getSameSpeed() {
        return this.sameSpeed;
    }

    public void setSameSpeed(Boolean bl) {
        this.sameSpeed = bl;
    }

    public Boolean getCineAutoPlay() {
        return this.cineAutoPlay;
    }

    public void setCineAutoPlay(Boolean bl) {
        this.cineAutoPlay = bl;
    }

    public Double getCineFrameRate() {
        return this.cineFrameRate;
    }

    public void setCineFrameRate(Double d) {
        this.cineFrameRate = d;
    }

    public Integer getCineImageSelection() {
        return this.cineImageSelection;
    }

    public void setCineImageSelection(Integer n) {
        this.cineImageSelection = n;
    }

    public Boolean getSplitMultiframes() {
        return this.splitMultiframes;
    }

    public void setSplitMultiframes(Boolean bl) {
        this.splitMultiframes = bl;
    }

    public Boolean getShowECG() {
        return this.showECG;
    }

    public void setShowECG(Boolean bl) {
        this.showECG = bl;
    }

    public Boolean getShowFocusFrame() {
        return this.showFocusFrame;
    }

    public void setShowFocusFrame(Boolean bl) {
        this.showFocusFrame = bl;
    }

    public Boolean getShowFixedAnnotationPatientInfo() {
        return this.showFixedAnnotationPatientInfo;
    }

    public void setShowFixedAnnotationPatientInfo(Boolean bl) {
        this.showFixedAnnotationPatientInfo = bl;
    }

    public Boolean getShowFixedAnnotationRuler() {
        return this.showFixedAnnotationRuler;
    }

    public void setShowFixedAnnotationRuler(Boolean bl) {
        this.showFixedAnnotationRuler = bl;
    }

    public Boolean getShowFixedAnnotationOrientation() {
        return this.showFixedAnnotationOrientation;
    }

    public void setShowFixedAnnotationOrientation(Boolean bl) {
        this.showFixedAnnotationOrientation = bl;
    }

    public Boolean getShowFixedAnnotationUserDefined() {
        return this.showFixedAnnotationUserDefined;
    }

    public void setShowFixedAnnotationUserDefined(Boolean bl) {
        this.showFixedAnnotationUserDefined = bl;
    }

    public Boolean getShowFixedAnnotationWindowLevelZoom() {
        return this.showFixedAnnotationWindowLevelZoom;
    }

    public void setShowFixedAnnotationWindowLevelZoom(Boolean bl) {
        this.showFixedAnnotationWindowLevelZoom = bl;
    }

    public Boolean getShowFixedAnnotationImageNumber() {
        return this.showFixedAnnotationImageNumber;
    }

    public void setShowFixedAnnotationImageNumber(Boolean bl) {
        this.showFixedAnnotationImageNumber = bl;
    }

    public Boolean getShowFixedAnnotationTomosynthesisSlab() {
        return this.showFixedAnnotationTomosynthesisSlab;
    }

    public void setShowFixedAnnotationTomosynthesisSlab(Boolean bl) {
        this.showFixedAnnotationTomosynthesisSlab = bl;
    }

    public List<aal> getViewingSections() {
        return this.viewingSections;
    }

    public void setViewingSections(List<aal> list) {
        this.viewingSections = list;
    }

    public an getMatrixOfViewingSections() {
        return this.viewingSectionMatrix;
    }

    public void setMatrixOfViewingSections(an an2) {
        this.viewingSectionMatrix = an2;
    }

    public List<aae> getSeriesConfigs() {
        return this.seriesConfigs;
    }

    public aae getSeriesConfiguration(String string) {
        String string2;
        aae aae2;
        if (this.seriesConfigs == null) {
            return null;
        }
        if (this.seriesConfigMap == null) {
            this.seriesConfigMap = new Hashtable<String, aae>();
            int n = this.seriesConfigs.size();
            for (int i = 0; i < n; ++i) {
                aae aae3 = this.seriesConfigs.get(i);
                this.seriesConfigMap.put(aae3.aa().toLowerCase(), aae3);
            }
        }
        if ((aae2 = this.seriesConfigMap.get(string2 = string.toLowerCase())) == null) {
            int n = -1;
            for (Map.Entry<String, aae> entry : this.seriesConfigMap.entrySet()) {
                String string3 = entry.getKey();
                if (string3.length() <= n || !StringTool.matchWildCard(string2, string3)) continue;
                aae2 = entry.getValue();
                n = string3.length();
            }
            if (aae2 == null) {
                aae2 = this.seriesConfigMap.get("*");
            }
        }
        return aae2;
    }

    public void setSeriesConfigs(List<aae> list) {
        this.seriesConfigs = list;
        this.seriesConfigMap = null;
    }

    public Boolean getAutoImageAlignment() {
        return this.autoImageAlignment;
    }

    public void setAutoImageAlignment(Boolean bl) {
        this.autoImageAlignment = bl;
    }

    public Boolean getMirrorLeftMammos() {
        return this.mirrorLeftMammos;
    }

    public void setMirrorLeftMammos(Boolean bl) {
        this.mirrorLeftMammos = bl;
    }

    public Boolean getFlipMainStudyLeft() {
        return this.flipMainStudyLeft;
    }

    public boolean isFlipMainStudyLeft() {
        return this.flipMainStudyLeft != null && this.flipMainStudyLeft != false;
    }

    public void setFlipMainStudyLeft(Boolean bl) {
        this.flipMainStudyLeft = bl;
    }

    public Boolean getFlipMainStudyRight() {
        return this.flipMainStudyRight;
    }

    public boolean isFlipMainStudyRight() {
        return this.flipMainStudyRight != null && this.flipMainStudyRight != false;
    }

    public void setFlipMainStudyRight(Boolean bl) {
        this.flipMainStudyRight = bl;
    }

    public Boolean getFlipPriorStudyLeft() {
        return this.flipPriorStudyLeft;
    }

    public boolean isFlipPriorStudyLeft() {
        return this.flipPriorStudyLeft != null && this.flipPriorStudyLeft != false;
    }

    public void setFlipPriorStudyLeft(Boolean bl) {
        this.flipPriorStudyLeft = bl;
    }

    public Boolean getFlipPriorStudyRight() {
        return this.flipPriorStudyRight;
    }

    public boolean isFlipPriorStudyRight() {
        return this.flipPriorStudyRight != null && this.flipPriorStudyRight != false;
    }

    public void setFlipPriorStudyRight(Boolean bl) {
        this.flipPriorStudyRight = bl;
    }

    public boolean isFlipTomoStudyLeft() {
        return this.flipTomoStudyLeft != null && this.flipTomoStudyLeft != false;
    }

    public Boolean getFlipTomoStudyLeft() {
        return this.flipTomoStudyLeft;
    }

    public void setFlipTomoStudyLeft(Boolean bl) {
        this.flipTomoStudyLeft = bl;
    }

    public boolean isFlipTomoStudyRight() {
        return this.flipTomoStudyRight != null && this.flipTomoStudyRight != false;
    }

    public void setFlipTomoStudyRight(Boolean bl) {
        this.flipTomoStudyRight = bl;
    }

    public Boolean getFlipTomoStudyRight() {
        return this.flipTomoStudyRight;
    }

    public Integer getTomoSlab() {
        return this.tomoSlab;
    }

    public void setTomoSlab(Integer n) {
        this.tomoSlab = n;
    }

    public Boolean getMammoAutoShutter() {
        return this.mammoAutoShutter;
    }

    public Boolean getMammoProjectionLines() {
        return this.mammoProjectionLines;
    }

    public void setMammoProjectionLines(Boolean bl) {
        this.mammoProjectionLines = bl;
    }

    public Boolean getMammoMamilaDistance() {
        return this.mammoMamilaDistance;
    }

    public void setMammoMamilaDistance(Boolean bl) {
        this.mammoMamilaDistance = bl;
    }

    public void setMammoMamilaPositions(Boolean bl) {
        this.mammoMamilaPositions = bl;
    }

    public Boolean getMammoMamilaPositions() {
        return this.mammoMamilaPositions;
    }

    public void setMammoAutoShutter(Boolean bl) {
        this.mammoAutoShutter = bl;
    }

    public Boolean getMammoAlign() {
        return this.mammoAlign;
    }

    public void setMammoAlign(Boolean bl) {
        this.mammoAlign = bl;
    }

    public Boolean getMammoShutterShowOutline() {
        return this.mammoShutterShowOutline;
    }

    public void setMammoShutterShowOutline(Boolean bl) {
        this.mammoShutterShowOutline = bl;
    }

    public Boolean getBalanceMammoMatrix() {
        return this.balanceMammoMatrix;
    }

    public void setBalanceMammoMatrix(Boolean bl) {
        this.balanceMammoMatrix = bl;
    }

    public Integer getNumberOfPlaceholders() {
        return this.numberOfPlaceholders;
    }

    public void setNumberOfPlaceholders(Integer n) {
        this.numberOfPlaceholders = n;
    }

    public Boolean getMammoMLEqualsMLO() {
        return this.mammoMlEqualsMlo;
    }

    public void setMammoMLEqualsMLO(Boolean bl) {
        this.mammoMlEqualsMlo = bl;
    }

    public Boolean getMergeMammoRecallStudies() {
        return this.mergeMammoRecallStudies;
    }

    public void setMergeMammoRecallStudies(Boolean bl) {
        this.mergeMammoRecallStudies = bl;
    }

    public Boolean getMammoIgnoreForProcessing() {
        return this.mammoIgnoreForProcessing;
    }

    public void setMammoIgnoreForProcessing(Boolean bl) {
        this.mammoIgnoreForProcessing = bl;
    }

    public String getMammoImageSorting() {
        return this.mammoImageSorting;
    }

    public void setMammoImageSorting(String string) {
        this.mammoImageSorting = string;
    }

    public String getMammoAcquisitionSorting() {
        return this.mammoAcquisitionSorting;
    }

    public void setMammoAcquisitionSorting(String string) {
        this.mammoAcquisitionSorting = string;
    }

    public Boolean getStartSectorSampling() {
        return this.startSectorSampling;
    }

    public void setStartSectorSampling(Boolean bl) {
        this.startSectorSampling = bl;
    }

    public String getSectorSamplingDirection() {
        return this.sectorSamplingDirection;
    }

    public void setSectorSamplingDirection(String string) {
        this.sectorSamplingDirection = string;
    }

    public String getSectorSamplingMode() {
        return this.sectorSamplingMode;
    }

    public void setSectorSamplingMode(String string) {
        this.sectorSamplingMode = string;
    }

    public void setSectorSamplingZoom(Double d) {
        this.sectorSamplingZoom = d;
    }

    public Double getSectorSamplingZoom() {
        return this.sectorSamplingZoom;
    }

    public Boolean getRemoveEarlierViews() {
        return this.removeEarlierViews;
    }

    public void setRemoveEarlierViews(Boolean bl) {
        this.removeEarlierViews = bl;
    }

    public Boolean getShowNavigationBars() {
        return this.showNavigationBars;
    }

    public void setShowNavigationBars(Boolean bl) {
        this.showNavigationBars = bl;
    }

    public PriorStudiesDefinition getPriorStudiesDefinition() {
        return this.studyDefinition.getPriorStudiesDefinition();
    }

    public void setPriorStudiesDefinition(PriorStudiesDefinition priorStudiesDefinition) {
        this.studyDefinition.setPriorStudiesDefinition(priorStudiesDefinition);
    }

    public StudyDefinition getStudyDefinition() {
        return this.studyDefinition;
    }

    public Boolean getShowAsToolbarButton() {
        return this.showAsToolbarButton;
    }

    public void setShowAsToolbarButton(Boolean bl) {
        this.showAsToolbarButton = bl;
    }

    public String getToolbarButtonImageServerPath() {
        return this.toolbarButtonImageServerPath;
    }

    public void setToolbarButtonImageServerPath(String string) {
        this.toolbarButtonImageServerPath = string;
    }

    public String getToolbarButtonShortcut() {
        return this.toolbarButtonShortcut;
    }

    public void setToolbarButtonShortcut(String string) {
        this.toolbarButtonShortcut = string;
    }

    public Integer getToolbarButtonOrder() {
        return this.toolbarButtonOrder;
    }

    public void setToolbarButtonOrder(Integer n) {
        this.toolbarButtonOrder = n;
    }

    public String getWaveformSignalType() {
        return this.waveformSignalType;
    }

    public void setWaveformSignalType(String string) {
        this.waveformSignalType = string;
    }

    public String getWaveformLeadLayout() {
        return this.waveformLeadLayout;
    }

    public void setWaveformLeadLayout(String string) {
        this.waveformLeadLayout = string;
    }

    public Boolean getWaveformCompactView() {
        return this.waveformCompactView;
    }

    public void setWaveformCompactView(Boolean bl) {
        this.waveformCompactView = bl;
    }

    public Boolean getWaveformCabreraView() {
        return this.waveformCabreraView;
    }

    public void setWaveformCabreraView(Boolean bl) {
        this.waveformCabreraView = bl;
    }

    public String getWaveformXScaling() {
        return this.waveformXScaling;
    }

    public void setWaveformXScaling(String string) {
        this.waveformXScaling = string;
    }

    public String getWaveformGain() {
        return this.waveformGain;
    }

    public void setWaveformGain(String string) {
        this.waveformGain = string;
    }

    public String getWaveformYSpacing() {
        return this.waveformYSpacing;
    }

    public void setWaveformYSpacing(String string) {
        this.waveformYSpacing = string;
    }

    public String getWaveformAnchorLead() {
        return this.waveformAnchorLead;
    }

    public String getWaveformOverlay() {
        return this.waveformOverlay;
    }

    public void setWaveformOverlay(String string) {
        this.waveformOverlay = string;
    }

    public void setWaveformAnchorLead(String string) {
        this.waveformAnchorLead = string;
    }

    public Boolean getWaveform40HzFilter() {
        return this.waveform40HzFilter;
    }

    public void setWaveform40HzFilter(Boolean bl) {
        this.waveform40HzFilter = bl;
    }

    public Boolean getWaveformHeader() {
        return this.waveformHeader;
    }

    public void setWaveformHeader(Boolean bl) {
        this.waveformHeader = bl;
    }

    public Boolean getWaveformCalibrationPeak() {
        return this.waveformCalibrationPeak;
    }

    public void setWaveformCalibrationPeak(Boolean bl) {
        this.waveformCalibrationPeak = bl;
    }

    public Boolean getWaveformBaseline() {
        return this.waveformBaseline;
    }

    public void setWaveformBaseline(Boolean bl) {
        this.waveformBaseline = bl;
    }

    public Boolean getWaveformGridMM() {
        return this.waveformGridMM;
    }

    public void setWaveformGridMM(Boolean bl) {
        this.waveformGridMM = bl;
    }

    public Boolean getWaveformGrid5MM() {
        return this.waveformGrid5MM;
    }

    public void setWaveformGrid5MM(Boolean bl) {
        this.waveformGrid5MM = bl;
    }

    public Boolean getWaveformGridCM() {
        return this.waveformGridCM;
    }

    public void setWaveformGridCM(Boolean bl) {
        this.waveformGridCM = bl;
    }

    public void setShowCADMarkers(Boolean bl) {
        this.showCADMarkers = bl;
    }

    public Boolean getShowCADMarkers() {
        return this.showCADMarkers;
    }

    public String getCadMarkerResolution() {
        return this.cadMarkerResolution;
    }

    public void setCadMarkerResolution(String string) {
        this.cadMarkerResolution = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HangingProtocol hangingProtocol = (HangingProtocol)object;
        return this.useHangingProtocolAutomatically == hangingProtocol.useHangingProtocolAutomatically && this.studyDefinition.getPriority() == hangingProtocol.getPriorityIndex() && this.getStudySelectionCriteria().equals(hangingProtocol.getStudySelectionCriteria()) && this.getAlias().equals(hangingProtocol.getAlias());
    }

    @Override
    public int compareTo(HangingProtocol hangingProtocol) {
        if (hangingProtocol == null) {
            return 1;
        }
        if (this.studyDefinition.getPriority() > hangingProtocol.getPriorityIndex()) {
            return -1;
        }
        if (this.studyDefinition.getPriority() < hangingProtocol.getPriorityIndex()) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder("HangingProtocol ");
        stringBuilder.append(this.getAlias());
        stringBuilder.append(" for ");
        if (this.getStudyDefinition() != null) {
            stringBuilder.append(this.getStudyDefinition().toString());
        } else {
            stringBuilder.append("[no criterium]");
        }
        if (bl) {
            stringBuilder.append(" Options:[");
            stringBuilder.append("applyFunctionsTo:");
            stringBuilder.append(this.nns(this.applyFunctionsTo));
            stringBuilder.append(";autoImageAlignment:");
            stringBuilder.append(this.nns(this.autoImageAlignment));
            stringBuilder.append(";convertModalityToStudy:");
            stringBuilder.append(this.nns(this.convertModalityToStudy));
            stringBuilder.append(";showECG:");
            stringBuilder.append(this.nns(this.showECG));
            stringBuilder.append(";filterHPsInContextmenu:");
            stringBuilder.append(this.nns(this.filterHPsInContextmenu));
            stringBuilder.append(";fsMatrixPerMonitor:");
            stringBuilder.append(this.nns(this.fsMatrixPerMonitor));
            stringBuilder.append(";dontShowScoutSeries:");
            stringBuilder.append(this.nns(this.dontShowScoutSeries));
            stringBuilder.append(";nextHangingProtocol:");
            stringBuilder.append(this.nns(this.nextHangingProtocolAlias));
            stringBuilder.append(";skipHPIfNoPrior:");
            stringBuilder.append(this.nns(this.skipHPIfNoPrior));
            stringBuilder.append(";skipHPIfNoTomo:");
            stringBuilder.append(this.nns(this.skipHPIfNoTomo));
            stringBuilder.append(";defaultAnnotColor:");
            stringBuilder.append(this.nns(this.defaultAnnotColor));
            stringBuilder.append(";startSectorSampling:");
            stringBuilder.append(this.nns(this.startSectorSampling));
            stringBuilder.append(";sectorSamplingDirection:");
            stringBuilder.append(this.nns(this.sectorSamplingDirection));
            stringBuilder.append(";sectorSamplingMode:");
            stringBuilder.append(this.nns(this.sectorSamplingMode));
            stringBuilder.append(";sectorSamplingZoom:");
            stringBuilder.append(this.nns(this.sectorSamplingZoom));
            stringBuilder.append(";removeEarlierViews:");
            stringBuilder.append(this.nns(this.removeEarlierViews));
            stringBuilder.append(";showFocusFrame:");
            stringBuilder.append(this.nns(this.showFocusFrame));
            stringBuilder.append(";synchrScrollWithFittingPlanes:");
            stringBuilder.append(this.nns(this.synchrScrollWithFittingPlanes));
            stringBuilder.append(";syncPanZoomWithFittingPlanes:");
            stringBuilder.append(this.nns(this.syncPanZoomWithFittingPlanes));
            stringBuilder.append(";syncScrollWithFittingImgPosition:");
            stringBuilder.append(this.nns(this.syncScrollWithFittingImgPosition));
            stringBuilder.append(";syncLinkedWindowing:");
            stringBuilder.append(this.nns(this.syncLinkedWindowing));
            stringBuilder.append(";fullscreenIs1x1SeriesMatrix:");
            stringBuilder.append(this.nns(this.fullscreenIs1x1SeriesMatrix));
            stringBuilder.append(";fullscreenMatrix:");
            stringBuilder.append(this.nns(this.fullscreenMatrix));
            stringBuilder.append(";functionpanel:");
            stringBuilder.append(this.nns(this.functionpanel));
            stringBuilder.append(";functionPanelFixed:");
            stringBuilder.append(this.nns(this.functionPanelFixed));
            stringBuilder.append(this.nns(this.activeTab));
            stringBuilder.append(";functionsInFullscreen:");
            stringBuilder.append(this.nns(this.functionsInFullscreen));
            stringBuilder.append(";viewingSections:");
            stringBuilder.append(this.nns(this.viewingSections));
            stringBuilder.append(";interpolation:");
            stringBuilder.append(this.nns(this.interpolation));
            stringBuilder.append(";sharpenRadius:");
            stringBuilder.append(this.nns(this.sharpenRadius));
            stringBuilder.append(";sharpenAmount:");
            stringBuilder.append(this.nns(this.sharpenAmount));
            stringBuilder.append(";filter:");
            stringBuilder.append(this.nns(this.filter));
            stringBuilder.append(";claheClipLimit:");
            stringBuilder.append(this.nns(this.claheClipLimit));
            stringBuilder.append(";separateMultiframeSeries:");
            stringBuilder.append(this.nns(this.separateMultiframeSeries));
            stringBuilder.append(";priorStudiesDefinition:");
            stringBuilder.append(this.nns(this.studyDefinition.getPriorStudiesDefinition()));
            stringBuilder.append(";loadCriteriaRelatedStudies:");
            stringBuilder.append(this.nns(this.isLoadCriteriaRelatedStudies()));
            stringBuilder.append(";mammoAutoShutter:");
            stringBuilder.append(this.nns(this.mammoAutoShutter));
            stringBuilder.append(";mammoAlign:");
            stringBuilder.append(this.nns(this.mammoAlign));
            stringBuilder.append(";mammoShutterShowOutline:");
            stringBuilder.append(this.nns(this.mammoShutterShowOutline));
            stringBuilder.append(";balanceMammoMatrix:");
            stringBuilder.append(this.nns(this.balanceMammoMatrix));
            stringBuilder.append(";numberOfPlaceholders:");
            stringBuilder.append(this.nns(this.numberOfPlaceholders));
            stringBuilder.append(";mammoMlEqualsMlo:");
            stringBuilder.append(this.nns(this.mammoMlEqualsMlo));
            stringBuilder.append(";mergeMammoRecallStudies:");
            stringBuilder.append(this.nns(this.mergeMammoRecallStudies));
            stringBuilder.append(";mammoIgnoreForProcessing:");
            stringBuilder.append(this.nns(this.mammoIgnoreForProcessing));
            stringBuilder.append(";mammoProjectionLines:");
            stringBuilder.append(this.nns(this.mammoProjectionLines));
            stringBuilder.append(";mammoMamilaDistance:");
            stringBuilder.append(this.nns(this.mammoMamilaDistance));
            stringBuilder.append(";mammoMamilaPositions:");
            stringBuilder.append(this.nns(this.mammoMamilaPositions));
            stringBuilder.append(";mirrorLeftMammos:");
            stringBuilder.append(this.nns(this.mirrorLeftMammos));
            stringBuilder.append(";flipMainStudyLeft:");
            stringBuilder.append(this.nns(this.flipMainStudyLeft));
            stringBuilder.append(";flipMainStudyRight:");
            stringBuilder.append(this.nns(this.flipMainStudyRight));
            stringBuilder.append(";flipPriorStudyLeft:");
            stringBuilder.append(this.nns(this.flipPriorStudyLeft));
            stringBuilder.append(";flipPriorStudyRight:");
            stringBuilder.append(this.nns(this.flipTomoStudyLeft));
            stringBuilder.append(";flipTomoStudyRight:");
            stringBuilder.append(this.nns(this.flipTomoStudyRight));
            stringBuilder.append(";flipTomoStudyRight:");
            stringBuilder.append(this.nns(this.flipPriorStudyRight));
            stringBuilder.append(";mammoImageSorting:");
            stringBuilder.append(this.nns(this.tomoSlab));
            stringBuilder.append(";tomoSlab:");
            stringBuilder.append(this.nns(this.mammoImageSorting));
            stringBuilder.append(";mammoAcquisitionSorting:");
            stringBuilder.append(this.nns(this.mammoAcquisitionSorting));
            stringBuilder.append(";showNavigationBars:");
            stringBuilder.append(this.nns(this.showNavigationBars));
            stringBuilder.append(";rulerAdjustment:");
            stringBuilder.append(this.nns(this.rulerAdjustment));
            stringBuilder.append(";applyExistingImageRegistration:");
            stringBuilder.append(this.nns(this.applyExistingImageRegistration));
            stringBuilder.append(";createNewImageRegistration:");
            stringBuilder.append(this.nns(this.createNewImageRegistration));
            stringBuilder.append(";seriesConfigs:");
            stringBuilder.append(this.nns(this.seriesConfigs));
            stringBuilder.append(";showAsToolbarButton:");
            stringBuilder.append(this.nns(this.showAsToolbarButton));
            stringBuilder.append(";useInSecondBar:");
            stringBuilder.append(this.nns(this.useInSecondSymbolBar));
            stringBuilder.append(";showCutlines:");
            stringBuilder.append(this.nns(this.showCutlines));
            stringBuilder.append(";splitMultiframes:");
            stringBuilder.append(this.nns(this.splitMultiframes));
            stringBuilder.append(";multiframeAutoplay:");
            stringBuilder.append(this.nns(this.multiframeAutoplay));
            stringBuilder.append(";multiframeCycling:");
            stringBuilder.append(this.nns(this.multiframeCycling));
            stringBuilder.append(";sameSpeed:");
            stringBuilder.append(this.nns(this.sameSpeed));
            stringBuilder.append(";cineAutoPlay:");
            stringBuilder.append(this.nns(this.cineAutoPlay));
            stringBuilder.append(";cineFrameRate:");
            stringBuilder.append(this.nns(this.cineFrameRate));
            stringBuilder.append(";cineImageSelection:");
            stringBuilder.append(this.nns(this.cineImageSelection));
            stringBuilder.append(";startCineInFullscreen:");
            stringBuilder.append(this.nns(this.startCineInFullscreen));
            stringBuilder.append(";playMpgAviInFullscreen:");
            stringBuilder.append(this.nns(this.playMpgAviInFullscreen));
            stringBuilder.append(";suppressFullscreenComparemode:");
            stringBuilder.append(this.nns(this.suppressFullscreenComparemode));
            stringBuilder.append(";synchrScrollWithFittingPlanes:");
            stringBuilder.append(this.nns(this.synchrScrollWithFittingPlanes));
            stringBuilder.append(";thumbnailTreeConfig:");
            stringBuilder.append(this.nns(this.thumbnailTreeConfig));
            stringBuilder.append(";toolbarButtonImage_ServerPath:");
            stringBuilder.append(this.nns(this.toolbarButtonImageServerPath));
            stringBuilder.append(";toolbarButtonShortcut:");
            stringBuilder.append(this.nns(this.toolbarButtonShortcut));
            stringBuilder.append(";toolbarButtonOrder:");
            stringBuilder.append(this.nns(this.toolbarButtonOrder));
            stringBuilder.append(";useAutoImageOrientation:");
            stringBuilder.append(this.nns(this.useAutoImageOrientation));
            stringBuilder.append(";useAutomaticSorting:");
            stringBuilder.append(this.nns(this.useAutomaticSorting));
            stringBuilder.append(";useHangingProtocolAutomatically:");
            stringBuilder.append(this.nns(this.useHangingProtocolAutomatically));
            stringBuilder.append(";showFixedAnnotationPatientInfo:");
            stringBuilder.append(this.nns(this.showFixedAnnotationPatientInfo));
            stringBuilder.append(";showFixedAnnotationRuler:");
            stringBuilder.append(this.nns(this.showFixedAnnotationRuler));
            stringBuilder.append(";showFixedAnnotationOrientation:");
            stringBuilder.append(this.nns(this.showFixedAnnotationOrientation));
            stringBuilder.append(";showFixedAnnotationTomosynthesisSlab:");
            stringBuilder.append(this.nns(this.showFixedAnnotationTomosynthesisSlab));
            stringBuilder.append(";showFixedAnnotationUserDefined:");
            stringBuilder.append(this.nns(this.showFixedAnnotationUserDefined));
            stringBuilder.append(";showFixedAnnotationWindowLevelZoom:");
            stringBuilder.append(this.nns(this.showFixedAnnotationWindowLevelZoom));
            stringBuilder.append(";showFixedAnnotationImageNumber:");
            stringBuilder.append(this.nns(this.showFixedAnnotationImageNumber));
            stringBuilder.append(";viewingSectionMatrix:");
            stringBuilder.append(this.nns(this.viewingSectionMatrix));
            stringBuilder.append(";zoomToOriginalSizeInFullscreen:");
            stringBuilder.append(this.nns(this.zoomToOriginalSizeInFullscreen));
            stringBuilder.append(";waveformSignalType:");
            stringBuilder.append(this.nns(this.waveformSignalType));
            stringBuilder.append(";waveformLeadLayout:");
            stringBuilder.append(this.nns(this.waveformLeadLayout));
            stringBuilder.append(";waveformCompactView:");
            stringBuilder.append(this.nns(this.waveformCompactView));
            stringBuilder.append(";waveformCabreraView:");
            stringBuilder.append(this.nns(this.waveformCabreraView));
            stringBuilder.append(";waveformXScaling:");
            stringBuilder.append(this.nns(this.waveformXScaling));
            stringBuilder.append(";waveformGain:");
            stringBuilder.append(this.nns(this.waveformGain));
            stringBuilder.append(";waveformYSpacing:");
            stringBuilder.append(this.nns(this.waveformYSpacing));
            stringBuilder.append(";waveformAnchorLead:");
            stringBuilder.append(this.nns(this.waveformAnchorLead));
            stringBuilder.append(";waveform40HzFilter:");
            stringBuilder.append(this.nns(this.waveform40HzFilter));
            stringBuilder.append(";waveformHeader:");
            stringBuilder.append(this.nns(this.waveformHeader));
            stringBuilder.append(";waveformCalibrationPeak:");
            stringBuilder.append(this.nns(this.waveformCalibrationPeak));
            stringBuilder.append(";waveformBaseline:");
            stringBuilder.append(this.nns(this.waveformBaseline));
            stringBuilder.append(";waveformGridMM:");
            stringBuilder.append(this.nns(this.waveformGridMM));
            stringBuilder.append(";waveformGrid5MM:");
            stringBuilder.append(this.nns(this.waveformGrid5MM));
            stringBuilder.append(";waveformGridCM:");
            stringBuilder.append(this.nns(this.waveformGridCM));
            stringBuilder.append(";showCADMarkers:");
            stringBuilder.append(this.nns(this.showCADMarkers));
            stringBuilder.append(";cadMarkerResolution:");
            stringBuilder.append(this.nns(this.cadMarkerResolution));
            stringBuilder.append("]");
        }
        return stringBuilder.toString();
    }

    private String nns(Object object) {
        return object == null ? "undefined" : object.toString();
    }

    public List<StudyCriteria> getStudySelectionCriteria() {
        return this.studyDefinition.getStudySelectionCriteria();
    }

    public void setStudySelectionCriteria(List<StudyCriteria> list) {
        this.studyDefinition.setStudySelectionCriteria(list);
    }

    public void setHPSelectionCriteria(List<StudyCriteria> list) throws CriteriaConfigurationException {
        int n = 0;
        for (StudyCriteria studyCriteria : list) {
            Collections.sort(studyCriteria.getCriteriaList(), new CriterionResolverTypeComparator());
        }
        for (StudyCriteria studyCriteria : list) {
            try {
                if (!studyCriteria.isMainStudyCriteria()) continue;
                ++n;
            }
            catch (CriteriaConfigurationException criteriaConfigurationException) {
                throw HangingProtocol.a(criteriaConfigurationException);
            }
        }
        try {
            if (n > 1) {
                throw new CriteriaConfigurationException("More than one main study criteria object.");
            }
        }
        catch (CriteriaConfigurationException criteriaConfigurationException) {
            throw HangingProtocol.a(criteriaConfigurationException);
        }
        this.setStudySelectionCriteria(list);
    }

    public StudyCriteria getMainStudyCriteria() {
        for (StudyCriteria studyCriteria : this.getStudySelectionCriteria()) {
            if (!studyCriteria.isMainStudyCriteria()) continue;
            return studyCriteria;
        }
        return null;
    }

    public String dump(int n) {
        String string = StringTool.dupeString(n, "    ", null);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "hanging protocol - [hash='" + this.hashCode() + "', Priority Index='" + this.getPriorityIndex() + "', Is Start HP='" + this.useHangingProtocolAutomatically + "', , Alias='" + this.getAlias() + "']\n");
        for (int i = 0; i < this.getStudySelectionCriteria().size(); ++i) {
            StudyCriteria studyCriteria = this.getStudySelectionCriteria().get(i);
            if (studyCriteria.isMainStudyCriteria()) {
                stringBuilder.append(string + string + "criteria main study:\n");
            } else {
                stringBuilder.append(string + string + "criteria pre study:\n");
            }
            List<UUID> list = studyCriteria.getStudyCriteriaUUIDs();
            for (UUID uUID : list) {
                stringBuilder.append(string + string + string + "UID: " + uUID.toString() + "\n");
            }
            List<SeriesCriteria> list2 = studyCriteria.getSeriesCriteriaList();
            Iterator object2 = list2.iterator();
            while (object2.hasNext()) {
                SeriesCriteria seriesCriteria = (SeriesCriteria)object2.next();
                stringBuilder.append(string + string + "criteria series:\n");
                List<UUID> list3 = seriesCriteria.getSeriesCriteriaUUIDs();
                for (UUID uUID : list3) {
                    stringBuilder.append(string + string + string + "UID: " + uUID.toString() + "\n");
                }
            }
        }
        return stringBuilder.toString();
    }

    public int getPriorityIndex() {
        return this.studyDefinition.getPriority();
    }

    public void setPriorityIndex(int n) {
        this.studyDefinition.setPriority(n);
    }

    public boolean isStartHP() {
        Boolean bl = this.getUseHangingProtocolAutomatically();
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public Boolean getUseInSecondSymbolBar() {
        return this.useInSecondSymbolBar;
    }

    public void setUseInSecondSymbolBar(Boolean bl) {
        this.useInSecondSymbolBar = bl;
    }

    public boolean isValid() {
        return this.getStudySelectionCriteria() != null && this.getMainStudyCriteria() != null && this.getMainStudyCriteria().getCriteriaList() != null;
    }

    public void createOldStudyCriteria() {
        StudyCriteria studyCriteria = new StudyCriteria(true);
        studyCriteria.add(new CriterionResolverAdapter(UUID.randomUUID(), DicomTagNames.TAG_modality.toString(), this.studyDefinition.getMainStudyModality()));
        studyCriteria.add(new CriterionResolverAdapter(UUID.randomUUID(), DicomTagNames.TAG_studyDescription.toString(), this.studyDefinition.getMainStudyDescription()));
        ArrayList<StudyCriteria> arrayList = new ArrayList<StudyCriteria>();
        arrayList.add(studyCriteria);
        try {
            this.setHPSelectionCriteria(arrayList);
        }
        catch (CriteriaConfigurationException criteriaConfigurationException) {
            // empty catch block
        }
    }

    public boolean isLoadCriteriaRelatedStudies() {
        return this.studyDefinition.isLoadCriteriaRelatedStudies();
    }

    public void setLoadCriteriaRelatedStudies(boolean bl) {
        this.studyDefinition.setLoadCriteriaRelatedStudies(bl);
    }

    public void setMergedSeries(List<ab> list) {
        this.mergedSeries = list;
    }

    public List<ab> getMergedSeries() {
        return this.mergedSeries;
    }

    public void setWaveformLeadConfig(ad ad2) {
        this.waveformLeadConfig = ad2;
    }

    public ad getWaveformLeadConfig() {
        return this.waveformLeadConfig;
    }

    public void setWaveformLeadColor(Integer n) {
        this.waveformLeadColor = n;
    }

    public Integer getWaveformLeadColor() {
        return this.waveformLeadColor;
    }

    public Integer getWaveformGridMMColor() {
        return this.waveformGridMMColor;
    }

    public void setWaveformGridMMColor(Integer n) {
        this.waveformGridMMColor = n;
    }

    public Integer getWaveformGrid5MMColor() {
        return this.waveformGrid5MMColor;
    }

    public void setWaveformGrid5MMColor(Integer n) {
        this.waveformGrid5MMColor = n;
    }

    public Integer getWaveformGridCMColor() {
        return this.waveformGridCMColor;
    }

    public void setWaveformGridCMColor(Integer n) {
        this.waveformGridCMColor = n;
    }

    public Integer getWaveformGridBackgroundColor() {
        return this.waveformGridBackgroundColor;
    }

    public void setWaveformGridBackgroundColor(Integer n) {
        this.waveformGridBackgroundColor = n;
    }

    public int hashCode() {
        int n = 23 + this.getAlias().hashCode();
        n = n * 23 + this.getPriorityIndex();
        if (this.studyDefinition != null && this.studyDefinition.getMainStudyDescription() != null) {
            n = n * 23 + this.studyDefinition.getMainStudyDescription().hashCode();
        }
        if (this.studyDefinition != null && this.studyDefinition.getMainStudyModality() != null) {
            n = n * 23 + this.studyDefinition.getMainStudyModality().hashCode();
        }
        if (this.getStudySelectionCriteria() != null && !this.getStudySelectionCriteria().isEmpty()) {
            int n2 = 61;
            for (StudyCriteria studyCriteria : this.getStudySelectionCriteria()) {
                n2 += studyCriteria.hashCode();
            }
            n = n * 23 + n2;
        }
        n = n * 23 + (this.useHangingProtocolAutomatically == null ? 17 : this.useHangingProtocolAutomatically.hashCode());
        return n;
    }

    private static CriteriaConfigurationException a(CriteriaConfigurationException criteriaConfigurationException) {
        return criteriaConfigurationException;
    }
}

