/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.video;

import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.system.LibLoader;
import com.visustt.tools.system.OSVersion;
import com.visustt.tools.system.ac;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Supplier;

public class Image2WebMConverter {
    private static final Logger aa = LoggerFactory.getInstance("Image2WebMConverter");
    private int ab = Integer.getInteger("jx.vb.videoexport.bitrate", 5000);
    private int ac = 0;
    private long ad = 0L;

    public void aa(File file, int n, int n2, int n3) throws IOException {
        try {
            this.ac = 0;
            this.ad = 0L;
            Supplier[] supplierArray = new Supplier[5];
            supplierArray[0] = file::getAbsolutePath;
            supplierArray[1] = () -> this.ab;
            supplierArray[2] = () -> n;
            supplierArray[3] = () -> n2;
            supplierArray[4] = () -> n3;
            aa.debug("Creating new encoder: file={}, bitrate={}, framerate={}, width={}, height={}", supplierArray);
            this.ad = this.nativeCreate(file.getAbsolutePath(), this.ab, n, n2, n3);
            if (this.ad == 0L) {
                throw new IOException("Cannot create native video encoder module.");
            }
        }
        catch (IOException iOException) {
            throw Image2WebMConverter.a(iOException);
        }
    }

    public void aa(BufferedImage bufferedImage) throws IOException {
        block10: {
            try {
                if (bufferedImage == null) {
                    aa.debug("Added <null> image for encoding, skipping");
                    return;
                }
            }
            catch (IOException iOException) {
                throw Image2WebMConverter.a(iOException);
            }
            try {
                try {
                    if (bufferedImage.getType() == 5 && bufferedImage.getData().getDataBuffer() instanceof DataBufferByte) break block10;
                }
                catch (IOException iOException) {
                    throw Image2WebMConverter.a(iOException);
                }
                throw new IOException("Cannot use image for video encoding, image-type is " + bufferedImage.getType() + ", buffer-type is " + bufferedImage.getData().getDataBuffer().getClass().getSimpleName());
            }
            catch (IOException iOException) {
                throw Image2WebMConverter.a(iOException);
            }
        }
        Supplier[] supplierArray = new Supplier[3];
        supplierArray[0] = bufferedImage::getType;
        supplierArray[1] = bufferedImage::getWidth;
        supplierArray[2] = bufferedImage::getHeight;
        aa.debug("Added new image for encoding, type={}, width={}, height={}", supplierArray);
        int n = this.nativeEncode(this.ad, ((DataBufferByte)bufferedImage.getData().getDataBuffer()).getData(), this.ac);
        try {
            if (n == 0) {
                throw new IOException("Failed to encode image, error code " + n);
            }
        }
        catch (IOException iOException) {
            throw Image2WebMConverter.a(iOException);
        }
        ++this.ac;
    }

    public void aa() throws IOException {
        int n = this.nativeFinish(this.ad);
        try {
            if (n == 0) {
                throw new IOException("Failed to finisch encoding, error code " + n);
            }
        }
        catch (IOException iOException) {
            throw Image2WebMConverter.a(iOException);
        }
    }

    public void ab() {
        this.nativeDelete(this.ad);
        this.ac = 0;
        this.ad = 0L;
    }

    private native long nativeCreate(String var1, int var2, int var3, int var4, int var5);

    private native int nativeEncode(long var1, byte[] var3, int var4);

    private native int nativeFinish(long var1);

    private native void nativeDelete(long var1);

    static {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (OSVersion.isWindows()) {
            if (com.visustt.tools.system.ac.aa() && OSVersion.is64BitOS()) {
                arrayList.add("libwinpthread-1");
                arrayList.add("libgcc_s_seh-1");
                arrayList.add("libstdc++-6");
                arrayList.add("libvpxjni");
            } else {
                arrayList.add("libwinpthread-1");
                arrayList.add("libgcc_s_dw2-1");
                arrayList.add("libstdc++-6");
                arrayList.add("libvpxjni");
            }
            if (!LibLoader.loadLibraries(arrayList, null)) {
                aa.fatal("Cannot instantiate native VPX library (load failed)");
            }
        } else {
            aa.fatal("Cannot instantiate native VPX library (non-Windows system)");
        }
    }

    private static IOException a(IOException iOException) {
        return iOException;
    }
}

