/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.swing;

import com.visustt.jiveX.general.data.event.rv.RVEventGroup;
import com.visustt.jiveX.tools.ad.ab.aj;
import com.visustt.jiveX.tools.ad.ai;
import com.visustt.jiveX.tools.swing.ab.ab;
import com.visustt.jiveX.tools.swing.ah.aa;
import com.visustt.jiveX.tools.swing.ah.ac;
import com.visustt.jiveX.tools.swing.al;
import com.visustt.jiveX.tools.swing.am;
import com.visustt.tools.awt.event.KeyboardHandler;
import com.visustt.tools.awt.screen.Monitor;
import com.visustt.tools.awt.screen.ScreenProperties;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.system.OSVersion;
import de.pixopia.visuslaf.support.VisusLafControl;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class VisusJFrame
extends JFrame {
    private static final String TITLE_TEMPLATE = "${APP} ${VER}${SPACE1}${USER}${SPACE2}${MISC}";
    private static String titleSpacer = "               ";
    private boolean maximizedPending = false;
    private String titleApplication = "";
    private String titleVersion = "";
    private String titleUserName = "";
    private String titleMiscInfo = "";
    private com.visustt.jiveX.tools.swing.aj.aa.aa debugRepaintLayeredPane = null;
    private boolean isAlreadyScaled = false;
    private boolean neverScaleFrameSize = false;
    private boolean isCurrentlyScaled = false;
    private boolean isMaximized = false;
    protected float scalingFactor;
    protected ComponentAdapter componentAdapter;
    protected am mouseAdapter;
    private Rectangle oldBounds;
    private ScreenProperties screenProperties;
    private boolean disableNativeMouselistener = Boolean.parseBoolean(System.getProperty("jx.disableNativeMouselistener", "false"));

    public VisusJFrame() {
        this("");
    }

    public VisusJFrame(String string) {
        this.constructor(string);
    }

    public VisusJFrame(String string, ScreenProperties screenProperties, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.screenProperties = screenProperties;
        this.constructor(string);
    }

    public VisusJFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.constructor(string);
    }

    public VisusJFrame(GraphicsConfiguration graphicsConfiguration) {
        this("", graphicsConfiguration);
    }

    @Override
    public Container getContentPane() {
        if (this.debugRepaintLayeredPane == null && Boolean.getBoolean("jx.debug.repaint")) {
            this.debugRepaintLayeredPane = new com.visustt.jiveX.tools.swing.aj.aa.aa(super.getContentPane());
            super.setContentPane(this.debugRepaintLayeredPane);
        }
        if (this.debugRepaintLayeredPane != null) {
            return this.debugRepaintLayeredPane.aa();
        }
        return super.getContentPane();
    }

    @Override
    public void setContentPane(Container container) {
        if (this.debugRepaintLayeredPane != null) {
            this.debugRepaintLayeredPane.aa(container);
        } else {
            super.setContentPane(container);
        }
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        if (this.disableNativeMouselistener) {
            this.setMaximized(this.calculateMaximizedState());
        }
    }

    @Override
    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        if (this.disableNativeMouselistener) {
            this.setMaximized(this.calculateMaximizedState());
        }
    }

    @Override
    public void setExtendedState(int n) {
        if (!this.disableNativeMouselistener) {
            super.setExtendedState(n);
        } else {
            if (this.mouseAdapter.ad()) {
                return;
            }
            this.setMaximized(this.calculateMaximizedState());
            boolean bl = this.isTriggerPressed();
            this.setExtendedStateToMaximizeBoth(n, bl);
            if (n == 6) {
                if (!bl) {
                    Rectangle rectangle = this.calculateMaximizedBounds();
                    this.setExtendedStateToNormal();
                    if (!this.isMaximized()) {
                        if (!this.checkIfBoundsWithin5PixelOfTopOfScreen(this.getBounds())) {
                            this.storeBounds();
                        }
                        this.setBounds(rectangle);
                        this.setMaximized(true);
                    } else {
                        this.recoverBounds();
                    }
                } else {
                    this.maximizeFrameForTwoScreens(true);
                }
            }
        }
        this.notifyObserver(aj.aa.FRAME_RESIZED_AND_MOUSE_RELEASED);
    }

    protected boolean isTriggerPressed() {
        return KeyboardHandler.getCurrentKeyDown() == 17;
    }

    protected void setExtendedStateToNormal() {
        super.setExtendedState(0);
    }

    protected void setExtendedStateToMaximizeBoth(int n, boolean bl) {
        if (!bl || n != 6) {
            super.setExtendedState(n);
        }
    }

    protected Rectangle calculateMaximizedBounds() {
        Rectangle rectangle;
        if (this.isShowing()) {
            rectangle = this.getBounds();
        } else {
            rectangle = ScreenProperties.calculateDefaultScreensizeWithoutTaskbar();
            this.setOldBounds(this.getBounds());
        }
        this.subtractInsets(rectangle);
        return rectangle;
    }

    protected void subtractInsets(Rectangle rectangle) {
        rectangle.width = (int)(rectangle.getWidth() - (double)this.getInsets().left - (double)this.getInsets().right);
        rectangle.height = (int)(rectangle.getHeight() - (double)this.getInsets().top - (double)this.getInsets().bottom);
        rectangle.y = (int)(rectangle.getY() + (double)this.getInsets().top);
        rectangle.x = (int)(rectangle.getX() + (double)this.getInsets().left);
    }

    protected boolean calculateMaximizedState() {
        GraphicsConfiguration graphicsConfiguration;
        Rectangle rectangle;
        Monitor monitor;
        return this.isShowing() && (monitor = this.getCurrentMonitorShowingFrame()) != null && (rectangle = this.calculateScreenSizeWithoutTaskbar(graphicsConfiguration = monitor.getGraphicsDevice().getDefaultConfiguration())).equals(this.getBounds());
    }

    protected Rectangle calculateScreenSizeWithoutTaskbar(GraphicsConfiguration graphicsConfiguration) {
        return ScreenProperties.calculateScreensizeWithoutTaskbar(graphicsConfiguration);
    }

    protected Monitor getCurrentMonitorShowingFrame() {
        if (!this.isShowing()) {
            return null;
        }
        Vector<Monitor> vector = this.screenProperties.getAllMonitorsShowingComponent(this, 10, true);
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        return vector.firstElement();
    }

    public void storeBounds() {
        this.setOldBounds(new Rectangle(this.getBounds()));
        if (this.checkIfBoundsWithin5PixelOfTopOfScreen(this.getOldBounds())) {
            this.setOldBoundsOffset();
        }
    }

    private void setOldBoundsOffset() {
        this.getOldBounds().setBounds(this.getOldBounds().x + 10, this.getOldBounds().y + 10, this.getOldBounds().width - 10, this.getOldBounds().height - 10);
    }

    boolean checkIfBoundsWithin5PixelOfTopOfScreen(Rectangle rectangle) {
        Monitor monitor = this.getCurrentMonitorShowingFrame();
        return monitor != null && rectangle.getY() <= (double)(monitor.getY() + 5);
    }

    private void recoverBounds() {
        if (this.getOldBounds() == null) {
            this.setOldBounds(new Rectangle(this.getBounds()));
            this.setOldBoundsOffset();
        }
        this.setBounds(this.getOldBounds());
    }

    protected void addAdapter() {
        this.componentAdapter = new al(this);
        this.mouseAdapter = new am(this);
        this.addMouseListener(this.mouseAdapter);
        this.addComponentListener(this.componentAdapter);
    }

    public void switchAdapter(ComponentAdapter componentAdapter, am am2) {
        this.removeMouseListener(this.mouseAdapter);
        this.removeComponentListener(this.componentAdapter);
        this.componentAdapter = componentAdapter;
        this.mouseAdapter = am2;
        this.addMouseListener(am2);
        this.addComponentListener(componentAdapter);
    }

    private void constructor(String string) {
        if (this.screenProperties == null) {
            this.screenProperties = new ScreenProperties();
        }
        this.setTitle(string);
        this.addAdapter();
        KeyboardHandler.getCurrentKeyDown();
        ab.aa((Window)this);
        this.getContentPane();
    }

    @Override
    public void dispose() {
        ComponentListener[] componentListenerArray;
        aa aa10 = ac.aa(this);
        if (aa10 != null) {
            aa10.ab();
        }
        for (ComponentListener componentListener : componentListenerArray = this.getComponentListeners()) {
            this.removeComponentListener(componentListener);
        }
        this.removeMouseListener(this.mouseAdapter);
        this.mouseAdapter = null;
        this.componentAdapter = null;
        VisusJFrame.cleanUpChildComponents(this.getContentPane());
        super.dispose();
    }

    protected static void cleanUpChildComponents(Container container) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = container.getComponent(i);
            if (!(component instanceof Container)) continue;
            VisusJFrame.cleanUpChildComponents((Container)component);
        }
    }

    public void notifyObserver(aj.aa aa10) {
        aj aj2 = new aj(aa10);
        ai.aa(RVEventGroup.General, aj2);
    }

    private void updateTitle() {
        String string = TITLE_TEMPLATE;
        String string2 = this.titleApplication == null ? "" : this.titleApplication;
        String string3 = this.titleVersion == null ? "" : this.titleVersion;
        String string4 = this.titleUserName == null ? "" : this.titleUserName;
        String string5 = this.titleMiscInfo == null ? "" : this.titleMiscInfo;
        string = StringTool.replaceString(string, "${APP}", string2);
        string = StringTool.replaceString(string, "${VER}", string3);
        string = StringTool.replaceString(string, "${USER}", string4);
        string = StringTool.replaceString(string, "${MISC}", string5);
        string = string4.length() > 0 ? StringTool.replaceString(string, "${SPACE1}", titleSpacer) : StringTool.replaceString(string, "${SPACE1}", "");
        string = string5.length() > 0 ? StringTool.replaceString(string, "${SPACE2}", titleSpacer) : StringTool.replaceString(string, "${SPACE2}", "");
        this.setTitle(string);
    }

    public void setApplicationName(String string) {
        this.titleApplication = string;
        this.updateTitle();
    }

    public void setApplicationVersion(String string) {
        this.titleVersion = string;
        this.updateTitle();
    }

    public void setApplicationUser(String string) {
        this.titleUserName = string;
        this.updateTitle();
    }

    public void setMiscTitleInfo(String string) {
        this.titleMiscInfo = string;
        this.updateTitle();
    }

    public static void setTitleSpacerLength(int n) {
        int n2 = n;
        if (n2 < 1) {
            n2 = 1;
        } else if (n2 > 100) {
            n2 = 100;
        }
        titleSpacer = "";
        for (int i = 0; i < n2; ++i) {
            titleSpacer = titleSpacer + " ";
        }
    }

    public String getApplicationName() {
        return this.titleApplication;
    }

    public String getApplicationVersion() {
        return this.titleVersion;
    }

    public String getApplicationUser() {
        return this.titleUserName;
    }

    public String getMiscTitleInfo() {
        return this.titleMiscInfo;
    }

    public int getTitleSpacerLength() {
        return titleSpacer.length();
    }

    public boolean isFrameMaximized() {
        return this.getExtendedState() == 6;
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        KeyboardHandler.processKeyEvent(keyEvent);
        super.processKeyEvent(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maximizeFrameForTwoScreens(boolean bl) {
        Object object;
        Rectangle rectangle;
        block14: {
            Vector<Integer> vector;
            List<Monitor> list;
            block15: {
                Monitor monitor;
                block13: {
                    Monitor monitor2;
                    if (this.isMaximizedPending() || !bl) {
                        return;
                    }
                    rectangle = this.getBounds();
                    list = this.screenProperties.getAllMonitorsSortedByLocation();
                    vector = this.calculateMonitorsShowingFrame(rectangle, list);
                    if (!OSVersion.isWindows()) {
                        rectangle = this.screenProperties.getAllMonitorsShowingComponent(this, 10, true).firstElement().getScreenRect();
                    }
                    if (vector.size() != 2) break block13;
                    object = list.get(vector.get(0));
                    if (!((Monitor)object).isSameSizeAs(monitor2 = list.get(vector.get(1)))) break block14;
                    rectangle = ((Monitor)object).getScreenRect().union(monitor2.getScreenRect());
                    break block14;
                }
                if (vector.size() != 3) break block15;
                object = list.get(vector.get(1));
                if (!((Monitor)object).isSameSizeAs(monitor = list.get(vector.get(2)))) break block14;
                rectangle = ((Monitor)object).getScreenRect().union(monitor.getScreenRect());
                break block14;
            }
            if (vector.size() == 1) {
                object = list.get(vector.get(0));
                for (int i = 0; i < list.size(); ++i) {
                    Monitor monitor = list.get(i);
                    if (i == vector.get(0) || !((Monitor)object).isSameSizeAs(monitor) || !monitor.isLeftOf((Monitor)object) && !monitor.isRightOf((Monitor)object)) continue;
                    rectangle = monitor.getScreenRect().union(((Monitor)object).getScreenRect());
                    break;
                }
            }
        }
        object = this;
        synchronized (object) {
            if (this.getBounds().equals(rectangle)) {
                return;
            }
            this.setMaximizedPending(true);
            Rectangle rectangle2 = this.screenProperties.calculateTaskbarBounds(true);
            if (rectangle2 != null) {
                this.setTwoMonitorsFrameBoundsConsiderTaskbar(rectangle);
            } else if (OSVersion.isWindows()) {
                int n = this.getState();
                if (n != 1) {
                    this.setState(1);
                }
                this.setBounds(rectangle);
                this.setState(n);
            } else {
                this.setExtendedState(0);
                this.setBounds(rectangle);
            }
            this.correctTwoMonitorsFrameBoundsConsiderWindows10();
            this.setMaximized(false);
            this.storeBounds();
            this.setMaximizedPending(false);
        }
    }

    void correctTwoMonitorsFrameBoundsConsiderWindows10() {
        if (this.isWindows10()) {
            int n = Integer.getInteger("jx.screen.windows10maximizeOffset", 7);
            Rectangle rectangle = this.getBounds();
            rectangle.x -= n;
            rectangle.width += 2 * n;
            rectangle.height += n;
            this.setBounds(rectangle);
        }
    }

    boolean isWindows10() {
        return OSVersion.isWindows10();
    }

    void setTwoMonitorsFrameBoundsConsiderTaskbar(Rectangle rectangle) {
        Insets insets = this.getTaskbarInsets();
        if (insets != null && (insets.top != 0 || insets.right != 0 || insets.bottom != 0 || insets.left != 0)) {
            Rectangle rectangle2 = new Rectangle(rectangle);
            if (insets.top != 0) {
                rectangle2.height -= insets.top;
                rectangle2.y += insets.top;
            } else if (insets.right != 0) {
                rectangle2.width -= insets.right;
            } else if (insets.bottom != 0) {
                rectangle2.height -= insets.bottom;
            } else if (insets.left != 0) {
                rectangle2.width -= insets.left;
                rectangle2.x += insets.left;
            }
            this.setBounds(rectangle2);
            this.repaint();
        } else {
            this.setBounds(rectangle);
            this.repaint();
        }
    }

    Insets getTaskbarInsets() {
        return Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
    }

    protected Vector<Integer> calculateMonitorsShowingFrame(Rectangle rectangle, List<Monitor> list) {
        Vector<Integer> vector = new Vector<Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            Monitor monitor = list.get(i);
            if (!monitor.coversGivenPercentOrMore(rectangle, 25.0)) continue;
            vector.add(i);
        }
        return vector;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && !this.isVisible()) {
            this.scaleFrameSize();
            this.scaleComponent();
        } else if (this.isVisible() && !bl) {
            this.unscaleFrameSize();
        }
        super.setVisible(bl);
    }

    protected void scaleFrameSize() {
        Point point = this.getLocation();
        Monitor monitor = ScreenProperties.getMonitorAtScreenPosition(point);
        this.scaleFrameSize(monitor, false);
    }

    public void scaleFrameSize(Monitor monitor, boolean bl) {
        boolean bl2;
        if (this.neverScaleFrameSize) {
            return;
        }
        boolean bl3 = this.isVisible();
        boolean bl4 = bl2 = !this.isFrameMaximized() && monitor != null && this.hasUIScalingAdapter() && !this.isAlreadyScaled;
        if ((!bl3 || bl) && bl2) {
            this.scalingFactor = monitor.getScalingFactor();
            if (this.scalingFactor > 0.0f) {
                Dimension dimension = this.getPreferredSize();
                double d = dimension.getWidth() * (double)this.scalingFactor;
                double d2 = dimension.getHeight() * (double)this.scalingFactor;
                dimension.setSize(d, d2);
                this.setSize(dimension);
                this.setPreferredSize(dimension);
                this.setCurrentlyScaled(true);
            }
        }
        this.isAlreadyScaled = false;
    }

    protected void scaleComponent() {
        float f = VisusLafControl.get().getLocalScale((JComponent)this.rootPane, 0, true);
        if (this.scalingFactor > 0.0f && Float.compare(this.scalingFactor, f) != 0) {
            VisusLafControl.get().setLocalScale((JComponent)this.rootPane, this.scalingFactor, 0, true);
        }
    }

    protected void unscaleFrameSize() {
        Vector<Monitor> vector;
        Monitor monitor = ScreenProperties.getMonitorAtScreenPosition(this.getLocationOnScreen());
        if (monitor == null && (vector = ScreenProperties.getAllMonitorsShowingApplication(this, 60)).size() == 1) {
            monitor = vector.elementAt(0);
        }
        this.unscaleFrameSize(monitor);
    }

    public void unscaleFrameSize(Monitor monitor) {
        Dimension dimension;
        boolean bl = this.isVisible();
        if (bl && this.hasUIScalingAdapter() && (dimension = this.getUnscaledSize(monitor)) != null) {
            this.setPreferredSize(dimension);
            this.setCurrentlyScaled(false);
            this.scalingFactor = 1.0f;
        }
    }

    public boolean hasUIScalingAdapter() {
        return aa.aa(this) != null;
    }

    public void setHasUIScalingAdapter(boolean bl) {
        if (bl && !this.hasUIScalingAdapter()) {
            ac.aa(this);
        } else if (!bl && this.hasUIScalingAdapter()) {
            aa.ab(this);
        }
    }

    public boolean isAlreadyScaled() {
        return this.isAlreadyScaled;
    }

    public void setAlreadyScaled(boolean bl) {
        this.isAlreadyScaled = bl;
    }

    public Dimension getUnscaledSize(Monitor monitor) {
        double d;
        if (this.isVisible() && monitor != null && (d = (double)monitor.getScalingFactor()) > 0.0) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            if (this.isFrameMaximized()) {
                Dimension dimension = this.getPreferredSize();
                n = dimension.width;
                n2 = dimension.height;
            }
            n = (int)((double)n / d);
            n2 = (int)((double)n2 / d);
            return new Dimension(n, n2);
        }
        return null;
    }

    public boolean isNeverScaleFrameSize() {
        return this.neverScaleFrameSize;
    }

    public void setNeverScaleFrameSize(boolean bl) {
        this.neverScaleFrameSize = bl;
    }

    public boolean isCurrentlyScaled() {
        return this.isCurrentlyScaled;
    }

    public void setCurrentlyScaled(boolean bl) {
        this.isCurrentlyScaled = bl;
    }

    public boolean isMaximized() {
        return this.isMaximized;
    }

    public void setMaximized(boolean bl) {
        this.isMaximized = bl;
    }

    public Rectangle getOldBounds() {
        return this.oldBounds;
    }

    public void setOldBounds(Rectangle rectangle) {
        this.oldBounds = rectangle;
    }

    public boolean isMaximizedPending() {
        return this.maximizedPending;
    }

    public void setMaximizedPending(boolean bl) {
        this.maximizedPending = bl;
    }

    public boolean useNativeMouselistener() {
        return this.disableNativeMouselistener;
    }
}

