/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.net;

import com.visustt.jiveX.general.message.ImageResponseMessage;
import com.visustt.jiveX.general.message.JiveMessage;
import com.visustt.jiveX.general.message.TCPMessageSendUtils;
import com.visustt.jiveX.tools.net.LoginException;
import com.visustt.jiveX.tools.net.af;
import com.visustt.net.aa;
import com.visustt.tools.ah.ab;
import com.visustt.tools.control.license.util.VisusVersionString;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.io.Closeables;
import com.visustt.tools.net.Localhost;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class RemoteTCPConnection {
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    protected static final Logger logger = LoggerFactory.getInstance("jx.tools.net.TCPConnection");
    public static String JIVEX_SERVER = "JiveX-Server";
    public static String JIVEX_LOCAL = "localWorklist";
    private Socket socket;
    private int port;
    private String host;
    private DataInputStream in;
    private DataOutputStream out;
    private int connectTimeout = 5000;
    private int socketTimeout = 5000;
    private boolean connectionOpen = false;
    private String connectionName;
    private final List<af> listenerList = new ArrayList<af>();
    private VisusVersionString clientVersion;

    public RemoteTCPConnection(String string, int n, int n2, VisusVersionString visusVersionString) throws UnknownHostException {
        this(string, n, n2, JIVEX_SERVER, visusVersionString);
    }

    public RemoteTCPConnection(String string, int n, int n2, String string2, VisusVersionString visusVersionString) throws UnknownHostException {
        this.host = string;
        this.port = n;
        this.socketTimeout = n2;
        this.connectionName = string2;
        this.clientVersion = visusVersionString;
        this.setHost(string);
    }

    public final String getHost() {
        return this.host;
    }

    public final int getPort() {
        return this.port;
    }

    public void setHost(String string) throws UnknownHostException {
        string = this.isUndefined(string) ? Localhost.getLocalHostIP() : InetAddress.getByName(string).getHostAddress();
        this.host = string;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }

    public synchronized void connectionOpen() throws LoginException {
        this.connectionOpen(this.getConnectTimeout());
    }

    public synchronized void connectionOpen(int n) throws LoginException {
        try {
            if (this.connectionOpen_(n)) {
                this.fireConnectionOpened();
            }
        }
        catch (IOException iOException) {
            this.connectionClose();
            throw new LoginException(iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            this.connectionClose();
            throw new LoginException(exception.getMessage(), exception);
        }
    }

    protected synchronized boolean connectionOpen_(int n) throws Exception {
        block10: {
            try {
                try {
                    if (this.host == null || !"".equals(this.host.trim())) break block10;
                }
                catch (Exception exception) {
                    throw RemoteTCPConnection.b(exception);
                }
                this.host = null;
            }
            catch (Exception exception) {
                throw RemoteTCPConnection.b(exception);
            }
        }
        String string = this.getHostInfo();
        try {
            if (logger.debugIsEnabled()) {
                logger.debug("Connecting to host:" + string);
            }
        }
        catch (Exception exception) {
            throw RemoteTCPConnection.b(exception);
        }
        try {
            this.socket = aa.aa(this.host, this.port, n);
            this.socket.setSoTimeout(this.socketTimeout);
            this.socket.setReuseAddress(true);
            if (logger.debugIsEnabled()) {
                logger.debug("Connected to host:" + string);
            }
        }
        catch (Exception exception) {
            throw RemoteTCPConnection.b(exception);
        }
        this.out = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream(), 8192));
        this.out.flush();
        this.in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 8192));
        this.connectionOpen = true;
        return this.connectionOpen;
    }

    public final String getHostInfo() {
        return this.host + ":" + this.port;
    }

    public synchronized void sendMessage(JiveMessage jiveMessage) throws IOException {
        block9: {
            block8: {
                try {
                    if (logger.debugIsEnabled()) {
                        logger.debug("JiveTCPConnection.sendMessage(): " + jiveMessage);
                    }
                }
                catch (IOException iOException) {
                    throw RemoteTCPConnection.b(iOException);
                }
                try {
                    if (this.out == null) break block8;
                    TCPMessageSendUtils.sendMessage(jiveMessage, this.out);
                    break block9;
                }
                catch (IOException iOException) {
                    throw RemoteTCPConnection.b(iOException);
                }
            }
            try {
                if (logger.debugIsEnabled()) {
                    logger.debug("Unable to send message. Stream already closed.");
                }
            }
            catch (IOException iOException) {
                throw RemoteTCPConnection.b(iOException);
            }
        }
    }

    public synchronized JiveMessage getMessage() throws IOException {
        try {
            return this.getMessage_();
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            logger.error((Object)("getMessage failed to create Object:" + exception.getMessage()), exception);
            return null;
        }
    }

    protected synchronized JiveMessage getMessage_() throws Exception {
        JiveMessage jiveMessage = null;
        if (!logger.debugIsEnabled()) {
            jiveMessage = TCPMessageSendUtils.getMessage(this.in);
        } else {
            logger.debug("JiveTCPConnection.getJiveMessage(): ");
            long l = System.currentTimeMillis();
            jiveMessage = TCPMessageSendUtils.getMessage(this.in);
            long l2 = System.currentTimeMillis();
            logger.debug("JiveTCPConnection.getJiveMessage(): " + jiveMessage + ", Time: " + (l2 - l));
        }
        try {
            if (jiveMessage instanceof ImageResponseMessage) {
                ((ImageResponseMessage)jiveMessage).setConnectionName(this.connectionName);
            }
        }
        catch (Exception exception) {
            throw RemoteTCPConnection.b(exception);
        }
        return jiveMessage;
    }

    public void connectionClose() {
        try {
            if (logger.debugIsEnabled()) {
                logger.debug("Closing connection to " + this.connectionName);
            }
        }
        catch (IOException iOException) {
            throw RemoteTCPConnection.b(iOException);
        }
        try {
            if (this.in != null) {
                Closeables.close(this.in);
                this.in = null;
            }
        }
        catch (IOException iOException) {
            throw RemoteTCPConnection.b(iOException);
        }
        try {
            if (this.out != null) {
                Closeables.close(this.out);
                this.out = null;
            }
        }
        catch (IOException iOException) {
            throw RemoteTCPConnection.b(iOException);
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                logger.info((Object)("Failed to close socket of connection to " + this.connectionName), iOException);
            }
            this.socket = null;
        }
        this.fireConnectionClosed();
        this.connectionOpen = false;
    }

    public String getName() {
        return this.connectionName;
    }

    public final void setName(String string) {
        this.connectionName = string;
    }

    private boolean isUndefined(String string) {
        return string == null || string.trim().length() == 0;
    }

    public boolean isConnectionOpen() {
        return this.connectionOpen;
    }

    public final int getTimeOutMs() {
        return this.socketTimeout;
    }

    public final void setTimeOutMs(int n) {
        block4: {
            try {
                this.socketTimeout = n;
                if (!this.connectionOpen || this.socket == null) break block4;
            }
            catch (SocketException socketException) {
                throw RemoteTCPConnection.b(socketException);
            }
            try {
                this.socket.setSoTimeout(n);
            }
            catch (SocketException socketException) {
                logger.error((Object)"Error updating timeout.", socketException);
            }
        }
    }

    protected VisusVersionString getClientVersion() {
        return this.clientVersion;
    }

    protected void fireConnectionOpened() {
        for (af af2 : this.listenerList) {
            af2.aa(this.host);
        }
    }

    protected void fireConnectionClosed() {
        Vector<af> vector = new Vector<af>();
        for (af af2 : this.listenerList) {
            af2.ab(this.host);
            if (!af2.aa()) continue;
            if (logger.debugIsEnabled()) {
                logger.debug("Removing connection listener from connection: " + this.connectionName);
            }
            vector.add(af2);
        }
        this.listenerList.removeAll(vector);
    }

    public void addConnectionListener(af af2) {
        if (!this.listenerList.contains(af2)) {
            if (logger.debugIsEnabled()) {
                logger.debug("Adding connection listener to connection: " + this.connectionName);
            }
            this.listenerList.add(af2);
        }
    }

    public boolean removeConnectionListener(af af2) {
        if (logger.debugIsEnabled()) {
            logger.debug("Removing connection listener from connection: " + this.connectionName);
        }
        return this.listenerList.remove(af2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("JiveTCPConnection [connectionName=").append(this.connectionName);
        stringBuffer.append(", host=").append(this.host);
        stringBuffer.append(", port=").append(this.port);
        stringBuffer.append(", socketTimeout=");
        stringBuffer.append(ab.ao(this.socketTimeout));
        stringBuffer.append(", connectTimeout=");
        stringBuffer.append(ab.ao(this.connectTimeout));
        stringBuffer.append(", isConnectionOpen=").append(this.connectionOpen);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

