/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.database.utils;

import com.visustt.jiveX.tools.database.dbms.DbAccessor;
import com.visustt.jiveX.tools.database.dbms.JiveDbmsException;
import com.visustt.jiveX.tools.database.structure.ab;
import com.visustt.jiveX.tools.database.structure.ae;
import com.visustt.jiveX.tools.database.utils.aa;
import com.visustt.jiveX.tools.database.utils.ad;
import com.visustt.log.Log4JLoggerConfiguration;
import com.visustt.tools.config.main.ConfigurationException;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.io.FileAccess;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.Level;

public class DatabaseUtilRunner {
    public DatabaseUtilRunner(String[] stringArray) throws JiveDbmsException, SQLException, IllegalArgumentException, FileNotFoundException, ClassNotFoundException, InstantiationException, IllegalAccessException, IOException, ConfigurationException {
        System.out.println("\n---=> Database Utils started <=---");
        if (stringArray.length < 3) {
            this.printSyntax(System.out);
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        Properties properties = this.createLoginProperties(stringArray);
        ab ab5 = new ab(FileAccess.getStream(string2));
        this.executeDatabaseOperation(string, ab5, string3, properties);
    }

    private Properties createLoginProperties(String[] stringArray) {
        Properties properties = null;
        if (stringArray.length > 3) {
            properties = new Properties();
            try {
                properties.setProperty("user", stringArray[3]);
                if (stringArray.length > 4) {
                    properties.setProperty("password", stringArray[4]);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DatabaseUtilRunner.a(illegalArgumentException);
            }
        }
        return properties;
    }

    private void printSyntax(PrintStream printStream) {
        printStream.println("\nNo parameters specified to run the application:");
        printStream.println("\nDatabaseUtils <dburl> <xmlfile> <operation> <user> <password>");
        printStream.println("The following operations are supported: CREATE-TABLES");
        printStream.println("                                        CREATE-DATABASE");
        printStream.println("                                        CREATE-KEYS");
        printStream.println("                                        DROP-TABLES");
        printStream.println("                                        DROP-DATABASE");
        printStream.println("                                        INFO-DATABASE");
    }

    public static void updateTables(String string, ab ab5, String string2, String string3) throws IllegalArgumentException, SQLException, JiveDbmsException {
        Properties properties = aa.ac(string, null);
        string = aa.ad(string);
        try {
            if (string2 != null) {
                properties.setProperty("user", string2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DatabaseUtilRunner.a(illegalArgumentException);
        }
        try {
            if (string3 != null) {
                properties.setProperty("password", string3);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DatabaseUtilRunner.a(illegalArgumentException);
        }
        DatabaseUtilRunner.updateTables(string, ab5, properties);
    }

    public static void updateTables(String string, ab ab5, Properties properties) throws IllegalArgumentException, SQLException, JiveDbmsException {
        properties = aa.ac(string, properties);
        string = aa.ad(string);
        try {
            if (!aa.ad(string, properties)) {
                aa.aa(string, properties);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DatabaseUtilRunner.a(illegalArgumentException);
        }
        Vector<String> vector = aa.aa(string, ab5.ab(), properties);
        DbAccessor dbAccessor = DbAccessor.getAccessor(string);
        ad ad2 = new ad(dbAccessor);
        dbAccessor.connect(properties);
        for (int i = 0; i < vector.size(); ++i) {
            ae ae2 = ab5.aa(vector.elementAt(i));
            try {
                try {
                    ad2.aa(ae2, true);
                    ad2.ab(ae2, true);
                    if (string.contains("jdbc:hsqldb") || !dbAccessor.supportsForeignKeys(ae2.aa())) continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DatabaseUtilRunner.a(illegalArgumentException);
                }
                ad2.ac(ae2, true);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DatabaseUtilRunner.a(illegalArgumentException);
            }
        }
        dbAccessor.disconnect();
    }

    public void executeDatabaseOperation(String string, ab ab5, String string2, Properties properties) throws IllegalArgumentException, SQLException, JiveDbmsException {
        block33: {
            properties = aa.ac(string, properties);
            string = aa.ad(string);
            this.initLog();
            if (string2.equals("CREATE-TABLES")) {
                System.out.println("Creating tables...");
                ae[] aeArray = ab5.aa();
                DbAccessor dbAccessor = DbAccessor.getAccessor(string);
                ad ad2 = new ad(dbAccessor);
                dbAccessor.connect(properties);
                for (ae ae2 : aeArray) {
                    try {
                        ad2.aa(ae2, true);
                        ad2.ab(ae2, true);
                        if (!dbAccessor.supportsForeignKeys(ae2.aa())) continue;
                        ad2.ac(ae2, true);
                    }
                    catch (Exception exception) {
                        throw DatabaseUtilRunner.a(exception);
                    }
                }
                dbAccessor.disconnect();
                System.out.println("done.");
            } else if (string2.equals("UPDATE-TABLES")) {
                System.out.println("UPDATE tables...");
                Vector<String> vector = aa.aa(string, ab5.ab(), properties);
                DbAccessor dbAccessor = DbAccessor.getAccessor(string);
                ad ad3 = new ad(dbAccessor);
                dbAccessor.connect(properties);
                for (int i = 0; i < vector.size(); ++i) {
                    ae ae3 = ab5.aa(vector.elementAt(i));
                    try {
                        ad3.aa(ae3, true);
                        ad3.ab(ae3, true);
                        if (!dbAccessor.supportsForeignKeys(ae3.aa())) continue;
                        ad3.ac(ae3, true);
                        continue;
                    }
                    catch (Exception exception) {
                        throw DatabaseUtilRunner.a(exception);
                    }
                }
                dbAccessor.disconnect();
                System.out.println("done.");
            } else if (string2.equals("CREATE-KEYS")) {
                System.out.println("Creating KEYS...");
                ae[] aeArray = ab5.aa();
                DbAccessor dbAccessor = DbAccessor.getAccessor(string);
                ad ad4 = new ad(dbAccessor);
                dbAccessor.connect(properties);
                for (ae ae4 : aeArray) {
                    try {
                        ad4.ab(ae4, true);
                        if (!dbAccessor.supportsForeignKeys(ae4.aa())) continue;
                        ad4.ac(ae4, true);
                    }
                    catch (Exception exception) {
                        throw DatabaseUtilRunner.a(exception);
                    }
                }
                dbAccessor.disconnect();
                System.out.println("done.");
            } else {
                block34: {
                    block32: {
                        try {
                            if (!string2.equals("CREATE-DATABASE")) break block32;
                            System.out.println("Creating database...");
                            aa.aa(string, properties);
                            System.out.println("done.");
                            break block33;
                        }
                        catch (Exception exception) {
                            throw DatabaseUtilRunner.a(exception);
                        }
                    }
                    try {
                        if (!string2.equals("DROP-DATABASE")) break block34;
                        System.out.println("Dropping database...");
                        aa.ab(string, properties);
                        System.out.println("done.");
                        break block33;
                    }
                    catch (Exception exception) {
                        throw DatabaseUtilRunner.a(exception);
                    }
                }
                if (string2.equals("DROP-TABLES")) {
                    block37: {
                        block36: {
                            boolean bl = false;
                            try {
                                bl = aa.ad(string, properties);
                            }
                            catch (Exception exception) {
                                Logger logger;
                                block35: {
                                    logger = LoggerFactory.getInstance("Init");
                                    try {
                                        if (!logger.debugIsEnabled()) break block35;
                                        logger.warn((Object)"failed to check database", exception);
                                    }
                                    catch (Exception exception2) {
                                        throw DatabaseUtilRunner.a(exception2);
                                    }
                                }
                                logger.warn("failed to check database:" + exception.getMessage());
                            }
                            try {
                                System.out.println("Dropping tables...");
                                if (bl) break block36;
                                System.out.println("Database does not exist - skipping drop tables");
                                break block37;
                            }
                            catch (Exception exception) {
                                throw DatabaseUtilRunner.a(exception);
                            }
                        }
                        ae[] aeArray = ab5.aa();
                        try {
                            for (int i = aeArray.length - 1; i >= 0; --i) {
                                aa.aa(string, aeArray[i], properties);
                            }
                        }
                        catch (Exception exception) {
                            throw DatabaseUtilRunner.a(exception);
                        }
                    }
                    System.out.println("done.");
                } else {
                    block38: {
                        try {
                            if (!string2.equals("INFO-DATABASE")) break block38;
                            System.out.println("Displaying database information...");
                            aa.ae(string, properties);
                            System.out.println("done.");
                            break block33;
                        }
                        catch (Exception exception) {
                            throw DatabaseUtilRunner.a(exception);
                        }
                    }
                    throw new IllegalArgumentException("The operation " + string2 + " is not supported.");
                }
            }
        }
    }

    public void initLog() {
        Log4JLoggerConfiguration.configureDefaultConsole(Level.DEBUG);
    }

    public static void main(String[] stringArray) {
        try {
            new DatabaseUtilRunner(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            exception.printStackTrace();
            System.err.println(exception.toString());
            System.exit(1);
        }
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

