/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.tools.database.structure;

import com.visustt.dicomTk.DicomElementList;
import com.visustt.dicomTk.DicomModule;
import com.visustt.dicomTk.DicomObject;
import com.visustt.dicomTk.DicomTag;
import com.visustt.dicomTk.InvalidDataException;
import com.visustt.dicomTk.PersonName;
import com.visustt.dicomTk.data.DicomElement;
import com.visustt.dicomTk.data.aap;
import com.visustt.dicomTk.data.av;
import com.visustt.dicomTk.data.ax;
import com.visustt.dicomTk.data.ay;
import com.visustt.dicomTk.dict.DicomDictionary;
import com.visustt.jiveX.tools.database.converter.dicom.DefaultDicomDbTypeConverter;
import com.visustt.jiveX.tools.database.converter.dicom.DicomDbTypeConverter;
import com.visustt.jiveX.tools.database.structure.ColumnMetaData;
import com.visustt.jiveX.tools.database.structure.aa;
import com.visustt.jiveX.tools.database.structure.ae;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Objects;
import java.util.Vector;

public class DicomColumnMetaData
extends ColumnMetaData {
    private static final String OLD_PACKAGE_NAME = "com.visustt.database.";
    private static final String NEW_PACKAGE_NAME = "com.visustt.jiveX.tools.database.";
    private static Logger logger = LoggerFactory.getInstance("jx.jcs.db.dicomcolumnmetadata");
    private DicomTag tag;
    private DicomDbTypeConverter converter;
    private DicomTag sqReferenceTag;
    private boolean vmSensitive;
    private String vr;

    public DicomColumnMetaData(String string, DicomTag dicomTag, DicomTag dicomTag2, String string2, String string3, String string4, boolean bl) throws ClassNotFoundException, InstantiationException, ClassCastException, IllegalAccessException {
        this(string, dicomTag, dicomTag2, string2, string3, string4, bl, false, false, 0);
    }

    /*
     * Unable to fully structure code
     */
    public DicomColumnMetaData(String var1_1, DicomTag var2_2, DicomTag var3_3, String var4_4, String var5_5, String var6_6, boolean var7_7, boolean var8_8, boolean var9_9, int var10_10) throws ClassNotFoundException, InstantiationException, ClassCastException, IllegalAccessException {
        super(var1_1, var4_4, var8_8);
        this.tag = var2_2;
        this.sqReferenceTag = var3_3;
        this.vmSensitive = var9_9;
        if (var5_5 == null) {
            var12_11 = DicomDictionary.instance();
            var13_13 = var12_11.searchElement(var2_2);
            try {
                if (var13_13 == null) {
                    throw new IllegalArgumentException("Invalid Dicom Tag: " + var2_2 + " Value is not in the DICOM data dictionary");
                }
            }
            catch (ClassNotFoundException v0) {
                throw DicomColumnMetaData.a(v0);
            }
            try {
                this.vr = var13_13.getVR();
                if (this.vr.equals("US|SS")) {
                    this.vr = "SS";
                }
            }
            catch (ClassNotFoundException v1) {
                throw DicomColumnMetaData.a(v1);
            }
            var14_14 = Class.forName("com.visustt.jiveX.tools.database.converter.dicom.DicomDbTypeConverter_" + this.vr);
            var11_15 = (DicomDbTypeConverter)var14_14.newInstance();
            try {
                var11_15.setDicomTag(var2_2);
                if (!(var11_15 instanceof DefaultDicomDbTypeConverter)) ** GOTO lbl35
                ((DefaultDicomDbTypeConverter)var11_15).setCheckDicomTag(var7_7);
            }
            catch (ClassNotFoundException v2) {
                throw DicomColumnMetaData.a(v2);
            }
        } else {
            if (var5_5.startsWith("com.visustt.database.")) {
                var5_5 = var5_5.replaceFirst("com.visustt.database.", "com.visustt.jiveX.tools.database.");
            }
            var12_12 = Class.forName(var5_5);
            var11_15 = (DicomDbTypeConverter)var12_12.newInstance();
            var11_15.setDicomTag(var2_2);
        }
lbl35:
        // 3 sources

        this.columnType = var11_15.getDicomColumnMetaDataType();
        this.setConverter(var11_15, var10_10);
    }

    public void setConverter(DicomDbTypeConverter dicomDbTypeConverter, int n) {
        block4: {
            try {
                try {
                    this.converter = dicomDbTypeConverter;
                    this.columnSize = dicomDbTypeConverter.getDicomColumnMetaDataSize();
                    if (n <= 0 || n >= this.columnSize) break block4;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomColumnMetaData.a(illegalArgumentException);
                }
                this.columnSize = n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomColumnMetaData.a(illegalArgumentException);
            }
        }
    }

    public DicomTag getDicomTag() {
        return this.tag;
    }

    public DicomDbTypeConverter getConverter() {
        return this.converter;
    }

    @Override
    public String toJDBCString() {
        StringBuffer stringBuffer;
        block3: {
            block2: {
                stringBuffer = new StringBuffer();
                try {
                    stringBuffer.append(this.columnName + " ");
                    stringBuffer.append(aa.aa(this.converter.getDicomColumnMetaDataType()));
                    if (this.columnSize <= 0) break block2;
                    stringBuffer.append("(" + this.columnSize + "),");
                    break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomColumnMetaData.a(illegalArgumentException);
                }
            }
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        try {
            stringBuilder.append("columnname='" + this.columnName + "' tag='" + this.tag + "'");
            if (this.sqReferenceTag != null) {
                stringBuilder.append(" sqReferenceTag='" + this.sqReferenceTag + "'");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomColumnMetaData.a(illegalArgumentException);
        }
        try {
            if (this.columnFlag != null) {
                stringBuilder.append(" flag='" + this.columnFlag + "'");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomColumnMetaData.a(illegalArgumentException);
        }
        try {
            if (this.converter != null) {
                stringBuilder.append(" converter='" + this.converter + "'");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomColumnMetaData.a(illegalArgumentException);
        }
        stringBuilder.append(" caseInSensitive='" + this.caseInSensitive + "'");
        return stringBuilder.toString();
    }

    /*
     * Loose catch block
     */
    public void fillPreparedStatement(PreparedStatement preparedStatement, int n, Object object, Logger logger) throws SQLException {
        block10: {
            object = this.correctValue(object);
            try {
                if (logger.debugIsEnabled()) {
                    logger.debug("columnName = " + this.columnName + ", value = " + object);
                }
            }
            catch (SQLException sQLException) {
                throw DicomColumnMetaData.a(sQLException);
            }
            if (object == null) break block10;
            try {
                block9: {
                    if (!(object instanceof String)) break block9;
                    try {
                        block11: {
                            if (this.columnType != 2004) break block9;
                            break block11;
                            catch (SQLException sQLException) {
                                throw DicomColumnMetaData.a(sQLException);
                            }
                        }
                        preparedStatement.setString(n, (String)object);
                    }
                    catch (SQLException sQLException) {
                        throw DicomColumnMetaData.a(sQLException);
                    }
                }
                preparedStatement.setObject(n, object, this.columnType);
            }
            catch (SQLException sQLException) {
                DicomColumnMetaData.logger.error("Error setting value \"" + object + "\" for column " + this.columnName);
                throw sQLException;
            }
        }
        preparedStatement.setNull(n, this.columnType);
    }

    public void fillPreparedStatement(PreparedStatement preparedStatement, int n, DicomModule dicomModule, Logger logger) throws SQLException {
        block14: {
            block12: {
                Object object;
                block13: {
                    object = this.getDBObject(dicomModule, logger);
                    try {
                        try {
                            try {
                                if (object == null) break block12;
                                if (!(object instanceof String)) break block13;
                            }
                            catch (SQLException sQLException) {
                                throw DicomColumnMetaData.a(sQLException);
                            }
                            if (this.columnType != 2004) break block13;
                        }
                        catch (SQLException sQLException) {
                            throw DicomColumnMetaData.a(sQLException);
                        }
                        preparedStatement.setString(n, (String)object);
                        break block14;
                    }
                    catch (SQLException sQLException) {
                        throw DicomColumnMetaData.a(sQLException);
                    }
                }
                preparedStatement.setObject(n, object, this.columnType);
                break block14;
            }
            if (this.hasDefaultValue()) {
                String string;
                block15: {
                    string = this.getDefaultValue();
                    try {
                        try {
                            if (!(string instanceof String) || this.columnType != 2004) break block15;
                        }
                        catch (SQLException sQLException) {
                            throw DicomColumnMetaData.a(sQLException);
                        }
                        preparedStatement.setString(n, string);
                        break block14;
                    }
                    catch (SQLException sQLException) {
                        throw DicomColumnMetaData.a(sQLException);
                    }
                }
                preparedStatement.setObject(n, (Object)string, this.columnType);
            } else {
                preparedStatement.setNull(n, this.columnType);
            }
        }
    }

    public Object getDBObject(DicomModule dicomModule, Logger logger) {
        try {
            if (dicomModule == null) {
                return null;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DicomColumnMetaData.a(invalidDataException);
        }
        Object object = null;
        DicomElementList dicomElementList = dicomModule.getDicomElementList();
        try {
            DicomElement dicomElement;
            block15: {
                try {
                    if (!this.hasSQReference() || !dicomElementList.hasDicomElement(this.sqReferenceTag)) break block15;
                }
                catch (InvalidDataException invalidDataException) {
                    throw DicomColumnMetaData.a(invalidDataException);
                }
                dicomElement = dicomElementList.getDicomElement(this.sqReferenceTag);
                try {
                    if (!(dicomElement instanceof av) || dicomElement.getValueMultiplication() <= 0) break block15;
                }
                catch (InvalidDataException invalidDataException) {
                    throw DicomColumnMetaData.a(invalidDataException);
                }
                dicomElementList = ((av)dicomElement).ac(0);
            }
            if ((dicomElement = dicomElementList.getDicomElement(this.getDicomTag())) != null) {
                object = this.getConverter().getDbValue(dicomElement);
            }
        }
        catch (InvalidDataException invalidDataException) {
            DicomObject dicomObject;
            StringBuilder stringBuilder;
            block17: {
                block16: {
                    stringBuilder = new StringBuilder(256);
                    dicomObject = new DicomObject(dicomModule);
                    PersonName personName = dicomObject.getPatientModule().getPatientName();
                    try {
                        if (personName == null) break block16;
                        stringBuilder.append("Patients name: ").append(personName.getFullName());
                        break block17;
                    }
                    catch (InvalidDataException invalidDataException2) {
                        throw DicomColumnMetaData.a(invalidDataException2);
                    }
                }
                stringBuilder.append("Patients name: null");
            }
            stringBuilder.append("\nStudyDate: ").append(dicomObject.getStudyModule().getStudyDate());
            stringBuilder.append("\nStudyInstanceUID: ").append(dicomObject.getStudyModule().getStudyInstanceUID());
            stringBuilder.append("\nSeriesInstanceUID: ").append(dicomObject.getSeriesModule().getSeriesInstanceUID());
            stringBuilder.append("\nSOP Instance UID: ").append(dicomObject.getImageModule().getSOPInstanceUID());
            stringBuilder.append("\nModality: ").append(dicomObject.getSeriesModule().getModality());
            stringBuilder.append("\nImage Number: ").append(dicomObject.getImageModule().getImageNumber());
            logger.warn((Object)("Exception while parsing Data: " + this.getDicomTag() + "\n" + stringBuilder), invalidDataException);
        }
        object = this.correctValue(object);
        try {
            if (logger.debugIsEnabled()) {
                logger.debug("columnName= " + this.columnName + ", value = " + object);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw DicomColumnMetaData.a(invalidDataException);
        }
        return object;
    }

    public Object correctValue(Object object) {
        block7: {
            String string;
            block8: {
                try {
                    try {
                        try {
                            if (object == null) break block7;
                            if (this.columnType == 1) break block8;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw DicomColumnMetaData.a(illegalArgumentException);
                        }
                        if (this.columnType == 12) break block8;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw DicomColumnMetaData.a(illegalArgumentException);
                    }
                    if (this.columnType != -1) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomColumnMetaData.a(illegalArgumentException);
                }
            }
            if ((string = object.toString()).length() > this.columnSize) {
                logger.debug("Value for column " + this.columnName + " is too long\nvalue : " + string + " will be cropped at character: " + this.columnSize);
                string = string.substring(0, this.columnSize);
            }
            object = StringTool.deleteLastChars(string, ' ');
        }
        return object;
    }

    public int fillQueryPreparedStatement(PreparedStatement preparedStatement, int n, DicomObject dicomObject, Logger logger) throws SQLException, InvalidDataException {
        int n2;
        block9: {
            DicomElement dicomElement;
            block6: {
                Object object;
                n2 = n;
                dicomElement = dicomObject.getDicomElement(this.getDicomTag());
                try {
                    if (!(dicomElement instanceof ay) || !((ay)dicomElement).af()) break block6;
                }
                catch (SQLException sQLException) {
                    throw DicomColumnMetaData.a(sQLException);
                }
                ay ay2 = (ay)dicomElement;
                if (ay2.ag()) {
                    object = this.getConverter().getDbValue(ay2.al());
                    preparedStatement.setObject(n2, object, this.columnType);
                    ++n2;
                }
                if (!ay2.ah()) break block9;
                object = this.getConverter().getDbValue(ay2.am());
                preparedStatement.setObject(n2, object, this.columnType);
                ++n2;
                break block9;
            }
            int n3 = dicomElement.getValueMultiplication();
            for (int i = 0; i < n3; ++i) {
                block8: {
                    block7: {
                        String string = this.getSQLColumnValue(dicomElement, i);
                        try {
                            if (string == null) break block7;
                            preparedStatement.setObject(n2, (Object)string, this.columnType);
                            break block8;
                        }
                        catch (SQLException sQLException) {
                            throw DicomColumnMetaData.a(sQLException);
                        }
                    }
                    preparedStatement.setNull(n2, this.columnType);
                }
                ++n2;
            }
        }
        return n2;
    }

    public String getSQLColumnValue(DicomElement dicomElement, int n) throws InvalidDataException {
        block15: {
            Object object;
            block18: {
                block17: {
                    block16: {
                        object = null;
                        try {
                            object = this.getConverter().getDbValue(dicomElement, n);
                        }
                        catch (InvalidDataException invalidDataException) {
                            logger.warn((Object)("Could not parse data for DICOM Tag '" + dicomElement.getDicomTag() + "'."), invalidDataException);
                            return null;
                        }
                        if (this.columnType == 2004) {
                            object = null;
                        }
                        try {
                            try {
                                try {
                                    if (object == null) break block15;
                                    if (this.columnType == 1) break block16;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw DicomColumnMetaData.a(invalidDataException);
                                }
                                if (this.columnType == 12) break block16;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw DicomColumnMetaData.a(invalidDataException);
                            }
                            if (this.columnType != -1) break block17;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw DicomColumnMetaData.a(invalidDataException);
                        }
                    }
                    object = object.toString();
                }
                try {
                    if (!dicomElement.canUseWildcardMatching() || !(object instanceof String)) break block18;
                }
                catch (InvalidDataException invalidDataException) {
                    throw DicomColumnMetaData.a(invalidDataException);
                }
                object = ((String)object).replace('*', '%');
                object = ((String)object).replace('?', '_');
            }
            try {
                if (logger.debugIsEnabled()) {
                    logger.debug("index: " + n + ", columnName= " + this.columnName + ", value = " + object);
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw DicomColumnMetaData.a(invalidDataException);
            }
            if (this.vmSensitive) {
                object = "%" + object + "%";
            }
            return object.toString();
        }
        return null;
    }

    public static final String createFromStatement(Hashtable<String, ?> hashtable) {
        Enumeration<String> enumeration = hashtable.keys();
        Object object = null;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (object == null) {
                object = new String(string);
                continue;
            }
            object = object + ", " + string;
        }
        return " FROM " + object;
    }

    public static final String getSQLPreparestatmentSuffix(Vector<DicomColumnMetaData> vector) {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("SELECT DISTINCT ");
        for (int i = 0; i < vector.size(); ++i) {
            DicomColumnMetaData dicomColumnMetaData = vector.elementAt(i);
            try {
                if (i != 0) {
                    stringBuilder.append(", ");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomColumnMetaData.a(illegalArgumentException);
            }
            stringBuilder.append(dicomColumnMetaData.getColumnName());
        }
        return stringBuilder.toString();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String prepareQueryPreparedStatement(DicomObject dicomObject) {
        CharSequence charSequence;
        block30: {
            DicomElement dicomElement;
            block29: {
                block31: {
                    block28: {
                        block27: {
                            dicomElement = dicomObject.getDicomElement(this.getDicomTag());
                            if (dicomElement == null) return null;
                            try {
                                if (dicomElement.getValueMultiplication() != 0) break block27;
                                return null;
                                catch (InvalidDataException invalidDataException) {
                                    throw DicomColumnMetaData.a(invalidDataException);
                                }
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw DicomColumnMetaData.a(invalidDataException);
                            }
                        }
                        try {
                            this.getConverter().getDbValue(dicomElement, 0);
                        }
                        catch (InvalidDataException invalidDataException) {
                            logger.warn("Could not parse DATA for DICOM Tag '" + dicomElement.getDicomTag() + "'. " + invalidDataException.getMessage());
                            return null;
                        }
                        if (dicomElement instanceof ax) {
                            charSequence = dicomObject.getString(this.getDicomTag());
                            try {
                                try {
                                    if (charSequence == null || !((String)charSequence).equals("*")) break block28;
                                    return null;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw DicomColumnMetaData.a(invalidDataException);
                                }
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw DicomColumnMetaData.a(invalidDataException);
                            }
                        }
                    }
                    charSequence = new StringBuilder(256);
                    try {
                        ((StringBuilder)charSequence).append("(");
                        if (!(dicomElement instanceof ay) || !((ay)dicomElement).af()) break block29;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw DicomColumnMetaData.a(invalidDataException);
                    }
                    ay ay2 = (ay)dicomElement;
                    try {
                        if (ay2.ag()) {
                            ((StringBuilder)charSequence).append(this.columnName).append(" >= ?");
                        }
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw DicomColumnMetaData.a(invalidDataException);
                    }
                    try {
                        try {
                            if (!ay2.ah()) break block30;
                            if (!ay2.ag()) break block31;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw DicomColumnMetaData.a(invalidDataException);
                        }
                        ((StringBuilder)charSequence).append(" AND ");
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw DicomColumnMetaData.a(invalidDataException);
                    }
                }
                ((StringBuilder)charSequence).append(this.columnName).append(" <= ?");
                break block30;
            }
            int n = 0;
            while (true) {
                block34: {
                    block33: {
                        block32: {
                            try {
                                try {
                                    if (n >= dicomElement.getValueMultiplication()) break;
                                    if (n <= 0) break block32;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw DicomColumnMetaData.a(invalidDataException);
                                }
                                ((StringBuilder)charSequence).append(" OR ");
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw DicomColumnMetaData.a(invalidDataException);
                            }
                        }
                        try {
                            if (!(dicomElement instanceof aap)) break block33;
                            ((StringBuilder)charSequence).append(this.columnName).append(" = ?");
                            break block34;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw DicomColumnMetaData.a(invalidDataException);
                        }
                    }
                    ((StringBuilder)charSequence).append(this.columnName).append(" like ?");
                }
                ++n;
            }
        }
        ((StringBuilder)charSequence).append(")");
        return ((StringBuilder)charSequence).toString();
    }

    public static final String getSQPPrepareCondition(Vector<DicomColumnMetaData> vector, DicomObject dicomObject, Vector<DicomColumnMetaData> vector2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(256);
        boolean bl2 = true;
        for (int i = 0; i < vector2.size(); ++i) {
            String string;
            block12: {
                block9: {
                    block11: {
                        block10: {
                            DicomColumnMetaData dicomColumnMetaData = vector2.elementAt(i);
                            string = dicomColumnMetaData.prepareQueryPreparedStatement(dicomObject);
                            try {
                                try {
                                    try {
                                        try {
                                            if (string == null || string.equals("")) continue;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw DicomColumnMetaData.a(illegalArgumentException);
                                        }
                                        vector.add(dicomColumnMetaData);
                                        if (!bl2) break block9;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw DicomColumnMetaData.a(illegalArgumentException);
                                    }
                                    if (bl) break block10;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw DicomColumnMetaData.a(illegalArgumentException);
                                }
                                stringBuilder.append(" AND ");
                                break block11;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw DicomColumnMetaData.a(illegalArgumentException);
                            }
                        }
                        stringBuilder.append(" WHERE ");
                    }
                    bl2 = false;
                    break block12;
                }
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public DicomTag getSqReferenceTag() {
        return this.sqReferenceTag;
    }

    public void setSqReferenceTag(DicomTag dicomTag) {
        this.sqReferenceTag = dicomTag;
    }

    public boolean hasSQReference() {
        try {
            if (this.sqReferenceTag == null) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomColumnMetaData.a(illegalArgumentException);
        }
        return true;
    }

    public boolean isVmSensitive() {
        return this.vmSensitive;
    }

    public void setVmSensitive(boolean bl) {
        this.vmSensitive = bl;
    }

    public com.visustt.dicomTk.data.aa getVR() {
        return com.visustt.dicomTk.data.aa.aa(this.vr);
    }

    public static Vector<String> getDataFieldNames(Vector<DicomColumnMetaData> vector) {
        Vector<String> vector2;
        block3: {
            vector2 = new Vector<String>();
            try {
                if (vector == null || vector.isEmpty()) break block3;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomColumnMetaData.a(illegalArgumentException);
            }
            for (int i = 0; i < vector.size(); ++i) {
                DicomColumnMetaData dicomColumnMetaData = vector.get(i);
                vector2.add(dicomColumnMetaData.getColumnName());
            }
        }
        return vector2;
    }

    public static Object getDBObject(DicomObject dicomObject, DicomTag dicomTag, ae ae2, Logger logger) {
        DicomColumnMetaData dicomColumnMetaData = ae2.aa(dicomTag);
        Objects.requireNonNull(dicomColumnMetaData, "Unknown DICOM tag " + dicomTag.toString());
        return dicomColumnMetaData.getDBObject(dicomObject, logger);
    }

    private static Exception a(Exception exception) {
        return exception;
    }
}

