/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.rmi.jiveresource;

import com.visustt.jiveX.general.rmi.jiveresource.JiveResourceConstants;
import com.visustt.jiveX.general.rmi.jiveresource.ResourceNotFoundException;
import com.visustt.jiveX.general.rmi.jiveresource.ResourceReadException;
import com.visustt.jiveX.general.rmi.jiveresource.ResourceWriteException;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;

public class JiveResourceObject
implements Serializable,
JiveResourceConstants {
    protected static final long serialVersionUID = 5041386388727186800L;
    public static final String VERSION = "1.1";
    private static boolean updateJRIFiles = System.getProperty("com.visustt.remoteResources.updateJRIFiles", "false").equalsIgnoreCase("true");
    private static final transient String JRI_HEADER = "#\n# Jive Resource Information\n#\njri_version=1.1\n";
    private byte[] data;
    private long timestamp;

    public JiveResourceObject() {
        this.timestamp = -1L;
    }

    public JiveResourceObject(JiveResourceObject jiveResourceObject) {
        if (jiveResourceObject == null) {
            throw new IllegalArgumentException("Specified JiveResouceObject must not be null");
        }
        try {
            if (jiveResourceObject.getData() != null) {
                this.data = new byte[jiveResourceObject.getLength()];
                System.arraycopy(jiveResourceObject.getData(), 0, this.data, 0, jiveResourceObject.getLength());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JiveResourceObject.a(illegalArgumentException);
        }
        this.timestamp = jiveResourceObject.getTimestamp();
    }

    public JiveResourceObject(byte[] byArray, long l) {
        this.data = byArray;
        this.timestamp = l;
    }

    public JiveResourceObject(File file) throws ResourceReadException, ResourceNotFoundException, ResourceWriteException {
        this.loadResource(file);
    }

    public int getLength() {
        int n;
        try {
            n = this.data == null ? 0 : this.data.length;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JiveResourceObject.a(illegalArgumentException);
        }
        return n;
    }

    public byte[] getData() {
        return this.data;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long l) {
        this.timestamp = l;
    }

    public static long getTimestamp(File file) throws ResourceNotFoundException, ResourceReadException {
        try {
            if (file == null) {
                throw new IllegalArgumentException("Specified resourceObject file must not be null");
            }
        }
        catch (ResourceWriteException resourceWriteException) {
            throw JiveResourceObject.a(resourceWriteException);
        }
        try {
            if (!file.exists()) {
                throw new ResourceNotFoundException("Resource does not exist: " + file.getAbsolutePath());
            }
        }
        catch (ResourceWriteException resourceWriteException) {
            throw JiveResourceObject.a(resourceWriteException);
        }
        JiveResourceObject jiveResourceObject = new JiveResourceObject();
        File file2 = new File(file.getAbsolutePath() + ".jri");
        try {
            if (file2.exists()) {
                jiveResourceObject.loadResourceInformation(file2);
                return jiveResourceObject.getTimestamp();
            }
        }
        catch (ResourceWriteException resourceWriteException) {
            throw JiveResourceObject.a(resourceWriteException);
        }
        jiveResourceObject.setTimestamp(file.lastModified());
        try {
            jiveResourceObject.storeResourceInformation(file2);
        }
        catch (ResourceWriteException resourceWriteException) {
            // empty catch block
        }
        return jiveResourceObject.getTimestamp();
    }

    public void loadResource(File file) throws ResourceNotFoundException, ResourceReadException, ResourceWriteException {
        try {
            if (file == null) {
                throw new IllegalArgumentException("Specified resourceObject file must not be null.");
            }
        }
        catch (Exception exception) {
            throw JiveResourceObject.a(exception);
        }
        File file2 = new File(file.getAbsolutePath() + ".jri");
        this.data = new byte[(int)file.length()];
        this.timestamp = -1L;
        int n = 0;
        int n2 = 0;
        try {
            if (!file.isFile()) {
                throw new ResourceNotFoundException("Specified resource file does not exist or is not a file: " + file.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            throw JiveResourceObject.a(exception);
        }
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
            while (true) {
                boolean bl;
                boolean bl2;
                n2 = bufferedInputStream.read(this.data, n, Math.min(4096, this.data.length - n));
                try {
                    bl2 = n2 != -1;
                }
                catch (Exception exception) {
                    throw JiveResourceObject.a(exception);
                }
                try {
                    bl = n != this.data.length;
                }
                catch (Exception exception) {
                    throw JiveResourceObject.a(exception);
                }
                if (!(bl2 & bl)) break;
                n += n2;
            }
            bufferedInputStream.close();
            if (file2.exists()) {
                try {
                    this.loadResourceInformation(file2);
                }
                catch (Exception exception) {
                    LoggerFactory.getInstance("JiveResourceInterface").error(exception);
                }
            }
            try {
                if (this.timestamp == -1L) {
                    this.timestamp = System.currentTimeMillis();
                }
            }
            catch (Exception exception) {
                throw JiveResourceObject.a(exception);
            }
            if (!file2.exists()) {
                try {
                    this.storeResourceInformation(file2);
                }
                catch (Exception exception) {
                    LoggerFactory.getInstance("JiveResourceInterface").error(exception);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResourceNotFoundException("Resource file not found: " + file.getAbsolutePath(), fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new ResourceReadException("Error reading resource: " + file.getAbsolutePath(), iOException);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void loadResourceInformation(File var1_1) throws ResourceReadException, ResourceNotFoundException {
        block26: {
            try {
                var2_2 = new BufferedInputStream(new FileInputStream(var1_1));
                try {
                    block27: {
                        block28: {
                            block23: {
                                block25: {
                                    block24: {
                                        block29: {
                                            var3_5 = new Properties();
                                            var3_5.load(var2_2);
                                            var2_2.close();
                                            var4_7 = false;
                                            var5_9 = var3_5.getProperty("timestamp");
                                            var6_10 = new File(StringTool.cutRight(var1_1.getAbsolutePath(), 4));
                                            var7_11 = var6_10.lastModified();
                                            if (var5_9 == null) break block28;
                                            var9_12 = var3_5.getProperty("jri_version");
                                            if (var9_12 == null) break block23;
                                            if (!(Double.parseDouble(var9_12) > 1.0)) break block23;
                                            break block29;
                                            catch (ResourceWriteException v0) {
                                                throw JiveResourceObject.a(v0);
                                            }
                                        }
                                        try {
                                            block30: {
                                                if (var5_9.equalsIgnoreCase("new")) break block24;
                                                break block30;
                                                catch (ResourceWriteException v1) {
                                                    throw JiveResourceObject.a(v1);
                                                }
                                            }
                                            if (!var5_9.equalsIgnoreCase("now")) break block25;
                                        }
                                        catch (ResourceWriteException v2) {
                                            throw JiveResourceObject.a(v2);
                                        }
                                    }
                                    this.timestamp = System.currentTimeMillis();
                                    var4_7 = true;
                                    break block28;
                                }
                                if (var5_9.equalsIgnoreCase("lastModified")) {
                                    this.timestamp = var7_11;
                                    var4_7 = true;
                                } else {
                                    this.timestamp = Long.parseLong(var5_9);
                                }
                                break block28;
                            }
                            this.timestamp = Long.parseLong(var5_9);
                        }
                        if (JiveResourceObject.updateJRIFiles) ** GOTO lbl52
                        try {
                            block31: {
                                if (!var4_7) break block26;
                                break block31;
                                catch (ResourceWriteException v3) {
                                    throw JiveResourceObject.a(v3);
                                }
                            }
                            if (var4_7) break block27;
                        }
                        catch (ResourceWriteException v4) {
                            throw JiveResourceObject.a(v4);
                        }
                        var9_13 = var7_11;
                        if (this.timestamp < var9_13) {
                            this.timestamp = var9_13;
                            var4_7 = true;
                        }
                    }
                    if (!var4_7) break block26;
                    var4_7 = false;
                    try {
                        this.storeResourceInformation(var1_1);
                    }
                    catch (ResourceWriteException var9_14) {
                        LoggerFactory.getInstance("JiveResourceInterface").error(var9_14);
                    }
                }
                finally {
                    var2_2.close();
                }
            }
            catch (FileNotFoundException var2_3) {
                throw new ResourceNotFoundException("Resource file not found: " + var1_1.getAbsolutePath(), var2_3);
            }
            catch (Exception var2_4) {
                throw new ResourceReadException("Error reading resource: " + var1_1.getAbsolutePath(), var2_4);
            }
        }
    }

    @Deprecated
    void storeResourceInformation(File file) throws ResourceWriteException {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write(JRI_HEADER);
            bufferedWriter.write("timestamp=");
            if (updateJRIFiles) {
                String string = StringTool.cutRight(file.getAbsolutePath(), ".jri".length());
                bufferedWriter.write(Long.toString(Math.max(this.timestamp, new File(string).lastModified())));
            } else {
                bufferedWriter.write(Long.toString(this.timestamp));
            }
            bufferedWriter.write("\n");
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (IOException iOException) {
            throw new ResourceWriteException("Error writing ResourceInformationFile: " + file.getAbsolutePath(), iOException);
        }
    }

    /*
     * Loose catch block
     */
    public void storeResource(File file) throws ResourceWriteException {
        File file2;
        block22: {
            block21: {
                file2 = new File(file.getAbsolutePath() + ".jri");
                if (!file.exists()) break block21;
                try {
                    block24: {
                        if (file.canWrite()) break block21;
                        break block24;
                        catch (Throwable throwable) {
                            throw JiveResourceObject.a(throwable);
                        }
                    }
                    throw new ResourceWriteException("Existing ResourceObjectFile can't be overwritten: " + file.getAbsolutePath());
                }
                catch (Throwable throwable) {
                    throw JiveResourceObject.a(throwable);
                }
            }
            if (!file2.exists()) break block22;
            try {
                block25: {
                    if (file2.canWrite()) break block22;
                    break block25;
                    catch (Throwable throwable) {
                        throw JiveResourceObject.a(throwable);
                    }
                }
                throw new ResourceWriteException("Existing ResourceInformationFile can't be overwritten: " + file2.getAbsolutePath());
            }
            catch (Throwable throwable) {
                throw JiveResourceObject.a(throwable);
            }
        }
        File file3 = file.getParentFile();
        try {
            if (!file3.isDirectory()) {
                file3.mkdirs();
            }
        }
        catch (Throwable throwable) {
            throw JiveResourceObject.a(throwable);
        }
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
            try {
                if (this.data != null) {
                    bufferedOutputStream.write(this.data);
                }
            }
            catch (Throwable throwable) {
                throw JiveResourceObject.a(throwable);
            }
            this.storeResourceInformation(file2);
        }
        catch (IOException iOException) {
            throw new ResourceWriteException("Error writing ResourceObjectFile: " + file.getAbsolutePath(), iOException);
        }
    }

    public String toString() {
        int n;
        long l;
        try {
            l = this.timestamp;
            n = this.data == null ? 0 : this.data.length;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JiveResourceObject.a(illegalArgumentException);
        }
        return "JiveResourceObject (Timestamp: " + l + " | Data: byte[" + n + "])";
    }

    private static Throwable a(Throwable throwable) {
        return throwable;
    }
}

