/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.rmi.html.shared;

import com.visustt.jiveX.general.rmi.html.shared.HTMLPresentationStateHint;
import java.io.Serializable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class HTMLPresentationStateInstanceData
implements Serializable {
    private static final long serialVersionUID = 1515021635261238910L;
    private SortedSet<Integer> orientations = new TreeSet<Integer>();
    private SortedSet<String> hints = new TreeSet<String>();

    public void addOrientation(int n, boolean bl) {
        int n2 = n % 360;
        if (n2 < 0) {
            n2 += 360;
        }
        int n3 = n2 + (bl ? 360 : 0);
        this.orientations.add(n3);
    }

    public boolean hasAmbigousOrientation() {
        return this.orientations.size() > 1;
    }

    public int getUniqueRotation() {
        return this.getUniqueOrientation() % 360;
    }

    public boolean isUniqueFlippedHorizontally() {
        return this.getUniqueOrientation() >= 360;
    }

    private int getUniqueOrientation() {
        return this.orientations.size() == 1 ? this.orientations.first() : 0;
    }

    public void addHint(String string) {
        this.hints.add(string);
    }

    public boolean hasHint(String string) {
        return this.hints.contains(string);
    }

    public Set<String> getHints() {
        return this.hints;
    }

    public boolean hasData() {
        if (!this.orientations.isEmpty()) {
            return true;
        }
        for (String string : HTMLPresentationStateHint.HAS_DATA_HINTS) {
            if (!this.hasHint(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAnnotation() {
        return this.hasHint("ANNOTATIONS");
    }
}

