/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.message;

import com.visustt.jiveX.general.message.FrameResponseMessage;
import com.visustt.jiveX.general.message.ImageResponseMessage;
import com.visustt.jiveX.general.message.JiveMessage;
import com.visustt.tools.io.ah;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class TCPMessageSendUtils {
    private static final int MESSAGE_TYPE_GENERAL = 0;
    private static final int MESSAGE_TYPE_SEND_IMAGE = 1;
    private static final int MESSAGE_TYPE_EXTENDABLE_SEND_IMAGE = 2;
    private static final int MESSAGE_TYPE_FRAME_RESP = 3;

    public static void sendMessage(JiveMessage jiveMessage, DataOutputStream dataOutputStream) throws IOException {
        if (jiveMessage instanceof ImageResponseMessage) {
            ImageResponseMessage imageResponseMessage = (ImageResponseMessage)jiveMessage;
            dataOutputStream.writeInt(2);
            imageResponseMessage.write(dataOutputStream);
            dataOutputStream.flush();
            imageResponseMessage.image = null;
        } else if (jiveMessage instanceof FrameResponseMessage) {
            FrameResponseMessage frameResponseMessage = (FrameResponseMessage)jiveMessage;
            dataOutputStream.writeInt(3);
            frameResponseMessage.write(dataOutputStream);
            dataOutputStream.flush();
        } else {
            ah ah2 = new ah(10000);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(ah2);
            objectOutputStream.writeObject(jiveMessage);
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(ah2.size());
            dataOutputStream.write(ah2.toByteArray());
            dataOutputStream.flush();
            objectOutputStream.close();
            ah2.aa();
            objectOutputStream = null;
            ah2 = null;
        }
    }

    public static JiveMessage getMessage(DataInputStream dataInputStream) throws IOException, ClassNotFoundException {
        JiveMessage jiveMessage = null;
        if (dataInputStream != null) {
            int n = dataInputStream.readInt();
            if (n == 0) {
                int n2 = dataInputStream.readInt();
                byte[] byArray = new byte[n2];
                dataInputStream.readFully(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                jiveMessage = (JiveMessage)objectInputStream.readObject();
                objectInputStream.close();
                byArray = null;
            } else if (n == 2) {
                jiveMessage = new ImageResponseMessage();
                jiveMessage.read(dataInputStream);
            } else {
                try {
                    if (n == 1) {
                        throw new IOException("Obsolete message type: MESSAGE_TYPE_SEND_IMAGE");
                    }
                }
                catch (IOException iOException) {
                    throw TCPMessageSendUtils.a(iOException);
                }
                if (n == 3) {
                    jiveMessage = new FrameResponseMessage();
                    ((FrameResponseMessage)jiveMessage).read(dataInputStream);
                } else {
                    throw new IOException("Unknown message type:" + n);
                }
            }
        }
        return jiveMessage;
    }

    public static JiveMessage cloneMessage(JiveMessage jiveMessage) throws IOException, ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        TCPMessageSendUtils.sendMessage(jiveMessage, dataOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        return TCPMessageSendUtils.getMessage(dataInputStream);
    }

    private static IOException a(IOException iOException) {
        return iOException;
    }
}

