/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.message;

import com.visustt.dicomTk.ac.ad;
import com.visustt.jiveX.general.message.JiveMessage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;

public class ImageResponseMessage
implements JiveMessage {
    private static final long serialVersionUID = 848744383221594007L;
    private static final int MAX_UTF_LENGTH = 65534;
    public static final String PIXEL_RANGE = "PixelRange";
    public static final String APPLY_HP_NOW = "ApplyHPNow";
    public static final String LAST_PRE_IMAGE_OF_BLOB = "LastPreImageOfBlob";
    public static final String SORTED_SOP_UID_LIST = "SortedSOPUIDList";
    public static final String IMAGE_ORIENTATIONS = "ImageOrientations";
    public static final String TOTAL_SERIES_COUNT = "TotalSeriesCount";
    public static final String PRIORITY_UPDATE_ID = "PriorityUpdateID";
    public static final String REQUEST_ID = "requestID";
    public static final String JIVE_IMAGE_NUMBER = "JiveImageNumber";
    public static final String JIVE_SERIES_DATA_ID = "JiveSeriesDataID";
    public static final String STUDY_INSTANCE_UID = "StudyInstanceUID";
    public static final String SERIES_INSTANCE_UID = "SeriesInstanceUID";
    public static final String SERIES_RELATED_IMAGE_COUNT = "SeriesRelatedImageCount";
    public static final String LAST_IMAGE_OF_SERIES = "LastImageOfSeries";
    public static final String JIVEX_SERVER = "JiveXServer";
    public static final String DICOM_HEADER_LENGTH = "DicomHeaderLength";
    public ad ddf = null;
    public int receiverID;
    public int imageNumber = 0;
    public int totalImages = 0;
    public String imageFlavor = "dicom";
    public byte[] image;
    public boolean autoDeCompress = false;
    protected int numberOfRequest = -1;
    protected int requestNumber = -1;
    private transient String connectionName = null;
    private transient boolean loadingImagesAborted = false;
    public transient boolean resetDecodingTaskQueue = false;
    private final Hashtable<String, String> additionalMessageAttributes = new Hashtable();

    public void addMessageAttribute(String string, String string2) {
        if (string2 != null) {
            this.additionalMessageAttributes.put(string, string2);
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        block8: {
            block7: {
                dataOutputStream.writeBoolean(this.autoDeCompress);
                dataOutputStream.writeInt(this.receiverID);
                dataOutputStream.writeInt(this.imageNumber);
                dataOutputStream.writeInt(this.totalImages);
                dataOutputStream.writeInt(this.numberOfRequest);
                dataOutputStream.writeInt(this.requestNumber);
                dataOutputStream.writeUTF(this.imageFlavor);
                int n = 0;
                for (String object : this.additionalMessageAttributes.values()) {
                    n += object.length() / 65534;
                }
                dataOutputStream.writeInt(this.additionalMessageAttributes.size() + n);
                if (this.additionalMessageAttributes.size() > 0) {
                    for (Map.Entry entry : this.additionalMessageAttributes.entrySet()) {
                        String string = (String)entry.getKey();
                        String string2 = (String)entry.getValue();
                        if (string2.length() > 65534) {
                            int n2 = 0;
                            int n3 = string2.length();
                            int n4 = Math.min(65534, n3);
                            while (n3 > 0) {
                                dataOutputStream.writeUTF(string);
                                dataOutputStream.writeUTF(string2.substring(n2, n2 + n4));
                                n2 += n4;
                                n4 = Math.min(65534, n3 -= n4);
                            }
                            continue;
                        }
                        dataOutputStream.writeUTF(string);
                        dataOutputStream.writeUTF(string2);
                    }
                }
                try {
                    if (this.image != null) break block7;
                    dataOutputStream.writeInt(0);
                    break block8;
                }
                catch (IOException iOException) {
                    throw ImageResponseMessage.a(iOException);
                }
            }
            dataOutputStream.writeInt(this.image.length);
            dataOutputStream.write(this.image);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.autoDeCompress = dataInputStream.readBoolean();
        this.receiverID = dataInputStream.readInt();
        this.imageNumber = dataInputStream.readInt();
        this.totalImages = dataInputStream.readInt();
        this.numberOfRequest = dataInputStream.readInt();
        this.requestNumber = dataInputStream.readInt();
        this.imageFlavor = dataInputStream.readUTF();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = dataInputStream.readUTF();
            Object object = dataInputStream.readUTF();
            try {
                if (!this.additionalMessageAttributes.containsKey(string)) {
                    this.additionalMessageAttributes.put(string, (String)object);
                    continue;
                }
            }
            catch (IOException iOException) {
                throw ImageResponseMessage.a(iOException);
            }
            object = this.additionalMessageAttributes.get(string) + (String)object;
            this.additionalMessageAttributes.put(string, (String)object);
        }
        n = dataInputStream.readInt();
        try {
            if (n == 0) {
                return;
            }
        }
        catch (IOException iOException) {
            throw ImageResponseMessage.a(iOException);
        }
        byte[] byArray = new byte[n];
        dataInputStream.readFully(byArray);
        this.image = byArray;
    }

    public String getAdditionalMessageAttribute(String string) {
        return this.additionalMessageAttributes.get(string);
    }

    public String getAdditionalMessageAttribute(String string, String string2) {
        String string3 = this.additionalMessageAttributes.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    public void removeAdditionalMessageAttribute(String string) {
        this.additionalMessageAttributes.remove(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("ImageResponseMessage{receiverID:");
        stringBuilder.append(this.receiverID);
        stringBuilder.append("; imageNumber:");
        stringBuilder.append(this.imageNumber);
        stringBuilder.append("; totalImages:");
        stringBuilder.append(this.totalImages);
        stringBuilder.append("; imageFlavor: ");
        stringBuilder.append(this.imageFlavor);
        stringBuilder.append("; numberOfRequest:");
        stringBuilder.append(this.numberOfRequest);
        stringBuilder.append("; requestNumber:");
        stringBuilder.append(this.requestNumber);
        stringBuilder.append("; autoDeCompress:");
        stringBuilder.append(this.autoDeCompress);
        stringBuilder.append("; additionalMessageAttributes[");
        Iterator<Map.Entry<String, String>> iterator = this.additionalMessageAttributes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            stringBuilder.append(entry.getKey()).append("=").append(entry.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(";");
        }
        stringBuilder.append("]; image=");
        if (this.image == null) {
            stringBuilder.append("<null>");
        } else {
            stringBuilder.append("byte[");
            stringBuilder.append(this.image.length);
            stringBuilder.append("]");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public int getNumberOfRequest() {
        return this.numberOfRequest;
    }

    public void setNumberOfRequest(int n) {
        this.numberOfRequest = n;
    }

    public int getRequestNumber() {
        return this.requestNumber;
    }

    public void setRequestNumber(int n) {
        this.requestNumber = n;
    }

    public void setConnectionName(String string) {
        this.connectionName = string;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public boolean isLoadingImagesAborted() {
        return this.loadingImagesAborted;
    }

    public void setLoadingImagesAborted(boolean bl) {
        this.loadingImagesAborted = bl;
    }

    public boolean isHeaderOnly() {
        return Integer.parseInt(this.getAdditionalMessageAttribute(DICOM_HEADER_LENGTH, "0")) > 0;
    }

    private static IOException a(IOException iOException) {
        return iOException;
    }
}

