/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.message;

import com.visustt.jiveX.general.data.priorstudies.StudyDefinition;
import com.visustt.jiveX.general.message.AbstractRedirectableMessage;
import com.visustt.tools.control.license.util.VisusVersionString;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.lang.al;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

public class ImageRequestMessage
extends AbstractRedirectableMessage {
    private static final long serialVersionUID = -2604418210919874533L;
    public int senderID = 1;
    public boolean keyImages = false;
    @XmlElement(nillable=true)
    public String instanceType = "Instance";
    public String[] flavors = new String[]{"dcmpre", "dicomzip", "dicom", "dcmjpg", "dcmjp2kl", "dcmjp2k", "dcmjpg12", "dcmjpg8", "dcmjpgls", "dcmmpeg2", "dcmorgzip", "dcmheaders", "pixel"};
    public boolean acceptDicomPre = true;
    public boolean abortAfterDicomPre = false;
    public boolean abortAfterDicomPrePrelim = false;
    public boolean allowClientDataChange = false;
    public static final String IMAGELOADTEST_IMAGES = "IMAGES";
    public static final String IMAGELOADTEST_SIZE = "SIZE";
    public static final int DISABLE_IMAGE_SKIPPING = -1;
    protected boolean localDatabase = true;
    public String[] accession = null;
    public String[] patientIDs = null;
    public String[] studyUIDs = null;
    public String[] seriesUIDs = null;
    public String[] imageUIDs = null;
    public String database;
    protected int numberOfRequest;
    protected int requestNumber;
    public String modality;
    public String description;
    public String patientID;
    protected String requestID = "";
    public int skipFirstImages = 0;
    public ArrayList<String> skipSOPInstanceUIDs = null;
    public boolean keepConnection = false;
    private int imageCount = 0;
    public int[] updateImageOrder = null;
    private VisusVersionString clientVersion;
    public boolean dontUpdateSendOrder = false;
    public boolean sortRequestedStudies = true;
    public boolean reloadImages = false;
    private boolean requestFrames = false;
    public Hashtable<String, Object> imageLoadTestProperties = new Hashtable();
    public boolean loadTest = false;
    public Map<String, String> uidDatabaseMap;
    public int jiveImageNumber = -1;
    public long jiveSeriesDataID = -1L;
    private boolean sendImageContentMessage;
    private String originalServerComputerID;
    private StudyDefinition studyDefinition;
    private boolean omitPrelimImages = false;
    private boolean loadCapture;
    private boolean requestHP;
    private String assigningAuthorityNamespaceID;
    private String assigningAuthorityUniversalID;
    private String assigningAuthorityUniversalIDType;
    private boolean showMRMFindings;
    private boolean suppressStudyLoadSQLAppend;

    public ImageRequestMessage() {
    }

    public ImageRequestMessage(String string, String string2, String string3, String string4, String string5, boolean bl) {
        this(string, string2, string3, string4);
        this.database = string5;
        this.localDatabase = bl;
    }

    public ImageRequestMessage(String string, String string2, String string3, String string4) {
        if (string != null) {
            this.patientIDs = new String[1];
            this.patientIDs[0] = string;
        }
        if (string2 != null) {
            this.studyUIDs = new String[1];
            this.studyUIDs[0] = string2;
        }
        if (string3 != null) {
            this.seriesUIDs = new String[1];
            this.seriesUIDs[0] = string3;
        }
        if (string4 != null) {
            this.imageUIDs = new String[1];
            this.imageUIDs[0] = string4;
        }
        this.setSendImageContentMessage(true);
    }

    public ImageRequestMessage(String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        this.patientIDs = stringArray;
        this.studyUIDs = stringArray2;
        this.seriesUIDs = stringArray3;
        this.imageUIDs = stringArray4;
        this.setSendImageContentMessage(true);
    }

    public ImageRequestMessage(String[] stringArray) {
        this.accession = stringArray;
        this.setSendImageContentMessage(true);
    }

    public final boolean isSendImageContentMessage() {
        return this.sendImageContentMessage;
    }

    public final void setSendImageContentMessage(boolean bl) {
        this.sendImageContentMessage = bl;
    }

    public final String getOriginalServerComputerID() {
        return this.originalServerComputerID;
    }

    public final void setOriginalServerComputerID(String string) {
        this.originalServerComputerID = string;
    }

    public boolean isLocalDatabase() {
        return this.localDatabase;
    }

    public void setLocalDatabase(boolean bl) {
        this.localDatabase = bl;
    }

    public int getNumberOfRequest() {
        return this.numberOfRequest;
    }

    public void setNumberOfRequest(int n) {
        this.numberOfRequest = n;
    }

    public int getRequestNumber() {
        return this.requestNumber;
    }

    public void setRequestNumber(int n) {
        this.requestNumber = n;
    }

    public int getImageCount() {
        return this.imageCount;
    }

    public void setImageCount(int n) {
        this.imageCount = n;
    }

    public String getRequestID() {
        return this.requestID;
    }

    public void setRequestID(String string) {
        this.requestID = string;
    }

    public ArrayList<String> getSOPInstanceUIDsToSkip() {
        return this.skipSOPInstanceUIDs;
    }

    public void setSkipSOPInstanceUIDs(ArrayList<String> arrayList) {
        this.skipSOPInstanceUIDs = arrayList;
    }

    public VisusVersionString getClientVersion() {
        return this.clientVersion;
    }

    public void setClientVersion(VisusVersionString visusVersionString) {
        this.clientVersion = visusVersionString;
    }

    public void setLoadImageTest(int n, int n2) {
        this.loadTest = true;
        this.imageLoadTestProperties.put(IMAGELOADTEST_IMAGES, n);
        this.imageLoadTestProperties.put(IMAGELOADTEST_SIZE, n2);
    }

    public int getSize() {
        if (this.imageLoadTestProperties.containsKey(IMAGELOADTEST_SIZE)) {
            return (Integer)this.imageLoadTestProperties.get(IMAGELOADTEST_SIZE);
        }
        return -1;
    }

    public int getImages() {
        if (this.imageLoadTestProperties.containsKey(IMAGELOADTEST_IMAGES)) {
            return (Integer)this.imageLoadTestProperties.get(IMAGELOADTEST_IMAGES);
        }
        return -1;
    }

    public void setDatabase(String string) {
        this.database = string;
    }

    public boolean isPatientLevel() {
        return this.patientIDs != null && this.patientIDs.length > 0;
    }

    public boolean isAccessionLevel() {
        return this.accession != null && this.accession.length > 0;
    }

    public boolean isStudyLevel() {
        return this.studyUIDs != null && this.studyUIDs.length > 0;
    }

    public boolean isSeriesLevel() {
        return this.seriesUIDs != null && this.seriesUIDs.length > 0;
    }

    public boolean isInstanceLevel() {
        return this.imageUIDs != null && this.imageUIDs.length > 0;
    }

    public int getNumberOfRequestedUIDs() {
        if (this.isInstanceLevel()) {
            return this.imageUIDs.length;
        }
        if (this.isSeriesLevel()) {
            return this.seriesUIDs.length;
        }
        if (this.isStudyLevel()) {
            return this.studyUIDs.length;
        }
        if (this.isAccessionLevel()) {
            return this.accession.length;
        }
        return 0;
    }

    public String[] getRequestedUIDs() {
        if (this.isInstanceLevel()) {
            return this.imageUIDs;
        }
        if (this.isSeriesLevel()) {
            return this.seriesUIDs;
        }
        if (this.isStudyLevel()) {
            return this.studyUIDs;
        }
        if (this.isAccessionLevel()) {
            return this.accession;
        }
        return this.patientIDs;
    }

    @XmlTransient
    public void setRequestedUIDs(String[] stringArray) {
        if (this.isInstanceLevel()) {
            this.imageUIDs = stringArray;
        } else if (this.isSeriesLevel()) {
            this.seriesUIDs = stringArray;
        } else if (this.isStudyLevel()) {
            this.studyUIDs = stringArray;
        } else if (this.isAccessionLevel()) {
            this.accession = stringArray;
        } else {
            this.patientIDs = stringArray;
        }
    }

    public boolean isOmitPrelimImages() {
        return this.omitPrelimImages;
    }

    public void setOmitPrelimImages(boolean bl) {
        this.omitPrelimImages = bl;
    }

    public boolean isLoadCapture() {
        return this.loadCapture;
    }

    public void setLoadCapture(boolean bl) {
        this.loadCapture = bl;
    }

    public final boolean isRequestHP() {
        return this.requestHP;
    }

    public final void setRequestHP(boolean bl) {
        this.requestHP = bl;
    }

    public boolean isRequestFrames() {
        return this.requestFrames;
    }

    public void setRequestFrames(boolean bl) {
        this.requestFrames = bl;
    }

    public StudyDefinition getStudyDefinition() {
        return this.studyDefinition;
    }

    public void setStudyDefinition(StudyDefinition studyDefinition) {
        this.studyDefinition = studyDefinition;
    }

    public String toString2() {
        if (this.loadTest) {
            return "ImageRequestMessage: Loadtest, images: " + this.getImages() + ", size:" + this.getSize();
        }
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("ImageRequestMessage{");
        stringBuilder.append((CharSequence)this.getAttributes());
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("ImageRequestMessage [senderID=").append(this.senderID).append(", keyImages=").append(this.keyImages).append(", instanceType=").append(this.instanceType).append(", flavors=").append(Arrays.toString(this.flavors)).append(", acceptDicomPre=").append(this.acceptDicomPre).append(", abortAfterDicomPre=").append(this.abortAfterDicomPre).append(", abortAfterDicomPrePrelim=").append(this.abortAfterDicomPrePrelim).append(", allowClientDataChange=").append(this.allowClientDataChange).append(", localDatabase=").append(this.localDatabase).append(", accession=").append(Arrays.toString(this.accession)).append(", patientIDs=").append(Arrays.toString(this.patientIDs)).append(", studyUIDs=").append(Arrays.toString(this.studyUIDs)).append(", seriesUIDs=").append(Arrays.toString(this.seriesUIDs)).append(", imageUIDs=").append(Arrays.toString(this.imageUIDs)).append(", database=").append(this.database).append(", numberOfRequest=").append(this.numberOfRequest).append(", requestNumber=").append(this.requestNumber).append(", modality=").append(this.modality).append(", description=").append(this.description).append(", patientID=").append(this.patientID).append(", requestID=").append(this.requestID).append(", skipFirstImages=").append(this.skipFirstImages).append(", skipSOPInstanceUIDs=").append(this.skipSOPInstanceUIDs).append(", keepConnection=").append(this.keepConnection).append(", imageCount=").append(this.imageCount).append(", updateImageOrder=").append(Arrays.toString(this.updateImageOrder)).append(", clientVersion=").append(this.clientVersion).append(", dontUpdateSendOrder=").append(this.dontUpdateSendOrder).append(", sortRequestedStudies=").append(this.sortRequestedStudies).append(", reloadImages=").append(this.reloadImages).append(", imageLoadTestProperties=").append(this.imageLoadTestProperties).append(", loadTest=").append(this.loadTest).append(", uidDatabaseMap=").append(this.uidDatabaseMap).append(", jiveImageNumber=").append(this.jiveImageNumber).append(", jiveSeriesDataID=").append(this.jiveSeriesDataID).append(", sendImageContentMessage=").append(this.sendImageContentMessage).append(", originalServerComputerID=").append(this.originalServerComputerID).append(", studyDefinition=").append(this.studyDefinition).append(", omitPrelimImages=").append(this.omitPrelimImages).append(", loadCapture=").append(this.loadCapture).append(", requestHP=").append(this.requestHP).append("]").append(", assigningAuthorityNamespaceID=").append(this.assigningAuthorityNamespaceID).append(", assigningAuthorityUniversalID=").append(this.assigningAuthorityUniversalID).append(", suppressStudyLoadSQLAppend=").append(this.suppressStudyLoadSQLAppend);
        return stringBuilder.toString();
    }

    protected StringBuilder getAttributes() {
        StringBuilder stringBuilder = new StringBuilder(1024);
        stringBuilder.append("senderID=").append(this.senderID);
        stringBuilder.append("; instanceType=").append(this.instanceType);
        stringBuilder.append("; requestID=").append(this.requestID);
        stringBuilder.append("; numberOfRequest=").append(this.numberOfRequest);
        stringBuilder.append("; requestNumber=").append(this.requestNumber);
        stringBuilder.append("; skipFirstImages=").append(this.skipFirstImages);
        stringBuilder.append("; acceptDicomPre=").append(this.acceptDicomPre);
        stringBuilder.append("; abortAfterDicomPre=").append(this.abortAfterDicomPre);
        stringBuilder.append("; abortAfterDicomPrePrelim=").append(this.abortAfterDicomPrePrelim);
        stringBuilder.append("; requestFrames=").append(this.requestFrames);
        stringBuilder.append("; allowClientDataChange=").append(this.allowClientDataChange);
        stringBuilder.append("; keepConnection=").append(this.keepConnection);
        stringBuilder.append("; sendImageContentMessage=").append(this.sendImageContentMessage);
        stringBuilder.append("; originalServerComputerID=").append(this.originalServerComputerID);
        stringBuilder.append("; flavors=[").append(StringTool.createString(this.flavors, ", ")).append("]");
        if (this.patientIDs != null && this.patientIDs.length != 0) {
            stringBuilder.append("; patientIDs=[").append(StringTool.createString(this.patientIDs, ", ")).append("]");
        }
        if (this.studyUIDs != null && this.studyUIDs.length != 0) {
            stringBuilder.append("; studyUIDs=[").append(StringTool.createString(this.studyUIDs, ", ")).append("]");
        }
        if (this.seriesUIDs != null && this.seriesUIDs.length != 0) {
            stringBuilder.append("; seriesUIDs=[").append(StringTool.createString(this.seriesUIDs, ", ")).append("]");
        }
        if (this.imageUIDs != null && this.imageUIDs.length != 0) {
            stringBuilder.append("; imageUIDs=[").append(StringTool.createString(this.imageUIDs, ", ")).append("]");
        }
        if (this.accession != null && this.accession.length != 0) {
            stringBuilder.append("; accession=[").append(StringTool.createString(this.accession, ", ")).append("]");
        }
        if (this.skipSOPInstanceUIDs != null && this.skipSOPInstanceUIDs.size() != 0) {
            stringBuilder.append("; skipSOPInstanceUIDs=[").append(StringTool.createString(this.skipSOPInstanceUIDs, ", ")).append("]");
        }
        if (this.uidDatabaseMap != null && this.uidDatabaseMap.size() != 0) {
            stringBuilder.append("; uidDatabaseMap=[").append(this.uidDatabaseMap).append("]");
        }
        stringBuilder.append("; omitPrelimImages=").append(this.omitPrelimImages);
        stringBuilder.append("; requestHP=").append(this.requestHP);
        if (this.studyDefinition != null) {
            stringBuilder.append("; studyDefinition=").append(this.studyDefinition);
        }
        stringBuilder.append("; loadCapture=").append(this.loadCapture);
        stringBuilder.append("; jiveImageNumber=").append(this.jiveImageNumber);
        stringBuilder.append("; jiveSeriesDataID=").append(this.jiveSeriesDataID);
        return stringBuilder;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + ImageRequestMessage.hashCode(this.accession);
        n2 = 31 * n2 + (this.database == null ? 0 : this.database.hashCode());
        n2 = 31 * n2 + ImageRequestMessage.hashCode(this.imageUIDs);
        n2 = 31 * n2 + (this.localDatabase ? 1231 : 1237);
        n2 = 31 * n2 + (this.keepConnection ? 1233 : 1239);
        n2 = 31 * n2 + (this.omitPrelimImages ? 1231 : 1237);
        n2 = 31 * n2 + (this.requestHP ? 1231 : 1237);
        n2 = 31 * n2 + (this.loadCapture ? 1231 : 1237);
        n2 = 31 * n2 + (this.studyDefinition == null ? 0 : this.studyDefinition.hashCode());
        n2 = 31 * n2 + (this.modality == null ? 0 : this.modality.hashCode());
        n2 = 31 * n2 + this.numberOfRequest;
        n2 = 31 * n2 + (this.patientID == null ? 0 : this.patientID.hashCode());
        n2 = 31 * n2 + ImageRequestMessage.hashCode(this.patientIDs);
        n2 = 31 * n2 + this.requestNumber;
        n2 = 31 * n2 + ImageRequestMessage.hashCode(this.seriesUIDs);
        n2 = 31 * n2 + this.jiveImageNumber;
        n2 = (int)((long)(31 * n2) + this.jiveSeriesDataID);
        n2 = 31 * n2 + ImageRequestMessage.hashCode(this.studyUIDs);
        return n2;
    }

    private static int hashCode(Object[] objectArray) {
        int n = 31;
        if (objectArray == null) {
            return 0;
        }
        int n2 = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            n2 = 31 * n2 + (objectArray[i] == null ? 0 : objectArray[i].hashCode());
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ImageRequestMessage imageRequestMessage = (ImageRequestMessage)object;
        if (!Arrays.equals(this.accession, imageRequestMessage.accession)) {
            return false;
        }
        if (this.database == null ? imageRequestMessage.database != null : !al.aa((Object)this.database, (Object)imageRequestMessage.database)) {
            return false;
        }
        if (!Arrays.equals(this.imageUIDs, imageRequestMessage.imageUIDs)) {
            return false;
        }
        if (this.localDatabase != imageRequestMessage.localDatabase) {
            return false;
        }
        if (this.modality == null ? imageRequestMessage.modality != null : !this.modality.equals(imageRequestMessage.modality)) {
            return false;
        }
        if (this.numberOfRequest != imageRequestMessage.numberOfRequest) {
            return false;
        }
        if (this.patientID == null ? imageRequestMessage.patientID != null : !this.patientID.equals(imageRequestMessage.patientID)) {
            return false;
        }
        if (!Arrays.equals(this.patientIDs, imageRequestMessage.patientIDs)) {
            return false;
        }
        if (this.requestNumber != imageRequestMessage.requestNumber) {
            return false;
        }
        if (this.keepConnection != imageRequestMessage.keepConnection) {
            return false;
        }
        if (this.omitPrelimImages != imageRequestMessage.omitPrelimImages) {
            return false;
        }
        if (this.requestHP != imageRequestMessage.requestHP) {
            return false;
        }
        if (this.loadCapture != imageRequestMessage.loadCapture) {
            return false;
        }
        if (this.studyDefinition == null ? imageRequestMessage.studyDefinition != null : !this.studyDefinition.equals(imageRequestMessage.studyDefinition)) {
            return false;
        }
        if (!Arrays.equals(this.seriesUIDs, imageRequestMessage.seriesUIDs)) {
            return false;
        }
        if (this.skipFirstImages != imageRequestMessage.skipFirstImages) {
            return false;
        }
        if (!Arrays.equals(this.studyUIDs, imageRequestMessage.studyUIDs)) {
            return false;
        }
        return al.aa(imageRequestMessage.skipSOPInstanceUIDs, this.skipSOPInstanceUIDs);
    }

    public void setAssigningAuthorityNamespaceID(String string) {
        this.assigningAuthorityNamespaceID = string;
    }

    public void setAssigningAuthorityUniversalID(String string) {
        this.assigningAuthorityUniversalID = string;
    }

    public String getAssigningAuthorityNamespaceID() {
        return this.assigningAuthorityNamespaceID;
    }

    public String getAssigningAuthorityUniversalID() {
        return this.assigningAuthorityUniversalID;
    }

    public void setAssigningAuthorityUniversalIDType(String string) {
        this.assigningAuthorityUniversalIDType = string;
    }

    public String getAssigningAuthorityUniversalIDType() {
        return this.assigningAuthorityUniversalIDType;
    }

    public boolean isShowMRMFindings() {
        return this.showMRMFindings;
    }

    public void setShowMRMFindings(boolean bl) {
        this.showMRMFindings = bl;
    }

    public boolean isSuppressStudyLoadSQLAppend() {
        return this.suppressStudyLoadSQLAppend;
    }

    public void setSuppressStudyLoadSQLAppend(boolean bl) {
        this.suppressStudyLoadSQLAppend = bl;
    }
}

