/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.user;

import com.visustt.jiveX.general.data.user.Group;
import com.visustt.jiveX.general.data.user.UserManagerDataObject;
import com.visustt.security.handle.AccessHandle;
import com.visustt.security.handle.aa;
import com.visustt.tools.io.StringCrypt;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.text.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class User
implements UserManagerDataObject {
    private static final long serialVersionUID = -8357206173042630679L;
    private String surname = null;
    private String firstname = null;
    private String login = null;
    private String passwd = null;
    private transient String systemLoginName;
    private String lastProfileUpdate = null;
    private long expireDate = 0L;
    private long lockedUntil = 0L;
    private boolean deactivated = false;
    private boolean external = false;
    private boolean updatePassword = false;
    private Vector<String> passwordHistory = new Vector();
    private AccessHandle access_handle = null;
    private Vector<Group> groups = null;
    private int secLevel = 0;
    private transient boolean ghostUser = false;
    private transient boolean isDirty = false;
    private transient boolean isNew = false;
    private transient boolean deleted;
    private Map<String, String> accessRights;
    private boolean isEmergencyAccessUser;

    public User() {
        this.accessRights = new HashMap<String, String>(0);
    }

    public User(User user) {
        Vector<String> vector;
        this.surname = user.surname;
        this.firstname = user.firstname;
        this.login = User.fixLogin(user.login);
        this.passwd = user.passwd;
        this.systemLoginName = user.systemLoginName;
        this.lastProfileUpdate = user.lastProfileUpdate;
        this.expireDate = user.expireDate;
        this.lockedUntil = user.lockedUntil;
        this.deactivated = user.deactivated;
        this.external = user.external;
        this.access_handle = user.access_handle;
        try {
            this.groups = user.groups == null ? null : new Vector<Group>(user.groups);
            this.secLevel = user.secLevel;
            this.accessRights = new HashMap<String, String>(0);
            if (user.accessRights != null) {
                this.accessRights.putAll(user.accessRights);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        try {
            User user2 = this;
            vector = user.passwordHistory == null ? null : new Vector<String>(user.passwordHistory);
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        user2.passwordHistory = vector;
        this.updatePassword = user.updatePassword;
        this.isEmergencyAccessUser = user.isEmergencyAccessUser;
    }

    public User(String string, String string2, String string3, String string4, Vector<Group> vector, long l, long l2, boolean bl, boolean bl2) {
        this.surname = string2;
        this.firstname = string3;
        this.login = User.fixLogin(string);
        this.passwd = string4;
        this.groups = vector;
        this.expireDate = l;
        this.lockedUntil = l2;
        this.deactivated = bl;
        this.external = bl2;
        this.access_handle = aa.aa(string, string4);
        this.accessRights = new HashMap<String, String>(0);
        this.isEmergencyAccessUser = false;
    }

    public static String fixLogin(String string) {
        String string2;
        try {
            string2 = string != null ? string.toLowerCase() : null;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return string2;
    }

    public static User createUser(String string, String string2, String string3, String string4, Vector<Group> vector, long l, long l2, boolean bl, boolean bl2) {
        User user = new User(string, string2, string3, StringCrypt.cryptString(string4), vector, l, l2, bl, bl2);
        user.setSecLevel(0);
        return user;
    }

    public static User createUser(String string, String string2, String string3, String string4, Group group, long l, long l2, boolean bl, boolean bl2) {
        Vector<Group> vector = new Vector<Group>();
        vector.add(group);
        return User.createUser(string, string2, string3, string4, vector, l, l2, bl, bl2);
    }

    public String getSurname() {
        String string;
        try {
            string = this.surname == null ? "" : this.surname;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return string;
    }

    public String getFirstname() {
        String string;
        try {
            string = this.firstname == null ? "" : this.firstname;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return string;
    }

    public String getLogin() {
        String string;
        try {
            string = this.login == null ? "" : this.login;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return string;
    }

    public String getLastProfileUpdate() {
        String string;
        try {
            string = this.lastProfileUpdate == null ? "" : this.lastProfileUpdate;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return string;
    }

    public void setLastProfileUpdate(String string) {
        this.lastProfileUpdate = string;
    }

    public String getPassword() {
        String string;
        try {
            string = this.passwd == null ? "" : this.passwd;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return string;
    }

    public AccessHandle getAccessHandle() {
        return this.access_handle;
    }

    @Deprecated
    public String getDecryptPassword() {
        try {
            if (this.passwd == null) {
                return "";
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        try {
            if (this.secLevel != 0) {
                throw new IllegalStateException("Wrong security level for the password!");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return StringCrypt.decryptString(this.passwd);
    }

    public int getNumberOfGroups() {
        block4: {
            try {
                try {
                    if (this.groups != null && this.groups.size() != 0) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                return 0;
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        return this.groups.size();
    }

    @Deprecated
    public Group getGroup(int n) {
        return this.getGroup();
    }

    public Group getGroup() {
        block4: {
            try {
                try {
                    if (this.groups != null && this.groups.size() != 0) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                return null;
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        return this.groups.elementAt(0);
    }

    public Vector<Group> getGroups() {
        try {
            if (this.groups == null) {
                this.groups = new Vector();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return this.groups;
    }

    public void setSurname(String string) {
        block4: {
            try {
                try {
                    if (StringTool.isDefined(this.surname) && this.surname.equals(string)) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                this.setDirty(true);
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        this.surname = string;
    }

    public void setFirstname(String string) {
        block4: {
            try {
                try {
                    if (StringTool.isDefined(this.firstname) && this.firstname.equals(string)) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                this.setDirty(true);
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        this.firstname = string;
    }

    public void setLogin(String string) {
        String string2;
        block4: {
            string2 = User.fixLogin(string);
            try {
                try {
                    if (StringTool.isDefined(this.login) && this.login.equals(string2)) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                this.setDirty(true);
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        this.login = string2;
        this.access_handle = aa.aa(this.login, this.passwd);
    }

    public void setUncryptedPassword(String string) {
        String string2;
        block4: {
            string2 = StringCrypt.cryptString(string);
            try {
                try {
                    if (StringTool.isDefined(this.passwd) && this.passwd.equals(string2)) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                this.setDirty(true);
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        this.secLevel = 0;
        this.passwd = string2;
    }

    public void setPassword(String string) {
        block4: {
            try {
                try {
                    if (StringTool.isDefined(this.passwd) && this.passwd.equals(string)) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                this.setDirty(true);
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        this.passwd = string;
        this.access_handle = aa.aa(this.login, this.passwd);
    }

    public void addGroup(Group group) {
        block4: {
            block5: {
                try {
                    try {
                        if (group == null) break block4;
                        if (this.groups != null) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                    this.groups = new Vector();
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
            }
            this.groups.add(group);
        }
    }

    public void removeGroup(Group group) {
        block4: {
            try {
                try {
                    if (group == null || this.groups == null) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                this.groups.remove(group);
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
    }

    public String toString() {
        Object object;
        StringBuffer stringBuffer;
        StringBuffer stringBuffer2 = new StringBuffer(150);
        try {
            stringBuffer2.append("login: ").append(this.login);
            stringBuffer2.append(", surname: ").append(this.surname);
            stringBuffer2.append(", firstname: ").append(this.firstname);
            stringBuffer2.append(", deactivated: ").append(this.deactivated);
            stringBuffer2.append(", lockedUntil: ").append(DateUtils.isoSDF.aa(new Date(this.lockedUntil)));
            stringBuffer2.append(", expireDate: ").append(DateUtils.isoDateSDF.aa(new Date(this.expireDate)));
            stringBuffer2.append(", external: ").append(this.external);
            stringBuffer2.append(", updatePassword: ").append(this.updatePassword);
            stringBuffer = stringBuffer2.append(", passwordHistory: ");
            object = this.passwordHistory == null ? "0" : Integer.valueOf(this.passwordHistory.size());
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        stringBuffer.append(object);
        stringBuffer2.append(" items");
        stringBuffer2.append(", Groups: ");
        if (this.groups != null) {
            try {
                for (int i = 0; i < this.groups.size(); ++i) {
                    stringBuffer2.append("Group ").append(i).append(": ").append(this.groups.elementAt(i)).append(" ");
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        } else {
            stringBuffer2.append("(none)");
        }
        return stringBuffer2.toString();
    }

    public boolean hasAdminRights() {
        if (this.groups != null) {
            int n = 0;
            while (true) {
                block6: {
                    try {
                        try {
                            if (n >= this.groups.size()) break;
                            if (!this.groups.elementAt(n).isAdmin()) break block6;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw User.a(illegalStateException);
                        }
                        return true;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                }
                ++n;
            }
        }
        return false;
    }

    public boolean hasRights(String string) {
        try {
            if (string == null) {
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        if (this.groups != null) {
            int n = 0;
            while (true) {
                block9: {
                    try {
                        try {
                            if (n >= this.groups.size()) break;
                            if (!this.groups.elementAt(n).getRights().equals(string)) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw User.a(illegalStateException);
                        }
                        return true;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                }
                ++n;
            }
        }
        return false;
    }

    public static String cryptPwd(String string) {
        return StringCrypt.cryptString(string);
    }

    public long getExpireDate() {
        return this.expireDate;
    }

    public void setExpireDate(long l) {
        try {
            if (this.expireDate != l) {
                this.setDirty(true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        this.expireDate = l;
    }

    public boolean isExpired() {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (this.expireDate == 0L || System.currentTimeMillis() <= this.expireDate) break block4;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                    bl = true;
                    break block5;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public long getLockedUntil() {
        return this.lockedUntil;
    }

    public void setLockedUntil(long l) {
        try {
            if (this.lockedUntil != l) {
                this.setDirty(true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        this.lockedUntil = l;
    }

    public boolean isLocked() {
        boolean bl;
        try {
            bl = System.currentTimeMillis() < this.lockedUntil;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return bl;
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public boolean loginIsAllowed() {
        boolean bl;
        block7: {
            block6: {
                try {
                    try {
                        try {
                            if (this.isDeactivated() || this.isExpired()) break block6;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw User.a(illegalStateException);
                        }
                        if (this.isLocked()) break block6;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                    bl = true;
                    break block7;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public void setDeactivated(boolean bl) {
        try {
            if (this.deactivated != bl) {
                this.setDirty(true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        this.deactivated = bl;
    }

    public boolean isExternal() {
        return this.external;
    }

    public void setExternal(boolean bl) {
        try {
            if (this.external != bl) {
                this.setDirty(true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        this.external = bl;
    }

    public boolean isUpdatePassword() {
        return this.updatePassword;
    }

    public void setUpdatePassword(boolean bl) {
        try {
            if (this.updatePassword != bl) {
                this.setDirty(true);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        this.updatePassword = bl;
    }

    public void addToPasswordHistory(String string, int n) {
        this.getPasswordHistory().add(string);
        try {
            while (this.passwordHistory.size() > n) {
                this.passwordHistory.remove(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
    }

    public Vector<String> getPasswordHistory() {
        try {
            if (this.passwordHistory == null) {
                this.passwordHistory = new Vector();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return this.passwordHistory;
    }

    public void setPasswordHistory(Vector<String> vector) {
        this.passwordHistory = vector;
    }

    public String getPasswordHistoryString() {
        this.getPasswordHistory();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (true) {
            block5: {
                try {
                    try {
                        if (n >= this.passwordHistory.size()) break;
                        if (n <= 0) break block5;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                    stringBuilder.append("\n");
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
            }
            stringBuilder.append(this.passwordHistory.get(n));
            ++n;
        }
        return stringBuilder.toString();
    }

    public boolean isGhostUser() {
        return this.ghostUser;
    }

    public void setGhostUser(boolean bl) {
        this.ghostUser = bl;
    }

    public String getSystemLoginName() {
        return this.systemLoginName;
    }

    public void setSystemLoginName(String string) {
        this.systemLoginName = string;
        this.setDirty(true);
    }

    public int hashCode() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21 = 31;
        int n22 = 1;
        try {
            n20 = 31 * n22;
            n19 = this.deactivated ? 1231 : 1237;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n20 + n19;
        n22 = 31 * n22 + (int)(this.expireDate ^ this.expireDate >>> 32);
        try {
            n18 = 31 * n22;
            n17 = this.external ? 1231 : 1237;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n18 + n17;
        try {
            n16 = 31 * n22;
            n15 = this.updatePassword ? 1231 : 1237;
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n16 + n15;
        try {
            n14 = 31 * n22;
            n13 = this.firstname == null ? 0 : this.firstname.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n14 + n13;
        try {
            n12 = 31 * n22;
            n11 = this.groups == null ? 0 : this.groups.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n12 + n11;
        try {
            n10 = 31 * n22;
            n9 = this.lastProfileUpdate == null ? 0 : this.lastProfileUpdate.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n10 + n9;
        n22 = 31 * n22 + (int)(this.lockedUntil ^ this.lockedUntil >>> 32);
        try {
            n8 = 31 * n22;
            n7 = this.login == null ? 0 : this.login.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n8 + n7;
        try {
            n6 = 31 * n22;
            n5 = this.passwd == null ? 0 : this.passwd.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n6 + n5;
        try {
            n4 = 31 * n22;
            n3 = this.surname == null ? 0 : this.surname.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n4 + n3;
        try {
            n2 = 31 * n22;
            n = this.passwordHistory == null ? 0 : this.passwordHistory.hashCode();
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        n22 = n2 + n;
        return n22;
    }

    public boolean equals(Object object) {
        block17: {
            User user;
            block16: {
                try {
                    if (this == object) {
                        return true;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                try {
                    if (!(object instanceof User)) {
                        return false;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                user = (User)object;
                try {
                    if (!this.remoteEquals(user, false)) {
                        return false;
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
                try {
                    try {
                        if (this.lastProfileUpdate != null) break block16;
                        if (user.lastProfileUpdate == null) break block17;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                    return false;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
            }
            try {
                if (!this.lastProfileUpdate.equals(user.lastProfileUpdate)) {
                    return false;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        return true;
    }

    public boolean remoteEquals(User user) {
        return this.remoteEquals(user, false);
    }

    public boolean remoteEquals(User user, boolean bl) {
        block78: {
            block77: {
                block75: {
                    block76: {
                        block74: {
                            block73: {
                                block72: {
                                    block70: {
                                        block71: {
                                            block69: {
                                                block68: {
                                                    block67: {
                                                        block66: {
                                                            try {
                                                                if (user == null) {
                                                                    return false;
                                                                }
                                                            }
                                                            catch (IllegalStateException illegalStateException) {
                                                                throw User.a(illegalStateException);
                                                            }
                                                            try {
                                                                if (this.deactivated != user.deactivated) {
                                                                    return false;
                                                                }
                                                            }
                                                            catch (IllegalStateException illegalStateException) {
                                                                throw User.a(illegalStateException);
                                                            }
                                                            try {
                                                                if (this.expireDate != user.expireDate) {
                                                                    return false;
                                                                }
                                                            }
                                                            catch (IllegalStateException illegalStateException) {
                                                                throw User.a(illegalStateException);
                                                            }
                                                            try {
                                                                if (this.external != user.external) {
                                                                    return false;
                                                                }
                                                            }
                                                            catch (IllegalStateException illegalStateException) {
                                                                throw User.a(illegalStateException);
                                                            }
                                                            try {
                                                                if (this.updatePassword != user.updatePassword) {
                                                                    return false;
                                                                }
                                                            }
                                                            catch (IllegalStateException illegalStateException) {
                                                                throw User.a(illegalStateException);
                                                            }
                                                            try {
                                                                try {
                                                                    if (this.firstname != null) break block66;
                                                                    if (user.firstname == null) break block67;
                                                                }
                                                                catch (IllegalStateException illegalStateException) {
                                                                    throw User.a(illegalStateException);
                                                                }
                                                                return false;
                                                            }
                                                            catch (IllegalStateException illegalStateException) {
                                                                throw User.a(illegalStateException);
                                                            }
                                                        }
                                                        try {
                                                            if (!this.firstname.equals(user.firstname)) {
                                                                return false;
                                                            }
                                                        }
                                                        catch (IllegalStateException illegalStateException) {
                                                            throw User.a(illegalStateException);
                                                        }
                                                    }
                                                    try {
                                                        try {
                                                            if (this.groups != null) break block68;
                                                            if (user.groups == null) break block69;
                                                        }
                                                        catch (IllegalStateException illegalStateException) {
                                                            throw User.a(illegalStateException);
                                                        }
                                                        return false;
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw User.a(illegalStateException);
                                                    }
                                                }
                                                try {
                                                    if (!this.groups.equals(user.groups)) {
                                                        return false;
                                                    }
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw User.a(illegalStateException);
                                                }
                                            }
                                            try {
                                                try {
                                                    try {
                                                        if (bl) break block70;
                                                        if (this.passwordHistory != null) break block71;
                                                    }
                                                    catch (IllegalStateException illegalStateException) {
                                                        throw User.a(illegalStateException);
                                                    }
                                                    if (user.passwordHistory == null) break block70;
                                                }
                                                catch (IllegalStateException illegalStateException) {
                                                    throw User.a(illegalStateException);
                                                }
                                                return false;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw User.a(illegalStateException);
                                            }
                                        }
                                        try {
                                            if (!this.passwordHistory.equals(user.passwordHistory)) {
                                                return false;
                                            }
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw User.a(illegalStateException);
                                        }
                                    }
                                    if (this.lockedUntil != user.lockedUntil) {
                                        Calendar calendar = Calendar.getInstance();
                                        Calendar calendar2 = Calendar.getInstance();
                                        try {
                                            try {
                                                calendar.setTimeInMillis(this.lockedUntil);
                                                calendar2.setTimeInMillis(user.lockedUntil);
                                                if (calendar.get(10) == calendar2.get(10) && calendar.get(12) == calendar2.get(12)) break block72;
                                            }
                                            catch (IllegalStateException illegalStateException) {
                                                throw User.a(illegalStateException);
                                            }
                                            return false;
                                        }
                                        catch (IllegalStateException illegalStateException) {
                                            throw User.a(illegalStateException);
                                        }
                                    }
                                }
                                try {
                                    try {
                                        if (this.login != null) break block73;
                                        if (user.login == null) break block74;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        throw User.a(illegalStateException);
                                    }
                                    return false;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw User.a(illegalStateException);
                                }
                            }
                            try {
                                if (!this.login.equals(user.login)) {
                                    return false;
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw User.a(illegalStateException);
                            }
                        }
                        try {
                            try {
                                try {
                                    if (bl) break block75;
                                    if (this.passwd != null) break block76;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw User.a(illegalStateException);
                                }
                                if (user.passwd == null) break block75;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw User.a(illegalStateException);
                            }
                            return false;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw User.a(illegalStateException);
                        }
                    }
                    try {
                        if (!this.passwd.equals(user.passwd)) {
                            return false;
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                }
                try {
                    try {
                        if (this.surname != null) break block77;
                        if (user.surname == null) break block78;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw User.a(illegalStateException);
                    }
                    return false;
                }
                catch (IllegalStateException illegalStateException) {
                    throw User.a(illegalStateException);
                }
            }
            try {
                if (!this.surname.equals(user.surname)) {
                    return false;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw User.a(illegalStateException);
            }
        }
        return true;
    }

    @Override
    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean hasRoles() {
        boolean bl;
        try {
            if (this.groups == null) {
                return false;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        try {
            bl = !this.groups.get(0).getRoles().isEmpty();
        }
        catch (IllegalStateException illegalStateException) {
            throw User.a(illegalStateException);
        }
        return bl;
    }

    public int getSecLevel() {
        return this.secLevel;
    }

    public void setSecLevel(int n) {
        this.secLevel = n;
    }

    public String getAccessRightValue(String string) {
        return this.accessRights.get(string);
    }

    public void addAccessRightValue(String string, String string2) {
        this.accessRights.put(string, string2);
    }

    public void addAccessRights(Map<String, String> map) {
        this.accessRights.putAll(map);
    }

    public Map<String, String> getAccessRights() {
        return this.accessRights;
    }

    public boolean isEmergencyAccessUser() {
        return this.isEmergencyAccessUser;
    }

    public void setEmergencyAccessUser(boolean bl) {
        this.isEmergencyAccessUser = bl;
    }

    private static IllegalStateException a(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

