/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.user;

import com.visustt.jiveX.general.data.user.Role;
import com.visustt.jiveX.general.data.user.UserManagerDataObject;
import com.visustt.tools.ab.ad;
import com.visustt.tools.lang.StringTool;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class Group
implements UserManagerDataObject {
    private static final long serialVersionUID = 7646299495349210071L;
    public static final String ALL_RIGHT = "All";
    public static final String DELETE_RIGHT = "Delete";
    public static final String EDIT_RIGHT = "Edit";
    public static final String READ_RIGHT = "Read";
    public static final String[] rightValues = new String[]{"All", "Delete", "Edit", "Read"};
    private String name = null;
    String sqlAppend = null;
    private String excludeMSQNodes = null;
    private Collection<Role> roleList;
    private String rights = "Read";
    private String lastProfileUpdate = null;
    private transient boolean isDirty = false;
    private transient boolean isNew = false;
    private boolean deleted;
    private boolean disableSqlAppendForHcm = false;

    public Group() {
    }

    public Group(String string, String string2, String string3) {
        this.name = string;
        this.sqlAppend = string3;
        this.rights = string2;
    }

    public Group(String string, String string2, String string3, String string4) {
        this(string, string2, string3);
        this.disableSqlAppendForHcm = Boolean.valueOf(string4);
    }

    public String getName() {
        return this.name == null ? "" : this.name;
    }

    public String getSQLAppend() {
        return this.sqlAppend == null ? "" : this.sqlAppend;
    }

    public String getExcludeMSQNodes() {
        return this.excludeMSQNodes == null ? "" : this.excludeMSQNodes;
    }

    public Set<String> getExcludedMSQNodesSet() {
        return StringTool.isDefined(this.excludeMSQNodes) ? ad.aa(this.excludeMSQNodes.split("\\\\")) : ad.aa();
    }

    public Collection<Role> getRoles() {
        if (this.roleList == null) {
            this.roleList = new ArrayList<Role>();
        }
        return this.roleList;
    }

    public Collection<String> getRoleNames() {
        Collection<Role> collection = this.getRoles();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Role role : collection) {
            arrayList.add(role.getName());
        }
        return arrayList;
    }

    public void setRoles(Collection<Role> collection) {
        this.roleList = collection;
    }

    public void setName(String string) {
        if (!StringTool.isDefined(this.name) || !this.name.equals(string)) {
            this.setDirty(true);
        }
        this.name = string;
    }

    public void setSqlAppend(String string) {
        if (!StringTool.isDefined(this.sqlAppend) || !this.sqlAppend.equals(string)) {
            this.setDirty(true);
        }
        this.sqlAppend = string;
    }

    public void setExcludeMSQNodes(String string) {
        if (!StringTool.isDefined(this.excludeMSQNodes) || !this.excludeMSQNodes.equals(string)) {
            this.setDirty(true);
        }
        this.excludeMSQNodes = string;
    }

    public boolean addRole(Role role) {
        return this.getRoles().add(role);
    }

    public boolean removeRole(Role role) {
        return this.getRoles().remove(role);
    }

    public String toString() {
        return String.format("Name: %s, SQL: %s, Rights: %s, Roles: %s, disableSqlAppendForHcm: %s, last profile update: %s, excluded MSQ nodes: %s", this.name, this.sqlAppend, this.rights, this.getRoleNames(), this.isDisableSqlAppendForHcm(), this.lastProfileUpdate, this.getExcludeMSQNodes());
    }

    public String getRights() {
        return this.rights == null ? "" : this.rights;
    }

    public int getRightsAsInt() {
        if (this.rights.equals(READ_RIGHT)) {
            return 1;
        }
        if (this.rights.equals(EDIT_RIGHT)) {
            return 2;
        }
        if (this.rights.equals(DELETE_RIGHT)) {
            return 3;
        }
        if (this.rights.equals(ALL_RIGHT)) {
            return 4;
        }
        return 0;
    }

    public void setRights(String string) {
        if (this.rights != string) {
            this.setDirty(true);
        }
        this.rights = string;
    }

    public boolean isAdmin() {
        return this.getRights().equals(ALL_RIGHT);
    }

    public String getLastProfileUpdate() {
        return this.lastProfileUpdate == null ? "" : this.lastProfileUpdate;
    }

    public void setLastProfileUpdate(String string) {
        this.lastProfileUpdate = string;
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Group group = (Group)object;
        return !(this.name == null ? group.name != null : !this.name.equals(group.name));
    }

    public boolean completelyEquals(Group group) {
        return this.remoteEquals(group) && this.rolesEquals(group);
    }

    public boolean remoteEquals(Group group) {
        String string;
        if (this == group) {
            return true;
        }
        if (!this.equals(group) || !this.rights.equals(group.rights) || this.disableSqlAppendForHcm != group.disableSqlAppendForHcm) {
            return false;
        }
        String string2 = StringTool.removeAllWhitespaces(StringTool.nullToEmpty(this.excludeMSQNodes));
        if (!string2.equals(string = StringTool.removeAllWhitespaces(StringTool.nullToEmpty(group.excludeMSQNodes)))) {
            return false;
        }
        String string3 = StringTool.removeAllWhitespaces(StringTool.nullToEmpty(this.sqlAppend));
        String string4 = StringTool.removeAllWhitespaces(StringTool.nullToEmpty(group.sqlAppend));
        return string3.equals(string4);
    }

    public boolean rolesEquals(Group group) {
        if (this.getRoles().size() != group.getRoles().size()) {
            return false;
        }
        HashSet<Role> hashSet = new HashSet<Role>(this.getRoles());
        HashSet<Role> hashSet2 = new HashSet<Role>(group.getRoles());
        return hashSet.equals(hashSet2);
    }

    @Override
    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    @Override
    public boolean isNew() {
        return this.isNew;
    }

    @Override
    public void setDeleted(boolean bl) {
        this.deleted = bl;
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    public static Group clone(Group group) {
        if (group == null) {
            return null;
        }
        Group group2 = new Group();
        group2.deleted = group.deleted;
        group2.isDirty = group.isDirty;
        group2.isNew = group.isNew;
        group2.lastProfileUpdate = group.lastProfileUpdate;
        group2.name = group.name;
        group2.rights = group.rights;
        group2.roleList = new ArrayList<Role>();
        group2.roleList.addAll(group.roleList);
        group2.sqlAppend = group.sqlAppend;
        group2.excludeMSQNodes = group.excludeMSQNodes;
        group2.disableSqlAppendForHcm = group.disableSqlAppendForHcm;
        return group2;
    }

    public boolean isDisableSqlAppendForHcm() {
        return this.disableSqlAppendForHcm;
    }

    public void setDisableSqlAppendForHcm(boolean bl) {
        this.disableSqlAppendForHcm = bl;
    }
}

