/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.studydefinition;

import com.visustt.jTools.configManager.main.ConfigurationElement;
import com.visustt.jiveX.general.criteria.StudyCriteria;
import com.visustt.jiveX.general.criteria.StudyCriteriaUtil;
import com.visustt.jiveX.general.data.priorstudies.PriorStudiesDefinition;
import com.visustt.jiveX.general.data.priorstudies.StudyAttributes;
import com.visustt.jiveX.general.data.priorstudies.StudyDefinition;
import com.visustt.jiveX.general.data.priorstudies.StudyDefinitionList;
import com.visustt.tools.ab.ab;
import com.visustt.tools.config.main.ConfigurationException;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.lang.al;
import com.visustt.tools.lang.am;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public abstract class StudyDefinitionListFactory {
    private static final Logger logger = LoggerFactory.getInstance("StudyDefinitionListFactory");

    public static StudyDefinitionList fromConfigurationElement(ConfigurationElement configurationElement) throws ConfigurationException {
        return StudyDefinitionListFactory.fromConfigurationElement(configurationElement, true);
    }

    public static StudyDefinitionList fromConfigurationElement(ConfigurationElement configurationElement, boolean bl) throws ConfigurationException {
        StudyDefinitionList studyDefinitionList = new StudyDefinitionList();
        try {
            if (configurationElement == null) {
                return studyDefinitionList;
            }
        }
        catch (ConfigurationException configurationException) {
            throw StudyDefinitionListFactory.a(configurationException);
        }
        Vector<ConfigurationElement> vector = configurationElement.getAllChildren();
        for (int i = 0; i < vector.size(); ++i) {
            StudyDefinition studyDefinition;
            block11: {
                ConfigurationElement configurationElement2 = vector.elementAt(i);
                studyDefinition = StudyDefinitionListFactory.parseStudyDefinition(configurationElement2, i);
                try {
                    try {
                        if (StudyDefinitionListFactory.canInsert(studyDefinitionList, studyDefinition) || !bl) break block11;
                    }
                    catch (ConfigurationException configurationException) {
                        throw StudyDefinitionListFactory.a(configurationException);
                    }
                    logger.warn("Found duplicate HangingProtocol criterium:" + studyDefinition.getMainStudyModality() + " - " + studyDefinition.getMainStudyDescription() + " ! Deactivating this hanging protocol: " + studyDefinition.getAlias());
                    studyDefinition.setUseAutomatically(false);
                }
                catch (ConfigurationException configurationException) {
                    throw StudyDefinitionListFactory.a(configurationException);
                }
            }
            studyDefinitionList.addStudyDefinition(studyDefinition);
        }
        try {
            if (logger.debugIsEnabled()) {
                logger.debug(studyDefinitionList);
            }
        }
        catch (ConfigurationException configurationException) {
            throw StudyDefinitionListFactory.a(configurationException);
        }
        return studyDefinitionList;
    }

    private static boolean canInsert(StudyDefinitionList studyDefinitionList, StudyDefinition studyDefinition) {
        if (studyDefinition.isUseAutomatically()) {
            String string = studyDefinition.getMainStudyModality();
            String string2 = studyDefinition.getMainStudyDescription();
            List<StudyDefinition> list = studyDefinitionList.getAllStudyDefinitions();
            for (StudyDefinition studyDefinition2 : list) {
                if (!studyDefinition2.isUseAutomatically()) continue;
                String string3 = studyDefinition2.getMainStudyModality();
                String string4 = studyDefinition2.getMainStudyDescription();
                if (!al.aa((Object)string, (Object)string3) || !al.aa((Object)string2, (Object)string4)) continue;
                return false;
            }
        }
        return true;
    }

    protected static StudyDefinition parseStudyDefinition(ConfigurationElement configurationElement, int n) throws ConfigurationException {
        Serializable serializable;
        String string;
        Object object;
        block23: {
            object = null;
            if (configurationElement.checkForAttribute("alias")) {
                object = configurationElement.getStringValue("alias");
            }
            try {
                if (object != null && ((String)object).length() != 0) break block23;
            }
            catch (ConfigurationException configurationException) {
                throw StudyDefinitionListFactory.a(configurationException);
            }
            object = "HangProt " + n;
        }
        object = StringTool.convertHTMLToString((String)object);
        String string2 = configurationElement.getStringValue("modality");
        if (!StringTool.isDefined(string2)) {
            string2 = "*";
        }
        if (!StringTool.isDefined(string = configurationElement.getStringValue("studydescription"))) {
            string = "*";
        }
        string = StringTool.convertHTMLToString(string);
        Vector<ConfigurationElement> vector = configurationElement.getAllChildren();
        int n2 = configurationElement.getIntValue("priority", Integer.MAX_VALUE);
        ArrayList<StudyCriteria> arrayList = ab.aa(3);
        StudyCriteria studyCriteria = StudyCriteriaUtil.createStudyCriteria(string2, string);
        arrayList.add(studyCriteria);
        boolean bl = true;
        if (configurationElement.getChild("AutomaticallyUseHP") != null) {
            serializable = configurationElement.getChild("AutomaticallyUseHP").getAttribute("mode");
            bl = Boolean.valueOf((String)((Vector)serializable).firstElement());
        }
        serializable = new StudyDefinition((String)object, n2, bl, arrayList);
        ((StudyDefinition)serializable).setPriority(n2);
        for (int i = 0; i < vector.size(); ++i) {
            ConfigurationElement[] configurationElementArray;
            ConfigurationElement configurationElement2;
            ConfigurationElement configurationElement3 = vector.elementAt(i);
            String string3 = configurationElement3.getName();
            try {
                if (string3.equals("PreliminaryEnquiry")) {
                    StudyDefinitionListFactory.parsePreviousStudyCfg((StudyDefinition)serializable, configurationElement3);
                    continue;
                }
            }
            catch (ConfigurationException configurationException) {
                throw StudyDefinitionListFactory.a(configurationException);
            }
            if (string3.equals("PreliminaryEnquiryHPSelection")) {
                configurationElement2 = configurationElement.getChild("PreliminaryEnquiryHPSelection");
                configurationElementArray = configurationElement2.getStringValue("enabled");
                ((StudyDefinition)serializable).setLoadCriteriaRelatedStudies(Boolean.parseBoolean((String)configurationElementArray));
                continue;
            }
            if (!string3.equals("HangingProtocolSelection") || (configurationElement2 = configurationElement.getChild("HangingProtocolSelection")) == null) continue;
            configurationElementArray = configurationElement2.getAllChildrenWithName("StudyCriteria");
            boolean bl2 = false;
            for (ConfigurationElement configurationElement4 : configurationElementArray) {
                StudyCriteria studyCriteria2;
                block24: {
                    block25: {
                        block26: {
                            studyCriteria2 = new StudyCriteria(configurationElement4);
                            try {
                                try {
                                    try {
                                        if (!studyCriteria2.isMainStudyCriteria()) break block24;
                                        if (bl2) break block25;
                                    }
                                    catch (ConfigurationException configurationException) {
                                        throw StudyDefinitionListFactory.a(configurationException);
                                    }
                                    if (studyCriteria2.getCriteriaList().isEmpty()) break block26;
                                }
                                catch (ConfigurationException configurationException) {
                                    throw StudyDefinitionListFactory.a(configurationException);
                                }
                                studyCriteria.getCriteriaList().addAll(studyCriteria2.getCriteriaList());
                            }
                            catch (ConfigurationException configurationException) {
                                throw StudyDefinitionListFactory.a(configurationException);
                            }
                        }
                        try {
                            if (!studyCriteria2.getSeriesCriteriaList().isEmpty()) {
                                studyCriteria.getSeriesCriteriaList().addAll(studyCriteria2.getSeriesCriteriaList());
                            }
                        }
                        catch (ConfigurationException configurationException) {
                            throw StudyDefinitionListFactory.a(configurationException);
                        }
                        bl2 = true;
                        continue;
                    }
                    try {
                        if (!logger.infoIsEnabled()) continue;
                        logger.info("skipping additional main study criteria: " + studyCriteria2 + " for alias: " + ((StudyDefinition)serializable).getAlias());
                        continue;
                    }
                    catch (ConfigurationException configurationException) {
                        throw StudyDefinitionListFactory.a(configurationException);
                    }
                }
                arrayList.add(studyCriteria2);
            }
        }
        return serializable;
    }

    public static void parsePreviousStudyCfg(StudyDefinition studyDefinition, ConfigurationElement configurationElement) throws ConfigurationException {
        int n;
        PriorStudiesDefinition priorStudiesDefinition = studyDefinition.getPriorStudiesDefinition();
        priorStudiesDefinition.setLoadPriorStudies(Boolean.TRUE);
        if (configurationElement.checkForAttribute("maxNumOfStudies")) {
            int n2 = configurationElement.getIntValue("maxNumOfStudies");
            priorStudiesDefinition.setMaxNumberOfStudies(n2);
        }
        if (configurationElement.checkForAttribute("startingFromDate")) {
            String string = configurationElement.getStringValue("startingFromDate");
            priorStudiesDefinition.setStartDate(string);
        }
        if (configurationElement.checkForAttribute("loadOldestStudy")) {
            String string = configurationElement.getStringValue("loadOldestStudy");
            priorStudiesDefinition.setLoadIncludeLastStudy(Boolean.valueOf(string));
        }
        if (configurationElement.checkForAttribute("dateRange")) {
            String string = configurationElement.getStringValue("dateRange");
            priorStudiesDefinition.setDateRange(string);
        }
        Vector<StudyAttributes> vector = new Vector<StudyAttributes>();
        Vector<ConfigurationElement> vector2 = configurationElement.getAllChildren();
        for (n = 0; n < vector2.size(); n += 1) {
            ConfigurationElement configurationElement2 = vector2.elementAt(n);
            String string = configurationElement2.getName();
            if (!string.equals("LoadStudy")) continue;
            String string2 = configurationElement2.getStringValue("modality");
            String string3 = configurationElement2.getStringValue("studydescription");
            string3 = StringTool.convertHTMLToString(string3);
            StudyAttributes studyAttributes = new StudyAttributes(string2, string3);
            vector.add(studyAttributes);
        }
        try {
            if (vector.size() > 0) {
                priorStudiesDefinition.setPriorStudyAttributes(vector);
            }
        }
        catch (ConfigurationException configurationException) {
            throw StudyDefinitionListFactory.a(configurationException);
        }
        if (configurationElement.checkForAttribute("PreliminaryEnquiryOrdered")) {
            n = configurationElement.getBooleanValue("PreliminaryEnquiryOrdered") ? 1 : 0;
            priorStudiesDefinition.setSortStudiesByDate(n != 0);
        }
    }

    public static ConfigurationElement toConfigurationElement(StudyDefinitionList studyDefinitionList) {
        ConfigurationElement configurationElement = new ConfigurationElement("HangingProtocolConfiguration");
        Iterator<StudyDefinition> iterator = studyDefinitionList.getAllStudyDefinitions().iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        while (iterator.hasNext()) {
            StudyDefinition studyDefinition = iterator.next();
            ConfigurationElement configurationElement2 = StudyDefinitionListFactory.createConfig(studyDefinition);
            configurationElement.addChild(configurationElement2);
        }
        return configurationElement;
    }

    private static ConfigurationElement createConfig(StudyDefinition studyDefinition) {
        ConfigurationElement configurationElement;
        String string;
        ConfigurationElement configurationElement2 = new ConfigurationElement("HangingProtocolConfigurationValue");
        configurationElement2.addAttribute("alias", StringTool.convertStringToHTML(studyDefinition.getAlias()));
        String string2 = studyDefinition.getMainStudyModality();
        if (string2 != null) {
            configurationElement2.addAttribute("modality", string2);
        }
        if ((string = studyDefinition.getMainStudyDescription()) != null) {
            configurationElement2.addAttribute("studydescription", StringTool.convertStringToHTML(string));
        }
        if (studyDefinition.getPriorStudiesDefinition() != null && studyDefinition.getPriorStudiesDefinition().getLoadPriorStudies() != null) {
            configurationElement = StudyDefinitionListFactory.createPrelimConfig(studyDefinition);
            configurationElement2.addChild(configurationElement);
        }
        if (am.aa(studyDefinition.getStudySelectionCriteria())) {
            configurationElement = new ConfigurationElement("HangingProtocolSelection");
            for (StudyCriteria studyCriteria : studyDefinition.getStudySelectionCriteria()) {
                ConfigurationElement configurationElement3 = studyCriteria.createXMLConfiguration();
                configurationElement.addChild(configurationElement3);
            }
            configurationElement2.addChild(configurationElement);
        }
        if (studyDefinition.isLoadCriteriaRelatedStudies()) {
            configurationElement = new ConfigurationElement("PreliminaryEnquiryHPSelection");
            configurationElement.addAttribute("enabled", String.valueOf(studyDefinition.isLoadCriteriaRelatedStudies()));
            configurationElement2.addChild(configurationElement);
        }
        return configurationElement2;
    }

    public static ConfigurationElement createPrelimConfig(StudyDefinition studyDefinition) {
        ConfigurationElement configurationElement = new ConfigurationElement("PreliminaryEnquiry");
        configurationElement.addAttribute("enabled", "true");
        PriorStudiesDefinition priorStudiesDefinition = studyDefinition.getPriorStudiesDefinition();
        if (priorStudiesDefinition.getMaxNumberOfStudies() != null) {
            configurationElement.addAttribute("maxNumOfStudies", String.valueOf(priorStudiesDefinition.getMaxNumberOfStudies()));
        }
        if (priorStudiesDefinition.getStartDate() != null) {
            configurationElement.addAttribute("startingFromDate", priorStudiesDefinition.getStartDate());
        }
        configurationElement.addAttribute("loadOldestStudy", "" + priorStudiesDefinition.isLoadIncludeLastStudy());
        if (priorStudiesDefinition.getDateRange() != null) {
            configurationElement.addAttribute("dateRange", priorStudiesDefinition.getDateRange());
        }
        if (priorStudiesDefinition.getPriorStudyAttributes() != null) {
            Vector<StudyAttributes> vector = priorStudiesDefinition.getPriorStudyAttributes();
            for (int i = 0; i < vector.size(); ++i) {
                StudyAttributes studyAttributes = vector.get(i);
                ConfigurationElement configurationElement2 = new ConfigurationElement("LoadStudy", configurationElement);
                configurationElement2.addAttribute("modality", studyAttributes.getModality());
                configurationElement2.addAttribute("studydescription", StringTool.convertStringToHTML(studyAttributes.getStudyDescription()));
            }
        }
        return configurationElement;
    }

    private static ConfigurationException a(ConfigurationException configurationException) {
        return configurationException;
    }
}

