/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.sql;

import com.visustt.tools.lang.StringTool;
import com.visustt.tools.lang.al;
import java.io.Serializable;

public final class TableColumn
implements Serializable,
Cloneable,
Comparable<TableColumn> {
    private static final long serialVersionUID = 8715240397784028091L;
    private final String tableName;
    private final String columnName;

    private TableColumn(String string, String string2) {
        this.tableName = StringTool.nullToEmpty(string);
        this.columnName = StringTool.nullToEmpty(string2);
    }

    static TableColumn of(String string, String string2) {
        return new TableColumn(string, string2);
    }

    static TableColumn of(String string) {
        return new TableColumn(null, string);
    }

    final String getTable() {
        return this.tableName;
    }

    final String getColumn() {
        return this.columnName;
    }

    final String getAbsoluteName() {
        return StringTool.isDefined(this.tableName) ? this.tableName + "." + this.columnName : this.columnName;
    }

    @Override
    public final int compareTo(TableColumn tableColumn) {
        if (tableColumn == null) {
            return 1;
        }
        return this.getAbsoluteName().compareTo(tableColumn.getAbsoluteName());
    }

    public final int hashCode() {
        return this.getAbsoluteName().hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TableColumn tableColumn = (TableColumn)object;
        return al.aa((Object)this.getAbsoluteName(), (Object)tableColumn.getAbsoluteName());
    }

    public final Object clone() {
        return new TableColumn(this.tableName, this.columnName);
    }

    public final String toString() {
        return this.getAbsoluteName();
    }
}

