/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.sql;

import com.visustt.jiveX.general.data.sql.RowSetMergeDelegator;
import com.visustt.jiveX.general.data.sql.TableColumn;
import com.visustt.jiveX.general.data.sql.TableColumns;
import com.visustt.jiveX.tools.database.utils.ab;
import com.visustt.tools.lang.am;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

public class RowSet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -782329198570361164L;
    protected Vector<Vector<Object>> resultRows_;
    protected int numOfColumns_;
    private int currentRow_;
    private int offset_;
    protected int sizeOfResultSet_;
    private boolean lastWasNull_;
    private boolean validSize;
    private boolean resultTrimmed;
    private boolean suppressMaxRows;
    private List<TableColumn> tableColumns;

    public RowSet(ResultSet resultSet) throws SQLException {
        this(resultSet, 0, -1, true);
    }

    public RowSet(ResultSet resultSet, int n, int n2) throws SQLException {
        this(resultSet, n, n2, false);
    }

    public RowSet(ResultSet resultSet, int n, int n2, boolean bl) throws SQLException {
        block15: {
            block16: {
                block14: {
                    this.resultRows_ = null;
                    this.numOfColumns_ = 0;
                    this.currentRow_ = 0;
                    this.offset_ = 0;
                    this.sizeOfResultSet_ = -1;
                    this.lastWasNull_ = false;
                    this.validSize = true;
                    this.resultTrimmed = false;
                    this.suppressMaxRows = false;
                    this.offset_ = n;
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    this.numOfColumns_ = resultSetMetaData.getColumnCount();
                    this.resultRows_ = new Vector();
                    int n3 = 0;
                    try {
                        if (n > 0) {
                            resultSet.absolute(n);
                        }
                    }
                    catch (SQLException sQLException) {
                        throw RowSet.b(sQLException);
                    }
                    if (n2 <= 0) {
                        n2 = Integer.MAX_VALUE;
                    }
                    while (true) {
                        try {
                            if (!resultSet.next() || n3 >= n2) break;
                        }
                        catch (SQLException sQLException) {
                            throw RowSet.b(sQLException);
                        }
                        Vector<Object> vector = new Vector<Object>(this.numOfColumns_);
                        try {
                            for (int i = 1; i <= this.numOfColumns_; ++i) {
                                vector.add(ab.ab(i, resultSet));
                            }
                        }
                        catch (SQLException sQLException) {
                            throw RowSet.b(sQLException);
                        }
                        this.resultRows_.addElement(vector);
                        ++n3;
                    }
                    try {
                        if (n3 >= n2) break block14;
                        this.sizeOfResultSet_ = n3 + n;
                        break block15;
                    }
                    catch (SQLException sQLException) {
                        throw RowSet.b(sQLException);
                    }
                }
                try {
                    if (!bl) break block16;
                    this.validSize = false;
                    break block15;
                }
                catch (SQLException sQLException) {
                    throw RowSet.b(sQLException);
                }
            }
            resultSet.last();
            this.sizeOfResultSet_ = resultSet.getRow();
        }
    }

    public RowSet(Vector vector, int n, int n2, int n3) {
        this.resultRows_ = null;
        this.numOfColumns_ = 0;
        this.currentRow_ = 0;
        this.offset_ = 0;
        this.sizeOfResultSet_ = -1;
        this.lastWasNull_ = false;
        this.validSize = true;
        this.resultTrimmed = false;
        this.suppressMaxRows = false;
        this.resultRows_ = vector;
        this.numOfColumns_ = n;
        this.offset_ = n2;
        this.sizeOfResultSet_ = n3;
    }

    public int getOffset() {
        return this.offset_;
    }

    public boolean isEmpty() {
        boolean bl;
        try {
            bl = this.sizeOfResultSet_ == 0;
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        return bl;
    }

    public int getSizeOfResultSet() {
        return this.sizeOfResultSet_;
    }

    public void setSizeOfResultSet(int n) {
        this.sizeOfResultSet_ = n;
    }

    public void close() throws SQLException {
        try {
            if (this.resultRows_ != null) {
                this.resultRows_.removeAllElements();
                this.resultRows_ = null;
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        this.numOfColumns_ = 0;
        this.currentRow_ = 0;
    }

    public int size() {
        try {
            if (this.resultRows_ != null) {
                return this.resultRows_.size();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        return 0;
    }

    public boolean absolute(int n) throws SQLException {
        block11: {
            block9: {
                block10: {
                    block8: {
                        try {
                            if (n <= 0) break block8;
                            this.currentRow_ = n;
                            break block9;
                        }
                        catch (SQLException sQLException) {
                            throw RowSet.b(sQLException);
                        }
                    }
                    try {
                        if (n >= 0) break block10;
                        this.currentRow_ = this.size() - n + 1;
                        break block9;
                    }
                    catch (SQLException sQLException) {
                        throw RowSet.b(sQLException);
                    }
                }
                throw new SQLException("function called with invalid argument (row=0)");
            }
            try {
                try {
                    if (this.currentRow_ <= 0 || this.currentRow_ > this.size()) break block11;
                }
                catch (SQLException sQLException) {
                    throw RowSet.b(sQLException);
                }
                return true;
            }
            catch (SQLException sQLException) {
                throw RowSet.b(sQLException);
            }
        }
        this.currentRow_ = 0;
        return false;
    }

    public void reset() {
        this.currentRow_ = 0;
    }

    public boolean first() throws SQLException {
        try {
            if (this.size() > 0) {
                this.currentRow_ = 1;
                return true;
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        this.currentRow_ = 0;
        return false;
    }

    public boolean last() throws SQLException {
        boolean bl;
        try {
            this.currentRow_ = this.size();
            bl = this.currentRow_ > 0;
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        return bl;
    }

    public boolean relative(int n) throws SQLException {
        block7: {
            try {
                if (this.currentRow_ == 0) {
                    throw new SQLException("this function requires the cursor to be on a valid row");
                }
            }
            catch (SQLException sQLException) {
                throw RowSet.b(sQLException);
            }
            try {
                try {
                    this.currentRow_ += n;
                    if (this.currentRow_ <= 0 || this.currentRow_ > this.size()) break block7;
                }
                catch (SQLException sQLException) {
                    throw RowSet.b(sQLException);
                }
                return true;
            }
            catch (SQLException sQLException) {
                throw RowSet.b(sQLException);
            }
        }
        this.currentRow_ = 0;
        return false;
    }

    public boolean next() throws SQLException {
        try {
            if (this.currentRow_ < this.size()) {
                ++this.currentRow_;
                return true;
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        this.currentRow_ = 0;
        return false;
    }

    public boolean previous() throws SQLException {
        boolean bl;
        block5: {
            block4: {
                try {
                    if (this.currentRow_ <= 0) break block4;
                    --this.currentRow_;
                    break block5;
                }
                catch (SQLException sQLException) {
                    throw RowSet.b(sQLException);
                }
            }
            this.currentRow_ = this.size();
        }
        try {
            bl = this.currentRow_ > 0;
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        return bl;
    }

    public boolean isFirst() throws SQLException {
        boolean bl;
        try {
            bl = this.currentRow_ == 1;
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        return bl;
    }

    public boolean isLast() throws SQLException {
        boolean bl;
        block5: {
            block4: {
                try {
                    try {
                        if (this.currentRow_ != this.size() || this.size() <= 0) break block4;
                    }
                    catch (SQLException sQLException) {
                        throw RowSet.b(sQLException);
                    }
                    bl = true;
                    break block5;
                }
                catch (SQLException sQLException) {
                    throw RowSet.b(sQLException);
                }
            }
            bl = false;
        }
        return bl;
    }

    public int getRow() throws SQLException {
        return this.currentRow_;
    }

    public Vector getResultRows() {
        return this.resultRows_;
    }

    public Object getObject(int n) throws SQLException {
        boolean bl;
        try {
            if (this.currentRow_ == 0) {
                throw new SQLException("this function requires the cursor to be on a valid row");
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        try {
            if (n > this.numOfColumns_) {
                throw new SQLException("column index out of range");
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        Vector<Object> vector = this.resultRows_.elementAt(this.currentRow_ - 1);
        Object object = vector.elementAt(n - 1);
        try {
            RowSet rowSet = this;
            bl = object == null;
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        rowSet.lastWasNull_ = bl;
        return object;
    }

    public String getString(int n) throws SQLException {
        String string;
        Object object = this.getObject(n);
        try {
            string = object != null ? object.toString() : null;
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        return string;
    }

    public double getDouble(int n) throws SQLException {
        Object object = this.getObject(n);
        try {
            if (object == null) {
                return 0.0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        try {
            if (object instanceof Number) {
                return ((Number)object).doubleValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("wrong accessor function: column value is not a double");
        }
    }

    public float getFloat(int n) throws SQLException {
        Object object = this.getObject(n);
        try {
            if (object == null) {
                return 0.0f;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        try {
            if (object instanceof Number) {
                return ((Number)object).floatValue();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        try {
            return Float.parseFloat(object.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new SQLException("wrong accessor function: column value is not a float");
        }
    }

    /*
     * Loose catch block
     */
    public long getLong(int n) throws SQLException {
        block15: {
            Object object;
            block14: {
                object = this.getObject(n);
                try {
                    if (object == null) {
                        return 0L;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw RowSet.b(numberFormatException);
                }
                try {
                    if (!(object instanceof Double) && !(object instanceof Float)) break block14;
                }
                catch (NumberFormatException numberFormatException) {
                    throw RowSet.b(numberFormatException);
                }
                long l = ((Number)object).longValue();
                if (l < Long.MIN_VALUE) break block15;
                try {
                    block16: {
                        if (l > Long.MAX_VALUE) break block15;
                        break block16;
                        catch (NumberFormatException numberFormatException) {
                            throw RowSet.b(numberFormatException);
                        }
                    }
                    return l;
                }
                catch (NumberFormatException numberFormatException) {
                    throw RowSet.b(numberFormatException);
                }
            }
            try {
                if (object instanceof Number) {
                    return ((Number)object).longValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw RowSet.b(numberFormatException);
            }
            try {
                return Long.parseLong(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new SQLException("wrong accessor function: column value is not a long");
    }

    /*
     * Loose catch block
     */
    public int getInt(int n) throws SQLException {
        block18: {
            Object object;
            block17: {
                block16: {
                    object = this.getObject(n);
                    try {
                        if (object == null) {
                            return 0;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw RowSet.b(numberFormatException);
                    }
                    if (object instanceof Double) break block16;
                    try {
                        block19: {
                            if (object instanceof Float) break block16;
                            break block19;
                            catch (NumberFormatException numberFormatException) {
                                throw RowSet.b(numberFormatException);
                            }
                        }
                        if (!(object instanceof Long)) break block17;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw RowSet.b(numberFormatException);
                    }
                }
                double d = ((Number)object).doubleValue();
                if (!(d >= -2.147483648E9)) break block18;
                try {
                    block20: {
                        if (!(d <= 2.147483647E9)) break block18;
                        break block20;
                        catch (NumberFormatException numberFormatException) {
                            throw RowSet.b(numberFormatException);
                        }
                    }
                    return (int)d;
                }
                catch (NumberFormatException numberFormatException) {
                    throw RowSet.b(numberFormatException);
                }
            }
            try {
                if (object instanceof Number) {
                    return ((Number)object).intValue();
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw RowSet.b(numberFormatException);
            }
            try {
                return Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new SQLException("wrong accessor function: column value is not an integer");
    }

    public byte[] getBytes(int n) throws SQLException {
        Object object = this.getObject(n);
        try {
            if (object == null) {
                return null;
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        try {
            if (object instanceof byte[]) {
                return (byte[])object;
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        throw new SQLException("wrong accessor function: column value is not an byte array");
    }

    public boolean wasNull() throws SQLException {
        return this.lastWasNull_;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.numOfColumns_);
        objectOutputStream.writeInt(this.offset_);
        objectOutputStream.writeInt(this.sizeOfResultSet_);
        objectOutputStream.writeInt(this.currentRow_);
        if (this.resultRows_ != null) {
            int n = this.resultRows_.size();
            objectOutputStream.writeInt(n);
            for (int i = 0; i < n; ++i) {
                Vector<Object> vector = this.resultRows_.elementAt(i);
                try {
                    for (int j = 0; j < this.numOfColumns_; ++j) {
                        objectOutputStream.writeObject(vector.elementAt(j));
                    }
                    continue;
                }
                catch (IOException iOException) {
                    throw RowSet.b(iOException);
                }
            }
        }
        try {
            objectOutputStream.writeBoolean(this.resultTrimmed);
            if (am.aa(this.tableColumns)) {
                objectOutputStream.writeObject(this.tableColumns);
            }
        }
        catch (IOException iOException) {
            throw RowSet.b(iOException);
        }
        objectOutputStream.writeBoolean(this.suppressMaxRows);
        objectOutputStream.flush();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.numOfColumns_ = objectInputStream.readInt();
        this.offset_ = objectInputStream.readInt();
        this.sizeOfResultSet_ = objectInputStream.readInt();
        this.currentRow_ = objectInputStream.readInt();
        int n = objectInputStream.readInt();
        this.resultRows_ = new Vector(n);
        for (int i = 0; i < n; ++i) {
            Vector<Object> vector = new Vector<Object>(this.numOfColumns_);
            this.resultRows_.addElement(vector);
            try {
                for (int j = 0; j < this.numOfColumns_; ++j) {
                    vector.addElement(objectInputStream.readObject());
                }
                continue;
            }
            catch (OptionalDataException optionalDataException) {
                throw RowSet.b(optionalDataException);
            }
        }
        try {
            if (objectInputStream.available() > 0) {
                this.resultTrimmed = objectInputStream.readBoolean();
            }
        }
        catch (OptionalDataException optionalDataException) {
            throw RowSet.b(optionalDataException);
        }
        try {
            this.tableColumns = (List)objectInputStream.readObject();
        }
        catch (OptionalDataException optionalDataException) {
            // empty catch block
        }
        try {
            if (objectInputStream.available() > 0) {
                this.suppressMaxRows = objectInputStream.readBoolean();
            }
        }
        catch (OptionalDataException optionalDataException) {
            throw RowSet.b(optionalDataException);
        }
    }

    public boolean isValidSize() {
        return this.validSize;
    }

    public void setValidSize(boolean bl) {
        this.validSize = bl;
    }

    public void setOffset(int n) {
        this.offset_ = n;
    }

    public boolean isResultTrimmed() {
        return this.resultTrimmed;
    }

    public void setResultTrimmed(boolean bl) {
        this.resultTrimmed = bl;
    }

    public int getColumnCount() {
        return this.numOfColumns_;
    }

    public void addColumn(Vector vector) {
        this.addColumn(this.getColumnCount(), vector);
    }

    public void addColumn(int n, Vector vector) {
        try {
            if (vector.size() < this.resultRows_.size()) {
                throw new IllegalArgumentException("Row count does not match.");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        for (int i = 0; i < this.resultRows_.size(); ++i) {
            Vector<Object> vector2 = this.resultRows_.get(i);
            Object e = vector.get(i);
            try {
                if (e instanceof Collection) {
                    throw new IllegalArgumentException("Could not add a collection as column value.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw RowSet.b(numberFormatException);
            }
            vector2.add(n, e);
        }
        ++this.numOfColumns_;
    }

    public RowSet merge(RowSet rowSet) throws SQLException {
        return this.merge(rowSet, null);
    }

    public RowSet merge(RowSet rowSet, RowSetMergeDelegator rowSetMergeDelegator) throws SQLException {
        Vector<Object> vector;
        int n;
        try {
            if (rowSetMergeDelegator != null) {
                return rowSetMergeDelegator.merge(this, rowSet);
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        try {
            if (this.numOfColumns_ != rowSet.numOfColumns_) {
                throw new SQLException("Column count does not match. This:" + this.numOfColumns_ + ", other:" + rowSet.numOfColumns_);
            }
        }
        catch (SQLException sQLException) {
            throw RowSet.b(sQLException);
        }
        int n2 = this.sizeOfResultSet_ + rowSet.sizeOfResultSet_;
        Vector<Vector<Object>> vector2 = new Vector<Vector<Object>>(n2);
        for (n = 0; n < this.resultRows_.size(); ++n) {
            vector = this.resultRows_.get(n);
            vector2.add(vector);
        }
        for (n = 0; n < rowSet.resultRows_.size(); ++n) {
            vector = rowSet.resultRows_.get(n);
            vector2.add(vector);
        }
        return new RowSet(vector2, this.numOfColumns_, 0, vector2.size());
    }

    public void clear() {
        this.numOfColumns_ = 0;
        this.offset_ = 0;
        this.resultRows_.clear();
        this.validSize = false;
    }

    public String toString() {
        return "RowSet [numOfColumns_=" + this.numOfColumns_ + ", currentRow_=" + this.currentRow_ + ", offset_=" + this.offset_ + ", sizeOfResultSet_=" + this.sizeOfResultSet_ + ", lastWasNull_=" + this.lastWasNull_ + ", validSize=" + this.validSize + ", resultTrimmed=" + this.resultTrimmed + ", suppressMaxRows=" + this.suppressMaxRows + "]";
    }

    public Vector<Object> getRow(int n) {
        Vector<Object> vector;
        try {
            vector = this.resultRows_ != null ? this.resultRows_.get(n) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        return vector;
    }

    public List<String> getColumnNames() {
        List<String> list;
        try {
            list = this.tableColumns != null ? Collections.unmodifiableList(TableColumns.getColumns(this.tableColumns)) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        return list;
    }

    public List<TableColumn> getTableColumns() {
        List<TableColumn> list;
        try {
            list = this.tableColumns != null ? Collections.unmodifiableList(this.tableColumns) : null;
        }
        catch (NumberFormatException numberFormatException) {
            throw RowSet.b(numberFormatException);
        }
        return list;
    }

    public void setTableColumns(List<TableColumn> list) {
        this.tableColumns = list;
    }

    public void addTableColumn(String string, int n) {
        if (this.tableColumns != null) {
            TableColumn tableColumn = TableColumn.of(string);
            try {
                if (!this.tableColumns.contains(tableColumn)) {
                    this.tableColumns.add(n, tableColumn);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw RowSet.b(numberFormatException);
            }
        }
    }

    public boolean isSuppressMaxRows() {
        return this.suppressMaxRows;
    }

    public void setSuppressMaxRows(boolean bl) {
        this.suppressMaxRows = bl;
    }

    public void setColumnName(int n, String string) {
        if (this.tableColumns != null) {
            TableColumn tableColumn = TableColumn.of(string);
            this.tableColumns.set(n, tableColumn);
        }
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

