/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.sql;

import com.visustt.jiveX.general.data.sql.RowSet;
import com.visustt.tools.control.log.Logger;
import com.visustt.tools.control.log.LoggerFactory;
import com.visustt.tools.lang.LowerCaseKeyHashtable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;

public class ExtendedRowSet
extends RowSet {
    private static final long serialVersionUID = -829829490984609710L;
    private static final Logger logger = LoggerFactory.getInstance("jx.db.ExtendedRowSet");
    private transient LowerCaseKeyHashtable<String, LowerCaseKeyHashtable<String, Integer>> tables = new LowerCaseKeyHashtable();
    private transient LowerCaseKeyHashtable<String, String> fieldTableMap = new LowerCaseKeyHashtable();
    private transient HashSet<String> allFieldNames = new HashSet();
    private transient LowerCaseKeyHashtable<Integer, Integer> columnTypes = new LowerCaseKeyHashtable();

    public ExtendedRowSet(ResultSet resultSet, int n, int n2, boolean bl) throws SQLException {
        super(resultSet, n, n2, bl);
        this.parseColumnNames(resultSet.getMetaData());
    }

    public ExtendedRowSet(ResultSet resultSet, int n, int n2) throws SQLException {
        super(resultSet, n, n2);
        this.parseColumnNames(resultSet.getMetaData());
    }

    public ExtendedRowSet(ResultSet resultSet) throws SQLException {
        super(resultSet);
        this.parseColumnNames(resultSet.getMetaData());
    }

    public ExtendedRowSet() {
        super(new Vector(), 0, 0, 0);
    }

    public ExtendedRowSet(Vector vector, int n, int n2, int n3) {
        super(vector, n, n2, n3);
    }

    private void parseColumnNames(ResultSetMetaData resultSetMetaData) {
        try {
            if (logger.debugIsEnabled()) {
                logger.debug("Parsing ResultSet's table and column names...");
            }
        }
        catch (Exception exception) {
            throw ExtendedRowSet.a(exception);
        }
        try {
            int n = resultSetMetaData.getColumnCount();
            try {
                if (logger.debugIsEnabled()) {
                    logger.debug("ResultSet has " + n + " columns.");
                }
            }
            catch (Exception exception) {
                throw ExtendedRowSet.a(exception);
            }
            for (int i = 1; i <= n; ++i) {
                String string;
                LowerCaseKeyHashtable<Object, Object> lowerCaseKeyHashtable;
                block19: {
                    String string2;
                    block18: {
                        string2 = resultSetMetaData.getTableName(i);
                        lowerCaseKeyHashtable = null;
                        if (this.tables.containsKey(string2)) {
                            lowerCaseKeyHashtable = this.tables.get(string2);
                        } else {
                            lowerCaseKeyHashtable = new LowerCaseKeyHashtable();
                            this.tables.put(string2, lowerCaseKeyHashtable);
                        }
                        string = resultSetMetaData.getColumnLabel(i);
                        try {
                            if (!this.allFieldNames.contains(string)) break block18;
                            this.fieldTableMap.put(string, this.fieldTableMap.get(string) + "\\" + string2);
                            break block19;
                        }
                        catch (Exception exception) {
                            throw ExtendedRowSet.a(exception);
                        }
                    }
                    this.allFieldNames.add(string);
                    this.fieldTableMap.put(string, string2);
                }
                try {
                    lowerCaseKeyHashtable.put(string, i);
                    if (logger.debugIsEnabled()) {
                        logger.debug("Mapping column " + string + "." + string + " to index #" + i);
                    }
                }
                catch (Exception exception) {
                    throw ExtendedRowSet.a(exception);
                }
                int n2 = resultSetMetaData.getColumnType(i);
                try {
                    this.columnTypes.put(i, n2);
                    if (!logger.debugIsEnabled()) continue;
                    logger.debug("Resolved column type '" + n2 + "' for column " + string);
                    continue;
                }
                catch (Exception exception) {
                    throw ExtendedRowSet.a(exception);
                }
            }
        }
        catch (Exception exception) {
            logger.error((Object)"Error parsing ResultSet's column names.", exception);
        }
    }

    public int findColumn(String string) throws SQLException {
        int n = string.indexOf(46);
        String string2 = null;
        String string3 = string;
        if (n != -1) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        } else {
            string2 = this.fieldTableMap.get(string);
            try {
                if (string2 == null) {
                    throw new SQLException("Unknown column name: " + string);
                }
            }
            catch (SQLException sQLException) {
                throw ExtendedRowSet.a(sQLException);
            }
            try {
                if (string2.indexOf(92) != -1) {
                    throw new SQLException("Ambiguous column name \"" + string + "\" exists in more than one table: " + string2.replace('\\', ','));
                }
            }
            catch (SQLException sQLException) {
                throw ExtendedRowSet.a(sQLException);
            }
        }
        LowerCaseKeyHashtable<String, Integer> lowerCaseKeyHashtable = this.tables.get(string2);
        try {
            if (lowerCaseKeyHashtable == null) {
                throw new SQLException("Unknown table name: " + string2);
            }
        }
        catch (SQLException sQLException) {
            throw ExtendedRowSet.a(sQLException);
        }
        Integer n2 = lowerCaseKeyHashtable.get(string3);
        try {
            if (n2 == null) {
                throw new SQLException("Unknown column name: " + string);
            }
        }
        catch (SQLException sQLException) {
            throw ExtendedRowSet.a(sQLException);
        }
        return n2;
    }

    public int getColumnType(String string) throws SQLException {
        Integer n = this.columnTypes.get(this.findColumn(string));
        try {
            if (n == null) {
                throw new SQLException("Unknown column: " + string);
            }
        }
        catch (SQLException sQLException) {
            throw ExtendedRowSet.a(sQLException);
        }
        return n;
    }

    public double getDouble(String string) throws SQLException {
        return super.getDouble(this.findColumn(string));
    }

    public double getDouble(String string, int n) throws SQLException {
        return this.getDouble(this.findColumn(string), n);
    }

    public double getDouble(int n, int n2) throws SQLException {
        double d;
        block3: {
            int n3;
            block2: {
                n3 = this.getRow();
                this.absolute(n2);
                d = super.getDouble(n);
                try {
                    if (n3 != 0) break block2;
                    this.reset();
                    break block3;
                }
                catch (SQLException sQLException) {
                    throw ExtendedRowSet.a(sQLException);
                }
            }
            this.absolute(n3);
        }
        return d;
    }

    public float getFloat(String string) throws SQLException {
        return super.getFloat(this.findColumn(string));
    }

    public float getFloat(String string, int n) throws SQLException {
        return this.getFloat(this.findColumn(string), n);
    }

    public float getFloat(int n, int n2) throws SQLException {
        float f;
        block3: {
            int n3;
            block2: {
                n3 = this.getRow();
                this.absolute(n2);
                f = super.getFloat(n);
                try {
                    if (n3 != 0) break block2;
                    this.reset();
                    break block3;
                }
                catch (SQLException sQLException) {
                    throw ExtendedRowSet.a(sQLException);
                }
            }
            this.absolute(n3);
        }
        return f;
    }

    public int getInt(String string) throws SQLException {
        return super.getInt(this.findColumn(string));
    }

    public int getInt(String string, int n) throws SQLException {
        return this.getInt(this.findColumn(string), n);
    }

    public int getInt(int n, int n2) throws SQLException {
        int n3;
        block3: {
            int n4;
            block2: {
                n4 = this.getRow();
                this.absolute(n2);
                n3 = super.getInt(n);
                try {
                    if (n4 != 0) break block2;
                    this.reset();
                    break block3;
                }
                catch (SQLException sQLException) {
                    throw ExtendedRowSet.a(sQLException);
                }
            }
            this.absolute(n4);
        }
        return n3;
    }

    public long getLong(String string) throws SQLException {
        return super.getLong(this.findColumn(string));
    }

    public long getLong(String string, int n) throws SQLException {
        return this.getLong(this.findColumn(string), n);
    }

    public long getLong(int n, int n2) throws SQLException {
        long l;
        block3: {
            int n3;
            block2: {
                n3 = this.getRow();
                this.absolute(n2);
                l = super.getLong(n);
                try {
                    if (n3 != 0) break block2;
                    this.reset();
                    break block3;
                }
                catch (SQLException sQLException) {
                    throw ExtendedRowSet.a(sQLException);
                }
            }
            this.absolute(n3);
        }
        return l;
    }

    public Object getObject(String string) throws SQLException {
        return super.getObject(this.findColumn(string));
    }

    public Object getObject(String string, int n) throws SQLException {
        return this.getObject(this.findColumn(string), n);
    }

    public Object getObject(int n, int n2) throws SQLException {
        Object object;
        block3: {
            int n3;
            block2: {
                n3 = this.getRow();
                this.absolute(n2);
                object = super.getObject(n);
                try {
                    if (n3 != 0) break block2;
                    this.reset();
                    break block3;
                }
                catch (SQLException sQLException) {
                    throw ExtendedRowSet.a(sQLException);
                }
            }
            this.absolute(n3);
        }
        return object;
    }

    public String getString(String string) throws SQLException {
        return super.getString(this.findColumn(string));
    }

    public String getString(String string, int n) throws SQLException {
        return this.getString(this.findColumn(string), n);
    }

    public String getString(int n, int n2) throws SQLException {
        String string;
        block3: {
            int n3;
            block2: {
                n3 = this.getRow();
                this.absolute(n2);
                string = super.getString(n);
                try {
                    if (n3 != 0) break block2;
                    this.reset();
                    break block3;
                }
                catch (SQLException sQLException) {
                    throw ExtendedRowSet.a(sQLException);
                }
            }
            this.absolute(n3);
        }
        return string;
    }

    public byte[] getBytes(String string) throws SQLException {
        Object object = super.getObject(this.findColumn(string));
        try {
            if (object instanceof String) {
                return ((String)object).getBytes();
            }
        }
        catch (SQLException sQLException) {
            throw ExtendedRowSet.a(sQLException);
        }
        throw new SQLException("Can't return column value as byte array. Data type is " + object.getClass().toString());
    }

    public byte[] getBytes(String string, int n) throws SQLException {
        return this.getBytes(this.findColumn(string), n);
    }

    public byte[] getBytes(int n, int n2) throws SQLException {
        Object object;
        block6: {
            int n3;
            block5: {
                n3 = this.getRow();
                this.absolute(n2);
                object = super.getObject(n);
                try {
                    if (n3 != 0) break block5;
                    this.reset();
                    break block6;
                }
                catch (SQLException sQLException) {
                    throw ExtendedRowSet.a(sQLException);
                }
            }
            this.absolute(n3);
        }
        try {
            if (object instanceof String) {
                return ((String)object).getBytes();
            }
        }
        catch (SQLException sQLException) {
            throw ExtendedRowSet.a(sQLException);
        }
        throw new SQLException("Can't return column value as byte array. Data type is " + object.getClass().toString());
    }

    public HashSet<String> getFieldNames() {
        return this.allFieldNames;
    }

    public void reSortPatialResult(Vector<String> vector) throws SQLException {
        Vector<Boolean> vector2 = new Vector<Boolean>();
        try {
            for (int i = 0; i < vector.size(); ++i) {
                vector2.add(Boolean.TRUE);
            }
        }
        catch (SQLException sQLException) {
            throw ExtendedRowSet.a(sQLException);
        }
        this.reSortPatialResult(vector, vector2);
    }

    public void reSortPatialResult(Vector<String> vector, Vector<Boolean> vector2) throws SQLException {
        Collections.sort(this.resultRows_, new ResultRowComparator(vector, vector2));
    }

    private static Exception a(Exception exception) {
        return exception;
    }

    protected class ResultRowComparator
    implements Comparator<Vector<?>> {
        private int[] columns;
        private boolean[] asc;
        private int[] types;

        ResultRowComparator(Vector<String> vector, Vector<Boolean> vector2) throws SQLException {
            if (vector.size() != vector2.size()) {
                throw new SQLException("Column name count does not match ascending/descending count.");
            }
            this.columns = new int[vector.size()];
            this.asc = new boolean[vector.size()];
            this.types = new int[vector.size()];
            try {
                for (int i = 0; i < this.columns.length; ++i) {
                    this.columns[i] = ExtendedRowSet.this.findColumn(vector.get(i));
                    this.asc[i] = vector2.get(i);
                    this.types[i] = ExtendedRowSet.this.columnTypes.get(this.columns[i]);
                }
            }
            catch (SQLException sQLException) {
                throw ResultRowComparator.a(sQLException);
            }
        }

        @Override
        public int compare(Vector<?> vector, Vector<?> vector2) {
            block15: for (int i = 0; i < this.columns.length; ++i) {
                int n = this.columns[i] - 1;
                switch (this.types[i]) {
                    case 2: 
                    case 3: {
                        Object object = (BigDecimal)vector.get(n);
                        Object object2 = (BigDecimal)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = new BigDecimal(0);
                        }
                        if (object2 == null) {
                            object2 = new BigDecimal(0);
                        }
                        if (((BigDecimal)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((BigDecimal)object).compareTo((BigDecimal)object2);
                        }
                        return ((BigDecimal)object2).compareTo((BigDecimal)object);
                    }
                    case -7: {
                        Object object = (Boolean)vector.get(n);
                        Object object2 = (Boolean)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = Boolean.FALSE;
                        }
                        if (object2 == null) {
                            object2 = Boolean.FALSE;
                        }
                        if (((Boolean)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((Boolean)object).booleanValue() ? 1 : -1;
                        }
                        return ((Boolean)object).booleanValue() ? -1 : 1;
                    }
                    case -6: {
                        Object object = (Byte)vector.get(n);
                        Object object2 = (Byte)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = (byte)0;
                        }
                        if (object2 == null) {
                            object2 = (byte)0;
                        }
                        if (((Byte)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((Byte)object).compareTo((Byte)object2);
                        }
                        return ((Byte)object2).compareTo((Byte)object);
                    }
                    case 5: {
                        Object object = (Short)vector.get(n);
                        Object object2 = (Short)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = (short)0;
                        }
                        if (object2 == null) {
                            object2 = (short)0;
                        }
                        if (((Short)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((Short)object).compareTo((Short)object2);
                        }
                        return ((Short)object2).compareTo((Short)object);
                    }
                    case 4: {
                        Object object = (Integer)vector.get(n);
                        Object object2 = (Integer)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = 0;
                        }
                        if (object2 == null) {
                            object2 = 0;
                        }
                        if (((Integer)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((Integer)object).compareTo((Integer)object2);
                        }
                        return ((Integer)object2).compareTo((Integer)object);
                    }
                    case -5: {
                        Object object = (Long)vector.get(n);
                        Object object2 = (Long)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = 0L;
                        }
                        if (object2 == null) {
                            object2 = 0L;
                        }
                        if (((Long)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((Long)object).compareTo((Long)object2);
                        }
                        return ((Long)object2).compareTo((Long)object);
                    }
                    case 7: {
                        Object object = (Float)vector.get(n);
                        Object object2 = (Float)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = Float.valueOf(0.0f);
                        }
                        if (object2 == null) {
                            object2 = Float.valueOf(0.0f);
                        }
                        if (((Float)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((Float)object).compareTo((Float)object2);
                        }
                        return ((Float)object2).compareTo((Float)object);
                    }
                    case 6: 
                    case 8: {
                        Object object = (Double)vector.get(n);
                        Object object2 = (Double)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = 0.0;
                        }
                        if (object2 == null) {
                            object2 = 0.0;
                        }
                        if (((Double)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((Double)object).compareTo((Double)object2);
                        }
                        return ((Double)object2).compareTo((Double)object);
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        return 0;
                    }
                    case 91: {
                        Object object = (Date)vector.get(n);
                        Object object2 = (Date)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = new Date(0L);
                        }
                        if (object2 == null) {
                            object2 = new Date(0L);
                        }
                        if (((java.util.Date)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((java.util.Date)object).compareTo((java.util.Date)object2);
                        }
                        return ((java.util.Date)object2).compareTo((java.util.Date)object);
                    }
                    case 92: {
                        Object object = (Time)vector.get(n);
                        Object object2 = (Time)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = new Time(0L);
                        }
                        if (object2 == null) {
                            object2 = new Time(0L);
                        }
                        if (((java.util.Date)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((java.util.Date)object).compareTo((java.util.Date)object2);
                        }
                        return ((java.util.Date)object2).compareTo((java.util.Date)object);
                    }
                    case 93: {
                        Object object = (Timestamp)vector.get(n);
                        Object object2 = (Timestamp)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = new Timestamp(0L);
                        }
                        if (object2 == null) {
                            object2 = new Timestamp(0L);
                        }
                        if (((Timestamp)object).equals((Timestamp)object2)) continue block15;
                        if (this.asc[i]) {
                            return ((Timestamp)object).compareTo((Timestamp)object2);
                        }
                        return ((Timestamp)object2).compareTo((Timestamp)object);
                    }
                    case 2004: {
                        return 0;
                    }
                    default: {
                        Object object = (String)vector.get(n);
                        Object object2 = (String)vector2.get(n);
                        if (object == object2) continue block15;
                        if (object == null) {
                            object = "";
                        }
                        if (object2 == null) {
                            object2 = "";
                        }
                        if (((String)object).equals(object2)) continue block15;
                        if (this.asc[i]) {
                            return ((String)object).compareTo((String)object2);
                        }
                        return ((String)object2).compareTo((String)object);
                    }
                }
            }
            return 0;
        }

        private static SQLException a(SQLException sQLException) {
            return sQLException;
        }
    }
}

