/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.priorstudies;

import com.visustt.dicomTk.DicomTagNames;
import com.visustt.jiveX.general.criteria.CriterionResolver;
import com.visustt.jiveX.general.criteria.CriterionResolverAdapter;
import com.visustt.jiveX.general.criteria.CriterionResolverImpl;
import com.visustt.jiveX.general.criteria.StudyCriteria;
import com.visustt.jiveX.general.criteria.StudyCriteriaUtil;
import com.visustt.jiveX.general.data.priorstudies.PriorStudiesDefinition;
import com.visustt.jiveX.general.data.priorstudies.StudyAttributes;
import com.visustt.tools.ab.ab;
import com.visustt.tools.lang.StringTool;
import com.visustt.tools.lang.al;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class StudyDefinition
implements Comparable<StudyDefinition>,
Serializable {
    private static final long serialVersionUID = 201412231133L;
    private int priority = Integer.MAX_VALUE;
    private String alias;
    private PriorStudiesDefinition priorStudiesDefinition;
    private boolean useAutomatically;
    private boolean loadCriteriaRelatedStudies;
    private List<StudyCriteria> studyCriteriaList;

    public StudyDefinition() {
    }

    public StudyDefinition(String string, StudyAttributes studyAttributes) {
        this.alias = string;
        this.useAutomatically = true;
        this.priorStudiesDefinition = new PriorStudiesDefinition();
        this.studyCriteriaList = ab.aa();
        StudyCriteria studyCriteria = StudyCriteriaUtil.createStudyCriteria(studyAttributes.getModality(), studyAttributes.getStudyDescription());
        this.studyCriteriaList.add(studyCriteria);
    }

    public StudyDefinition(String string, int n, boolean bl, UUID uUID) {
        this.alias = string;
        this.priority = n;
        this.useAutomatically = bl;
        this.priorStudiesDefinition = new PriorStudiesDefinition();
        CriterionResolverImpl criterionResolverImpl = new CriterionResolverImpl(uUID, false);
        this.initCriteriaListWithResolver(criterionResolverImpl);
    }

    public StudyDefinition(String string, int n, boolean bl, CriterionResolver criterionResolver) {
        this.alias = string;
        this.priority = n;
        this.useAutomatically = bl;
        this.priorStudiesDefinition = new PriorStudiesDefinition();
        this.initCriteriaListWithResolver(al.ab(criterionResolver, "criterionResolver must not be null!"));
    }

    public StudyDefinition(String string, int n, boolean bl, List<StudyCriteria> list) {
        this.alias = string;
        this.priority = n;
        this.useAutomatically = bl;
        this.priorStudiesDefinition = new PriorStudiesDefinition();
        this.studyCriteriaList = al.ab(list, "studyCriteriaList must not be null!");
    }

    public StudyDefinition(StudyDefinition studyDefinition) {
        this.alias = new String(studyDefinition.getAlias());
        this.priority = studyDefinition.getPriority();
        this.useAutomatically = studyDefinition.isUseAutomatically();
        if (studyDefinition.getPriorStudiesDefinition() != null) {
            this.priorStudiesDefinition = studyDefinition.getPriorStudiesDefinition().clone();
        }
        this.loadCriteriaRelatedStudies = studyDefinition.isLoadCriteriaRelatedStudies();
        this.studyCriteriaList = new ArrayList<StudyCriteria>();
        List<StudyCriteria> list = studyDefinition.getStudySelectionCriteria();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                this.studyCriteriaList.add(list.get(i).copy());
            }
        }
    }

    private void initCriteriaListWithResolver(CriterionResolver criterionResolver) {
        StudyCriteria studyCriteria = new StudyCriteria(true);
        studyCriteria.add(criterionResolver);
        this.studyCriteriaList = ab.aa();
        this.studyCriteriaList.add(studyCriteria);
    }

    public String dump(int n) {
        String string = StringTool.dupeString(n, "  ", null);
        return string + this.toString();
    }

    public boolean isUseAutomatically() {
        return this.useAutomatically;
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public int compareTo(StudyDefinition studyDefinition) {
        if (this.priority > studyDefinition.getPriority()) {
            return -1;
        }
        if (this.priority < studyDefinition.getPriority()) {
            return 1;
        }
        return this.alias.compareTo(studyDefinition.getAlias());
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int n) {
        this.priority = n;
    }

    public PriorStudiesDefinition getPriorStudiesDefinition() {
        return this.priorStudiesDefinition;
    }

    public void setPriorStudiesDefinition(PriorStudiesDefinition priorStudiesDefinition) {
        this.priorStudiesDefinition = priorStudiesDefinition;
    }

    public void setUseAutomatically(boolean bl) {
        this.useAutomatically = bl;
    }

    public List<StudyCriteria> getStudySelectionCriteria() {
        return this.studyCriteriaList;
    }

    public void addStudySelectionCriteria(StudyCriteria studyCriteria) {
        this.studyCriteriaList.add(studyCriteria);
    }

    public void setStudySelectionCriteria(List<StudyCriteria> list) {
        this.studyCriteriaList = list;
    }

    public StudyCriteria getMainStudyCriteria() {
        for (StudyCriteria studyCriteria : this.studyCriteriaList) {
            if (!studyCriteria.isMainStudyCriteria()) continue;
            return studyCriteria;
        }
        return null;
    }

    public String toString() {
        return "StudyDefinition [alias=" + this.alias + ", priority=" + this.priority + ", priorStudiesDefinition=" + this.priorStudiesDefinition + ", useAutomatically=" + this.useAutomatically + ", loadCriteriaRelatedStudies=" + this.loadCriteriaRelatedStudies + ", criteriaList=" + this.studyCriteriaList + "]";
    }

    public boolean isLoadCriteriaRelatedStudies() {
        return this.loadCriteriaRelatedStudies;
    }

    public void setLoadCriteriaRelatedStudies(boolean bl) {
        this.loadCriteriaRelatedStudies = bl;
    }

    public String getMainStudyModality() {
        CriterionResolverAdapter criterionResolverAdapter;
        String string = null;
        StudyCriteria studyCriteria = this.getMainStudyCriteria();
        if (studyCriteria != null && (criterionResolverAdapter = studyCriteria.getOldCriterion(DicomTagNames.TAG_modality.toString())) != null) {
            string = criterionResolverAdapter.getOldCriterionValue();
        }
        return string;
    }

    public void setMainStudyModality(String string) {
        CriterionResolverAdapter criterionResolverAdapter;
        StudyCriteria studyCriteria = this.getMainStudyCriteria();
        if (studyCriteria != null && (criterionResolverAdapter = studyCriteria.getOldCriterion(DicomTagNames.TAG_modality.toString())) != null) {
            criterionResolverAdapter.setOldCriterionValue(string);
        }
    }

    public String getMainStudyDescription() {
        CriterionResolverAdapter criterionResolverAdapter;
        String string = null;
        StudyCriteria studyCriteria = this.getMainStudyCriteria();
        if (studyCriteria != null && (criterionResolverAdapter = studyCriteria.getOldCriterion(DicomTagNames.TAG_studyDescription.toString())) != null) {
            string = criterionResolverAdapter.getOldCriterionValue();
        }
        return string;
    }

    public void setMainStudyDescription(String string) {
        CriterionResolverAdapter criterionResolverAdapter;
        StudyCriteria studyCriteria = this.getMainStudyCriteria();
        if (studyCriteria != null && (criterionResolverAdapter = studyCriteria.getOldCriterion(DicomTagNames.TAG_studyDescription.toString())) != null) {
            criterionResolverAdapter.setOldCriterionValue(string);
        }
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.alias == null ? 0 : this.alias.hashCode());
        n2 = 31 * n2 + (this.loadCriteriaRelatedStudies ? 1231 : 1237);
        n2 = 31 * n2 + (this.priorStudiesDefinition == null ? 0 : this.priorStudiesDefinition.hashCode());
        n2 = 31 * n2 + this.priority;
        n2 = 31 * n2 + (this.studyCriteriaList == null ? 0 : this.studyCriteriaList.hashCode());
        n2 = 31 * n2 + (this.useAutomatically ? 1231 : 1237);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        StudyDefinition studyDefinition = (StudyDefinition)object;
        if (this.alias == null ? studyDefinition.alias != null : !this.alias.equals(studyDefinition.alias)) {
            return false;
        }
        if (this.loadCriteriaRelatedStudies != studyDefinition.loadCriteriaRelatedStudies) {
            return false;
        }
        if (this.priorStudiesDefinition == null ? studyDefinition.priorStudiesDefinition != null : !this.priorStudiesDefinition.equals(studyDefinition.priorStudiesDefinition)) {
            return false;
        }
        if (this.priority != studyDefinition.priority) {
            return false;
        }
        if (this.studyCriteriaList == null ? studyDefinition.studyCriteriaList != null : !this.studyCriteriaList.equals(studyDefinition.studyCriteriaList)) {
            return false;
        }
        return this.useAutomatically == studyDefinition.useAutomatically;
    }
}

