/*
 * Decompiled with CFR 0.152.
 */
package com.visustt.jiveX.general.data.pojo;

import com.visustt.jiveX.general.data.pojo.DatabaseBaseData;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(name="DicomMailContact")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class DicomMailContact
extends DatabaseBaseData {
    private static final long serialVersionUID = 8416536864184159815L;
    public static final String TABLE_NAME = "DicomMailContact";
    public static final String JIVE_CONTACT_ID = "jiveContactID";
    public static final String JIVE_NETWORK_ID = "jiveNetworkID";
    public static final String JIVE_ACCOUNT_ID = "jiveAccountID";
    public static final String PARTICIPANT_ID = "participantID";
    public static final String CONNECTION_ID = "connectionID";
    public static final String ORDER_NUMBER = "orderNumber";
    public static final String ENABLED = "enabled";
    public static final List<String> COLUMN_NAMES = new CopyOnWriteArrayList<String>();

    public DicomMailContact() {
        this.setOrderNumber(0);
        this.setEnabled(false);
    }

    public DicomMailContact(DicomMailContact dicomMailContact) {
        super(dicomMailContact);
    }

    public void setJiveContactID(long l) {
        this.setValue(JIVE_CONTACT_ID, l);
    }

    public long getJiveContactID() {
        return this.getLongValue(JIVE_CONTACT_ID);
    }

    public void setJiveNetworkID(long l) {
        this.setValue(JIVE_NETWORK_ID, l);
    }

    public long getJiveNetworkID() {
        return this.getLongValue(JIVE_NETWORK_ID);
    }

    public void setJiveAccountID(long l) {
        this.setValue(JIVE_ACCOUNT_ID, l);
    }

    public long getJiveAccountID() {
        return this.getLongValue(JIVE_ACCOUNT_ID);
    }

    public void setParticipantID(String string) {
        this.setValue(PARTICIPANT_ID, string);
    }

    public void setParticipantIDWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 36) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailContact.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field participantID; limit = 36");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailContact.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null participantID");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        this.setValue(PARTICIPANT_ID, string);
    }

    public String getParticipantID() {
        return this.getStringValue(PARTICIPANT_ID);
    }

    public void setConnectionID(String string) {
        this.setValue(CONNECTION_ID, string);
    }

    public void setConnectionIDWithCheck(String string) throws IllegalArgumentException {
        block7: {
            try {
                try {
                    if (string == null || string.length() <= 36) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw DicomMailContact.a(illegalArgumentException);
                }
                throw new IllegalArgumentException("Value too long for field connectionID; limit = 36");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailContact.a(illegalArgumentException);
            }
        }
        try {
            if (string == null) {
                throw new IllegalArgumentException("Value can't be null connectionID");
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        this.setValue(CONNECTION_ID, string);
    }

    public String getConnectionID() {
        return this.getStringValue(CONNECTION_ID);
    }

    public void setOrderNumber(int n) {
        this.setValue(ORDER_NUMBER, n);
    }

    public int getOrderNumber() {
        return this.getIntegerValue(ORDER_NUMBER, 0);
    }

    public void setEnabled(boolean bl) {
        this.setValue(ENABLED, bl);
    }

    public boolean isEnabled() {
        return this.getBooleanValue(ENABLED, false);
    }

    public String getCaseSensitiveName(String string) {
        for (String string2 : COLUMN_NAMES) {
            try {
                if (!string2.equalsIgnoreCase(string)) continue;
                return string2;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw DicomMailContact.a(illegalArgumentException);
            }
        }
        return null;
    }

    public boolean isModified(DicomMailContact dicomMailContact) {
        try {
            if (dicomMailContact == null) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (this.getJiveContactID() != dicomMailContact.getJiveContactID()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (this.getJiveNetworkID() != dicomMailContact.getJiveNetworkID()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (this.getJiveAccountID() != dicomMailContact.getJiveAccountID()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getParticipantID(), dicomMailContact.getParticipantID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (!Objects.equals(this.getConnectionID(), dicomMailContact.getConnectionID())) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (this.getOrderNumber() != dicomMailContact.getOrderNumber()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (this.isEnabled() != dicomMailContact.isEnabled()) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        return false;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        long l = this.getJiveContactID();
        n2 = 31 * n2 + (int)(l ^ l >>> 32);
        return n2;
    }

    public boolean equals(Object object) {
        try {
            if (this == object) {
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (!(object instanceof DicomMailContact)) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        DicomMailContact dicomMailContact = (DicomMailContact)object;
        try {
            if (this.getJiveContactID() == 0L) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        try {
            if (this.getJiveContactID() != dicomMailContact.getJiveContactID()) {
                return false;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw DicomMailContact.a(illegalArgumentException);
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DicomMailContact\n");
        for (String string : COLUMN_NAMES) {
            stringBuilder.append(string);
            stringBuilder.append(": ");
            stringBuilder.append(this.getValue(string));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    static {
        COLUMN_NAMES.add(JIVE_CONTACT_ID);
        COLUMN_NAMES.add(JIVE_NETWORK_ID);
        COLUMN_NAMES.add(JIVE_ACCOUNT_ID);
        COLUMN_NAMES.add(PARTICIPANT_ID);
        COLUMN_NAMES.add(CONNECTION_ID);
        COLUMN_NAMES.add(ORDER_NUMBER);
        COLUMN_NAMES.add(ENABLED);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }
}

